/*
 * Decompiled with CFR 0.152.
 */
package soc.server;

import java.io.BufferedReader;
import java.io.Console;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.net.SocketException;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;
import net.nand.util.i18n.mgr.StringManager;
import soc.baseclient.ServerConnectInfo;
import soc.debug.D;
import soc.game.SOCBoard;
import soc.game.SOCGame;
import soc.game.SOCGameOption;
import soc.game.SOCGameOptionSet;
import soc.game.SOCGameOptionVersionException;
import soc.game.SOCPlayer;
import soc.game.SOCPlayingPiece;
import soc.game.SOCScenario;
import soc.game.SOCVersionedItem;
import soc.message.SOCBCastTextMsg;
import soc.message.SOCBotJoinGameRequest;
import soc.message.SOCChannelMembers;
import soc.message.SOCChannels;
import soc.message.SOCDeleteChannel;
import soc.message.SOCDeleteGame;
import soc.message.SOCGameOptionInfo;
import soc.message.SOCGameServerText;
import soc.message.SOCGameTextMsg;
import soc.message.SOCKeyedMessage;
import soc.message.SOCLeaveChannel;
import soc.message.SOCLocalizedStrings;
import soc.message.SOCMessage;
import soc.message.SOCMessageForGame;
import soc.message.SOCNewGame;
import soc.message.SOCNewGameWithOptions;
import soc.message.SOCRejectConnection;
import soc.message.SOCResetBoardAuth;
import soc.message.SOCResetBoardReject;
import soc.message.SOCResetBoardVote;
import soc.message.SOCRobotDismiss;
import soc.message.SOCScenarioInfo;
import soc.message.SOCServerPing;
import soc.message.SOCSitDown;
import soc.message.SOCStartGame;
import soc.message.SOCStatusMessage;
import soc.message.SOCVersion;
import soc.robot.SOCRobotBrain;
import soc.robot.SOCRobotClient;
import soc.server.GameHandler;
import soc.server.SOCChannelList;
import soc.server.SOCClientData;
import soc.server.SOCGameHandler;
import soc.server.SOCGameListAtServer;
import soc.server.SOCGameTimeoutChecker;
import soc.server.SOCLocalRobotClient;
import soc.server.SOCMessageDispatcher;
import soc.server.SOCReplaceRequest;
import soc.server.SOCServerMessageHandler;
import soc.server.SOCServerRobotPinger;
import soc.server.StatsFileWriterTask;
import soc.server.database.DBSettingMismatchException;
import soc.server.database.SOCDBHelper;
import soc.server.genericServer.Connection;
import soc.server.genericServer.Server;
import soc.server.savegame.SavedGameModel;
import soc.util.DataUtils;
import soc.util.SOCFeatureSet;
import soc.util.SOCGameBoardReset;
import soc.util.SOCGameList;
import soc.util.SOCRobotParameters;
import soc.util.SOCStringManager;
import soc.util.Triple;
import soc.util.Version;

public class SOCServer
extends Server {
    public static final int SOC_PORT_DEFAULT = 8880;
    public static final int SOC_STARTROBOTS_DEFAULT = 7;
    public static final int SOC_MAXCONN_DEFAULT = Math.max(40, 27);
    private static final int SOC_MAXCONN_HUMANS_RESERVE = 6;
    public static final String SOC_SERVER_PROPS_FILENAME = "jsserver.properties";
    public static final String PROP_JSETTLERS_PORT = "jsettlers.port";
    public static final String PROP_JSETTLERS_CONNECTIONS = "jsettlers.connections";
    public static final String PROP_JSETTLERS_BOTS_COOKIE = "jsettlers.bots.cookie";
    public static final String PROP_JSETTLERS_BOTS_PAUSE_FOR_HUMAN_TRADE = "jsettlers.bot.human.pause";
    public static final String PROP_JSETTLERS_BOTS_SHOWCOOKIE = "jsettlers.bots.showcookie";
    public static final String PROP_JSETTLERS_BOTS_PERCENT3P = "jsettlers.bots.percent3p";
    public static final String PROP_JSETTLERS_BOTS_START3P = "jsettlers.bots.start3p";
    public static final String PROP_JSETTLERS_BOTS_TIMEOUT_TURN = "jsettlers.bots.timeout.turn";
    public static final String PROP_JSETTLERS_BOTS_FAST__PAUSE__PERCENT = "jsettlers.bots.fast_pause_percent";
    public static final String PROP_JSETTLERS_BOTS_BOTGAMES_TOTAL = "jsettlers.bots.botgames.total";
    public static final String PROP_JSETTLERS_BOTS_BOTGAMES_GAMETYPES = "jsettlers.bots.botgames.gametypes";
    public static final int BOTS_BOTGAMES_GAMETYPES_MAX = 3;
    public static final String PROP_JSETTLERS_BOTS_BOTGAMES_PARALLEL = "jsettlers.bots.botgames.parallel";
    public static final String PROP_JSETTLERS_BOTS_BOTGAMES_SHUTDOWN = "jsettlers.bots.botgames.shutdown";
    public static final String PROP_JSETTLERS_BOTS_BOTGAMES_WAIT__SEC = "jsettlers.bots.botgames.wait_sec";
    public static final String PROP_JSETTLERS_STARTROBOTS = "jsettlers.startrobots";
    public static final String PROP_JSETTLERS_ACCOUNTS_OPEN = "jsettlers.accounts.open";
    public static final String PROP_JSETTLERS_ACCOUNTS_REQUIRED = "jsettlers.accounts.required";
    public static final String PROP_JSETTLERS_ACCOUNTS_ADMINS = "jsettlers.accounts.admins";
    public static final String PROP_JSETTLERS_ADMIN_WELCOME = "jsettlers.admin.welcome";
    public static final String PROP_JSETTLERS_ALLOW_DEBUG = "jsettlers.allow.debug";
    public static final String PROP_JSETTLERS_CLI_MAXCREATEGAMES = "jsettlers.client.maxcreategames";
    public static final String PROP_JSETTLERS_CLI_MAXCREATECHANNELS = "jsettlers.client.maxcreatechannels";
    public static final String PROP_JSETTLERS_DEBUG_BOTS_DATACHECK_RSRC = "jsettlers.debug.bots.datacheck.rsrc";
    public static final String PROP_JSETTLERS_GAMEOPT_PREFIX = "jsettlers.gameopt.";
    public static final String PROP_JSETTLERS_GAMEOPTS_ACTIVATE = "jsettlers.gameopts.activate";
    public static final String PROP_JSETTLERS_GAME_DISALLOW_6PLAYER = "jsettlers.game.disallow.6player";
    public static final String PROP_JSETTLERS_GAME_DISALLOW_SEA__BOARD = "jsettlers.game.disallow.sea_board";
    public static final String PROP_JSETTLERS_SAVEGAME_DIR = "jsettlers.savegame.dir";
    public static final String PROP_JSETTLERS_STATS_FILE_NAME = "jsettlers.stats.file.name";
    public static final String PROP_JSETTLERS_TEST_DB = "jsettlers.test.db";
    public static final String PROP_JSETTLERS_TEST_VALIDATE__CONFIG = "jsettlers.test.validate_config";
    public static final String[] PROPS_LIST = new String[]{"jsettlers.port", "TCP port number for server to listen for client connections", "jsettlers.connections", "Maximum connection count, including robots (default " + SOC_MAXCONN_DEFAULT + ")", "jsettlers.startrobots", "Number of robots to create at startup (default 7)", "jsettlers.accounts.open", "Permit open self-registration of new user accounts? (if Y and using a DB)", "jsettlers.accounts.required", "Require all players to have a user account? (if Y; requires a DB)", "jsettlers.accounts.admins", "Permit only these usernames to create accounts (comma-separated)", "jsettlers.admin.welcome", "If set, welcome message text to send when clients connect", "jsettlers.allow.debug", "Allow remote debug commands? (if Y)", "jsettlers.client.maxcreatechannels", "Maximum simultaneous channels that a client can create", "jsettlers.client.maxcreategames", "Maximum simultaneous games that a client can create", "jsettlers.gameopt.*", "Game option defaults, case-insensitive: jsettlers.gameopt.RD=y", "jsettlers.gameopts.activate", "If set, activate these inactive game options (comma-separated list)", "jsettlers.game.disallow.6player", "Flag to disallow 6-player games", "jsettlers.game.disallow.sea_board", "Flag to disallow sea board and scenarios", "jsettlers.bots.botgames.total", "Run this many robot-only games, a few at a time (default 0); allow bot-only games", "jsettlers.bots.botgames.gametypes", "Robot-only games: Game size/board type mix (default 1)", "jsettlers.bots.botgames.parallel", "Start this many robot-only games at a time (default 4)", "jsettlers.bots.botgames.wait_sec", "Wait at startup before starting robot-only games (default 1.6 seconds)", "jsettlers.bots.botgames.shutdown", "After running the robot-only games, shut down the server if no other games are active (if Y)", "jsettlers.bots.cookie", "Robot cookie value (default is random generated each startup)", "jsettlers.bots.showcookie", "Flag to show the robot cookie value at startup", "jsettlers.bots.fast_pause_percent", "Pause at percent of normal pause time (0 to 100) for robot-only games (default 25)", "jsettlers.bot.human.pause", "In games with humans, robots wait this many seconds before answering a trade offer (default 8)", "jsettlers.bots.percent3p", "Percent of bots which should be third-party (0 to 100) if available", "jsettlers.bots.start3p", "Third-party bot client classes to start up with server", "jsettlers.bots.timeout.turn", "Robot turn timeout (seconds) for third-party bots", "jsettlers.debug.bots.datacheck.rsrc", "Debug flag to check bots' count of player resources", "jsettlers.savegame.dir", "Dir in which to store savegame files", "jsettlers.stats.file.name", "If set, filename to append daily *STATS* into", "jsettlers.test.validate_config", "Flag to validate server and DB config, then exit (same as -t command-line option)", "jsettlers.test.db", "Flag to test database methods, then exit", "jsettlers.db.bcrypt.work_factor", "For user accounts in DB, password encryption Work Factor (see README) (9 to 30)", "jsettlers.db.save.games", "Flag to save all games in DB (if 1 or Y)", "jsettlers.db.user", "DB username", "jsettlers.db.pass", "DB password", "jsettlers.db.url", "DB connection URL", "jsettlers.db.jar", "DB driver jar filename", "jsettlers.db.driver", "DB driver class name", "jsettlers.db.settings", "If set to \"write\", save DB settings properties values to the settings table and exit", "jsettlers.db.script.setup", "If set, full path or relative path to db setup sql script; will run and exit", "jsettlers.db.upgrade_schema", "Flag: If set, server will upgrade the DB schema to latest version and exit (if 1 or Y)"};
    public static final String PROP_JVM_JSETTLERS_DEBUG_SERVER_GAMEOPT3P = "jsettlers.debug.server.gameopt3p";
    public static final String SERVERNAME = "Server";
    private static final String SERVERNAME_LC = "Server".toLowerCase(Locale.US);
    public static final int CLI_VERSION_MIN = 0;
    public static final int CLI_VERSION_ASSUMED_GUESS = 1000;
    public static final int CLI_VERSION_TIMER_FIRE_MS = 1200;
    public static final int CLI_VERSION_MAX_REPORT = 6999;
    public static int GAME_TIME_EXPIRE_WARN_MINUTES = 15;
    public static int GAME_TIME_EXPIRE_CHECK_MINUTES = 5;
    public static final int GAME_TIME_EXPIRE_ADDTIME_MINUTES = 30;
    public static int ROBOT_FORCE_ENDTURN_SECONDS = 8;
    public static int ROBOT_FORCE_ENDTURN_STUBBORN_SECONDS = 4;
    public static int PLAYER_NAME_MAX_LENGTH = 20;
    public static int CLIENT_MAX_CREATE_GAMES = 5;
    public static int CLIENT_MAX_CREATE_CHANNELS = 2;
    public static String PRACTICE_STRINGPORT = "SOCPRACTICE";
    public static final int PN_NON_EVENT = -256;
    public static final int PN_OBSERVER = -257;
    public static final int PN_REPLY_TO_UNDETERMINED = -258;
    static final int AUTH_OR_REJECT__OK = 1;
    static final int AUTH_OR_REJECT__TAKING_OVER = 2;
    static final int AUTH_OR_REJECT__SET_USERNAME = 4;
    public static final SOCGameOptionSet startupKnownOpts = SOCGameOptionSet.getAllKnownOptions();
    private Random rand = new Random();
    protected int maxConnections;
    private boolean allowDebugUser;
    private boolean hasUtilityModeProp;
    private String utilityModeMessage;
    protected SOCDBHelper db;
    public final SOCGameOptionSet knownOpts = new SOCGameOptionSet(startupKnownOpts, true);
    private SOCFeatureSet features = new SOCFeatureSet(false, false);
    private boolean has3rdPartyGameopts;
    private final SOCGameHandler handler = this.buildGameHandler();
    private boolean acctsNotOpenRegButNoUsers;
    private String srvShutPassword;
    private long srvShutPasswordExpire;
    private String robotCookie;
    protected Vector<Connection> robots = new Vector();
    protected Vector<Connection> robots3p = new Vector();
    private List<Constructor<? extends SOCRobotClient>> robots3pCliConstrucs;
    protected HashSet<Connection> limitedConns = new HashSet();
    public static SOCRobotParameters ROBOT_PARAMS_DEFAULT = new SOCRobotParameters(120, 35, 0.13f, 1.0f, 1.0f, 3.0f, 1.0f, 1, 1);
    public static SOCRobotParameters ROBOT_PARAMS_SMARTER = new SOCRobotParameters(120, 35, 0.13f, 1.0f, 1.0f, 3.0f, 1.0f, 0, 1);
    protected static boolean hasStartupPrintAndExit = false;
    public static boolean hasSetGameOptions = false;
    public static final String MSG_NICKNAME_ALREADY_IN_USE = "Someone with that nickname is already logged into the system.";
    public static final String MSG_NICKNAME_ALREADY_IN_USE_WAIT_TRY_AGAIN = " and try again. ";
    public static final String MSG_NICKNAME_ALREADY_IN_USE_NEWER_VERSION_P1 = "You need client version ";
    public static final String MSG_NICKNAME_ALREADY_IN_USE_NEWER_VERSION_P2 = " or newer to take over this connection.";
    public static final int NICKNAME_TAKEOVER_SECONDS_SAME_PASSWORD = 15;
    public static final int NICKNAME_TAKEOVER_SECONDS_SAME_IP = 30;
    public static final int NICKNAME_TAKEOVER_SECONDS_DIFFERENT_IP = 150;
    protected File savegameDir;
    protected boolean savegameInitFailed;
    protected SOCChannelList channelList = new SOCChannelList();
    protected SOCGameListAtServer gameList = new SOCGameListAtServer(this.rand, this.knownOpts);
    private final SOCServerMessageHandler srvMsgHandler = this.buildServerMessageHandler(this.gameList, this.channelList);
    final Hashtable<String, Hashtable<Connection, Object>> robotJoinRequests = new Hashtable();
    final Hashtable<String, Vector<SOCReplaceRequest>> robotDismissRequests = new Hashtable();
    protected long startTime;
    protected int numberOfGamesStarted;
    protected int numberOfGamesFinished;
    protected int numberOfGamesFinishedWithBots;
    protected int numberOfBotsInFinishedGames;
    private Object countFieldSync = new Object();
    protected int numberOfUsers;
    protected TreeMap<Integer, AtomicInteger> clientPastVersionStats;
    private int numRobotOnlyGamesRemaining;
    static final String i18n_gameopt_PL_desc;
    static final String i18n_scenario_SC_WOND_desc;
    private Timer replyAuthTimer = new Timer(true);
    final Timer miscTaskTimer = new Timer(true);
    SOCServerRobotPinger serverRobotPinger;
    SOCGameTimeoutChecker gameTimeoutChecker;
    String databaseUserName;
    String databasePassword;
    private Set<String> databaseUserAdmins;
    private static final char[] GENERATEROBOTCOOKIE_HEX;
    public static final String[] GENERAL_COMMANDS_HELP;
    public static final String[] ADMIN_GAME_COMMANDS_HELP;
    static final String ADMIN_COMMANDS_HEADING = "--- Admin Commands ---";
    public static final String[] ADMIN_USER_COMMANDS_HELP;
    public static final String[] DEBUG_COMMANDS_HELP;
    public static final String RESUME_RELOADED_FETCHING_ROBOTS = "member.bot.join.fetching";
    public static boolean printedUsageAlready;
    private static BufferedReader sysInBuffered;

    public SOCServer(int p, int mc, String databaseUserName, String databasePassword) throws SocketException, EOFException, SQLException, IllegalStateException {
        super(p, (Server.InboundMessageDispatcher)new SOCMessageDispatcher(), null);
        this.maxConnections = mc;
        this.initSocServer(databaseUserName, databasePassword);
    }

    public SOCServer(int p, Properties props) throws SocketException, EOFException, SQLException, IllegalArgumentException, IllegalStateException {
        super(p, (Server.InboundMessageDispatcher)new SOCMessageDispatcher(), props);
        props = this.props;
        String dbuser = props.getProperty("jsettlers.db.user", "socuser");
        String dbpass = props.getProperty("jsettlers.db.pass", "socpass");
        this.initSocServer(dbuser, dbpass);
    }

    public SOCServer(String s, int mc, String databaseUserName, String databasePassword) throws SocketException, EOFException, SQLException, IllegalStateException {
        super(s, (Server.InboundMessageDispatcher)new SOCMessageDispatcher(), null);
        this.maxConnections = mc;
        this.initSocServer(databaseUserName, databasePassword);
    }

    public SOCServer(String s, Properties props) throws IllegalStateException {
        super(s, (Server.InboundMessageDispatcher)new SOCMessageDispatcher(), props);
        try {
            this.initSocServer(null, "");
        }
        catch (EOFException | SocketException | SQLException e) {
            throw new IllegalStateException("Internal error, not expected to encounter " + e.toString(), e);
        }
    }

    protected SOCGameHandler buildGameHandler() {
        return new SOCGameHandler(this);
    }

    protected SOCServerMessageHandler buildServerMessageHandler(SOCGameListAtServer games, SOCChannelList channels) {
        return new SOCServerMessageHandler(this, games, channels);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initSocServer(String dbUserName, String dbPassword) throws SocketException, EOFException, SQLException, IllegalArgumentException, IllegalStateException {
        String gameopt3p;
        String txt0;
        String txt;
        int reserve;
        int rcount;
        int hcount;
        Version.printVersionText(System.err, "Java Settlers Server ");
        if (Version.versionNumber() == 0) {
            throw new IllegalStateException("Packaging error: Cannot determine JSettlers version");
        }
        if (this.maxConnections == 0) {
            this.maxConnections = this.getConfigIntProperty(PROP_JSETTLERS_CONNECTIONS, SOC_MAXCONN_DEFAULT);
        }
        CLIENT_MAX_CREATE_GAMES = this.getConfigIntProperty(PROP_JSETTLERS_CLI_MAXCREATEGAMES, CLIENT_MAX_CREATE_GAMES);
        CLIENT_MAX_CREATE_CHANNELS = this.getConfigIntProperty(PROP_JSETTLERS_CLI_MAXCREATECHANNELS, CLIENT_MAX_CREATE_CHANNELS);
        if (this.getConfigBoolProperty(PROP_JSETTLERS_ALLOW_DEBUG, false)) {
            this.allowDebugUser = true;
        } else {
            String val = System.getProperty(PROP_JSETTLERS_ALLOW_DEBUG, "");
            if (!val.isEmpty()) {
                this.props.put(PROP_JSETTLERS_ALLOW_DEBUG, val);
                this.allowDebugUser = this.getConfigBoolProperty(PROP_JSETTLERS_ALLOW_DEBUG, false);
            }
        }
        boolean test_mode_with_db = this.getConfigBoolProperty(PROP_JSETTLERS_TEST_DB, false);
        boolean validate_config_mode = this.getConfigBoolProperty(PROP_JSETTLERS_TEST_VALIDATE__CONFIG, false);
        boolean wants_upg_schema = this.getConfigBoolProperty("jsettlers.db.upgrade_schema", false);
        boolean db_test_bcrypt_mode = false;
        String val = this.props.getProperty("jsettlers.db.bcrypt.work_factor");
        if (val != null && (db_test_bcrypt_mode = val.equalsIgnoreCase("test"))) {
            this.props.remove("jsettlers.db.bcrypt.work_factor");
        }
        boolean bl = this.hasUtilityModeProp = validate_config_mode || test_mode_with_db || wants_upg_schema || db_test_bcrypt_mode || null != this.props.getProperty("jsettlers.db.script.setup") || this.props.containsKey("jsettlers.db.settings") || null != this.props.getProperty("_jsettlers.user.pw_reset");
        if (test_mode_with_db) {
            System.err.println("* DB Test Mode: Will run tests and exit.");
        }
        if (validate_config_mode) {
            System.err.println("* Config Validation Mode: Checking configuration and exiting.");
        }
        if (this.error != null && !this.hasUtilityModeProp) {
            String errMsg = "* Exiting due to network setup problem: " + this.error.toString();
            throw new SocketException(errMsg);
        }
        if (!this.props.containsKey(PROP_JSETTLERS_STARTROBOTS)) {
            this.props.setProperty(PROP_JSETTLERS_STARTROBOTS, Integer.toString(7));
        }
        SOCServer.init_propsSetGameopts(this.props);
        int v = this.getConfigIntProperty(PROP_JSETTLERS_BOTS_FAST__PAUSE__PERCENT, -1);
        if (v != -1) {
            if (v >= 0 && v <= 100) {
                SOCRobotBrain.BOTS_ONLY_FAST_PAUSE_FACTOR = 0.01f * (float)v;
            } else {
                throw new IllegalArgumentException("Error: Property out of range (0 to 100): jsettlers.bots.fast_pause_percent");
            }
        }
        SOCRobotBrain.BOTS_PAUSE_FOR_HUMAN_TRADE = this.getConfigIntProperty(PROP_JSETTLERS_BOTS_PAUSE_FOR_HUMAN_TRADE, 8);
        if (validate_config_mode && (hcount = this.maxConnections - (rcount = Integer.parseInt(this.props.getProperty(PROP_JSETTLERS_STARTROBOTS)))) < (reserve = Math.max(rcount, 6))) {
            int incr = reserve - hcount;
            throw new IllegalArgumentException("Config: jsettlers.connections: Only " + hcount + " player connections would be available because of the " + rcount + " started robots. Should use " + (this.maxConnections + incr) + " for max connection count (+" + incr + ")");
        }
        ((SOCMessageDispatcher)this.inboundMsgDispatcher).setServer(this, this.srvMsgHandler, this.gameList);
        if (this.allowDebugUser) {
            System.err.println("Warning: Remote debug commands are allowed.");
        }
        if (this.props.containsKey(PROP_JSETTLERS_SAVEGAME_DIR)) {
            if (!this.allowDebugUser && !this.props.containsKey(PROP_JSETTLERS_ACCOUNTS_ADMINS)) {
                throw new IllegalArgumentException("Config: jsettlers.savegame.dir requires debug user or jsettlers.accounts.admins");
            }
            this.initSocServer_savegame();
        }
        if (this.props.containsKey(PROP_JSETTLERS_ADMIN_WELCOME)) {
            String txt02 = this.props.getProperty(PROP_JSETTLERS_ADMIN_WELCOME);
            String txt2 = txt02.trim();
            if (txt2.isEmpty()) {
                this.props.remove(PROP_JSETTLERS_ADMIN_WELCOME);
            } else {
                String err = null;
                char ch0 = txt2.charAt(0);
                if (ch0 == ',') {
                    err = "Cannot start with comma";
                } else if (Character.isDigit(ch0)) {
                    err = "Cannot start with digit";
                } else if (txt2.indexOf(124) != -1) {
                    err = "Cannot contain '|'";
                } else if (!SOCMessage.isSingleLineAndSafe(txt2, true)) {
                    err = "Cannot contain control character or newline";
                }
                if (err != null) {
                    throw new IllegalArgumentException("Config: jsettlers.admin.welcome: " + err);
                }
                if (!txt2.equals(txt02)) {
                    this.props.setProperty(PROP_JSETTLERS_ADMIN_WELCOME, txt2);
                }
            }
        }
        if (this.props.containsKey(PROP_JSETTLERS_GAMEOPTS_ACTIVATE) && !(txt = (txt0 = this.props.getProperty(PROP_JSETTLERS_GAMEOPTS_ACTIVATE)).trim()).isEmpty()) {
            StringBuilder err = new StringBuilder();
            for (String optKey : txt.split(",")) {
                if (null == this.knownOpts.getKnownOption(optKey, false)) {
                    if (err.length() > 0) {
                        err.append(", ");
                    }
                    err.append(optKey).append(": Not found");
                    continue;
                }
                try {
                    this.knownOpts.activate(optKey);
                }
                catch (IllegalArgumentException e) {
                    if (err.length() > 0) {
                        err.append(", ");
                    }
                    err.append(optKey).append(": Not inactive");
                }
            }
            if (err.length() > 0) {
                throw new IllegalArgumentException("Config: jsettlers.gameopts.activate: " + err);
            }
            System.err.println("Activated game options: " + txt);
        }
        if ((gameopt3p = System.getProperty(PROP_JVM_JSETTLERS_DEBUG_SERVER_GAMEOPT3P)) != null) {
            gameopt3p = gameopt3p.toUpperCase(Locale.US);
            SOCGameOption opt = new SOCGameOption(gameopt3p, 2000, Version.versionNumber(), false, 17, "Server test 3p option " + gameopt3p);
            opt.setClientFeature("com.example.js.feat." + gameopt3p);
            this.knownOpts.put(opt);
            if (null == System.getProperty("jsettlers.debug.client.gameopt3p")) {
                System.setProperty("jsettlers.debug.client.gameopt3p", gameopt3p);
            }
        }
        boolean bl2 = this.has3rdPartyGameopts = null != this.knownOpts.optionsWithFlag(16, 0);
        if (this.props.containsKey(PROP_JSETTLERS_BOTS_COOKIE)) {
            String cook = this.props.getProperty(PROP_JSETTLERS_BOTS_COOKIE).trim();
            if (cook.length() > 0) {
                if (!SOCMessage.isSingleLineAndSafe(cook)) {
                    String errmsg = "Error: The robot cookie value (param jsettlers.bots.cookie) can't contain comma or pipe characters.";
                    System.err.println("Error: The robot cookie value (param jsettlers.bots.cookie) can't contain comma or pipe characters.");
                    throw new IllegalArgumentException("Error: The robot cookie value (param jsettlers.bots.cookie) can't contain comma or pipe characters.");
                }
                this.robotCookie = cook;
            }
        } else {
            this.robotCookie = this.generateRobotCookie();
        }
        if (this.props.containsKey(PROP_JSETTLERS_BOTS_START3P) && (!this.hasUtilityModeProp || validate_config_mode)) {
            this.initSocServer_bots_start3p();
        }
        boolean accountsRequired = this.getConfigBoolProperty(PROP_JSETTLERS_ACCOUNTS_REQUIRED, false);
        this.initSocServer_DB(dbUserName, dbPassword, wants_upg_schema, accountsRequired, db_test_bcrypt_mode);
        if (this.hasUtilityModeProp && !test_mode_with_db && !validate_config_mode) {
            return;
        }
        if (this.db.isInitialized()) {
            if (accountsRequired) {
                System.err.println("User database accounts are required for all players.");
            }
            try {
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    @Override
                    public void run() {
                        System.err.println("\n--\n-- shutdown; disconnecting from db --\n--\n");
                        System.err.flush();
                        try {
                            SOCServer.this.db.checkSettings(true, false);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        SOCServer.this.db.cleanup(true);
                    }
                });
            }
            catch (Throwable th) {
                System.err.println("Warning: Could not register shutdown hook for database disconnect. Check java security settings.");
            }
        }
        this.startTime = System.currentTimeMillis();
        this.numberOfGamesStarted = 0;
        this.numberOfGamesFinished = 0;
        this.numberOfUsers = 0;
        this.clientPastVersionStats = new TreeMap();
        this.numRobotOnlyGamesRemaining = this.getConfigIntProperty(PROP_JSETTLERS_BOTS_BOTGAMES_TOTAL, 0);
        if (this.numRobotOnlyGamesRemaining > 0) {
            int n = 4;
            if (4 > this.getConfigIntProperty(PROP_JSETTLERS_STARTROBOTS, 0)) {
                String errmsg = "*** To start robot-only games, server needs at least 4 robots started.";
                System.err.println("*** To start robot-only games, server needs at least 4 robots started.");
                throw new IllegalArgumentException("*** To start robot-only games, server needs at least 4 robots started.");
            }
            int gt = this.getConfigIntProperty(PROP_JSETTLERS_BOTS_BOTGAMES_GAMETYPES, 1);
            if (gt < 1 || gt > 3) {
                throw new IllegalArgumentException("Config: jsettlers.bots.botgames.gametypes must be in range 1 - 3");
            }
        }
        if (CLIENT_MAX_CREATE_CHANNELS != 0) {
            this.features.add("ch");
        }
        if (!test_mode_with_db && !validate_config_mode) {
            this.serverRobotPinger = new SOCServerRobotPinger(this, this.robots);
            this.serverRobotPinger.start();
            this.gameTimeoutChecker = new SOCGameTimeoutChecker(this);
            this.gameTimeoutChecker.start();
            if (this.props.containsKey(PROP_JSETTLERS_STATS_FILE_NAME)) {
                String statsFilePath = this.props.getProperty(PROP_JSETTLERS_STATS_FILE_NAME);
                File statsFile = new File(statsFilePath).getAbsoluteFile();
                new StatsFileWriterTask(this.srvMsgHandler, statsFile, statsFilePath, this.miscTaskTimer);
                System.err.println("Stats file: Will append to " + statsFile.getPath());
            }
        }
        this.databaseUserName = dbUserName;
        this.databasePassword = dbPassword;
        if (hasSetGameOptions || validate_config_mode || SOCVersionedItem.itemsMinimumVersion(this.knownOpts.getAll()) > -1) {
            Thread.yield();
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException statsFilePath) {
                // empty catch block
            }
            SOCServer.printGameOptions();
        }
        if (this.getConfigBoolProperty(PROP_JSETTLERS_BOTS_SHOWCOOKIE, false)) {
            System.err.println("Robot cookie: " + this.robotCookie);
        }
        if (validate_config_mode) {
            System.err.println();
            System.err.println("-- Configured server properties: --");
            for (int i = 0; i < PROPS_LIST.length; i += 2) {
                String pkey = PROPS_LIST[i];
                if (pkey.equals(PROP_JSETTLERS_TEST_VALIDATE__CONFIG) || !this.props.containsKey(pkey)) continue;
                System.err.format("%-40s %s\n", pkey, this.props.getProperty(pkey));
            }
            System.err.println();
            System.err.println("* Config Validation Mode: No problems found.");
        }
        if (test_mode_with_db && this.db.isInitialized()) {
            this.db.testDBHelper();
        }
        if (!test_mode_with_db && !validate_config_mode) {
            System.err.print("The server is ready.");
            if (this.port > 0) {
                System.err.print(" Listening on port " + this.port);
            }
            System.err.println();
            if (this.db.isInitialized() && this.db.doesSchemaUpgradeNeedBGTasks()) {
                this.db.startSchemaUpgradeBGTasks();
            }
        }
        System.err.println();
    }

    private void initSocServer_DB(String dbUserName, String dbPassword, boolean wants_upg_schema, boolean accountsRequired, boolean db_test_bcrypt_mode) throws IllegalStateException, SQLException, EOFException {
        boolean db_err_printed = false;
        try {
            this.db = new SOCDBHelper();
            this.db.initialize(dbUserName, dbPassword, this.props);
            if (dbUserName == null) {
                return;
            }
            this.features.add("accts");
            System.err.println("User database initialized.");
            if (this.props.getProperty("jsettlers.db.script.setup") != null) {
                String msg = "DB setup script successful";
                this.utilityModeMessage = "DB setup script successful";
                throw new EOFException("DB setup script successful");
            }
            this.initSocServer_dbParamFields(wants_upg_schema);
            if (!this.db.isSchemaLatestVersion()) {
                if (wants_upg_schema) {
                    try {
                        this.db.upgradeSchema(this.databaseUserAdmins);
                        String msg = "DB schema upgrade was successful";
                        if (this.db.doesSchemaUpgradeNeedBGTasks()) {
                            msg = msg + "; some upgrade tasks will complete in the background during normal server operation";
                        }
                        this.utilityModeMessage = msg;
                        throw new EOFException(msg);
                    }
                    catch (EOFException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        db_err_printed = true;
                        if (e instanceof MissingResourceException) {
                            System.err.println("* To begin schema upgrade, please fix and rerun: " + e.getMessage());
                        } else {
                            System.err.println(e);
                        }
                        if (e instanceof SQLException) {
                            throw (SQLException)e;
                        }
                        SQLException sqle = new SQLException("Error during DB schema upgrade");
                        sqle.initCause(e);
                        throw sqle;
                    }
                }
                System.err.println("\n* Database schema upgrade is recommended: To upgrade, use -Djsettlers.db.upgrade_schema=Y command line flag.\n");
            } else if (wants_upg_schema) {
                db_err_printed = true;
                String errmsg = "* Cannot upgrade database schema: Already at latest version";
                System.err.println("* Cannot upgrade database schema: Already at latest version");
                throw new IllegalArgumentException("* Cannot upgrade database schema: Already at latest version");
            }
        }
        catch (SQLException sqle) {
            if (wants_upg_schema && db_err_printed) {
                throw sqle;
            }
            System.err.println("Warning: No user database available: " + sqle.getMessage());
            for (Throwable cause = sqle.getCause(); cause != null && !(cause instanceof ClassNotFoundException); cause = cause.getCause()) {
                System.err.println("\t" + cause);
            }
            if (wants_upg_schema || this.props.getProperty("jsettlers.db.script.setup") != null) {
                throw sqle;
            }
            String propReqDB = null;
            if (accountsRequired) {
                propReqDB = PROP_JSETTLERS_ACCOUNTS_REQUIRED;
            } else if (this.props.containsKey(PROP_JSETTLERS_ACCOUNTS_ADMINS)) {
                propReqDB = PROP_JSETTLERS_ACCOUNTS_ADMINS;
            } else if (this.getConfigBoolProperty("jsettlers.db.save.games", false)) {
                propReqDB = "jsettlers.db.save.games";
            }
            if (propReqDB != null) {
                String errMsg = "* Property " + propReqDB + " requires a database.";
                System.err.println(errMsg);
                System.err.println("\n* Exiting because current startup properties specify a database.");
                throw new SQLException(errMsg);
            }
            if (this.props.containsKey("jsettlers.db.url") || this.props.containsKey("jsettlers.db.jar") || this.props.containsKey("jsettlers.db.driver")) {
                System.err.println("* Exiting because current startup properties specify a database.");
                throw sqle;
            }
            if (this.props.containsKey("_jsettlers.user.pw_reset")) {
                System.err.println("* Exiting because --pw-reset requires a database.");
                throw sqle;
            }
            System.err.println("Users will not be authenticated.");
        }
        catch (EOFException eox) {
            throw eox;
        }
        catch (IOException iox) {
            System.err.println("\n* Could not run database setup script: " + iox.getMessage());
            for (Throwable cause = iox.getCause(); cause != null && !(cause instanceof ClassNotFoundException); cause = cause.getCause()) {
                System.err.println("\t" + cause);
            }
            this.db.cleanup(true);
            SQLException sqle = new SQLException("Error running DB setup script");
            sqle.initCause(iox);
            throw sqle;
        }
        catch (IllegalArgumentException iax) {
            System.err.println("\n* Error in specified database properties: " + iax.getMessage());
            SQLException sqle = new SQLException("Error with DB props");
            sqle.initCause(iax);
            throw sqle;
        }
        catch (DBSettingMismatchException dx) {
            System.err.println("\n* Mismatch between database settings and specified properties");
            SQLException sqle = new SQLException("DB settings mismatch");
            sqle.initCause(dx);
            throw sqle;
        }
        if (db_test_bcrypt_mode) {
            this.db.testBCryptSpeed();
        }
    }

    private void initSocServer_dbParamFields(boolean wantsUpgSchema) throws IllegalArgumentException, SQLException {
        if (this.getConfigBoolProperty(PROP_JSETTLERS_ACCOUNTS_OPEN, false)) {
            this.features.add("oreg");
            if (!this.hasUtilityModeProp) {
                System.err.println("User database Open Registration is active, anyone can create accounts.");
            }
        } else if (this.db.countUsers() == 0) {
            this.acctsNotOpenRegButNoUsers = true;
        }
        if (this.props.containsKey(PROP_JSETTLERS_ACCOUNTS_ADMINS)) {
            String errmsg = null;
            String userAdmins = this.props.getProperty(PROP_JSETTLERS_ACCOUNTS_ADMINS);
            if (userAdmins.length() == 0) {
                errmsg = "* Property jsettlers.accounts.admins cannot be an empty string.";
            } else if (this.features.isActive("oreg")) {
                errmsg = "* Cannot use Open Registration with User Account Admins List.";
            } else {
                boolean downcase = this.db.getSchemaVersion() >= 1200;
                this.databaseUserAdmins = new HashSet<String>();
                for (String adm : userAdmins.split(",")) {
                    String na = adm.trim();
                    if (na.length() <= 0) continue;
                    if (downcase) {
                        na = na.toLowerCase(Locale.US);
                    }
                    this.databaseUserAdmins.add(na);
                }
                if (this.databaseUserAdmins.isEmpty()) {
                    errmsg = "* Property jsettlers.accounts.admins cannot be an empty list.";
                }
            }
            if (errmsg != null) {
                System.err.println(errmsg);
                throw new IllegalArgumentException(errmsg);
            }
            System.err.println("User account administrators limited to: " + userAdmins);
            if (this.acctsNotOpenRegButNoUsers && !wantsUpgSchema) {
                System.err.println("** User database is currently empty: Run SOCAccountClient to create the user admin account(s) named above.");
            }
        } else if (!wantsUpgSchema && !this.features.isActive("oreg")) {
            System.err.println("** To create users, you must list admin names in property jsettlers.accounts.admins.");
        }
    }

    private void initSocServer_bots_start3p() throws IllegalArgumentException {
        String errMsg = null;
        this.robots3pCliConstrucs = new ArrayList<Constructor<? extends SOCRobotClient>>();
        int count = 1;
        for (String part : this.props.getProperty(PROP_JSETTLERS_BOTS_START3P).trim().split(",")) {
            if (part.isEmpty()) continue;
            if (Character.isDigit(part.charAt(0))) {
                count = 0;
                try {
                    count = Integer.parseInt(part);
                }
                catch (NumberFormatException e) {
                    errMsg = "Expected number but can't parse: " + part;
                    break;
                }
                if (count > 0) continue;
                errMsg = "Count must be at least 1: " + count;
                break;
            }
            if (part.indexOf(46) > 0) {
                try {
                    Class<?> rcli3p = Class.forName(part);
                    if (!SOCRobotClient.class.isAssignableFrom(rcli3p)) {
                        errMsg = "3p client not subclass of SOCRobotClient, can't be auto-started: " + part;
                        break;
                    }
                    try {
                        Constructor<?> cliConstruc3p = rcli3p.getDeclaredConstructor(ServerConnectInfo.class, String.class, String.class);
                        while (count > 0) {
                            this.robots3pCliConstrucs.add(cliConstruc3p);
                            --count;
                        }
                        count = 1;
                        continue;
                    }
                    catch (NoSuchMethodException e) {
                        errMsg = "3p client " + part + " missing constructor(ServerConnectInfo, String, String)";
                    }
                }
                catch (Exception | LinkageError err) {
                    errMsg = "3p client class " + part + " can't be loaded: " + err;
                }
                break;
            }
            errMsg = "Expected digits or fully qualified class name";
            break;
        }
        if (errMsg != null) {
            throw new IllegalArgumentException("Setup failed from property jsettlers.bots.start3p: " + errMsg);
        }
    }

    private void initSocServer_savegame() {
        String savegameDirPath = this.props.getProperty(PROP_JSETTLERS_SAVEGAME_DIR);
        if (savegameDirPath == null) {
            return;
        }
        try {
            this.savegameDir = new File(savegameDirPath);
            if (!this.savegameDir.exists()) {
                System.err.println("Warning: savegame.dir not found: " + savegameDirPath);
            } else if (!this.savegameDir.isDirectory()) {
                System.err.println("Warning: savegame.dir file exists but isn't a directory: " + savegameDirPath);
            }
        }
        catch (SecurityException e) {
            System.err.println("Warning: Can't access savegame.dir " + savegameDirPath + ": " + e);
        }
        boolean foundGson = false;
        Throwable loadErr = null;
        try {
            foundGson = null != Class.forName("com.google.gson.Gson");
        }
        catch (Throwable th) {
            loadErr = th;
        }
        if (loadErr != null || !foundGson) {
            this.savegameInitFailed = true;
            System.err.println("Warning: savegame disabled: Can't find Gson class" + (loadErr != null && !(loadErr instanceof ClassNotFoundException) ? ": " + loadErr : ""));
        }
    }

    @Override
    public void serverUp() throws IllegalStateException {
        if (this.hasUtilityModeProp) {
            throw new IllegalStateException();
        }
        if (this.props.containsKey(PROP_JSETTLERS_STARTROBOTS)) {
            try {
                int rcount = Integer.parseInt(this.props.getProperty(PROP_JSETTLERS_STARTROBOTS));
                final int hcount = this.maxConnections - rcount;
                int reserve = Math.max(rcount, 6);
                int fast30 = (int)(0.3f * (float)rcount);
                boolean loadSuccess = this.setupLocalRobots(fast30, rcount - fast30);
                if (!loadSuccess) {
                    System.err.println("** Cannot start the requested robots. Check server properties and classpath.");
                } else if (hcount < reserve) {
                    int newMaxC;
                    final int incr = reserve - hcount;
                    this.maxConnections = newMaxC = this.maxConnections + incr;
                    new Thread(){

                        @Override
                        public void run() {
                            try {
                                Thread.sleep(1600L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            System.err.println("** Warning: Only " + hcount + " player connections would be available because of the started robots.");
                            System.err.println("   Using " + SOCServer.this.maxConnections + " for max connection count (+" + incr + ").");
                        }
                    }.start();
                }
                if (this.numRobotOnlyGamesRemaining > 0) {
                    int n = 4;
                    if (4 > rcount) {
                        System.err.println("** To start robot-only games, server needs at least 4 robots started.");
                    } else {
                        int waitmSec;
                        final int waitSec = this.getConfigIntProperty(PROP_JSETTLERS_BOTS_BOTGAMES_WAIT__SEC, 0);
                        int n2 = waitmSec = waitSec > 0 ? 1000 * waitSec : 1600;
                        if (waitSec > 2) {
                            System.err.println("\nWaiting " + waitSec + " seconds before starting robot-only games.\n");
                        }
                        new Thread(){

                            @Override
                            public void run() {
                                try {
                                    Thread.sleep(waitmSec);
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                                if (waitSec > 2) {
                                    System.err.println("\nStarting robot-only games now, after waiting " + waitSec + " seconds.\n");
                                }
                                SOCServer.this.startRobotOnlyGames(false, false);
                            }
                        }.start();
                    }
                }
            }
            catch (NumberFormatException e) {
                System.err.println("** Not starting robots: Bad number format, ignoring property jsettlers.startrobots");
            }
        }
    }

    public final int getRobotCount() {
        return this.robots.size();
    }

    public final Connection getRobotConnection(String botName) {
        if (botName == null) {
            return null;
        }
        Enumeration<Connection> robotsEnum = this.robots.elements();
        while (robotsEnum.hasMoreElements()) {
            Connection robotConn = robotsEnum.nextElement();
            if (!botName.equals(robotConn.getData())) continue;
            return robotConn;
        }
        return null;
    }

    public final SOCRobotClient getRobotClient(String botName) {
        if (botName == null) {
            return null;
        }
        return SOCLocalRobotClient.robotClients.get(botName);
    }

    public final SOCRobotParameters getRobotParameters(String botName) {
        if (botName == null) {
            return null;
        }
        SOCRobotParameters params = null;
        try {
            params = this.db.retrieveRobotParams(botName);
            if (params != null && D.ebugIsEnabled()) {
                D.ebugPrintlnINFO("*** Robot Parameters for " + botName + " = " + params);
            }
        }
        catch (SQLException sqle) {
            System.err.println("Error retrieving robot parameters from db: Using defaults.");
        }
        if (params == null) {
            params = botName.startsWith("robot ") ? ROBOT_PARAMS_SMARTER : ROBOT_PARAMS_DEFAULT;
        }
        return params;
    }

    private final String generateRobotCookie() {
        byte[] rnd = new byte[16];
        this.rand.nextBytes(rnd);
        char[] rndChars = new char[32];
        int ic = 0;
        for (int i = 0; i < 16; ++i) {
            int byt = rnd[i] & 0xFF;
            rndChars[ic] = GENERATEROBOTCOOKIE_HEX[byt >>> 4];
            rndChars[++ic] = GENERATEROBOTCOOKIE_HEX[byt & 0xF];
            ++ic;
        }
        return new String(rndChars);
    }

    public void connectToChannel(Connection c, String ch) {
        if (c == null) {
            return;
        }
        if (this.channelList.isChannel(ch) && !this.channelList.isMember(c, ch)) {
            c.put(new SOCChannelMembers(ch, this.channelList.getMembers(ch)));
            D.ebugPrintlnINFO("*** " + c.getData() + " joined the channel " + ch + " at " + DateFormat.getTimeInstance(3).format(new Date()));
            this.channelList.addMember(c, ch);
        }
    }

    public boolean leaveChannel(Connection c, String ch, boolean destroyIfEmpty, boolean channelListLock) {
        boolean isEmpty;
        if (c == null) {
            return false;
        }
        String mName = c.getData();
        D.ebugPrintlnINFO("leaveChannel: " + mName + " " + ch + " " + channelListLock);
        if (this.channelList.isMember(c, ch)) {
            this.channelList.removeMember(c, ch);
            SOCLeaveChannel leaveMessage = new SOCLeaveChannel(mName, "-", ch);
            this.messageToChannelWithMon(ch, leaveMessage);
            D.ebugPrintlnINFO("*** " + mName + " left the channel " + ch + " at " + DateFormat.getTimeInstance(3).format(new Date()));
        }
        if ((isEmpty = this.channelList.isChannelEmpty(ch)) && destroyIfEmpty) {
            if (channelListLock) {
                this.destroyChannel(ch);
            } else {
                this.channelList.takeMonitor();
                try {
                    this.destroyChannel(ch);
                }
                catch (Exception e) {
                    D.ebugPrintStackTrace(e, "Exception in leaveChannel");
                }
                this.channelList.releaseMonitor();
            }
        }
        return isEmpty;
    }

    protected final void destroyChannel(String ch) {
        this.channelList.deleteChannel(ch);
        Connection oConn = (Connection)this.conns.get(this.channelList.getOwner(ch));
        if (oConn != null) {
            ((SOCClientData)oConn.getAppData()).deletedChannel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean connectToGame(Connection c, String gaName, SOCGameOptionSet gaOpts, SOCGame loadedGame) throws SOCGameOptionVersionException, MissingResourceException, NoSuchElementException, IllegalArgumentException, RuntimeException {
        if (c == null) {
            return false;
        }
        boolean result = false;
        int cliVers = c.getVersion();
        boolean gameExists = false;
        if (loadedGame == null) {
            try {
                this.gameList.takeMonitor();
                gameExists = this.gameList.isGame(gaName);
            }
            catch (Exception e) {
                D.ebugPrintStackTrace(e, "Exception in connectToGame");
            }
            finally {
                this.gameList.releaseMonitor();
            }
        }
        if (gameExists) {
            boolean cliVersOld = false;
            String cliMissingFeats = null;
            this.gameList.takeMonitorForGame(gaName);
            SOCGame ga = this.gameList.getGameData(gaName);
            try {
                if (this.gameList.isMember(c, gaName)) {
                    result = false;
                } else {
                    if (ga.getClientVersionMinRequired() > cliVers) {
                        cliVersOld = true;
                    } else {
                        SOCClientData scd = (SOCClientData)c.getAppData();
                        if ((this.has3rdPartyGameopts || scd.hasLimitedFeats) && (cliMissingFeats = ga.checkClientFeatures(scd.feats, false)) != null) {
                            cliVersOld = true;
                        }
                    }
                    if (!cliVersOld) {
                        this.gameList.addMember(c, gaName);
                        result = true;
                    }
                }
            }
            catch (Exception e) {
                D.ebugPrintStackTrace(e, "Exception in connectToGame (isMember)");
            }
            this.gameList.releaseMonitorForGame(gaName);
            if (cliMissingFeats != null) {
                throw new MissingResourceException("Client missing a feature", "unused", cliMissingFeats);
            }
            if (cliVersOld) {
                throw new IllegalArgumentException("Client version");
            }
        } else {
            int gVers;
            if (loadedGame != null) {
                gaOpts = loadedGame.getGameOptions();
            }
            if (gaOpts == null) {
                gVers = -1;
            } else {
                gVers = SOCVersionedItem.itemsMinimumVersion(gaOpts.getAll());
                if (gVers > cliVers && gVers < Integer.MAX_VALUE) {
                    List<SOCGameOption> optsValuesTooNew = gaOpts.optionsNewerThanVersion(cliVers, true, false);
                    throw new SOCGameOptionVersionException(gVers, cliVers, optsValuesTooNew);
                }
            }
            SOCGame newGame = this.createGameAndBroadcast(c, gaName, gaOpts, loadedGame, gVers, false, false);
            if (newGame != null) {
                result = true;
            }
        }
        return result;
    }

    public SOCGame createGameAndBroadcast(Connection c, String gaName, SOCGameOptionSet gaOpts, boolean isBotsOnly) {
        return this.createGameAndBroadcast(c, gaName, gaOpts, null, gaOpts != null ? SOCVersionedItem.itemsMinimumVersion(gaOpts.getAll()) : -1, isBotsOnly, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SOCGame createGameAndBroadcast(Connection c, String gaName, SOCGameOptionSet gaOpts, SOCGame loadedGame, int gVers, boolean isBotsOnly, boolean hasGameListMonitor) throws NoSuchElementException {
        SOCClientData scd = c != null ? (SOCClientData)c.getAppData() : null;
        SOCGame newGame = null;
        if (loadedGame != null) {
            gaOpts = loadedGame.getGameOptions();
        }
        if (!hasGameListMonitor) {
            this.gameList.takeMonitor();
        }
        boolean monitorReleased = false;
        try {
            String owner = c != null ? c.getData() : null;
            String localeStr = scd != null ? scd.localeStr : null;
            newGame = loadedGame != null ? this.gameList.addGame(loadedGame, this.handler, owner, localeStr) : this.gameList.createGame(gaName, owner, localeStr, gaOpts, this.handler);
            gaName = newGame.getName();
            if (isBotsOnly) {
                newGame.isBotsOnly = true;
            } else if (this.strSocketName != null && this.strSocketName.equals(PRACTICE_STRINGPORT)) {
                newGame.isPractice = true;
            }
            if (c != null) {
                this.gameList.addMember(c, gaName);
            }
            this.startLog(newGame, false);
            if (!hasGameListMonitor) {
                this.gameList.releaseMonitor();
            }
            monitorReleased = true;
            if (scd != null) {
                scd.createdGame();
            }
            this.broadcastNewGame(newGame, gaName, gaOpts, gVers);
        }
        catch (Exception e) {
            if (e instanceof NoSuchElementException && loadedGame != null) {
                throw (NoSuchElementException)e;
            }
            D.ebugPrintStackTrace(e, "Exception in createGameAndBroadcast");
        }
        finally {
            if (!monitorReleased && !hasGameListMonitor) {
                this.gameList.releaseMonitor();
            }
        }
        return newGame;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void broadcastNewGame(SOCGame newGame, String gaName, SOCGameOptionSet gaOpts, int gVers) {
        int cversMin = this.getMinConnectedCliVersion();
        if (gVers <= cversMin && gaOpts == null) {
            SOCNewGame msg = new SOCNewGame(gaName);
            this.broadcast(msg);
            this.recordGameEvent(gaName, msg);
        } else {
            Vector vector;
            SOCFeatureSet gameFeats;
            int gVersMinGameOptsNoChange = cversMin < Version.versionNumber() ? SOCVersionedItem.itemsMinimumVersion(gaOpts != null ? gaOpts.getAll() : null, true, null) : -1;
            Connection cliLimited = null;
            if ((this.has3rdPartyGameopts || !this.limitedConns.isEmpty()) && (gameFeats = newGame.getClientFeaturesRequired()) != null) {
                vector = this.unnamedConns;
                synchronized (vector) {
                    SOCClientData scd;
                    for (Connection lc : this.limitedConns) {
                        scd = (SOCClientData)lc.getAppData();
                        if (scd.isRobot || gVers > lc.getVersion() || newGame.canClientJoin(scd.feats)) continue;
                        cliLimited = lc;
                        break;
                    }
                    if (cliLimited == null && this.has3rdPartyGameopts) {
                        for (Connection c : this.conns.values()) {
                            scd = (SOCClientData)c.getAppData();
                            if (scd.isRobot || gVers > c.getVersion() || newGame.canClientJoin(scd.feats)) continue;
                            cliLimited = c;
                            break;
                        }
                        if (cliLimited == null) {
                            for (Connection c : this.unnamedConns) {
                                scd = (SOCClientData)c.getAppData();
                                if (scd.isRobot || gVers > c.getVersion() || newGame.canClientJoin(scd.feats)) continue;
                                cliLimited = c;
                                break;
                            }
                        }
                    }
                }
            }
            if (cversMin >= gVersMinGameOptsNoChange && cversMin >= 1107 && cliLimited == null) {
                SOCNewGameWithOptions msg = new SOCNewGameWithOptions(gaName, gaOpts, gVers, -2);
                this.broadcast(msg);
                this.recordGameEvent(gaName, msg);
            } else {
                HashMap<Integer, SOCMessage> msgCacheForVersion = new HashMap<Integer, SOCMessage>();
                vector = this.unnamedConns;
                synchronized (vector) {
                    this.broadcastNewGame_toConns(newGame, gaOpts, gVers, gVersMinGameOptsNoChange, this.conns.values(), cliLimited, msgCacheForVersion);
                    this.broadcastNewGame_toConns(newGame, gaOpts, gVers, gVersMinGameOptsNoChange, this.unnamedConns, cliLimited, msgCacheForVersion);
                }
                if (this.isRecordGameEventsActive()) {
                    this.recordGameEvent(gaName, new SOCNewGameWithOptions(gaName, gaOpts, gVers, -2));
                }
            }
        }
    }

    private void broadcastNewGame_toConns(SOCGame newGame, SOCGameOptionSet gaOpts, int gVers, int gVersMinGameOptsNoChange, Collection<Connection> connSet, Connection cliLimited, HashMap<Integer, SOCMessage> msgCacheForVersion) {
        String gaName = newGame.getName();
        SOCMessage cannotJoinMsgNoOpts = null;
        SOCNewGameWithOptions cannotJoinMsgWithOpts = null;
        for (Connection c : connSet) {
            Integer cversKey;
            SOCMessage cacheMsg;
            boolean versCanJoin;
            int cvers = c.getVersion();
            if (cliLimited != null && (c == cliLimited || (this.has3rdPartyGameopts || this.limitedConns.contains(c)) && !newGame.canClientJoin(((SOCClientData)c.getAppData()).feats))) {
                SOCMessage m;
                boolean unknownsWithDescs;
                boolean bl = unknownsWithDescs = cvers >= 2700;
                if (unknownsWithDescs && cvers < gVersMinGameOptsNoChange) {
                    m = new SOCNewGameWithOptions('?' + gaName, gaOpts, gVers, cvers);
                } else {
                    SOCNewGameWithOptions sOCNewGameWithOptions = m = unknownsWithDescs ? cannotJoinMsgWithOpts : cannotJoinMsgNoOpts;
                    if (m == null) {
                        m = unknownsWithDescs ? (cannotJoinMsgWithOpts = new SOCNewGameWithOptions(newGame, -2, false)) : (cannotJoinMsgNoOpts = new SOCNewGame('?' + gaName));
                    }
                }
                c.put(m);
                continue;
            }
            boolean bl = versCanJoin = cvers >= gVers;
            if (versCanJoin && (gaOpts == null || cvers < 1107)) {
                cvers = 1;
            }
            if ((cacheMsg = msgCacheForVersion.get(cversKey = Integer.valueOf(cvers))) != null) {
                c.put(cacheMsg);
                continue;
            }
            if (!versCanJoin) {
                boolean unknownsWithDescs;
                boolean bl2 = unknownsWithDescs = cvers >= 2700;
                if (unknownsWithDescs && cvers < gVersMinGameOptsNoChange) {
                    cacheMsg = new SOCNewGameWithOptions('?' + gaName, gaOpts, gVers, cvers);
                } else {
                    SOCMessage sOCMessage = cacheMsg = unknownsWithDescs ? cannotJoinMsgWithOpts : cannotJoinMsgNoOpts;
                    if (cacheMsg == null) {
                        if (unknownsWithDescs) {
                            cannotJoinMsgWithOpts = new SOCNewGameWithOptions(newGame, -2, false);
                            cacheMsg = cannotJoinMsgWithOpts;
                        } else {
                            cannotJoinMsgNoOpts = new SOCNewGame('?' + gaName);
                            cacheMsg = cannotJoinMsgNoOpts;
                        }
                    }
                }
            } else {
                cacheMsg = cvers == 1 ? new SOCNewGame(gaName) : (cvers >= gVersMinGameOptsNoChange ? new SOCNewGameWithOptions(gaName, gaOpts, gVers, -2) : new SOCNewGameWithOptions(gaName, gaOpts, gVers, cvers));
            }
            msgCacheForVersion.put(cversKey, cacheMsg);
            c.put(cacheMsg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean leaveGame(Connection c, SOCGame ga, String gm, boolean hasReplacement, boolean hasHumanReplacement, boolean destroyIfEmpty, boolean hasGameListLock) throws IllegalArgumentException {
        if (c == null) {
            return false;
        }
        if (gm == null) {
            if (ga == null) {
                throw new IllegalArgumentException("both null");
            }
            gm = ga.getName();
        }
        boolean gameDestroyed = false;
        this.gameList.removeMember(c, gm);
        if (ga == null && (ga = this.gameList.getGameData(gm)) == null) {
            return false;
        }
        GameHandler hand = this.gameList.getGameTypeHandler(gm);
        gameDestroyed = hand != null ? hand.leaveGame(ga, c, hasReplacement, hasHumanReplacement) || this.gameList.isGameEmpty(gm) : true;
        if (gameDestroyed && destroyIfEmpty) {
            if (hasGameListLock) {
                this.destroyGame(gm);
            } else {
                this.gameList.takeMonitor();
                try {
                    this.destroyGame(gm);
                }
                catch (Exception e) {
                    D.ebugPrintStackTrace(e, "Exception in leaveGame (destroyGame)");
                }
                finally {
                    this.gameList.releaseMonitor();
                }
            }
        }
        return gameDestroyed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void leaveGameMemberAndCleanup(Connection c, SOCGame game, String gaName) throws IllegalArgumentException {
        if (gaName == null) {
            if (game == null) {
                throw new IllegalArgumentException("both null");
            }
            gaName = game.getName();
        }
        if (!this.gameList.takeMonitorForGame(gaName)) {
            return;
        }
        boolean gameDestroyed = false;
        Vector<SOCReplaceRequest> reqList = this.robotDismissRequests.get(gaName);
        SOCReplaceRequest req = null;
        try {
            if (reqList != null) {
                Enumeration<SOCReplaceRequest> reqEnum = reqList.elements();
                while (reqEnum.hasMoreElements()) {
                    SOCReplaceRequest rr = reqEnum.nextElement();
                    if (rr.getLeaving() != c) continue;
                    req = rr;
                    break;
                }
            }
            boolean hasReplacement = req != null;
            SOCClientData repScd = hasReplacement ? (SOCClientData)req.getArriving().getAppData() : null;
            gameDestroyed = this.leaveGame(c, game, gaName, hasReplacement, repScd != null && !repScd.isRobot, true, false);
        }
        catch (Exception e) {
            D.ebugPrintStackTrace(e, "Exception in handleLEAVEGAME (leaveGame)");
        }
        finally {
            this.gameList.releaseMonitorForGame(gaName);
        }
        if (gameDestroyed) {
            this.broadcast(new SOCDeleteGame(gaName));
        }
        if (req != null) {
            reqList.removeElement(req);
            if (game == null) {
                game = this.gameList.getGameData(gaName);
            }
            if (gameDestroyed || game == null) {
                return;
            }
            int pn = req.getPlayerNumber();
            Connection arriving = req.getArriving();
            boolean isRobot = req.isArrivingRobot();
            if (!isRobot) {
                int faceId = 1;
                SOCClientData scd = (SOCClientData)arriving.getAppData();
                if (scd != null && scd.faceId > 0) {
                    faceId = scd.faceId;
                }
                game.getPlayer(pn).setFaceId(faceId);
            }
            this.sitDown(game, arriving, pn, isRobot, false);
        }
    }

    int[] robotShuffleForJoin() {
        int[] robotIndexes = new int[this.robots.size()];
        for (int i = 0; i < this.robots.size(); ++i) {
            robotIndexes[i] = i;
        }
        for (int j = 0; j < 3; ++j) {
            for (int i = 0; i < robotIndexes.length; ++i) {
                int idx = Math.abs(this.rand.nextInt() % (robotIndexes.length - i));
                int tmp = robotIndexes[idx];
                robotIndexes[idx] = robotIndexes[i];
                robotIndexes[i] = tmp;
            }
        }
        return robotIndexes;
    }

    public boolean setupLocalRobots(int numFast, int numSmart) {
        block9: {
            ServerConnectInfo sci = this.strSocketName != null ? new ServerConnectInfo(this.strSocketName, this.robotCookie) : new ServerConnectInfo("localhost", this.port, this.robotCookie);
            try {
                String rname;
                int i;
                for (i = 0; i < numFast; ++i) {
                    rname = "droid " + (i + 1);
                    SOCLocalRobotClient.createAndStartRobotClientThread(rname, sci, this.knownOpts, null);
                }
                for (i = 0; i < numSmart; ++i) {
                    rname = "robot " + (i + 1 + numFast);
                    SOCLocalRobotClient.createAndStartRobotClientThread(rname, sci, this.knownOpts, null);
                }
                if (this.robots3pCliConstrucs == null) break block9;
                String curr3pBotClass = null;
                try {
                    int i2 = 0;
                    for (Constructor<? extends SOCRobotClient> con : this.robots3pCliConstrucs) {
                        curr3pBotClass = con.getDeclaringClass().getName();
                        SOCLocalRobotClient.createAndStartRobotClientThread("extrabot " + ++i2, sci, this.knownOpts, con);
                    }
                }
                catch (Exception e) {
                    System.err.println("*** Can't start third-party bot " + curr3pBotClass + ": " + e);
                    if (e instanceof ReflectiveOperationException && e.getCause() instanceof Exception) {
                        e = (Exception)e.getCause();
                        System.err.println("    caused by " + e);
                    }
                    e.printStackTrace();
                    return false;
                }
            }
            catch (Exception e) {
                System.err.println("*** setupLocalRobots: Can't start bot: " + e);
                return false;
            }
            catch (LinkageError e) {
                return false;
            }
        }
        return true;
    }

    public void destroyGame(String gm) {
        Connection oConn;
        String gaOwner;
        SOCGame cg = null;
        cg = this.gameList.getGameData(gm);
        if (cg == null) {
            return;
        }
        boolean wasBotsOnly = cg.isBotsOnly;
        Vector<Connection> members = null;
        members = this.gameList.getMembers(gm);
        this.endLog(cg);
        this.gameList.deleteGame(gm);
        if (members != null) {
            Enumeration<Connection> conEnum = members.elements();
            while (conEnum.hasMoreElements()) {
                Connection con = conEnum.nextElement();
                this.messageToPlayer(con, null, -256, new SOCRobotDismiss(gm));
            }
        }
        if ((gaOwner = cg.getOwner()) != null && (oConn = (Connection)this.conns.get(gaOwner)) != null) {
            ((SOCClientData)oConn.getAppData()).deletedGame();
        }
        if (!wasBotsOnly) {
            return;
        }
        if (this.numRobotOnlyGamesRemaining > 0) {
            this.startRobotOnlyGames(true, true);
        } else if (this.getConfigIntProperty(PROP_JSETTLERS_BOTS_BOTGAMES_TOTAL, 0) > 0 && this.gameList.size() == 0 && this.getConfigBoolProperty(PROP_JSETTLERS_BOTS_BOTGAMES_SHUTDOWN, false)) {
            this.stopServer(">>> All Robot-only games have finished. Shutting down server. <<<");
            System.exit(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyGameAndBroadcast(String gaName, String descForStackTrace) {
        this.gameList.takeMonitor();
        try {
            this.destroyGame(gaName);
        }
        catch (Exception e) {
            D.ebugPrintStackTrace(e, "Exception in " + (descForStackTrace != null ? descForStackTrace : "destroyGame"));
        }
        finally {
            this.gameList.releaseMonitor();
        }
        this.broadcast(new SOCDeleteGame(gaName));
    }

    public SOCGameListAtServer getGameList() {
        return this.gameList;
    }

    public Collection<String> getGameNames() {
        return this.gameList.getGameNames();
    }

    public SOCGame getGame(String gaName) {
        return this.gameList.getGameData(gaName);
    }

    public int getGameState(String gm) {
        SOCGame g = this.gameList.getGameData(gm);
        if (g != null) {
            return g.getGameState();
        }
        return -1;
    }

    public SOCGameOptionSet getGameOptions(String gm) {
        return this.gameList.getGameOptions(gm);
    }

    public boolean activateKnownOption(String optKey) throws IllegalArgumentException {
        String desc;
        boolean isSupported;
        SOCClientData scd;
        int cliVers;
        SOCGameOption opt = this.knownOpts.get(optKey);
        if (opt == null) {
            return false;
        }
        if (opt.hasFlag(8)) {
            return true;
        }
        this.knownOpts.activate(optKey);
        opt = this.knownOpts.get(optKey);
        int minVers = opt.minVersion;
        String optFeat = opt.getClientFeature();
        String optDesc = opt.getDesc();
        for (Connection c : this.conns.values()) {
            cliVers = c.getVersion();
            scd = (SOCClientData)c.getAppData();
            isSupported = cliVers >= minVers && (optFeat == null || scd != null && scd.feats.isActive(optFeat));
            desc = !isSupported && cliVers >= 2700 ? optDesc : null;
            c.put(new SOCGameOptionInfo(isSupported ? opt : new SOCGameOption(opt.key, desc), cliVers, null));
        }
        for (Connection c : this.unnamedConns) {
            cliVers = c.getVersion();
            scd = (SOCClientData)c.getAppData();
            isSupported = cliVers >= minVers && (optFeat == null || scd != null && scd.feats.isActive(optFeat));
            desc = !isSupported && cliVers >= 2700 ? optDesc : null;
            c.put(new SOCGameOptionInfo(isSupported ? opt : new SOCGameOption(opt.key, desc), cliVers, null));
        }
        return true;
    }

    public final boolean isDebugUserEnabled() {
        return this.allowDebugUser;
    }

    public final boolean hasUtilityModeProperty() {
        return this.hasUtilityModeProp;
    }

    public final String getUtilityModeMessage() {
        return this.utilityModeMessage;
    }

    public String getFeaturesList() {
        SOCFeatureSet feats = this.features;
        if (this.acctsNotOpenRegButNoUsers) {
            feats = new SOCFeatureSet(this.features);
            feats.add("oreg");
        }
        return feats.getEncodedList();
    }

    public static SOCGameOptionSet localizeKnownOptions(Locale loc, boolean updateStaticKnownOpts) {
        boolean hasLocalDescs;
        SOCGameOptionSet knownOpts = new SOCGameOptionSet(startupKnownOpts, false);
        SOCStringManager sm = SOCStringManager.getServerManagerForClient(loc);
        boolean bl = hasLocalDescs = !i18n_gameopt_PL_desc.equals(sm.get("gameopt.PL"));
        if (!hasLocalDescs) {
            return knownOpts;
        }
        SOCGameOptionSet opts = new SOCGameOptionSet();
        for (SOCGameOption opt : knownOpts) {
            String optKey = opt.key;
            try {
                SOCGameOption oLocal = new SOCGameOption(opt, sm.get("gameopt." + optKey));
                opts.put(oLocal);
                if (!updateStaticKnownOpts) continue;
                startupKnownOpts.put(oLocal);
            }
            catch (MissingResourceException e) {
                opts.put(opt);
            }
        }
        return opts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void leaveAllChannels(Connection c) {
        if (c == null) {
            return;
        }
        ArrayList<String> toDestroy = new ArrayList<String>();
        this.channelList.takeMonitor();
        try {
            Enumeration<String> k = this.channelList.getChannels();
            while (k.hasMoreElements()) {
                String ch = k.nextElement();
                if (!this.channelList.isMember(c, ch)) continue;
                boolean thisChannelDestroyed = false;
                this.channelList.takeMonitorForChannel(ch);
                try {
                    thisChannelDestroyed = this.leaveChannel(c, ch, false, true);
                }
                catch (Exception e) {
                    D.ebugPrintStackTrace(e, "Exception in leaveAllChannels (leaveChannel)");
                }
                this.channelList.releaseMonitorForChannel(ch);
                if (!thisChannelDestroyed) continue;
                toDestroy.add(ch);
            }
        }
        catch (Exception e) {
            D.ebugPrintStackTrace(e, "Exception in leaveAllChannels");
        }
        finally {
            try {
                for (String ch : toDestroy) {
                    this.destroyChannel(ch);
                }
            }
            finally {
                this.channelList.releaseMonitor();
            }
        }
        for (String ch : toDestroy) {
            this.broadcast(new SOCDeleteChannel(ch));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void leaveAllGames(Connection c) {
        if (c == null) {
            return;
        }
        ArrayList<String> toDestroy = new ArrayList<String>();
        this.gameList.takeMonitor();
        for (String ga : this.gameList.getGameNames()) {
            Vector<Connection> v = this.gameList.getMembers(ga);
            if (!v.contains(c)) continue;
            boolean thisGameDestroyed = false;
            this.gameList.takeMonitorForGame(ga);
            try {
                thisGameDestroyed = this.leaveGame(c, null, ga, false, false, false, true);
            }
            catch (Exception e) {
                D.ebugPrintStackTrace(e, "Exception in leaveAllGames (leaveGame)");
            }
            this.gameList.releaseMonitorForGame(ga);
            if (!thisGameDestroyed) continue;
            toDestroy.add(ga);
        }
        try {
            for (String ga : toDestroy) {
                this.destroyGame(ga);
            }
        }
        finally {
            this.gameList.releaseMonitor();
        }
        catch (Exception e) {
            D.ebugPrintStackTrace(e, "Exception in leaveAllGames");
            try {
                for (String ga : toDestroy) {
                    this.destroyGame(ga);
                }
            }
            finally {
                this.gameList.releaseMonitor();
            }
            catch (Throwable throwable) {
                try {
                    for (String ga : toDestroy) {
                        this.destroyGame(ga);
                    }
                }
                finally {
                    this.gameList.releaseMonitor();
                }
                throw throwable;
            }
        }
        for (String ga : toDestroy) {
            D.ebugPrintlnINFO("** Broadcasting SOCDeleteGame " + ga);
            this.broadcast(new SOCDeleteGame(ga));
        }
    }

    public void messageToChannel(String ch, SOCMessage mes) {
        String mesCmd = mes.toCmd();
        this.channelList.takeMonitorForChannel(ch);
        try {
            Vector<Connection> v = this.channelList.getMembers(ch);
            if (v != null) {
                Enumeration<Connection> menum = v.elements();
                while (menum.hasMoreElements()) {
                    Connection c = menum.nextElement();
                    if (c == null) continue;
                    c.put(mesCmd);
                }
            }
        }
        catch (Exception e) {
            D.ebugPrintStackTrace(e, "Exception in messageToChannel");
        }
        this.channelList.releaseMonitorForChannel(ch);
    }

    public void messageToChannelWithMon(String ch, SOCMessage mes) {
        Vector<Connection> v = this.channelList.getMembers(ch);
        if (v != null) {
            String mesCmd = mes.toCmd();
            Enumeration<Connection> menum = v.elements();
            while (menum.hasMoreElements()) {
                Connection c = menum.nextElement();
                if (c == null) continue;
                c.put(mesCmd);
            }
        }
    }

    public void messageToPlayer(Connection c, SOCMessage mes) {
        this.messageToPlayer(c, null, -256, mes);
    }

    public void messageToPlayer(Connection c, String eventGameName, int eventPN, SOCMessage mes) {
        if (c == null || mes == null) {
            return;
        }
        if (eventGameName != null && eventPN != -256) {
            this.recordGameEventTo(eventGameName, eventPN, mes);
        }
        c.put(mes);
    }

    public void messageToPlayer(Connection c, String ga, String txt) {
        this.messageToPlayer(c, ga, -256, txt);
    }

    public void messageToPlayer(Connection c, String gameName, int eventPN, String txt) {
        if (c == null) {
            return;
        }
        if (c.getVersion() >= 2000) {
            SOCGameServerText msg = new SOCGameServerText(gameName, txt);
            c.put(msg);
            if (eventPN != -256) {
                this.recordGameEventTo(gameName, eventPN, msg);
            }
        } else {
            c.put(new SOCGameTextMsg(gameName, SERVERNAME, txt));
            if (eventPN != -256 && this.isRecordGameEventsActive()) {
                this.recordGameEventTo(gameName, eventPN, new SOCGameServerText(gameName, txt));
            }
        }
    }

    public final void messageToPlayerKeyed(Connection c, String gaName, String key) {
        if (c == null) {
            return;
        }
        this.messageToPlayer(c, gaName, -256, c.getLocalized(key));
    }

    public final void messageToPlayerKeyed(Connection c, String gameName, int eventPN, String key) {
        this.messageToPlayerKeyed(c, gameName, eventPN, key, (Object[])null);
    }

    public final void messageToPlayerKeyed(Connection c, String gaName, String key, Object ... args) {
        if (c == null) {
            return;
        }
        this.messageToPlayer(c, gaName, -256, c.getLocalized(key, args));
    }

    public final void messageToPlayerKeyed(Connection c, String gaName, int eventPN, String key, Object ... args) {
        if (c == null) {
            return;
        }
        if (eventPN != -256 && this.isRecordGameEventsActive() && !"en_US".equals(c.getI18NLocale())) {
            SOCStringManager mgr = SOCStringManager.getFallbackServerManagerForClient();
            this.recordGameEventTo(gaName, eventPN, new SOCGameServerText(gaName, args != null ? mgr.get(key, args) : mgr.get(key)));
            eventPN = -256;
        }
        this.messageToPlayer(c, gaName, eventPN, args != null ? c.getLocalized(key, args) : c.getLocalized(key));
    }

    public final void messageToPlayerKeyedSpecial(Connection c, SOCGame ga, int eventPN, String key, Object ... args) {
        if (c == null) {
            return;
        }
        if (eventPN != -256 && this.isRecordGameEventsActive() && !"en_US".equals(c.getI18NLocale())) {
            this.recordGameEventTo(ga.getName(), eventPN, new SOCGameServerText(ga.getName(), SOCStringManager.getFallbackServerManagerForClient().getSpecial(ga, key, args)));
            eventPN = -256;
        }
        this.messageToPlayer(c, ga.getName(), eventPN, c.getLocalizedSpecial(ga, key, args));
    }

    public final void messageToPlayerPendingKeyed(SOCPlayer pl, String gaName, String key) {
        if (pl == null) {
            return;
        }
        Connection c = this.getConnection(pl.getName());
        if (c == null) {
            return;
        }
        if (c.getVersion() >= 2000) {
            pl.pendingMessagesOut.add(new SOCGameServerText(gaName, c.getLocalized(key)));
        } else {
            pl.pendingMessagesOut.add(new SOCGameTextMsg(gaName, SERVERNAME, c.getLocalized(key)));
        }
    }

    public void messageToGame(String gameName, SOCMessage mes) {
        this.messageToGame(gameName, false, mes);
    }

    public void messageToGame(String gameName, boolean isEvent, SOCMessage mes) {
        if (isEvent) {
            this.recordGameEvent(gameName, mes);
        }
        String mesCmd = mes.toCmd();
        this.gameList.takeMonitorForGame(gameName);
        try {
            Vector<Connection> v = this.gameList.getMembers(gameName);
            if (v != null) {
                Enumeration<Connection> menum = v.elements();
                while (menum.hasMoreElements()) {
                    Connection c = menum.nextElement();
                    if (c == null) continue;
                    c.put(mesCmd);
                }
            }
        }
        catch (Exception e) {
            D.ebugPrintStackTrace(e, "Exception in messageToGame");
        }
        this.gameList.releaseMonitorForGame(gameName);
    }

    public void messageToGame(String ga, String txt) {
        this.messageToGame(ga, false, txt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageToGame(String ga, boolean isEvent, String txt) {
        SOCGameServerText msg = new SOCGameServerText(ga, txt);
        String gameServTxtMsg = msg.toCmd();
        if (isEvent) {
            this.recordGameEvent(ga, msg);
        }
        this.gameList.takeMonitorForGame(ga);
        try {
            Vector<Connection> v = this.gameList.getMembers(ga);
            if (v != null) {
                Enumeration<Connection> menum = v.elements();
                while (menum.hasMoreElements()) {
                    Connection c = menum.nextElement();
                    if (c == null) continue;
                    if (c.getVersion() >= 2000) {
                        c.put(gameServTxtMsg);
                        continue;
                    }
                    c.put(new SOCGameTextMsg(ga, SERVERNAME, txt));
                }
            }
        }
        catch (Throwable e) {
            D.ebugPrintStackTrace(e, "Exception in messageToGame");
        }
        finally {
            this.gameList.releaseMonitorForGame(ga);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageToGameKeyedType(SOCGame ga, boolean isEvent, SOCKeyedMessage msg, boolean takeMon) {
        block20: {
            boolean hasMultiLocales = ga.hasMultiLocales;
            String gaName = ga.getName();
            boolean rsrcMissing = false;
            SOCMessage msgForRecord = null;
            if (takeMon) {
                this.gameList.takeMonitorForGame(gaName);
            }
            try {
                Vector<Connection> v = this.gameList.getMembers(gaName);
                if (v == null) {
                    return;
                }
                Enumeration<Connection> menum = v.elements();
                String msgKey = msg.getKey();
                String localText = null;
                String gameTxtLocale = null;
                SOCMessage gameLocalMsg = null;
                while (menum.hasMoreElements()) {
                    Connection c = menum.nextElement();
                    if (c == null) continue;
                    String cliLocale = c.getI18NLocale();
                    if (gameLocalMsg == null || hasMultiLocales && (cliLocale == null ? gameTxtLocale != null : !cliLocale.equals(gameTxtLocale))) {
                        if (msgKey != null) {
                            try {
                                localText = c.getLocalized(msgKey);
                            }
                            catch (MissingResourceException e) {
                                localText = msgKey;
                                rsrcMissing = true;
                            }
                        }
                        gameLocalMsg = msg.localize(localText);
                        gameTxtLocale = cliLocale;
                        if (isEvent && msgForRecord == null && this.isRecordGameEventsActive() && "en_US".equals(cliLocale)) {
                            msgForRecord = gameLocalMsg;
                        }
                    }
                    if (gameLocalMsg == null) continue;
                    c.put(gameLocalMsg);
                }
                if (rsrcMissing) {
                    D.ebugPrintlnINFO("Missing string key in messageToGameKeyedType: " + msgKey);
                }
                if (!isEvent || !this.isRecordGameEventsActive()) break block20;
                if (msgForRecord == null) {
                    if (msgKey != null) {
                        try {
                            localText = SOCStringManager.getFallbackServerManagerForClient().get(msgKey);
                        }
                        catch (MissingResourceException e) {
                            localText = msgKey;
                        }
                    }
                    msgForRecord = msg.localize(localText);
                }
                this.recordGameEvent(gaName, msgForRecord);
            }
            catch (Throwable e) {
                D.ebugPrintStackTrace(e, "Exception in messageToGameKeyedType");
            }
            finally {
                if (takeMon) {
                    this.gameList.releaseMonitorForGame(gaName);
                }
            }
        }
    }

    public void messageToGameKeyed(SOCGame ga, boolean takeMon, String key) throws MissingResourceException {
        this.messageToGameKeyed(ga, false, takeMon, key, (Object[])null);
    }

    public void messageToGameKeyed(SOCGame ga, boolean isEvent, boolean takeMon, String key) throws MissingResourceException {
        this.messageToGameKeyed(ga, isEvent, takeMon, key, (Object[])null);
    }

    public void messageToGameKeyed(SOCGame ga, boolean takeMon, String key, Object ... params) throws NullPointerException, MissingResourceException {
        this.impl_messageToGameKeyedSpecial(ga, false, null, takeMon, this.gameList.getMembers(ga.getName()), null, false, key, params);
    }

    public void messageToGameKeyed(SOCGame ga, boolean isEvent, boolean takeMon, String key, Object ... params) throws NullPointerException, MissingResourceException {
        this.impl_messageToGameKeyedSpecial(ga, isEvent, null, takeMon, this.gameList.getMembers(ga.getName()), null, false, key, params);
    }

    public final void messageToGameKeyedSpecial(SOCGame ga, boolean isEvent, boolean takeMon, String key, Object ... params) throws NullPointerException, MissingResourceException, IllegalArgumentException {
        this.impl_messageToGameKeyedSpecial(ga, isEvent, null, takeMon, this.gameList.getMembers(ga.getName()), null, true, key, params);
    }

    public final void messageToGameKeyedSpecialExcept(SOCGame ga, int eventExclPN, boolean takeMon, Connection ex, String key, Object ... params) throws NullPointerException, MissingResourceException, IllegalArgumentException {
        int[] nArray;
        if (eventExclPN != -256) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = eventExclPN;
        } else {
            nArray = null;
        }
        int[] excl = nArray;
        this.impl_messageToGameKeyedSpecial(ga, excl != null, excl, takeMon, this.gameList.getMembers(ga.getName()), ex, true, key, params);
    }

    public final void messageToGameKeyedSpecialExcept(SOCGame ga, int[] eventExclPNs, boolean takeMon, List<Connection> ex, String key, Object ... params) throws NullPointerException, MissingResourceException, IllegalArgumentException {
        AbstractList sendTo = this.gameList.getMembers(ga.getName());
        if (ex != null && !ex.isEmpty()) {
            sendTo = new ArrayList<Connection>(sendTo);
            for (Connection excl : ex) {
                sendTo.remove(excl);
            }
        }
        this.impl_messageToGameKeyedSpecial(ga, eventExclPNs != null, eventExclPNs, takeMon, sendTo, null, true, key, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void impl_messageToGameKeyedSpecial(SOCGame ga, boolean isEvent, int[] eventExclPNs, boolean takeMon, List<Connection> members, Connection ex, boolean fmtSpecial, String key, Object ... params) throws NullPointerException, MissingResourceException, IllegalArgumentException {
        block20: {
            if (members == null) {
                return;
            }
            if (key == null) {
                throw new NullPointerException("key");
            }
            boolean hasMultiLocales = ga.hasMultiLocales;
            String gaName = ga.getName();
            SOCGameServerText msgForRecord = null;
            if (takeMon) {
                this.gameList.takeMonitorForGame(gaName);
            }
            try {
                Iterator<Connection> miter = members.iterator();
                String gameText = null;
                String gameTxtLocale = null;
                SOCGameServerText gameTextMsg = null;
                while (miter.hasNext()) {
                    String cliLocale;
                    Connection c = miter.next();
                    if (c == null || c == ex || (cliLocale = c.getI18NLocale()) == null) continue;
                    if (gameTextMsg == null || hasMultiLocales && !cliLocale.equals(gameTxtLocale)) {
                        gameText = fmtSpecial ? c.getLocalizedSpecial(ga, key, params) : (params != null ? c.getLocalized(key, params) : c.getLocalized(key));
                        gameTextMsg = new SOCGameServerText(gaName, gameText);
                        gameTxtLocale = cliLocale;
                        if (isEvent && msgForRecord == null && this.isRecordGameEventsActive() && "en_US".equals(cliLocale)) {
                            msgForRecord = gameTextMsg;
                        }
                    }
                    if (c.getVersion() >= 2000 && gameTextMsg != null) {
                        c.put(gameTextMsg);
                        continue;
                    }
                    c.put(new SOCGameTextMsg(gaName, SERVERNAME, gameText));
                }
                if (!isEvent || !this.isRecordGameEventsActive()) break block20;
                if (msgForRecord == null) {
                    String txt = key;
                    try {
                        SOCStringManager mgr = SOCStringManager.getFallbackServerManagerForClient();
                        txt = fmtSpecial ? mgr.getSpecial(ga, key, params) : (params != null ? mgr.get(key, params) : mgr.get(key));
                    }
                    catch (IllegalArgumentException | MissingResourceException runtimeException) {
                        // empty catch block
                    }
                    msgForRecord = new SOCGameServerText(gaName, txt);
                }
                if (eventExclPNs == null) {
                    this.recordGameEvent(gaName, msgForRecord);
                } else if (eventExclPNs.length == 1) {
                    this.recordGameEventNotTo(gaName, eventExclPNs[0], (SOCMessage)msgForRecord);
                } else {
                    this.recordGameEventNotTo(gaName, eventExclPNs, (SOCMessage)msgForRecord);
                }
            }
            catch (Throwable e) {
                D.ebugPrintStackTrace(e, fmtSpecial ? "Exception in messageToGameKeyedSpecial" : "Exception in messageToGameKeyed");
            }
            finally {
                if (takeMon) {
                    this.gameList.releaseMonitorForGame(gaName);
                }
            }
        }
    }

    public void messageToGameWithMon(String gameName, SOCMessage mes) {
        this.messageToGameWithMon(gameName, false, mes);
    }

    public void messageToGameWithMon(String gameName, boolean isEvent, SOCMessage mes) {
        Vector<Connection> v;
        if (isEvent) {
            this.recordGameEvent(gameName, mes);
        }
        if ((v = this.gameList.getMembers(gameName)) == null) {
            return;
        }
        String mesCmd = mes.toCmd();
        Enumeration<Connection> menum = v.elements();
        while (menum.hasMoreElements()) {
            Connection c = menum.nextElement();
            if (c == null) continue;
            c.put(mesCmd);
        }
    }

    public void messageToGameExcept(String gn, Connection ex, int eventExclPN, String txt, boolean takeMon) {
        this.messageToGameExcept(gn, ex, eventExclPN, (SOCMessage)new SOCGameTextMsg(gn, SERVERNAME, txt), takeMon);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageToGameExcept(String gn, List<Connection> ex, int[] eventExclPNs, SOCMessage mes, boolean takeMon) {
        if (eventExclPNs != null) {
            this.recordGameEventNotTo(gn, eventExclPNs, mes);
        }
        if (takeMon) {
            this.gameList.takeMonitorForGame(gn);
        }
        try {
            Vector<Connection> v = this.gameList.getMembers(gn);
            if (v != null) {
                String mesCmd = mes.toCmd();
                Enumeration<Connection> menum = v.elements();
                while (menum.hasMoreElements()) {
                    Connection con = menum.nextElement();
                    if (con == null || ex.contains(con)) continue;
                    con.put(mesCmd);
                }
            }
        }
        catch (Exception e) {
            D.ebugPrintStackTrace(e, "Exception in messageToGameExcept");
        }
        finally {
            if (takeMon) {
                this.gameList.releaseMonitorForGame(gn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageToGameExcept(String gn, Connection ex, int eventExclPN, SOCMessage mes, boolean takeMon) {
        if (eventExclPN != -256) {
            this.recordGameEventNotTo(gn, eventExclPN, mes);
        }
        if (takeMon) {
            this.gameList.takeMonitorForGame(gn);
        }
        try {
            Vector<Connection> v = this.gameList.getMembers(gn);
            if (v != null) {
                String mesCmd = mes.toCmd();
                Enumeration<Connection> menum = v.elements();
                while (menum.hasMoreElements()) {
                    Connection con = menum.nextElement();
                    if (con == null || con == ex) continue;
                    con.put(mesCmd);
                }
            }
        }
        catch (Exception e) {
            D.ebugPrintStackTrace(e, "Exception in messageToGameExcept");
        }
        finally {
            if (takeMon) {
                this.gameList.releaseMonitorForGame(gn);
            }
        }
    }

    public final void messageToGameForVersions(SOCGame ga, int vmin, int vmax, SOCMessage mes, boolean takeMon) {
        this.messageToGameForVersionsExcept(ga, vmin, vmax, (List<Connection>)null, mes, takeMon);
    }

    public final void messageToGameForVersionsExcept(SOCGame ga, int vmin, int vmax, Connection ex, SOCMessage mes, boolean takeMon) {
        ArrayList<Connection> exs;
        if (ex != null) {
            exs = new ArrayList<Connection>();
            exs.add(ex);
        } else {
            exs = null;
        }
        this.messageToGameForVersionsExcept(ga, vmin, vmax, exs, mes, takeMon);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void messageToGameForVersionsExcept(SOCGame ga, int vmin, int vmax, List<Connection> ex, SOCMessage mes, boolean takeMon) {
        if (ga.clientVersionLowest > vmax || ga.clientVersionHighest < vmin) {
            return;
        }
        String gaName = ga.getName();
        if (takeMon) {
            this.gameList.takeMonitorForGame(gaName);
        }
        try {
            Vector<Connection> v = this.gameList.getMembers(gaName);
            if (v == null) {
                return;
            }
            String mesCmd = null;
            Enumeration<Connection> menum = v.elements();
            while (menum.hasMoreElements()) {
                int cv;
                Connection c = menum.nextElement();
                if (c == null || ex != null && ex.contains(c) || (cv = c.getVersion()) < vmin || cv > vmax) continue;
                if (mesCmd == null) {
                    mesCmd = mes.toCmd();
                }
                c.put(mesCmd);
            }
        }
        catch (Exception e) {
            D.ebugPrintStackTrace(e, "Exception in messageToGameForVersionsExcept");
        }
        finally {
            if (takeMon) {
                this.gameList.releaseMonitorForGame(gaName);
            }
        }
    }

    public final void messageToGameForVersionsKeyed(SOCGame ga, int vmin, int vmax, boolean takeMon, boolean formatSpecial, String key, Object ... params) throws MissingResourceException, IllegalArgumentException {
        this.messageToGameForVersionsKeyedExcept(ga, vmin, vmax, takeMon, null, formatSpecial, key, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void messageToGameForVersionsKeyedExcept(SOCGame ga, int vmin, int vmax, boolean takeMon, List<Connection> ex, boolean formatSpecial, String key, Object ... params) throws MissingResourceException, IllegalArgumentException {
        if (ga.clientVersionLowest > vmax || ga.clientVersionHighest < vmin) {
            return;
        }
        boolean hasMultiLocales = ga.hasMultiLocales;
        String gaName = ga.getName();
        if (takeMon) {
            this.gameList.takeMonitorForGame(gaName);
        }
        try {
            Vector<Connection> v = this.gameList.getMembers(gaName);
            if (v == null) {
                return;
            }
            String gameText = null;
            String gameTxtLocale = null;
            SOCGameServerText gameTextMsg = null;
            Enumeration<Connection> menum = v.elements();
            while (menum.hasMoreElements()) {
                String cliLocale;
                int cv;
                Connection c = menum.nextElement();
                if (c == null || ex != null && ex.contains(c) || (cv = c.getVersion()) < vmin || cv > vmax || (cliLocale = c.getI18NLocale()) == null) continue;
                if (gameTextMsg == null || hasMultiLocales && !cliLocale.equals(gameTxtLocale)) {
                    gameText = formatSpecial ? c.getLocalizedSpecial(ga, key, params) : (params != null ? c.getLocalized(key, params) : c.getLocalized(key));
                    gameTextMsg = new SOCGameServerText(gaName, gameText);
                    gameTxtLocale = cliLocale;
                }
                if (cv >= 2000 && gameTextMsg != null) {
                    c.put(gameTextMsg);
                    continue;
                }
                c.put(new SOCGameTextMsg(gaName, SERVERNAME, gameText));
            }
        }
        catch (Exception e) {
            D.ebugPrintStackTrace(e, "Exception in messageToGameForVersionsKeyedExcept");
        }
        finally {
            if (takeMon) {
                this.gameList.releaseMonitorForGame(gaName);
            }
        }
    }

    public void messageToGameUrgent(String gaName, boolean isEvent, String mes) {
        if (!mes.startsWith(">>>")) {
            mes = ">>> " + mes;
        }
        this.messageToGame(gaName, isEvent, mes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void leaveConnection(Connection c) {
        if (c == null || c.getData() == null) {
            return;
        }
        this.leaveAllChannels(c);
        this.leaveAllGames(c);
        SOCClientData scd = (SOCClientData)c.getAppData();
        if (scd.isRobot) {
            Vector<Connection> vector = this.robots;
            synchronized (vector) {
                this.robots.removeElement(c);
                if (!scd.isBuiltInRobot) {
                    this.robots3p.removeElement(c);
                }
            }
            HashMap<String, Object> waitingGames = new HashMap<String, Object>();
            Hashtable<String, Hashtable<Connection, Object>> hashtable = this.robotJoinRequests;
            synchronized (hashtable) {
                for (Map.Entry<String, Hashtable<Connection, Object>> gaReqs : this.robotJoinRequests.entrySet()) {
                    Hashtable<Connection, Object> rConns = gaReqs.getValue();
                    Object reqInfo = rConns.remove(c);
                    if (reqInfo == null) continue;
                    if (null != System.getProperty("jsettlers.bots.test.quit_at_joinreq")) {
                        System.err.println("srv.leaveConnection('" + c.getData() + "') found waiting ga: '" + gaReqs.getKey() + "' (" + reqInfo + ")");
                    }
                    waitingGames.put(gaReqs.getKey(), reqInfo);
                }
            }
            if (!waitingGames.isEmpty()) {
                for (Map.Entry entry : waitingGames.entrySet()) {
                    GameHandler gh;
                    String gaName = (String)entry.getKey();
                    SOCGame ga = this.getGame(gaName);
                    if (ga == null || (gh = this.gameList.getGameTypeHandler(gaName)) == null) continue;
                    gh.findRobotAskJoinGame(ga, entry.getValue(), false);
                }
            }
        }
    }

    @Override
    public boolean newConnection1(Connection c) {
        if (c == null) {
            return false;
        }
        try {
            if (this.getNamedConnectionCount() >= this.maxConnections) {
                c.put(new SOCRejectConnection("Too many connections, please try another server."));
            }
        }
        catch (Exception e) {
            D.ebugPrintStackTrace(e, "Caught exception in SOCServer.newConnection(Connection)");
        }
        try {
            boolean hostMatch = false;
            if (!hostMatch) {
                c.setVersion(-1);
                return true;
            }
            c.put(new SOCRejectConnection("Can't connect to the server more than once from one machine."));
        }
        catch (Exception e) {
            D.ebugPrintStackTrace(e, "Caught exception in SOCServer.newConnection(Connection)");
        }
        return false;
    }

    @Override
    protected void newConnection2(Connection c) {
        SOCClientData cdata = new SOCClientData();
        c.setAppData(cdata);
        c.put(new SOCVersion(Version.versionNumber(), Version.version(), Version.buildnum(), this.getFeaturesList(), null));
        ArrayList<String> cl = new ArrayList<String>();
        this.channelList.takeMonitor();
        try {
            Enumeration<String> clEnum = this.channelList.getChannels();
            while (clEnum.hasMoreElements()) {
                cl.add(clEnum.nextElement());
            }
        }
        catch (Exception e) {
            D.ebugPrintStackTrace(e, "Exception in newConnection (channelList)");
        }
        this.channelList.releaseMonitor();
        c.put(new SOCChannels(cl));
        if (!c.isInputAvailable()) {
            cdata.setVersionTimer(this, c);
        }
    }

    @Override
    public void nameConnection(Connection c, boolean isReplacing) throws IllegalArgumentException {
        Connection oldConn = null;
        if (isReplacing) {
            String cliName = c.getData();
            if (cliName == null) {
                throw new IllegalArgumentException("null c.getData");
            }
            oldConn = (Connection)this.conns.get(cliName);
            if (oldConn == null) {
                isReplacing = false;
            }
        }
        super.nameConnection(c, isReplacing);
        if (isReplacing) {
            List<SOCGame> cannotReplace = this.gameList.replaceMemberAllGames(oldConn, c, this.has3rdPartyGameopts);
            this.channelList.replaceMemberAllChannels(oldConn, c);
            SOCClientData scdNew = (SOCClientData)c.getAppData();
            SOCClientData scdOld = (SOCClientData)oldConn.getAppData();
            if (scdNew != null && scdOld != null) {
                scdNew.copyClientPlayerStats(scdOld);
            }
            if (oldConn.getVersion() >= 1108) {
                oldConn.put(new SOCServerPing(-1));
            }
            if (cannotReplace != null) {
                for (SOCGame ga : cannotReplace) {
                    this.leaveGameMemberAndCleanup(oldConn, ga, null);
                }
            }
        }
        ++this.numberOfUsers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Integer getConnectedClientNames(List<StringBuilder> sbs) throws NullPointerException {
        int nUnnamed;
        StringBuilder sb = new StringBuilder("- ");
        sbs.add(sb);
        Vector vector = this.unnamedConns;
        synchronized (vector) {
            nUnnamed = this.unnamedConns.size();
            Enumeration<Connection> ec = this.getConnections();
            while (ec.hasMoreElements()) {
                String cliName = ec.nextElement().getData();
                int L = sb.length();
                if (L + cliName.length() > 50) {
                    sb.append(',');
                    sb = new StringBuilder("- ");
                    sbs.add(sb);
                    L = 2;
                }
                if (L > 2) {
                    sb.append(", ");
                }
                sb.append(cliName);
            }
        }
        return nUnnamed;
    }

    public SOCClientData getClientData(String nickname) {
        Connection c = this.getConnection(nickname);
        return c == null ? null : (SOCClientData)c.getAppData();
    }

    final boolean getConnectedRobotNames(StringBuilder sb) throws NullPointerException {
        ArrayList<String> names = new ArrayList<String>();
        for (Connection rc : this.robots) {
            names.add(rc.getData());
        }
        boolean hadAny = false;
        for (String botName : names) {
            if (hadAny) {
                sb.append(", ");
            } else {
                hadAny = true;
            }
            sb.append(botName);
        }
        return hadAny;
    }

    private int checkNickname(String n, Connection newc, boolean withPassword, boolean isBot) {
        String nLower = n.toLowerCase(Locale.US);
        if (nLower.equals(SERVERNAME_LC) || !SOCMessage.isSingleLineAndSafe(n)) {
            return -2;
        }
        if (SOCGameList.REGEX_ALL_DIGITS_OR_PUNCT.matcher(n).matches()) {
            return -2;
        }
        if (nLower.equals("debug") && this.port > 0 && !this.isDebugUserEnabled() || !isBot && (nLower.startsWith("droid ") || nLower.startsWith("robot ") || nLower.startsWith("extrabot "))) {
            return -2;
        }
        Connection oldc = this.getConnection(n, false);
        if (oldc == null) {
            return 0;
        }
        SOCClientData scd = (SOCClientData)oldc.getAppData();
        if (scd == null) {
            return -2;
        }
        int timeoutNeeded = withPassword ? 15 : (newc.host().equals(oldc.host()) ? 30 : 150);
        long now = System.currentTimeMillis();
        if (scd.disconnectLastPingMillis != 0L) {
            int secondsSincePing = (int)((now - scd.disconnectLastPingMillis) / 1000L);
            if (secondsSincePing >= timeoutNeeded) {
                int minVersForGames = this.gameList.playerGamesMinVersion(oldc);
                if (minVersForGames > newc.getVersion()) {
                    if (minVersForGames < 1000) {
                        minVersForGames = 1000;
                    }
                    return -minVersForGames;
                }
                return -1;
            }
            return timeoutNeeded - secondsSincePing;
        }
        int minVersForGames = this.gameList.playerGamesMinVersion(oldc);
        if (minVersForGames > newc.getVersion()) {
            if (minVersForGames < 1000) {
                minVersForGames = 1000;
            }
            return -minVersForGames;
        }
        scd.disconnectLastPingMillis = now;
        if (oldc.getVersion() >= 1108) {
            oldc.put(new SOCServerPing(timeoutNeeded));
        }
        return timeoutNeeded;
    }

    private static final String checkNickname_getRetryText(int nameTimeout) {
        StringBuffer sb = new StringBuffer("Please wait ");
        if (nameTimeout <= 90) {
            sb.append(nameTimeout);
            sb.append(" seconds");
        } else {
            sb.append((nameTimeout + 20) / 60);
            sb.append(" minute(s)");
        }
        sb.append(MSG_NICKNAME_ALREADY_IN_USE_WAIT_TRY_AGAIN);
        sb.append(MSG_NICKNAME_ALREADY_IN_USE);
        return sb.toString();
    }

    private static final String checkNickname_getVersionText(int needsVersion) {
        StringBuffer sb = new StringBuffer(MSG_NICKNAME_ALREADY_IN_USE_NEWER_VERSION_P1);
        sb.append(needsVersion);
        sb.append(MSG_NICKNAME_ALREADY_IN_USE_NEWER_VERSION_P2);
        return sb.toString();
    }

    @Override
    public boolean processFirstCommand(SOCMessage mes, Connection con) {
        try {
            if (mes != null && mes.getType() == 9998) {
                this.srvMsgHandler.handleVERSION(con, (SOCVersion)mes);
                return true;
            }
        }
        catch (Throwable e) {
            D.ebugPrintStackTrace(e, "ERROR -> processFirstCommand");
        }
        ((SOCClientData)con.getAppData()).setVersionTimer(this, con);
        return false;
    }

    public boolean processDebugCommand(Connection debugCli, SOCGame ga, String dcmd, String dcmdU) {
        boolean isCmd = true;
        String gaName = ga.getName();
        if (dcmdU.startsWith("*KILLGAME*")) {
            this.messageToGameUrgent(gaName, true, ">>> ********** " + debugCli.getData() + " KILLED THE GAME!!! ********** <<<");
            this.destroyGameAndBroadcast(gaName, "KILLGAME");
        } else if (dcmd.startsWith("*STOP*")) {
            boolean shutNow = false;
            long now = System.currentTimeMillis();
            if (this.srvShutPassword != null && now <= this.srvShutPasswordExpire) {
                int end = dcmd.length();
                while (Character.isISOControl(dcmd.charAt(end - 1))) {
                    --end;
                }
                int i = dcmd.lastIndexOf(32);
                if (i < dcmd.length() && dcmd.substring(i + 1, end).equals(this.srvShutPassword)) {
                    shutNow = true;
                }
            } else {
                this.srvShutPasswordExpire = now + 45000L;
                StringBuffer sb = new StringBuffer();
                for (int i = 12 + this.rand.nextInt(5); i > 0; --i) {
                    sb.append((char)(33 + this.rand.nextInt(93)));
                }
                this.srvShutPassword = sb.toString();
                System.err.println("** Shutdown password generated: " + this.srvShutPassword);
                this.broadcast(new SOCBCastTextMsg(debugCli.getData() + " WANTS TO STOP THE SERVER"));
                this.messageToPlayer(debugCli, gaName, -258, "Send stop command again with the password.");
            }
            if (shutNow) {
                String stopMsg = ">>> ********** " + debugCli.getData() + " KILLED THE SERVER!!! ********** <<<";
                this.stopServer(stopMsg);
                System.exit(0);
            }
        } else {
            if (dcmdU.startsWith("*STARTBOTGAME*")) {
                if (0 == this.getConfigIntProperty(PROP_JSETTLERS_BOTS_BOTGAMES_TOTAL, 0)) {
                    this.messageToPlayer(debugCli, gaName, -258, "To start a bots-only game, must restart server with jsettlers.bots.botgames.total != 0.");
                    return true;
                }
                if (ga.getGameState() != 0) {
                    this.messageToPlayer(debugCli, gaName, -258, "This game has already started; you must create a new one.");
                    return true;
                }
                int maxBots = 0;
                if (dcmdU.length() > 15) {
                    try {
                        maxBots = Integer.parseInt(dcmdU.substring(15).trim());
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                this.srvMsgHandler.handleSTARTGAME(debugCli, new SOCStartGame(gaName, 0), maxBots);
                return true;
            }
            GameHandler hand = this.gameList.getGameTypeHandler(gaName);
            isCmd = hand != null ? hand.processDebugCommand(debugCli, ga, dcmd, dcmdU) : false;
        }
        return isCmd;
    }

    final void processDebugCommand_connStats(Connection c, SOCGame ga, boolean skipWinLossBefore2) {
        this.srvMsgHandler.processDebugCommand_connStats(c, ga, skipWinLossBefore2);
    }

    @Override
    public synchronized void stopServer() {
        this.stopServer(">>> The game server is shutting down. <<<");
    }

    public synchronized void stopServer(String stopMsg) {
        if (stopMsg != null) {
            System.out.println("stopServer: " + stopMsg);
            System.out.println();
            this.broadcast(new SOCStatusMessage(23, stopMsg));
            if (this.getMinConnectedCliVersion() < 2100) {
                this.broadcastToVers(new SOCBCastTextMsg(stopMsg), 0, 2099);
            }
        }
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException ie) {
            Thread.yield();
        }
        this.db.cleanup(true);
        super.stopServer();
        System.out.println("Server shutdown completed.");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void authOrRejectClientUser(final Connection c, String msgUser, String msgPass, final int cliVers, final boolean doNameConnection, boolean allowTakeover, final AuthSuccessRunnable authCallback) throws IllegalArgumentException {
        if (authCallback == null) {
            throw new IllegalArgumentException("authCallback");
        }
        if (c.getData() != null) {
            authCallback.success(c, 1);
            return;
        }
        boolean isTakingOver = false;
        msgUser = msgUser.trim();
        msgPass = msgPass.trim();
        if (msgUser.length() > PLAYER_NAME_MAX_LENGTH) {
            c.put(SOCStatusMessage.buildForVersion(13, cliVers, c.getLocalized("netmsg.status.common.name_too_long", PLAYER_NAME_MAX_LENGTH)));
            return;
        }
        int nameTimeout = this.checkNickname(msgUser, c, msgPass != null && msgPass.length() > 0, false);
        if (nameTimeout == -1) {
            if (!allowTakeover) {
                c.put(SOCStatusMessage.buildForVersion(4, cliVers, MSG_NICKNAME_ALREADY_IN_USE));
                return;
            }
            isTakingOver = true;
        } else {
            if (nameTimeout == -2) {
                c.put(SOCStatusMessage.buildForVersion(19, cliVers, c.getLocalized("netmsg.status.nickname_not_allowed")));
                return;
            }
            if (nameTimeout <= -1000) {
                c.put(SOCStatusMessage.buildForVersion(4, cliVers, SOCServer.checkNickname_getVersionText(-nameTimeout)));
                return;
            }
            if (nameTimeout > 0) {
                c.put(SOCStatusMessage.buildForVersion(4, cliVers, allowTakeover ? SOCServer.checkNickname_getRetryText(nameTimeout) : MSG_NICKNAME_ALREADY_IN_USE));
                return;
            }
        }
        if (this.getConfigBoolProperty(PROP_JSETTLERS_ACCOUNTS_REQUIRED, false) && msgPass.length() == 0) {
            c.put(SOCStatusMessage.buildForVersion(16, cliVers, "This server requires user accounts and passwords."));
            return;
        }
        if (msgPass.length() > 256) {
            c.put(SOCStatusMessage.buildForVersion(3, c.getVersion(), c.getLocalized("netmsg.status.incorrect_password", msgUser)));
            return;
        }
        try {
            final String msgUserName = msgUser;
            final boolean takingOver = isTakingOver;
            this.db.authenticateUserPassword(msgUser, msgPass, new SOCDBHelper.AuthPasswordRunnable(){

                @Override
                public void authResult(final String dbUserName, final boolean hadDelay) {
                    if (SOCServer.this.inQueue.isCurrentThreadTreater()) {
                        SOCServer.this.authOrRejectClientUser_postDBAuth(c, msgUserName, dbUserName, cliVers, doNameConnection, takingOver, authCallback, hadDelay);
                    } else {
                        SOCServer.this.inQueue.post(new Runnable(){

                            @Override
                            public void run() {
                                SOCServer.this.authOrRejectClientUser_postDBAuth(c, msgUserName, dbUserName, cliVers, doNameConnection, takingOver, authCallback, hadDelay);
                            }
                        });
                    }
                }
            });
            return;
        }
        catch (SQLException sqle) {
            c.put(SOCStatusMessage.buildForVersion(6, c.getVersion(), "Problem connecting to database, please try again later."));
        }
    }

    private void authOrRejectClientUser_postDBAuth(final Connection c, String msgUser, String authUsername, int cliVers, boolean doNameConnection, boolean isTakingOver, AuthSuccessRunnable authCallback, boolean hadDelay) {
        boolean mustSetUsername;
        if (authUsername == null) {
            final SOCStatusMessage msg = SOCStatusMessage.buildForVersion(3, c.getVersion(), c.getLocalized("netmsg.status.incorrect_password", msgUser));
            if (hadDelay) {
                c.put(msg);
            } else {
                this.replyAuthTimer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        c.put(msg);
                    }
                }, 350 + this.rand.nextInt(250));
            }
            return;
        }
        boolean bl = mustSetUsername = !authUsername.equals(msgUser);
        if (mustSetUsername && cliVers < 1200) {
            final SOCStatusMessage msg = SOCStatusMessage.buildForVersion(2, cliVers, "Nickname is case-sensitive: Use " + authUsername);
            if (hadDelay) {
                c.put(msg);
            } else {
                this.replyAuthTimer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        c.put(msg);
                    }
                }, 350 + this.rand.nextInt(250));
            }
            return;
        }
        if (doNameConnection) {
            c.setData(authUsername);
            this.nameConnection(c, isTakingOver);
        }
        int ret = 1;
        if (isTakingOver) {
            ret |= 2;
        }
        if (mustSetUsername) {
            ret |= 4;
        }
        authCallback.success(c, ret);
    }

    boolean isUserDBUserAdmin(String uname) {
        if (uname == null || this.databaseUserAdmins == null) {
            return false;
        }
        if (this.db.getSchemaVersion() >= 1200) {
            uname = uname.toLowerCase(Locale.US);
        }
        return this.databaseUserAdmins.contains(uname);
    }

    boolean isUserGameAdmin(String uname, SOCGame game) {
        if (uname == null || game == null) {
            return false;
        }
        return uname.equals(game.getOwner());
    }

    protected SOCFeatureSet checkLimitClientFeaturesForServerDisallows(SOCFeatureSet cliFeats) {
        boolean disallow6pl = this.getConfigBoolProperty(PROP_JSETTLERS_GAME_DISALLOW_6PLAYER, false);
        boolean disallowSeaBoard = this.getConfigBoolProperty(PROP_JSETTLERS_GAME_DISALLOW_SEA__BOARD, false);
        if (!disallow6pl && !disallowSeaBoard) {
            return null;
        }
        if (cliFeats == null) {
            return new SOCFeatureSet((String)null);
        }
        cliFeats = new SOCFeatureSet(cliFeats);
        if (disallow6pl) {
            cliFeats.remove("6pl");
        }
        if (disallowSeaBoard) {
            cliFeats.remove("sb");
            cliFeats.remove("sc");
        }
        return cliFeats;
    }

    String getClientWelcomeMessage(Connection c) throws NullPointerException {
        String welcomeText = this.props.getProperty(PROP_JSETTLERS_ADMIN_WELCOME);
        if (welcomeText == null) {
            welcomeText = c.getLocalized("netmsg.status.welcome");
        }
        return welcomeText;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean setClientVersSendGamesOrReject(Connection c, int cvers, String cfeats, String clocale, boolean isKnown) {
        int prevVers = c.getVersion();
        boolean wasKnown = c.isVersionKnown();
        if (cvers < 1100 && cvers != 1000) {
            cvers = 1000;
        } else if (cvers > 1299 && cvers < 2000) {
            cvers = 1299;
        } else if (cvers > 6999) {
            cvers = 6999;
        }
        SOCFeatureSet cfeatSet = cfeats != null ? new SOCFeatureSet(cfeats) : (cvers < 2000 ? new SOCFeatureSet(true, false) : new SOCFeatureSet(false, false));
        boolean hasLimitedFeats = false;
        int scenVers = cfeatSet.getValue("sc", 0);
        if (scenVers > cvers) {
            scenVers = cvers;
        }
        hasLimitedFeats = !cfeatSet.isActive("6pl") || !cfeatSet.isActive("sb") ? true : scenVers != cvers && scenVers < SOCScenario.ALL_KNOWN_SCENARIOS_MIN_VERSION;
        SOCClientData scd = (SOCClientData)c.getAppData();
        scd.feats = cfeatSet;
        scd.hasLimitedFeats = hasLimitedFeats;
        scd.scenVersion = scenVers;
        if (hasLimitedFeats) {
            Vector vector = this.unnamedConns;
            synchronized (vector) {
                this.limitedConns.add(c);
            }
        }
        String rejectMsg = null;
        String rejectLogMsg = null;
        String warnText = null;
        if (clocale == null) {
            clocale = "en_US";
        }
        scd.localeStr = clocale;
        try {
            scd.locale = StringManager.parseLocale(clocale);
        }
        catch (IllegalArgumentException e) {
            warnText = "Sorry, cannot parse your locale.";
            scd.localeStr = "en_US";
            scd.locale = Locale.US;
        }
        c.setI18NStringManager(SOCStringManager.getServerManagerForClient(scd.locale), clocale);
        if (prevVers == -1) {
            scd.clearVersionTimer();
        }
        if (prevVers != cvers) {
            Vector e = this.unnamedConns;
            synchronized (e) {
                c.setVersion(cvers, isKnown);
            }
        } else if (wasKnown) {
            return true;
        }
        if (cvers < 0) {
            String cversStr = cvers > 0 ? Version.version(cvers) : "?";
            rejectMsg = c.getLocalized("connect.reject.client_version", cversStr, Version.version(0), 0);
            rejectLogMsg = "Rejected client: Version " + cvers + " too old";
        }
        if (wasKnown && isKnown && cvers != prevVers) {
            rejectMsg = "Sorry, cannot report two different versions.";
            rejectLogMsg = "Rejected client: Already gave VERSION(" + prevVers + "), now says VERSION(" + cvers + ")";
        }
        if (rejectMsg != null) {
            c.put(new SOCRejectConnection(rejectMsg));
            c.disconnectSoft();
            System.out.println(rejectLogMsg);
            final Connection rc = c;
            this.miscTaskTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    SOCServer.this.removeConnection(rc, true);
                }
            }, 300L);
            return false;
        }
        if (cvers >= Version.versionNumber()) {
            SOCGameOptionSet activatedOpts;
            boolean hadAny = false;
            SOCFeatureSet cliLimitedFeats = this.checkLimitClientFeaturesForServerDisallows(scd.feats);
            if (cliLimitedFeats == null && hasLimitedFeats) {
                cliLimitedFeats = scd.feats;
            }
            Map<String, SOCGameOption> unsupportedOpts = null;
            Map<String, SOCGameOption> trimmedOpts = null;
            if (cliLimitedFeats != null) {
                unsupportedOpts = this.knownOpts.optionsNotSupported(cliLimitedFeats);
                if (unsupportedOpts != null) {
                    for (SOCGameOption opt : unsupportedOpts.values()) {
                        c.put(new SOCGameOptionInfo(new SOCGameOption(opt.key, opt.getDesc()), cvers, "-"));
                    }
                    hadAny = true;
                }
                if ((trimmedOpts = this.knownOpts.optionsTrimmedForSupport(cliLimitedFeats)) != null) {
                    for (SOCGameOption opt : trimmedOpts.values()) {
                        c.put(new SOCGameOptionInfo(opt, cvers, null));
                    }
                    hadAny = true;
                }
            }
            if ((activatedOpts = this.knownOpts.optionsWithFlag(8, cvers)) != null) {
                boolean wantsLocalDescs = !"en_US".equals(clocale) && !i18n_gameopt_PL_desc.equals(c.getLocalized("gameopt.PL"));
                for (SOCGameOption opt : activatedOpts) {
                    String okey = opt.key;
                    if (unsupportedOpts != null && unsupportedOpts.containsKey(okey) || trimmedOpts != null && trimmedOpts.containsKey(okey)) continue;
                    String localDesc = null;
                    if (wantsLocalDescs) {
                        try {
                            localDesc = c.getLocalized("gameopt." + okey);
                            if (opt.getDesc().equals(localDesc)) {
                                localDesc = null;
                            }
                        }
                        catch (MissingResourceException missingResourceException) {
                            // empty catch block
                        }
                    }
                    c.put(new SOCGameOptionInfo(opt, cvers, localDesc));
                    hadAny = true;
                }
            }
            if (hadAny && cvers == Version.versionNumber()) {
                c.put(SOCGameOptionInfo.OPTINFO_NO_MORE_OPTS);
            }
        }
        this.gameList.sendGameList(c, prevVers, this.has3rdPartyGameopts);
        String welcomeText = this.props.getProperty(PROP_JSETTLERS_ADMIN_WELCOME);
        if (welcomeText != null) {
            warnText = warnText == null ? welcomeText : warnText + " " + welcomeText;
        }
        if (this.allowDebugUser) {
            StringBuilder txt = new StringBuilder(c.getLocalized("netmsg.status.welcome.debug"));
            if (warnText != null) {
                txt.append(' ');
                txt.append(warnText);
            }
            if (welcomeText == null) {
                txt.append(' ');
                txt.append(c.getLocalized("netmsg.status.welcome"));
            }
            c.put(SOCStatusMessage.buildForVersion(21, cvers, txt.toString()));
        } else if (warnText != null) {
            c.put(SOCStatusMessage.buildForVersion(0, cvers, warnText));
        }
        Integer cversObj = cvers;
        TreeMap<Integer, AtomicInteger> treeMap = this.clientPastVersionStats;
        synchronized (treeMap) {
            AtomicInteger prevCountInt = this.clientPastVersionStats.get(cversObj);
            if (prevCountInt != null) {
                prevCountInt.incrementAndGet();
            } else {
                this.clientPastVersionStats.put(cversObj, new AtomicInteger(1));
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final String authOrRejectClientRobot(Connection c, String botName, String cookie, String rbc) throws NullPointerException {
        boolean isBuiltIn;
        if (c.getData() != null) {
            System.out.println("Rejected robot " + botName + ": Client sent authorize already");
            return "Client has already authorized.";
        }
        if (this.robotCookie != null && !this.robotCookie.equals(cookie)) {
            System.out.println("Rejected robot " + botName + ": Wrong cookie");
            return "Cookie contents do not match the running server.";
        }
        int srvVers = Version.versionNumber();
        int cliVers = c.getVersion();
        boolean bl = isBuiltIn = rbc == null || rbc.equals("soc.robot.SOCRobotBrain");
        if (isBuiltIn) {
            if (cliVers != srvVers) {
                System.out.println("Rejected robot " + botName + ": Version " + cliVers + " does not match server version");
                String rejectMsg = "Sorry, robot client version does not match, version number " + Version.version(srvVers) + " is required.";
                return rejectMsg;
            }
            System.out.println("Robot arrived: " + botName + ": built-in type");
        } else {
            System.out.println("Robot arrived: " + botName + ": type " + rbc);
        }
        if (0 != this.checkNickname(botName, c, false, true)) {
            this.printAuditMessage(null, "Robot login attempt, name already in use or bad", botName, null, c.host());
            return MSG_NICKNAME_ALREADY_IN_USE;
        }
        Server.ConnExcepDelayedPrintTask depart = (Server.ConnExcepDelayedPrintTask)this.cliConnDisconPrintsPending.get(botName);
        if (depart != null) {
            depart.cancel();
            this.cliConnDisconPrintsPending.remove(botName);
            Server.ConnExcepDelayedPrintTask arrive = (Server.ConnExcepDelayedPrintTask)this.cliConnDisconPrintsPending.get(c);
            if (arrive != null) {
                arrive.cancel();
                this.cliConnDisconPrintsPending.remove(c);
            }
        }
        c.setData(botName);
        c.setHideTimeoutMessage(true);
        SOCClientData scd = (SOCClientData)c.getAppData();
        scd.isRobot = true;
        scd.isBuiltInRobot = isBuiltIn;
        if (!isBuiltIn) {
            scd.robot3rdPartyBrainClass = rbc;
        }
        Vector<Connection> vector = this.robots;
        synchronized (vector) {
            this.robots.addElement(c);
            if (!isBuiltIn) {
                this.robots3p.add(c);
            }
        }
        scd.locale = null;
        scd.localeStr = null;
        c.setI18NStringManager(null, null);
        super.nameConnection(c, false);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeConnection(Connection c, boolean doCleanup) {
        super.removeConnection(c, doCleanup);
        Vector vector = this.unnamedConns;
        synchronized (vector) {
            this.limitedConns.remove(c);
        }
    }

    void createOrJoinGameIfUserOK(Connection c, String msgUser, String msgPass, String gameName, final SOCGameOptionSet gameOpts) {
        if (gameName != null) {
            gameName = gameName.trim();
        }
        final int cliVers = c.getVersion();
        if (c.getData() != null) {
            this.createOrJoinGame(c, cliVers, gameName, gameOpts, null, 1);
        } else {
            if (msgUser != null) {
                msgUser = msgUser.trim();
            }
            if (msgPass != null) {
                msgPass = msgPass.trim();
            }
            final String gName = gameName;
            this.authOrRejectClientUser(c, msgUser, msgPass, cliVers, true, true, new AuthSuccessRunnable(){

                @Override
                public void success(Connection conn, int authResult) {
                    SOCServer.this.createOrJoinGame(conn, cliVers, gName, gameOpts, null, authResult);
                }
            });
        }
    }

    boolean createOrJoinGame(Connection c, int cliVers, String connGaName, SOCGameOptionSet gameOpts, SOCGame loadedGame, int authResult) throws IllegalStateException {
        String gameName;
        boolean isTakingOver = 0 != (authResult & 2);
        boolean sendErrorViaStatus = loadedGame == null || connGaName == null;
        SOCClientData scd = (SOCClientData)c.getAppData();
        if (loadedGame != null) {
            int gs = loadedGame.getGameState();
            if (gs != 990 && gs != 1000) {
                throw new IllegalStateException("gameState");
            }
            gameName = loadedGame.getName();
        } else {
            gameName = connGaName;
        }
        if (gameName.length() > 30) {
            String txt = c.getLocalized("netmsg.status.common.name_too_long", 30);
            if (sendErrorViaStatus) {
                c.put(SOCStatusMessage.buildForVersion(13, cliVers, txt));
            } else {
                this.messageToPlayer(c, connGaName, -256, txt);
            }
            return false;
        }
        if (!this.gameList.isGame(gameName)) {
            if (!(this.strSocketName != null && this.strSocketName.equals(PRACTICE_STRINGPORT) || loadedGame != null || CLIENT_MAX_CREATE_GAMES < 0 || CLIENT_MAX_CREATE_GAMES > scd.getCurrentCreatedGames())) {
                c.put(SOCStatusMessage.buildForVersion(14, cliVers, c.getLocalized("netmsg.status.newgame_too_many_created", CLIENT_MAX_CREATE_GAMES)));
                return false;
            }
            String rejectText = null;
            if (!SOCMessage.isSingleLineAndSafe(gameName) || "*".equals(gameName) || gameName.charAt(0) == '?') {
                rejectText = c.getLocalized("netmsg.status.common.newgame_name_rejected");
            } else if (SOCGameList.REGEX_ALL_DIGITS_OR_PUNCT.matcher(gameName).matches()) {
                rejectText = c.getLocalized("netmsg.status.common.newgame_name_rejected_digits_or_punct");
            }
            if (rejectText != null) {
                if (sendErrorViaStatus) {
                    c.put(SOCStatusMessage.buildForVersion(12, cliVers, rejectText));
                } else {
                    this.messageToPlayer(c, connGaName, -256, rejectText);
                }
                return false;
            }
        }
        if (gameOpts != null) {
            Map<String, String> optProblems;
            if (loadedGame == null && this.gameList.isGame(gameName)) {
                String txt = c.getLocalized("netmsg.status.common.newgame_already_exists");
                if (sendErrorViaStatus) {
                    c.put(SOCStatusMessage.buildForVersion(11, cliVers, txt));
                } else {
                    this.messageToPlayer(c, connGaName, -256, txt);
                }
                return false;
            }
            SOCFeatureSet limitedCliFeats = this.checkLimitClientFeaturesForServerDisallows(scd.feats);
            if (limitedCliFeats == null && scd.hasLimitedFeats) {
                limitedCliFeats = scd.feats;
            }
            if ((optProblems = gameOpts.adjustOptionsToKnown(this.knownOpts, true, limitedCliFeats)) != null) {
                boolean hadUnknowns;
                String txt;
                String scProblem = optProblems.get("SC");
                if (optProblems.size() == 1 && scProblem != null && scProblem.startsWith("unknown scenario")) {
                    txt = "Unknown scenario " + scProblem.substring(16).trim() + " requested, cannot create this game.";
                    hadUnknowns = false;
                } else {
                    StringBuilder sb = new StringBuilder();
                    if (!scd.sentUnknownGameoptsInfo) {
                        sb.append("Please try again. ");
                    }
                    sb.append("Unknown game option(s) were requested, cannot create this game. ");
                    DataUtils.mapIntoStringBuilder(optProblems, sb, null, "; ");
                    txt = sb.toString();
                    hadUnknowns = true;
                }
                if (sendErrorViaStatus) {
                    c.put(SOCStatusMessage.buildForVersion(9, cliVers, txt));
                } else {
                    this.messageToPlayer(c, connGaName, -256, txt);
                }
                if (hadUnknowns && !scd.sentUnknownGameoptsInfo) {
                    scd.sentUnknownGameoptsInfo = true;
                    boolean unknownsWithDescs = cliVers >= 2700;
                    for (String optKey : optProblems.keySet()) {
                        SOCGameOption opt;
                        String localDesc = null;
                        if (unknownsWithDescs && (opt = this.knownOpts.get(optKey)) != null) {
                            try {
                                localDesc = c.getLocalized("gameopt." + optKey);
                            }
                            catch (MissingResourceException e) {
                                localDesc = opt.getDesc();
                            }
                        }
                        c.put(new SOCGameOptionInfo(new SOCGameOption(optKey, localDesc), cliVers, null));
                    }
                    c.put(SOCGameOptionInfo.OPTINFO_NO_MORE_OPTS);
                }
                return false;
            }
        }
        try {
            if (0 != (authResult & 4)) {
                c.put(new SOCStatusMessage(20, c.getData() + ',' + this.getClientWelcomeMessage(c)));
            }
            if (isTakingOver) {
                List<SOCGame> allConnGames = this.gameList.memberGames(c, gameName);
                if (allConnGames.size() == 0) {
                    c.put(new SOCStatusMessage(0, "You've taken over the connection, but aren't in any games."));
                } else {
                    for (int i = allConnGames.size() - 1; i >= 0; --i) {
                        this.joinGame(allConnGames.get(i), c, false, false, true);
                    }
                }
            } else if (this.connectToGame(c, gameName, gameOpts, loadedGame)) {
                SOCGame ga;
                if (loadedGame != null) {
                    gameName = loadedGame.getName();
                }
                if ((ga = this.gameList.getGameData(gameName)) != null) {
                    boolean sendLikeTakingOver = false;
                    if (ga.getGameState() == 990 && !((SOCClientData)c.getAppData()).isRobot) {
                        String cliName = c.getData();
                        for (int pn = 0; pn < ga.maxPlayers; ++pn) {
                            if (ga.isSeatVacant(pn) || !cliName.equals(ga.getPlayer(pn).getName())) continue;
                            sendLikeTakingOver = true;
                            break;
                        }
                    }
                    this.joinGame(ga, c, false, loadedGame != null, sendLikeTakingOver);
                }
            }
        }
        catch (SOCGameOptionVersionException e) {
            c.put(SOCStatusMessage.buildForVersion(10, cliVers, "Cannot create game with these options; requires version " + Integer.toString(e.gameOptsVersion) + ',' + gameName + ',' + e.problemOptionsList()));
            return false;
        }
        catch (MissingResourceException e) {
            String verb = this.gameList.isGame(gameName) ? "join" : "create";
            String feats = e.getKey();
            c.put(SOCStatusMessage.buildForVersion(22, cliVers, "Cannot " + verb + "; this client is incompatible with features of the game" + ',' + gameName + ',' + feats));
            return false;
        }
        catch (IllegalArgumentException e) {
            SOCGame game = this.gameList.getGameData(gameName);
            if (game == null) {
                D.ebugPrintStackTrace(e, "Exception in createOrJoinGame");
            } else {
                c.put(SOCStatusMessage.buildForVersion(5, cliVers, "Cannot join game; requires version " + Integer.toString(game.getClientVersionMinRequired()) + ": " + gameName));
            }
            return false;
        }
        catch (NoSuchElementException e) {
            if (loadedGame != null) {
                this.messageToPlayer(c, connGaName, -256, "Game name in use, couldn't generate an alternate: Try again.");
            } else {
                D.ebugPrintStackTrace(e, "Exception in createOrJoinGame");
            }
            return false;
        }
        return true;
    }

    public String createAndJoinReloadedGame(final SavedGameModel sgm, final Connection c, String connGaName) {
        final SOCGame ga = sgm.getGame();
        if (!this.createOrJoinGame(c, c.getVersion(), connGaName, ga.getGameOptions(), ga, 1)) {
            return null;
        }
        int clientPN = -1;
        for (int pn = 0; pn < sgm.playerSeats.length; ++pn) {
            SavedGameModel.PlayerInfo pi = sgm.playerSeats[pn];
            if (pi.isSeatVacant || !pi.name.equals(c.getData())) continue;
            clientPN = pn;
            this.sitDown(ga, c, clientPN, false, false);
            break;
        }
        final String gaName = ga.getName();
        boolean foundNoRobots = false;
        if (sgm.gameState < 1000) {
            GameHandler gh = this.gameList.getGameTypeHandler(gaName);
            for (int pn = 0; pn < sgm.playerSeats.length; ++pn) {
                SavedGameModel.PlayerInfo pi = sgm.playerSeats[pn];
                if (pi.isSeatVacant || !pi.isRobot) continue;
                if (!ga.isSeatVacant(pn)) {
                    ga.removePlayer(ga.getPlayer(pn).getName(), true);
                }
                boolean bl = foundNoRobots = !gh.findRobotAskJoinGame(ga, pn, true);
                if (foundNoRobots) break;
            }
        }
        final boolean noBots = foundNoRobots;
        this.miscTaskTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                if (!gaName.equals(sgm.gameName)) {
                    SOCServer.this.messageToPlayerKeyed(c, gaName, -258, "admin.loadgame.ok.game_renamed", sgm.gameName);
                }
                if (sgm.warnDevCardDeckUnknownTypeAtIndex != -1) {
                    SOCServer.this.messageToGameKeyed(ga, true, true, "admin.resumegame.warn.dev_card_deck_contains_unknown_card_type", sgm.warnDevCardDeckUnknownTypeAtIndex);
                }
                if (sgm.warnHasHumanPlayerWithBotName) {
                    SOCServer.this.messageToGameKeyed(ga, true, true, "admin.resumegame.warn.human_with_bot_name");
                }
                if (noBots) {
                    SOCServer.this.messageToPlayerKeyed(c, gaName, -258, "admin.resumegame.err.not_enough_robots");
                } else if (sgm.gameState < 1000) {
                    SOCServer.this.messageToGameKeyed(ga, false, true, "admin.loadgame.ok.to_continue_resumegame");
                } else {
                    sgm.resumePlay(true);
                    GameHandler hand = SOCServer.this.gameList.getGameTypeHandler(gaName);
                    if (hand != null) {
                        hand.sendGameState(ga);
                    }
                }
            }
        }, 350L);
        long now = System.currentTimeMillis();
        long thresholdMin = GAME_TIME_EXPIRE_CHECK_MINUTES + GAME_TIME_EXPIRE_WARN_MINUTES;
        if (thresholdMin >= (long)((int)((ga.getExpiration() - now) / 60000L))) {
            ga.setExpiration(now + 60000L * (1L + thresholdMin));
        }
        return gaName;
    }

    public String resumeReloadedGame(Connection c, SOCGame ga) throws IllegalStateException {
        if (ga.getGameState() != 990 && ga.getGameState() != 992 || !(ga.savedGameModel instanceof SavedGameModel)) {
            throw new IllegalStateException("game not waiting to be resumed");
        }
        SavedGameModel sgm = (SavedGameModel)ga.savedGameModel;
        String gaName = ga.getName();
        boolean[] botsNeeded = sgm.findSeatsNeedingBots();
        if (botsNeeded != null) {
            ga.setGameState(992);
            GameHandler hand = this.gameList.getGameTypeHandler(gaName);
            if (hand != null) {
                hand.sendGameState(ga);
            }
            boolean invitedBots = false;
            IllegalStateException e = null;
            try {
                invitedBots = this.readyGameAskRobotsJoin(ga, botsNeeded, null, 0);
            }
            catch (IllegalStateException ex) {
                e = ex;
            }
            if (invitedBots) {
                return RESUME_RELOADED_FETCHING_ROBOTS;
            }
            ga.setGameState(990);
            if (hand != null) {
                hand.sendGameState(ga);
            }
            String retTxtKey = null;
            String[] retParams = null;
            if (e != null) {
                retTxtKey = "start.robots.cannot.join.problem";
                retParams = new String[]{e.getMessage()};
                this.messageToPlayerKeyed(c, gaName, -258, retTxtKey, (Object[])retParams);
            } else {
                retTxtKey = "admin.resumegame.err.not_enough_robots";
                this.messageToPlayerKeyed(c, gaName, -258, retTxtKey);
            }
            return SOCStringManager.getFallbackServerManagerForClient().get(retTxtKey, retParams);
        }
        boolean isBotsOnly = true;
        for (int pn = 0; pn < ga.maxPlayers; ++pn) {
            if (ga.isSeatVacant(pn) || ga.getPlayer(pn).isRobot()) continue;
            isBotsOnly = false;
            break;
        }
        if (isBotsOnly) {
            ga.isBotsOnly = true;
        }
        try {
            sgm.resumePlay(false);
            GameHandler hand = this.gameList.getGameTypeHandler(gaName);
            if (hand != null) {
                hand.sendGameStateResumingReloaded(ga);
            }
            this.messageToGameKeyed(ga, true, true, "admin.resumegame.ok.resuming");
            return null;
        }
        catch (MissingResourceException e) {
            String retTxtKey = "admin.resumegame.err.not_enough_robots";
            this.messageToGameKeyed(ga, true, true, retTxtKey);
            return SOCStringManager.getFallbackServerManagerForClient().get(retTxtKey);
        }
    }

    private void startRobotOnlyGames(boolean wasGameDestroyed, boolean hasGameListMonitor) {
        int nParallel;
        int gameTypes = this.getConfigIntProperty(PROP_JSETTLERS_BOTS_BOTGAMES_GAMETYPES, 1);
        if (wasGameDestroyed) {
            nParallel = 1;
        } else {
            nParallel = this.getConfigIntProperty(PROP_JSETTLERS_BOTS_BOTGAMES_PARALLEL, 4);
            if (nParallel == 0) {
                nParallel = this.numRobotOnlyGamesRemaining;
            }
        }
        SOCGameOptionSet allOpts = new SOCGameOptionSet();
        for (SOCGameOption opt : this.knownOpts) {
            if (opt.key.charAt(0) == '_' || opt.hasFlag(4) || opt.hasFlag(2)) continue;
            allOpts.put(opt);
        }
        StringBuilder desc = new StringBuilder();
        for (int i = 0; i < nParallel && this.numRobotOnlyGamesRemaining > 0; ++i) {
            SOCGame newGame;
            int gameNum = this.numRobotOnlyGamesRemaining;
            String gaName = "~botsOnly~" + gameNum;
            SOCGameOptionSet opts = new SOCGameOptionSet(allOpts, true);
            if (gameTypes > 1) {
                desc.setLength(0);
                if (0 != (gameNum & 1)) {
                    opts.get("PL").setIntValue(6);
                    opts.get("PLB").setBoolValue(true);
                    desc.append(": PL=6");
                } else {
                    desc.append(": PL=4");
                }
                if (gameTypes > 2 && 0 != (gameNum & 2)) {
                    opts.get("SBL").setBoolValue(true);
                    desc.append(", Sea Board");
                }
            }
            if ((newGame = this.createGameAndBroadcast(null, gaName, opts, null, SOCVersionedItem.itemsMinimumVersion(opts.getAll()), true, hasGameListMonitor)) == null) continue;
            --this.numRobotOnlyGamesRemaining;
            gaName = newGame.getName();
            System.out.println("Started bot-only game: " + gaName + desc.toString());
            newGame.setGameState(1);
            if (this.readyGameAskRobotsJoin(newGame, null, null, 0)) continue;
            System.out.println("Bot-only game " + gaName + ": Not enough bots can join, not starting");
            newGame.setGameState(1000);
        }
    }

    boolean readyGameAskRobotsJoin(SOCGame ga, boolean[] forSeats, Connection[] robotSeats, int maxBots) throws IllegalStateException, IllegalArgumentException {
        int seatsOpen;
        boolean gameHasLimitedFeats;
        int gstate = ga.getGameState();
        if (gstate != 1 && gstate != 992) {
            throw new IllegalStateException("SOCGame state not READY or LOADING_RESUMING: " + gstate);
        }
        if (ga.getClientVersionMinRequired() > Version.versionNumber()) {
            throw new IllegalStateException("SOCGame min version somehow newer than server and robots, it's " + ga.getClientVersionMinRequired());
        }
        Hashtable<Connection, Integer> robotsRequested = null;
        int[] robotIndexes = null;
        if (robotSeats == null) {
            robotIndexes = this.robotShuffleForJoin();
        } else if (robotSeats.length != ga.maxPlayers) {
            throw new IllegalArgumentException("robotSeats Length must be MAXPLAYERS");
        }
        int nRobotsAvailable = this.robots.size();
        String gaName = ga.getName();
        SOCGameOptionSet gaOpts = ga.getGameOptions();
        boolean bl = gameHasLimitedFeats = ga.getClientFeaturesRequired() != null;
        if (forSeats == null) {
            seatsOpen = ga.getAvailableSeatCount();
        } else {
            seatsOpen = 0;
            for (int pn = 0; pn < ga.maxPlayers; ++pn) {
                if (!forSeats[pn]) continue;
                ++seatsOpen;
            }
        }
        if (maxBots > 0 && maxBots < seatsOpen) {
            seatsOpen = maxBots;
        }
        int idx = 0;
        Connection[] robotSeatsConns = new Connection[ga.maxPlayers];
        for (int i = 0; i < ga.maxPlayers && seatsOpen > 0; ++i) {
            Connection robotConn;
            if (forSeats == null ? !ga.isSeatVacant(i) || ga.getSeatLock(i) != SOCGame.SeatLockState.UNLOCKED : !forSeats[i]) continue;
            if (idx >= nRobotsAvailable) continue;
            this.messageToGameKeyed(ga, true, true, RESUME_RELOADED_FETCHING_ROBOTS);
            if (robotSeats != null) {
                robotConn = robotSeats[i];
                if (robotConn == null) {
                    throw new IllegalArgumentException("robotSeats[" + i + "] was needed but null");
                }
            } else {
                do {
                    robotConn = this.robots.get(robotIndexes[idx]);
                    if ((forSeats == null || !this.gameList.isMember(robotConn, gaName)) && (!gameHasLimitedFeats || ga.canClientJoin(((SOCClientData)robotConn.getAppData()).feats))) continue;
                    robotConn = null;
                    ++idx;
                } while (robotConn == null && idx < nRobotsAvailable);
                if (robotConn == null) break;
            }
            ++idx;
            --seatsOpen;
            robotSeatsConns[i] = robotConn;
            if (robotsRequested == null) {
                robotsRequested = new Hashtable<Connection, Integer>();
            }
            robotsRequested.put(robotConn, i);
        }
        if (robotsRequested != null) {
            int reqPct3p = this.getConfigIntProperty(PROP_JSETTLERS_BOTS_PERCENT3P, 0);
            if (reqPct3p > 0) {
                this.readyGameAskRobotsMix3p(ga, reqPct3p, robotsRequested, robotSeatsConns);
            }
            this.robotJoinRequests.put(gaName, robotsRequested);
            for (int i = 0; i < ga.maxPlayers; ++i) {
                if (robotSeatsConns[i] == null) continue;
                this.messageToPlayer(robotSeatsConns[i], gaName, -257, new SOCBotJoinGameRequest(gaName, i, gaOpts));
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readyGameAskRobotsMix3p(SOCGame ga, int reqPct3p, Hashtable<Connection, Object> robotsRequested, Connection[] robotSeatsConns) {
        ArrayList<Connection> unused3p;
        int numBotsReq = robotsRequested.size();
        int num3pReq = Math.round((float)(numBotsReq * reqPct3p) / 100.0f);
        int curr3pReq = 0;
        boolean[] curr3pSeat = new boolean[robotSeatsConns.length];
        for (int i = 0; i < robotSeatsConns.length; ++i) {
            if (robotSeatsConns[i] == null || ((SOCClientData)robotSeatsConns[i].getAppData()).isBuiltInRobot) continue;
            ++curr3pReq;
            curr3pSeat[i] = true;
        }
        if (curr3pReq >= num3pReq) {
            return;
        }
        Vector<Connection> vector = this.robots3p;
        synchronized (vector) {
            unused3p = new ArrayList<Connection>(this.robots3p);
        }
        for (int i = 0; i < robotSeatsConns.length; ++i) {
            if (!curr3pSeat[i]) continue;
            unused3p.remove(robotSeatsConns[i]);
        }
        boolean gameHasLimitedFeats = ga.getClientFeaturesRequired() != null;
        for (int nAdd = num3pReq - curr3pReq; nAdd > 0 && !unused3p.isEmpty(); --nAdd) {
            int iNon = -1;
            int nSkip = nAdd > 1 ? this.rand.nextInt(num3pReq - curr3pReq) : 0;
            for (int i = 0; i < robotSeatsConns.length; ++i) {
                if (robotSeatsConns[i] == null || curr3pSeat[i]) continue;
                if (nSkip == 0) {
                    iNon = i;
                    break;
                }
                --nSkip;
            }
            if (iNon == -1) {
                return;
            }
            int s = unused3p.size();
            Connection bot3p = null;
            while (bot3p == null && s > 0) {
                bot3p = (Connection)unused3p.remove(s > 1 ? this.rand.nextInt(s) : 0);
                if (!gameHasLimitedFeats || ga.canClientJoin(((SOCClientData)bot3p.getAppData()).feats)) continue;
                bot3p = null;
                --s;
            }
            if (bot3p == null) break;
            Integer iObj = iNon;
            Hashtable<Connection, Object> hashtable = robotsRequested;
            synchronized (hashtable) {
                robotsRequested.remove(robotSeatsConns[iNon]);
                robotsRequested.put(bot3p, iObj);
            }
            robotSeatsConns[iNon] = bot3p;
            curr3pSeat[iNon] = true;
        }
    }

    void debug_printPieceDiceNumbers(SOCGame ga, String message) {
        int roll = ga.getCurrentDice();
        SOCBoard board = ga.getBoard();
        boolean hadAny = false;
        System.err.println(" " + roll + "\t" + message);
        for (int pn = 0; pn < ga.maxPlayers; ++pn) {
            if (ga.isSeatVacant(pn)) continue;
            SOCPlayer pl = ga.getPlayer(pn);
            hadAny |= this.debug_printPieceDiceNumbers_pl(pl, roll, board, "settle", pl.getSettlements().elements());
            hadAny |= this.debug_printPieceDiceNumbers_pl(pl, roll, board, "city", pl.getCities().elements());
        }
        if (hadAny) {
            System.err.println("    ** hadAny true");
        } else {
            System.err.println("    -- hadAny false");
        }
    }

    private boolean debug_printPieceDiceNumbers_pl(SOCPlayer pl, int roll, SOCBoard board, String pieceType, Enumeration<? extends SOCPlayingPiece> pe) {
        int robberHex = board.getRobberHex();
        boolean hadMatch = false;
        boolean wroteCall = false;
        while (pe.hasMoreElements()) {
            System.err.print("\t");
            SOCPlayingPiece sc = pe.nextElement();
            for (int hexCoord : board.getAdjacentHexesToNode(sc.getCoordinates())) {
                int hdice = board.getNumberOnHexFromCoord(hexCoord);
                if (hdice != 0) {
                    System.err.print(hdice);
                } else {
                    System.err.print(' ');
                }
                if (hexCoord == robberHex) {
                    System.err.print("(r)");
                }
                if (hdice == roll) {
                    System.err.print('*');
                    if (hexCoord != robberHex) {
                        hadMatch = true;
                    }
                }
                System.err.print("  ");
            }
            System.err.print(pieceType + " " + pl.getName());
            if (hadMatch && !wroteCall) {
                System.err.print("  roll " + pl.getRolledResources().toShortString());
                wroteCall = true;
            }
            System.err.println();
        }
        return hadMatch;
    }

    void resetBoardVoteNotifyOne(SOCGame ga, int pn, String plName, boolean vyes) {
        boolean votingComplete = false;
        String gaName = ga.getName();
        try {
            votingComplete = ga.resetVoteRegister(pn, vyes);
            this.messageToGame(gaName, true, new SOCResetBoardVote(gaName, pn, vyes));
        }
        catch (IllegalArgumentException e) {
            D.ebugPrintlnINFO("*Error in player voting: game " + gaName + ": " + e);
            return;
        }
        catch (IllegalStateException e) {
            D.ebugPrintlnINFO("*Voting not active: game " + gaName);
            return;
        }
        if (!votingComplete) {
            return;
        }
        if (ga.getResetVoteResult()) {
            this.resetBoardAndNotify(gaName, ga.getResetVoteRequester());
        } else {
            this.messageToGame(gaName, true, new SOCResetBoardReject(gaName));
        }
    }

    public static List<String> localizeGameScenarios(Locale loc, Collection<String> scKeys, boolean localizeAllKnown, boolean checkUnknowns_skipFirst, SOCClientData scd) {
        Map<String, String> scensSent;
        if (localizeAllKnown || scKeys == null) {
            scKeys = SOCScenario.getAllKnownScenarioKeynames();
            checkUnknowns_skipFirst = false;
        }
        SOCStringManager sm = SOCStringManager.getServerManagerForClient(loc);
        if (scd != null) {
            scensSent = scd.scenariosInfoSent;
            if (scensSent == null) {
                scd.scenariosInfoSent = scensSent = new HashMap<String, String>();
            }
        } else {
            scensSent = null;
        }
        ArrayList<String> rets = new ArrayList<String>();
        boolean mustSkipFirst = checkUnknowns_skipFirst;
        for (String scKey : scKeys) {
            if (mustSkipFirst) {
                mustSkipFirst = false;
                continue;
            }
            if (scensSent != null && !scensSent.containsKey(scKey)) {
                scensSent.put(scKey, "S");
            }
            SOCScenario sc = SOCScenario.getScenario(scKey);
            String nm = null;
            String desc = null;
            if (!checkUnknowns_skipFirst || sc != null) {
                try {
                    nm = sm.get("gamescen." + scKey + ".n");
                    desc = sm.get("gamescen." + scKey + ".d");
                    if (sc != null) {
                        if (nm != null && nm.equals(sc.getDesc())) {
                            nm = null;
                        } else if (desc != null && desc.equals(sc.getLongDesc())) {
                            desc = null;
                        }
                    }
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
            }
            if (nm != null) {
                rets.add(scKey);
                rets.add(nm);
                rets.add(desc);
                continue;
            }
            if (!checkUnknowns_skipFirst) continue;
            rets.add(scKey);
            rets.add("\u0016K");
        }
        return rets;
    }

    void sendGameScenarioInfo(String scKey, SOCScenario scData, Connection c, boolean alwaysSend, boolean stringsOnly) {
        boolean localeHasScenStrs;
        SOCScenario sc;
        String statusAlreadySent;
        if (scKey == null) {
            if (scData == null) {
                return;
            }
            scKey = scData.key;
        }
        SOCClientData scd = (SOCClientData)c.getAppData();
        if ((scd.sentAllScenarioInfo || stringsOnly && scd.sentAllScenarioStrings) && scData == null) {
            return;
        }
        int cliVers = scd.scenVersion;
        if (cliVers < 2000) {
            scd.sentAllScenarioStrings = true;
            scd.sentAllScenarioInfo = true;
            return;
        }
        Map<String, String> scensSent = scd.scenariosInfoSent;
        if (scData == null && scensSent != null) {
            statusAlreadySent = scensSent.get(scKey);
            if (statusAlreadySent != null && (stringsOnly || statusAlreadySent.equals("I"))) {
                return;
            }
        } else {
            statusAlreadySent = null;
        }
        SOCScenario scSend = null;
        if (scData != null) {
            scSend = scData;
        } else if (!stringsOnly && (sc = SOCScenario.getScenario(scKey)) != null && (sc.lastModVersion > cliVers || alwaysSend)) {
            scSend = sc;
        }
        if (scensSent == null) {
            scd.scenariosInfoSent = scensSent = new HashMap<String, String>();
        }
        if (scSend == null && statusAlreadySent != null) {
            if (!stringsOnly) {
                scensSent.put(scKey, "I");
            }
            return;
        }
        scensSent.put(scKey, stringsOnly ? "S" : "I");
        String nm = null;
        String desc = null;
        if (scd.checkedLocaleScenStrings) {
            localeHasScenStrs = scd.localeHasScenStrings;
        } else {
            scd.localeHasScenStrings = localeHasScenStrs = scd.localeHasGameScenarios(c);
            scd.checkedLocaleScenStrings = true;
            if (!localeHasScenStrs) {
                scd.sentAllScenarioStrings = true;
            }
        }
        if (localeHasScenStrs) {
            try {
                nm = c.getLocalized("gamescen." + scKey + ".n");
                desc = c.getLocalized("gamescen." + scKey + ".d");
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            if (scSend == null) {
                SOCScenario sc2;
                if (nm != null && (sc2 = SOCScenario.getScenario(scKey)) != null) {
                    if (nm.equals(sc2.getDesc())) {
                        nm = null;
                    } else if (desc != null && desc.equals(sc2.getLongDesc())) {
                        desc = null;
                    }
                }
                if (nm == null) {
                    return;
                }
            }
        } else if (scSend == null) {
            return;
        }
        if (scSend != null) {
            c.put(new SOCScenarioInfo(scSend, nm, desc));
        } else {
            ArrayList<String> scenStrs = new ArrayList<String>();
            scenStrs.add(scKey);
            if (nm != null) {
                scenStrs.add(nm);
                scenStrs.add(desc);
            } else {
                scenStrs.add("\u0016K");
            }
            c.put(new SOCLocalizedStrings("S", 0, scenStrs));
        }
    }

    final void createAccount(String nn, String pw, String em, Connection c) {
        String userName;
        int cliVers = c.getVersion();
        if (!this.db.isInitialized()) {
            c.put(SOCStatusMessage.buildForVersion(8, cliVers, c.getLocalized("account.common.no_accts")));
            return;
        }
        String requester = c.getData();
        Date currentTime = new Date();
        boolean isOpenReg = this.features.isActive("oreg");
        if (this.databaseUserAdmins == null && !isOpenReg) {
            c.put(SOCStatusMessage.buildForVersion(17, cliVers, c.getLocalized("account.create.not_auth")));
            this.printAuditMessage(requester, "Requested jsettlers account creation, but no account admins list", null, currentTime, c.host());
            return;
        }
        boolean isDBCountedEmpty = false;
        if (requester == null && !isOpenReg) {
            int count;
            if (cliVers < 1119) {
                c.put(SOCStatusMessage.buildForVersion(5, cliVers, c.getLocalized("account.create.client_version_minimum", Version.version(1119))));
                return;
            }
            try {
                count = this.db.countUsers();
            }
            catch (SQLException e) {
                c.put(SOCStatusMessage.buildForVersion(6, cliVers, c.getLocalized("account.create.error_db_conn")));
                return;
            }
            if (count > 0) {
                c.put(SOCStatusMessage.buildForVersion(3, cliVers, c.getLocalized("account.common.must_auth")));
                return;
            }
            isDBCountedEmpty = true;
        }
        if (!SOCMessage.isSingleLineAndSafe(userName = nn.trim())) {
            c.put(SOCStatusMessage.buildForVersion(12, cliVers, c.getLocalized("netmsg.status.common.newgame_name_rejected")));
            return;
        }
        if (userName.length() > PLAYER_NAME_MAX_LENGTH) {
            c.put(SOCStatusMessage.buildForVersion(13, cliVers, c.getLocalized("netmsg.status.common.name_too_long", PLAYER_NAME_MAX_LENGTH)));
            return;
        }
        if (this.databaseUserAdmins != null) {
            String chkName;
            String string = chkName = isDBCountedEmpty ? userName : requester;
            if (chkName != null && this.db.getSchemaVersion() >= 1200) {
                chkName = chkName.toLowerCase(Locale.US);
            }
            if (chkName == null || !this.databaseUserAdmins.contains(chkName)) {
                c.put(SOCStatusMessage.buildForVersion(17, cliVers, c.getLocalized("account.create.not_auth")));
                this.printAuditMessage(requester, isDBCountedEmpty ? "Requested jsettlers account creation, database is empty - first, create a user named in account admins list" : "Requested jsettlers account creation, this requester not on account admins list", null, currentTime, c.host());
                if (isDBCountedEmpty) {
                    System.err.println("User requested new account but database is currently empty: Run SOCAccountClient to create account(s) named in the admins list.");
                }
                return;
            }
        }
        try {
            String dbUserName = this.db.getUser(userName);
            if (dbUserName != null) {
                c.put(SOCStatusMessage.buildForVersion(4, cliVers, c.getLocalized("account.create.already_exists", dbUserName)));
                this.printAuditMessage(requester, "Requested jsettlers account creation, already exists", userName, currentTime, c.host());
                return;
            }
        }
        catch (SQLException sqle) {
            c.put(SOCStatusMessage.buildForVersion(6, cliVers, c.getLocalized("account.create.error_db_conn")));
            return;
        }
        boolean success = false;
        boolean pwTooLong = false;
        try {
            success = this.db.createAccount(userName, c.host(), pw, em, currentTime.getTime());
        }
        catch (IllegalArgumentException e) {
            pwTooLong = true;
        }
        catch (SQLException sqle) {
            System.err.println("SQL Error creating account in db.");
        }
        if (success) {
            int stat = isDBCountedEmpty ? 18 : 7;
            c.put(SOCStatusMessage.buildForVersion(stat, cliVers, c.getLocalized("account.create.created", userName)));
            this.printAuditMessage(requester, "Created jsettlers account", userName, currentTime, c.host());
            if (this.acctsNotOpenRegButNoUsers) {
                this.acctsNotOpenRegButNoUsers = false;
            }
        } else {
            String errText = c.getLocalized(pwTooLong ? "account.common.password_too_long" : "account.create.error");
            c.put(SOCStatusMessage.buildForVersion(8, cliVers, errText));
        }
    }

    private void joinGame(SOCGame gameData, Connection c, boolean isReset, boolean isLoading, boolean isRejoinOrLoadgame) {
        String gameName = gameData.getName();
        GameHandler hand = this.gameList.getGameTypeHandler(gameName);
        if (hand == null) {
            System.err.println("L6708 SOCServer.joinGame: null handler for " + gameName);
            return;
        }
        hand.joinGame(gameData, c, isReset, isLoading, isRejoinOrLoadgame);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sitDown(SOCGame ga, Connection c, int pn, boolean robot, boolean isReset) {
        if (c == null || ga == null) {
            return;
        }
        ga.takeMonitor();
        boolean sendLikeRejoin = ga.savedGameModel != null && !ga.isSeatVacant(pn) && c.getData().equals(ga.getPlayer(pn).getName());
        try {
            boolean willFinishResuming;
            boolean willStartGame;
            String gaName = ga.getName();
            if (!isReset) {
                try {
                    SOCClientData cd = (SOCClientData)c.getAppData();
                    ga.addPlayer(c.getData(), pn);
                    ga.getPlayer(pn).setRobotFlag(robot, cd != null && cd.isBuiltInRobot);
                }
                catch (IllegalStateException e) {
                    if (!robot) {
                        this.messageToPlayerKeyed(c, gaName, -258, "member.sit.not.here");
                    }
                    ga.releaseMonitor();
                    ga.releaseMonitor();
                    return;
                }
            }
            SOCSitDown sitMessage = new SOCSitDown(gaName, c.getData(), pn, robot);
            this.messageToGame(gaName, true, sitMessage);
            Hashtable<Connection, Object> requestedBots = !isReset ? this.robotJoinRequests.get(gaName) : null;
            if (requestedBots != null && requestedBots.isEmpty()) {
                this.robotJoinRequests.remove(gaName);
                int gstate = ga.getGameState();
                willStartGame = gstate < 5;
                willFinishResuming = gstate == 992;
            } else {
                willStartGame = false;
                willFinishResuming = false;
            }
            GameHandler hand = this.gameList.getGameTypeHandler(gaName);
            if (hand != null) {
                hand.sitDown_sendPrivateInfo(ga, c, pn, sendLikeRejoin);
            }
            if (willStartGame && hand != null) {
                hand.startGame(ga);
            } else if (willFinishResuming) {
                String owner = ga.getOwner();
                Connection ownC = owner != null ? this.getConnection(owner) : null;
                this.srvMsgHandler.processDebugCommand_resumeGame(ownC, ga, "");
            }
        }
        catch (Throwable e) {
            D.ebugPrintStackTrace(e, "Exception caught at sitDown");
        }
        finally {
            ga.releaseMonitor();
        }
    }

    void resetBoardAndNotify(String gaName, int requestingPlayer) {
        SOCGameBoardReset reBoard = this.gameList.resetBoard(gaName);
        if (reBoard == null) {
            SOCGame ga = this.gameList.getGameData(gaName);
            if (ga != null) {
                this.messageToGameKeyed(ga, true, true, "resetboard.doit.interror", gaName);
            }
            return;
        }
        SOCGame reGame = reBoard.newGame;
        String plName = reGame.getPlayer(requestingPlayer).getName();
        String key = plName != null ? "resetboard.doit.announce.requester" : "resetboard.doit.announce.playerwholeft";
        this.messageToGameKeyed(reGame, true, true, key, gaName, plName);
        boolean resetWithShuffledBots = reBoard.oldGameState < 15 || reBoard.oldGameState == 1000;
        Connection[] huConns = reBoard.humanConns;
        Connection[] roConns = reBoard.robotConns;
        SOCResetBoardAuth resetMsg = new SOCResetBoardAuth(gaName, -1, requestingPlayer);
        boolean hasOldClients = reGame.clientVersionLowest < 2000;
        for (int pn = 0; pn < reGame.maxPlayers; ++pn) {
            if (huConns[pn] != null) {
                SOCResetBoardAuth rMsg = hasOldClients && huConns[pn].getVersion() < 2000 ? new SOCResetBoardAuth(gaName, pn, requestingPlayer) : resetMsg;
                this.messageToPlayer(huConns[pn], gaName, pn, rMsg);
                continue;
            }
            if (roConns[pn] == null) continue;
            if (!resetWithShuffledBots) {
                this.messageToPlayer(roConns[pn], gaName, pn, resetMsg);
                continue;
            }
            this.messageToPlayer(roConns[pn], gaName, pn, new SOCRobotDismiss(gaName));
        }
        if (!reBoard.hadRobots) {
            this.resetBoardAndNotify_finish(reBoard, reGame);
        }
    }

    void resetBoardAndNotify_finish(SOCGameBoardReset reBoard, SOCGame reGame) {
        int pn;
        String gaName = reGame.getName();
        boolean resetWithShuffledBots = reBoard.oldGameState < 15 || reBoard.oldGameState == 1000;
        Connection[] huConns = reBoard.humanConns;
        if (this.isRecordGameEventsActive()) {
            try {
                this.startLog(reGame, true);
            }
            catch (IOException e) {
                D.ebugPrintStackTrace(e, "IOException in resetBoardAndNotify_finish calling startLog");
            }
        }
        for (pn = 0; pn < reGame.maxPlayers; ++pn) {
            if (huConns[pn] == null) continue;
            this.joinGame(reGame, huConns[pn], true, false, false);
        }
        for (pn = 0; pn < reGame.maxPlayers; ++pn) {
            if (huConns[pn] == null) continue;
            this.sitDown(reGame, huConns[pn], pn, false, true);
        }
        if (!reBoard.hasRobots) {
            GameHandler hand = this.gameList.getGameTypeHandler(gaName);
            if (hand != null) {
                hand.startGame(reGame);
            }
        } else {
            reGame.setGameState(1);
            if (!this.readyGameAskRobotsJoin(reGame, null, resetWithShuffledBots ? null : reBoard.robotConns, 0)) {
                reGame.setGameState(1000);
                GameHandler hand = this.gameList.getGameTypeHandler(gaName);
                if (hand != null) {
                    hand.sendGameState(reGame);
                }
                this.messageToGameKeyed(reGame, true, true, "member.bot.join.cantfind");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void gameOverIncrGamesFinishedCount(SOCGame ga) {
        int nBots = 0;
        for (int pn = 0; pn < ga.maxPlayers; ++pn) {
            if (ga.isSeatVacant(pn) || !ga.getPlayer(pn).isRobot()) continue;
            ++nBots;
        }
        Object object = this.countFieldSync;
        synchronized (object) {
            ++this.numberOfGamesFinished;
            if (nBots > 0) {
                ++this.numberOfGamesFinishedWithBots;
                this.numberOfBotsInFinishedGames += nBots;
            }
        }
    }

    protected void storeGameScores(SOCGame ga) {
        if (ga == null || !this.db.isInitialized()) {
            return;
        }
        if (ga.getGameState() != 1000 || !ga.allOriginalPlayers() && !ga.hasHumanPlayers()) {
            return;
        }
        try {
            this.db.saveGameScores(ga, ga.getDurationSeconds(), !this.getConfigBoolProperty("jsettlers.db.save.games", false));
        }
        catch (Exception e) {
            System.err.println("Error saving game scores in db: " + e);
        }
    }

    public boolean isRecordGameEventsActive() {
        return false;
    }

    public boolean isRecordGameEventsFromClientsActive() {
        return false;
    }

    public final void startLog(SOCGame game, boolean isReset) throws IllegalArgumentException, IOException {
        if (game == null) {
            throw new IllegalArgumentException("game");
        }
        if (!this.isRecordGameEventsActive()) {
            return;
        }
        this.startEmptyLog(game, isReset);
        String gameName = game.getName();
        this.recordGameEvent(gameName, new SOCVersion(Version.versionNumber(), Version.version(), Version.buildnum(), this.getFeaturesList(), null));
        if (isReset) {
            SOCGame ga = this.getGame(gameName);
            if (ga == null) {
                return;
            }
            SOCGameOptionSet gameOpts = ga.getGameOptions();
            this.recordGameEvent(gameName, gameOpts == null ? new SOCNewGame(gameName) : new SOCNewGameWithOptions(gameName, gameOpts, SOCVersionedItem.itemsMinimumVersion(gameOpts.getAll()), -2));
        }
    }

    protected void startEmptyLog(SOCGame game, boolean isReset) throws IllegalArgumentException, IOException {
    }

    public void recordGameEvent(String gameName, SOCMessage event) {
    }

    public void recordGameEventTo(String gameName, int pn, SOCMessage event) {
    }

    public void recordGameEventNotTo(String gameName, int excludedPN, SOCMessage event) {
    }

    public void recordGameEventNotTo(String gameName, int[] excludedPN, SOCMessage event) {
    }

    public void recordClientMessage(String gameName, int fromPN, SOCMessageForGame event) {
    }

    public void endLog(SOCGame game) throws IllegalArgumentException {
        if (game == null) {
            throw new IllegalArgumentException("game");
        }
    }

    public void checkForExpiredGames(long currentTimeMillis) {
        ArrayList<String> expired = new ArrayList<String>();
        this.gameList.takeMonitor();
        long warn_ms = (long)(3 + GAME_TIME_EXPIRE_WARN_MINUTES) * 60L * 1000L;
        try {
            for (SOCGame gameData : this.gameList.getGamesData()) {
                if (gameData.isPractice) continue;
                long gameExpir = gameData.getExpiration();
                boolean hasWarned = gameData.hasWarnedExpiration();
                if (hasWarned && gameExpir <= currentTimeMillis) {
                    String gameName = gameData.getName();
                    expired.add(gameName);
                    this.messageToGameKeyed(gameData, true, true, "game.time.expire.deleted");
                    continue;
                }
                if (gameExpir - warn_ms <= currentTimeMillis) {
                    int minutes = (int)((gameExpir - currentTimeMillis) / 60000L);
                    if (minutes < 1) {
                        if (hasWarned) {
                            minutes = 1;
                        } else {
                            minutes = GAME_TIME_EXPIRE_CHECK_MINUTES + 1;
                            gameData.setExpiration(currentTimeMillis + (long)(minutes * 60 * 1000));
                        }
                    }
                    this.messageToGameKeyed(gameData, true, true, "game.time.expire.soon.addtime", minutes);
                    if (hasWarned) continue;
                    gameData.setWarnedExpiration();
                    continue;
                }
                if (currentTimeMillis - gameData.lastActionTime <= (long)(GAME_TIME_EXPIRE_CHECK_MINUTES * 60 * 1000)) continue;
                this.messageToGame(gameData.getName(), false, new SOCServerPing(GAME_TIME_EXPIRE_CHECK_MINUTES * 60));
            }
        }
        catch (Exception e) {
            D.ebugPrintlnINFO("Exception in checkForExpiredGames - " + e);
        }
        this.gameList.releaseMonitor();
        for (String ga : expired) {
            this.destroyGameAndBroadcast(ga, "checkForExpired");
        }
    }

    public void checkForExpiredTurns(long currentTimeMillis) {
        long inactiveTime = currentTimeMillis - (long)ROBOT_FORCE_ENDTURN_SECONDS * 1000L;
        long inactiveTimeStubborn = currentTimeMillis - (long)ROBOT_FORCE_ENDTURN_STUBBORN_SECONDS * 1000L;
        int timeout3p2 = this.getConfigIntProperty(PROP_JSETTLERS_BOTS_TIMEOUT_TURN, 0);
        long inactiveTime3p = timeout3p2 <= ROBOT_FORCE_ENDTURN_SECONDS ? 0L : currentTimeMillis - (long)timeout3p2 * 1000L;
        try {
            Iterator<SOCGame> timeout3p2 = this.gameList.getGamesData().iterator();
            while (timeout3p2.hasNext()) {
                GameHandler hand;
                SOCPlayer pl;
                SOCGame ga;
                long lastActionTime = ga.lastActionTime;
                ga = timeout3p2.next();
                if (lastActionTime > (ga.isCurrentPlayerStubbornRobot() ? inactiveTimeStubborn : inactiveTime)) continue;
                int gs = ga.getGameState();
                if (gs >= 990) {
                    ga.lastActionTime = currentTimeMillis + (long)(SOCGameListAtServer.GAME_TIME_EXPIRE_MINUTES * 60 * 1000);
                    continue;
                }
                int cpn = ga.getCurrentPlayerNumber();
                if (cpn == -1 || inactiveTime3p != 0L && lastActionTime > inactiveTime3p && (pl = ga.getPlayer(cpn)).isRobot() && !pl.isBuiltInRobot() || (hand = this.gameList.getGameTypeHandler(ga.getName())) == null) continue;
                hand.endTurnIfInactive(ga, currentTimeMillis);
            }
        }
        catch (Exception e) {
            D.ebugPrintlnINFO("Exception in checkForExpiredTurns - " + e);
        }
    }

    public static SOCGameOption parseCmdline_GameOption(SOCGameOption op, String optRaw, HashMap<String, String> optsAlreadySet) throws IllegalArgumentException {
        if (op == null) {
            throw new IllegalArgumentException("Malformed game option: " + optRaw);
        }
        if (op.optType == 0) {
            throw new IllegalArgumentException("Unknown game option: " + op.key);
        }
        if (optsAlreadySet != null && optsAlreadySet.containsKey(op.key)) {
            throw new IllegalArgumentException("Game option cannot appear twice on command line: " + op.key);
        }
        try {
            startupKnownOpts.setKnownOptionCurrentValue(op);
            if (optsAlreadySet != null) {
                optsAlreadySet.put(op.key, optRaw);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Bad value, cannot set game option: " + op.key);
        }
        return op;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Properties parseCmdline_DashedArgs(String[] args) {
        String arg;
        int aidx;
        HashMap<String, String> gameOptsAlreadySet;
        HashSet<String> cmdlineOptsSet;
        boolean doPrintOptions;
        boolean hasArgProblems;
        Properties argp;
        block63: {
            argp = new Properties();
            hasArgProblems = false;
            doPrintOptions = false;
            cmdlineOptsSet = new HashSet<String>();
            gameOptsAlreadySet = new HashMap<String, String>();
            try {
                File pf = new File(SOC_SERVER_PROPS_FILENAME);
                if (!pf.exists()) break block63;
                if (pf.isFile() && pf.canRead()) {
                    System.err.println("Reading startup properties from jsserver.properties");
                    FileInputStream fis = new FileInputStream(pf);
                    argp.load(fis);
                    fis.close();
                    try {
                        SOCServer.init_propsSetGameopts(argp);
                        if (!SOCServer.init_checkScenarioOpts(argp, true, SOC_SERVER_PROPS_FILENAME, null, null)) {
                            throw new IllegalArgumentException();
                        }
                        break block63;
                    }
                    catch (IllegalArgumentException e) {
                        String msg = e.getMessage();
                        if (msg != null) {
                            System.err.println(msg);
                        }
                        System.err.println("*** Error in properties file jsserver.properties: Exiting.");
                        System.exit(1);
                    }
                    break block63;
                }
                System.err.println("*** Properties file jsserver.properties exists but isn't a readable plain file: Exiting.");
                System.exit(1);
            }
            catch (Exception e) {
                System.err.println("*** Error reading properties file jsserver.properties, exiting: " + e.toString());
                if (e.getMessage() != null) {
                    System.err.println("    : " + e.getMessage());
                }
                System.exit(1);
            }
        }
        int pfxL = PROP_JSETTLERS_GAMEOPT_PREFIX.length();
        for (aidx = 0; aidx < args.length && args[aidx].startsWith("-"); ++aidx) {
            String name;
            arg = args[aidx];
            if (arg.equals("-V") || arg.equalsIgnoreCase("--version")) {
                Version.printVersionText(System.err, "Java Settlers Server ");
                hasStartupPrintAndExit = true;
                continue;
            }
            if (arg.equalsIgnoreCase("-h") || arg.equals("?") || arg.equals("-?") || arg.equalsIgnoreCase("--help")) {
                SOCServer.printUsage(true);
                hasStartupPrintAndExit = true;
                continue;
            }
            if (arg.startsWith("-o") || arg.equalsIgnoreCase("--option")) {
                hasSetGameOptions = true;
                boolean printedMsg = false;
                String optNameValue = arg.startsWith("-o") && arg.length() > 2 ? arg.substring(2) : (++aidx < args.length ? args[aidx] : null);
                if (optNameValue != null) {
                    try {
                        String okUC;
                        String oKey;
                        int i = optNameValue.indexOf(61);
                        if (i > 0 && !(oKey = optNameValue.substring(0, i)).equals(okUC = oKey.toUpperCase(Locale.US))) {
                            optNameValue = okUC + optNameValue.substring(i);
                        }
                        SOCGameOption opt = SOCServer.parseCmdline_GameOption(SOCGameOption.parseOptionNameValue(optNameValue, false, startupKnownOpts), optNameValue, gameOptsAlreadySet);
                        String propKey = PROP_JSETTLERS_GAMEOPT_PREFIX + opt.key;
                        if (argp.containsKey(propKey)) {
                            argp.put(propKey, opt.getPackedValue().toString());
                        }
                    }
                    catch (IllegalArgumentException e) {
                        optNameValue = null;
                        System.err.println(e.getMessage());
                        printedMsg = true;
                    }
                }
                if (optNameValue != null) continue;
                if (!printedMsg) {
                    System.err.println("Missing required option name/value after " + arg);
                    System.err.println();
                }
                hasArgProblems = true;
                doPrintOptions = true;
                continue;
            }
            if (arg.startsWith("-D")) {
                if (arg.length() == 2) {
                    if (++aidx >= args.length) {
                        System.err.println("Missing property name after -D");
                        return null;
                    }
                    name = args[aidx];
                } else {
                    name = arg.substring(2, arg.length());
                }
                String value = null;
                int posEq = name.indexOf("=");
                if (posEq > 0) {
                    value = name.substring(posEq + 1);
                    name = name.substring(0, posEq);
                } else {
                    if (aidx >= args.length - 1) {
                        System.err.println("Missing value for property " + name);
                        return null;
                    }
                    value = args[++aidx];
                }
                if (cmdlineOptsSet.contains(name)) {
                    System.err.println("Property cannot appear twice on command line: " + name);
                    return null;
                }
                argp.setProperty(name, value);
                cmdlineOptsSet.add(name);
                if (!name.startsWith(PROP_JSETTLERS_GAMEOPT_PREFIX)) continue;
                String optKey = name.substring(pfxL).toUpperCase(Locale.US);
                boolean ok = true;
                if (optKey.length() == 0) {
                    System.err.println("Empty game option name in property key: " + name);
                    ok = false;
                } else {
                    hasSetGameOptions = true;
                    try {
                        SOCServer.parseCmdline_GameOption(SOCGameOption.parseOptionNameValue(optKey, value, false, startupKnownOpts), optKey + "=" + value, gameOptsAlreadySet);
                    }
                    catch (IllegalArgumentException e) {
                        ok = false;
                        System.err.println(e.getMessage());
                        doPrintOptions = true;
                    }
                }
                if (ok) continue;
                hasArgProblems = true;
                continue;
            }
            if (arg.equals("-t") || arg.equalsIgnoreCase("--test-config")) {
                argp.put(PROP_JSETTLERS_TEST_VALIDATE__CONFIG, "y");
                continue;
            }
            if (arg.startsWith("--pw-reset")) {
                name = null;
                if (arg.length() == 10) {
                    if (++aidx < args.length) {
                        name = args[aidx];
                    }
                } else {
                    if (arg.charAt(10) != '=') {
                        System.err.println("Unknown argument: " + arg);
                        return null;
                    }
                    name = arg.substring(11);
                }
                if (name == null || name.length() == 0) {
                    System.err.println("Missing username after --pw-reset");
                    return null;
                }
                argp.setProperty("_jsettlers.user.pw_reset", name);
                continue;
            }
            System.err.println("Unknown argument: " + arg);
            hasArgProblems = true;
        }
        if (!gameOptsAlreadySet.isEmpty()) {
            String scName;
            if (!SOCServer.init_checkScenarioOpts(gameOptsAlreadySet, false, "Command line", null, null)) {
                return null;
            }
            if (gameOptsAlreadySet.containsKey("SC") && !argp.isEmpty() && (scName = startupKnownOpts.getKnownOption("SC", false).getStringValue()).length() > 0) {
                SOCServer.init_checkScenarioOpts(argp, true, SOC_SERVER_PROPS_FILENAME, scName, "command line");
            }
        }
        if (args.length - aidx == 0) {
            if (!argp.containsKey(PROP_JSETTLERS_PORT)) {
                argp.setProperty(PROP_JSETTLERS_PORT, Integer.toString(8880));
            }
            if (!argp.containsKey(PROP_JSETTLERS_CONNECTIONS)) {
                argp.setProperty(PROP_JSETTLERS_CONNECTIONS, Integer.toString(SOC_MAXCONN_DEFAULT));
            }
        } else {
            if (args.length - aidx < 2) {
                if (!printedUsageAlready) {
                    System.err.println("SOCServer: Some required command-line parameters are missing.");
                }
                SOCServer.printUsage(false);
                return null;
            }
            argp.setProperty(PROP_JSETTLERS_PORT, args[aidx]);
            argp.setProperty(PROP_JSETTLERS_CONNECTIONS, args[++aidx]);
            if (args.length - ++aidx > 0) {
                if (cmdlineOptsSet.contains("jsettlers.db.user") || cmdlineOptsSet.contains("jsettlers.db.pass")) {
                    System.err.println("SOCServer: DB user and password cannot appear twice on command line.");
                    SOCServer.printUsage(false);
                    return null;
                }
                argp.setProperty("jsettlers.db.user", args[aidx]);
                if (args.length - ++aidx > 0) {
                    argp.setProperty("jsettlers.db.pass", args[aidx]);
                    ++aidx;
                } else {
                    argp.setProperty("jsettlers.db.pass", "");
                }
            }
        }
        if (!argp.containsKey("jsettlers.db.user")) {
            argp.setProperty("jsettlers.db.user", "socuser");
            if (!argp.containsKey("jsettlers.db.pass")) {
                argp.setProperty("jsettlers.db.pass", "socpass");
            }
        } else if (!argp.containsKey("jsettlers.db.pass")) {
            argp.setProperty("jsettlers.db.pass", "");
        }
        try {
            if (argp.containsKey("org.sqlite.tmpdir") && null == System.getProperty("org.sqlite.tmpdir") && (arg = argp.getProperty("org.sqlite.tmpdir")) != null && !arg.isEmpty()) {
                System.setProperty("org.sqlite.tmpdir", arg);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (aidx < args.length) {
            if (!printedUsageAlready) {
                if (args[aidx].startsWith("-")) {
                    System.err.println("SOCServer: Options must appear before, not after, the port number.");
                } else {
                    System.err.println("SOCServer: Options must appear before the port number, not after dbuser/dbpass.");
                }
                SOCServer.printUsage(false);
            }
            return null;
        }
        if (doPrintOptions) {
            SOCServer.printGameOptions();
        }
        if (hasArgProblems) {
            return null;
        }
        return argp;
    }

    private static final void init_propsSetGameopts(Properties pr) throws IllegalArgumentException {
        int pfxL = PROP_JSETTLERS_GAMEOPT_PREFIX.length();
        StringBuilder problems = null;
        ArrayList<String> makeUpper = new ArrayList<String>();
        for (Object k : pr.keySet()) {
            String optUC;
            String optKey;
            if (!(k instanceof String) || !((String)k).startsWith(PROP_JSETTLERS_GAMEOPT_PREFIX) || (optKey = ((String)k).substring(pfxL)).equals(optUC = optKey.toUpperCase(Locale.US))) continue;
            makeUpper.add((String)k);
            makeUpper.add(PROP_JSETTLERS_GAMEOPT_PREFIX + optUC);
        }
        for (int i = 0; i < makeUpper.size(); i += 2) {
            String propKey = (String)makeUpper.get(i);
            String propUC = (String)makeUpper.get(i + 1);
            pr.put(propUC, pr.get(propKey));
            pr.remove(propKey);
        }
        for (Object k : pr.keySet()) {
            if (!(k instanceof String) || !((String)k).startsWith(PROP_JSETTLERS_GAMEOPT_PREFIX)) continue;
            String optKey = ((String)k).substring(pfxL);
            if (optKey.length() == 0) {
                if (problems == null) {
                    problems = new StringBuilder();
                } else {
                    problems.append("\n");
                }
                problems.append("Empty game option name in property key: ");
                problems.append(k);
                continue;
            }
            try {
                String optVal = pr.getProperty((String)k);
                SOCServer.parseCmdline_GameOption(SOCGameOption.parseOptionNameValue(optKey, optVal, false, startupKnownOpts), optKey + '=' + optVal, null);
                hasSetGameOptions = true;
            }
            catch (IllegalArgumentException e) {
                if (problems == null) {
                    problems = new StringBuilder();
                } else {
                    problems.append("\n");
                }
                problems.append(e.getMessage());
            }
        }
        if (problems != null) {
            throw new IllegalArgumentException(problems.toString());
        }
    }

    public static List<Triple> checkScenarioOpts(Map<?, ?> configOpts, boolean optsAreProps, String scName) {
        ArrayList<Triple> scenConflictWarns = null;
        if (scName == null) {
            String scKey;
            String string = scKey = optsAreProps ? "jsettlers.gameopt.SC" : "SC";
            if (configOpts.containsKey(scKey)) {
                scName = (String)configOpts.get(scKey);
                if (!optsAreProps) {
                    scName = scName.substring(scName.indexOf(61) + 1).trim();
                }
            } else {
                return null;
            }
        }
        scenConflictWarns = new ArrayList<Triple>();
        SOCScenario sc = SOCScenario.getScenario(scName);
        if (sc == null) {
            scenConflictWarns.add(new Triple("SC", scName, null));
            return scenConflictWarns;
        }
        String scOptsStr = sc.scOpts;
        if (scOptsStr == null || scOptsStr.length() == 0) {
            return null;
        }
        if (optsAreProps) {
            HashMap normOpts = new HashMap();
            for (Object k : configOpts.keySet()) {
                if (!(k instanceof String) || !((String)k).startsWith(PROP_JSETTLERS_GAMEOPT_PREFIX)) continue;
                normOpts.put(((String)k).toLowerCase(Locale.US), configOpts.get(k));
            }
            configOpts = normOpts;
        }
        Map<String, SOCGameOption> scOpts = SOCGameOption.parseOptionsToMap(scOptsStr, startupKnownOpts);
        StringBuilder sb = new StringBuilder();
        for (SOCGameOption scOpt : scOpts.values()) {
            String scOptVal;
            String optKey;
            String string = optKey = optsAreProps ? (PROP_JSETTLERS_GAMEOPT_PREFIX + scOpt.key).toLowerCase(Locale.US) : scOpt.key;
            if (!configOpts.containsKey(optKey)) continue;
            String configOptVal = (String)configOpts.get(optKey);
            if (!optsAreProps) {
                configOptVal = configOptVal.substring(configOptVal.indexOf(61) + 1).trim();
            }
            configOptVal = configOptVal.toLowerCase(Locale.US);
            sb.setLength(0);
            scOpt.packValue(sb);
            if (scOpt.key.equals("VP") || configOptVal.equals(scOptVal = sb.toString().toLowerCase(Locale.US))) continue;
            scenConflictWarns.add(new Triple(scOpt.key, configOptVal, scOptVal));
        }
        if (scenConflictWarns.isEmpty()) {
            return null;
        }
        scenConflictWarns.add(0, new Triple("SC", scName, scOptsStr));
        return scenConflictWarns;
    }

    private static boolean init_checkScenarioOpts(Map<?, ?> configOpts, boolean optsAreProps, String srcDesc, String scName, String scNameSrcDesc) {
        List<Triple> warns = SOCServer.checkScenarioOpts(configOpts, optsAreProps, scName);
        if (warns == null) {
            return true;
        }
        if (scName == null) {
            scName = (String)warns.get(0).getB();
        }
        boolean scenKnown = true;
        for (Triple warn : warns) {
            String optName = (String)warn.getA();
            if (optName.equals("SC")) {
                if (warn.getC() != null || scNameSrcDesc != null) continue;
                System.err.println("Error: " + srcDesc + " default scenario " + scName + " is unknown");
                scenKnown = false;
                continue;
            }
            System.err.println("Warning: " + srcDesc + " game option " + optName + " value " + warn.getB() + (scNameSrcDesc != null ? " is changed in " + scNameSrcDesc + " default scenario " : " is changed in default scenario ") + scName + " to " + warn.getC());
        }
        return scenKnown;
    }

    private void init_resetUserPassword(String uname) {
        this.utilityModeMessage = null;
        if (!this.db.isInitialized()) {
            System.err.println("--pw-reset requires database connection properties.");
            return;
        }
        String dbUname = null;
        try {
            dbUname = this.db.getUser(uname);
            if (dbUname == null) {
                System.err.println("pw-reset user " + uname + " not found in database.");
                return;
            }
        }
        catch (SQLException e) {
            System.err.println("Error while querying user " + uname + ": " + e.getMessage());
            return;
        }
        System.out.println("Resetting password for " + dbUname + ".");
        StringBuilder pw1 = null;
        boolean hasNewPW = false;
        for (int tries = 0; tries < 3; ++tries) {
            int L2;
            StringBuilder pw2;
            if (tries > 0) {
                System.out.println("Passwords do not match; try again.");
            }
            if ((pw1 = SOCServer.readPassword("Enter the new password:")) == null || pw1.length() == 0 || (pw2 = SOCServer.readPassword("Confirm new password:  ")) == null) break;
            int L1 = pw1.length();
            if (L1 == (L2 = pw2.length())) {
                char[] pc1 = new char[L1];
                char[] pc2 = new char[L2];
                pw1.getChars(0, L1, pc1, 0);
                pw2.getChars(0, L2, pc2, 0);
                hasNewPW = Arrays.equals(pc1, pc2);
                Arrays.fill(pc1, '\u0000');
                Arrays.fill(pc2, '\u0000');
            }
            if (!hasNewPW) continue;
            SOCServer.clearBuffer(pw2);
            break;
        }
        if (!hasNewPW) {
            if (pw1 != null) {
                SOCServer.clearBuffer(pw1);
            }
            System.err.println("Password reset cancelled.");
            return;
        }
        try {
            this.db.updateUserPassword(dbUname, pw1.toString());
            SOCServer.clearBuffer(pw1);
            this.utilityModeMessage = "The password was changed";
        }
        catch (IllegalArgumentException e) {
            System.err.println("Password was too long, max length is " + this.db.getMaxPasswordLength());
        }
        catch (SQLException e) {
            System.err.println("Error while resetting password: " + e.getMessage());
        }
    }

    void printAuditMessage(String req, String msg, String obj, Date at, String reqHost) {
        if (at == null) {
            at = new Date();
        }
        if (obj != null) {
            System.out.println("Audit: " + msg + ": '" + obj + (req != null ? "' by '" + req : "") + "' from " + reqHost + " at " + at);
        } else {
            System.out.println("Audit: " + msg + ": " + (req != null ? "'" + req + "'" : "") + " from " + reqHost + " at " + at);
        }
    }

    public static void printUsage(boolean longFormat) {
        if (printedUsageAlready && !longFormat) {
            return;
        }
        printedUsageAlready = true;
        if (longFormat) {
            Version.printVersionText(System.err, "Java Settlers Server ");
        }
        System.err.println("usage: java soc.server.SOCServer [option...] port_number max_connections [dbUser [dbPass]]");
        if (longFormat) {
            System.err.println("usage: recognized options:");
            System.err.println("       -V or --version    : print version information");
            System.err.println("       -h or --help or -? : print this screen");
            System.err.println("       -t or --test-config: validate server and DB config, then exit");
            System.err.println("       -o or --option name=value : set per-game options' default values");
            System.err.println("       -D name=value : set properties such as jsettlers.db.user");
            System.err.println("       --pw-reset uname   : reset password in DB for user uname, then exit");
            System.err.println("-- Recognized properties: --");
            for (int i = 0; i < PROPS_LIST.length; ++i) {
                System.err.print("\t");
                System.err.print(PROPS_LIST[i]);
                System.err.print("\t");
                System.err.println(PROPS_LIST[++i]);
            }
            SOCServer.printGameOptions();
        } else {
            System.err.println("       use java soc.server.SOCServer --help to see recognized options");
        }
    }

    public static void printGameOptions() {
        System.err.println("-- Current default game options: --");
        ArrayList<String> okeys = new ArrayList<String>(startupKnownOpts.keySet());
        Collections.sort(okeys);
        for (String okey : okeys) {
            SOCGameOption opt = startupKnownOpts.get(okey);
            if (opt.hasFlag(2)) continue;
            boolean quotes = opt.optType == 6 || opt.optType == 7;
            StringBuilder sb = new StringBuilder("  ");
            sb.append(okey);
            sb.append(" (");
            sb.append(SOCGameOption.optionTypeName(opt.optType));
            sb.append(") ");
            if (quotes) {
                sb.append('\"');
            }
            opt.packValue(sb);
            if (quotes) {
                sb.append('\"');
            }
            sb.append("  ");
            sb.append(opt.getDesc());
            System.err.println(sb.toString());
            if (opt.enumVals == null) continue;
            sb.setLength(0);
            sb.append("    option choices (1-n): ");
            for (int i = 1; i <= opt.maxIntValue; ++i) {
                sb.append(' ');
                sb.append(i);
                sb.append(' ');
                sb.append(opt.enumVals[i - 1]);
                sb.append(' ');
            }
            System.err.println(sb.toString());
        }
        int optsVers = SOCVersionedItem.itemsMinimumVersion(startupKnownOpts.getAll());
        if (optsVers > -1) {
            System.err.println("*** Note: Client version " + Version.version(optsVers) + " or newer is required for these game options. ***");
            System.err.println("          Games created with different options may not have this restriction.");
        }
    }

    private static void clearBuffer(StringBuilder sb) {
        int L = sb.length();
        for (int i = 0; i < L; ++i) {
            sb.setCharAt(i, '\u0000');
        }
    }

    private static StringBuilder readPassword(String prompt) {
        Console con;
        if (prompt == null) {
            prompt = "Password:";
        }
        if ((con = System.console()) != null) {
            char[] pw = System.console().readPassword(prompt, new Object[0]);
            if (pw == null) {
                return new StringBuilder();
            }
            return new StringBuilder().append(pw);
        }
        System.out.print(prompt);
        System.out.print(' ');
        System.out.flush();
        if (sysInBuffered == null) {
            sysInBuffered = new BufferedReader(new InputStreamReader(System.in));
        }
        try {
            char ch;
            int L;
            StringBuilder sb = new StringBuilder();
            sb.append(sysInBuffered.readLine());
            while ((L = sb.length()) != 0 && ((ch = sb.charAt(L - 1)) == '\n' || ch == '\r')) {
                sb.setLength(L - 1);
            }
            return sb;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static void main(String[] args) {
        block23: {
            Properties argp = SOCServer.parseCmdline_DashedArgs(args);
            if (argp == null) {
                SOCServer.printUsage(false);
                return;
            }
            if (hasStartupPrintAndExit) {
                return;
            }
            if (Version.versionNumber() == 0) {
                System.err.println("\n*** Packaging Error in server JAR: Cannot determine JSettlers version. Exiting now.");
                System.exit(1);
            }
            try {
                int port = 0;
                try {
                    port = Integer.parseInt(argp.getProperty(PROP_JSETTLERS_PORT));
                }
                catch (NumberFormatException e) {
                    SOCServer.printUsage(false);
                    return;
                }
                try {
                    String msg;
                    SOCServer server = new SOCServer(port, argp);
                    if (!server.hasUtilityModeProperty()) {
                        server.setPriority(5);
                        server.start();
                        break block23;
                    }
                    boolean validate_config_mode = server.getConfigBoolProperty(PROP_JSETTLERS_TEST_VALIDATE__CONFIG, false);
                    String pval = argp.getProperty("_jsettlers.user.pw_reset");
                    if (pval != null) {
                        if (validate_config_mode) {
                            System.err.println("Skipping password reset: Config Validation mode");
                        } else {
                            server.init_resetUserPassword(pval);
                        }
                    }
                    System.err.println((msg = server.getUtilityModeMessage()) != null ? "\n" + msg + ". Exiting now.\n" : "\nExiting now.\n");
                }
                catch (SocketException e) {
                    System.err.println(e.getMessage());
                    System.exit(1);
                }
                catch (EOFException e) {
                    if (argp.containsKey("jsettlers.db.script.setup")) {
                        System.err.println("\nDB setup script was successful. Exiting now.\n");
                    } else {
                        System.err.println("\n" + e.getMessage() + ". Exiting now.\n");
                    }
                    System.exit(2);
                }
                catch (SQLException e) {
                    if (argp.containsKey("jsettlers.db.script.setup")) {
                        System.err.println("\n* DB setup script failed. Exiting now.\n");
                    } else if (argp.containsKey("jsettlers.db.upgrade_schema")) {
                        System.err.println("\n* DB schema upgrade failed. Exiting now.\n");
                    } else {
                        System.err.println("\n* Exiting now.\n");
                    }
                    System.exit(1);
                }
                catch (IllegalArgumentException e) {
                    System.err.println("\n" + e.getMessage() + "\n* Error in game options properties: Exiting now.\n");
                    System.exit(1);
                }
                catch (IllegalStateException e) {
                    System.err.println("\n" + e.getMessage() + "\n* Packaging Error in server JAR: Exiting now.\n");
                    System.exit(1);
                }
            }
            catch (Throwable e) {
                System.err.println("\n" + e.getMessage() + "\n* Internal error during startup: Exiting now.\n");
                e.printStackTrace();
                System.exit(1);
            }
        }
    }

    static {
        SOCGameOption optPL = startupKnownOpts.getKnownOption("PL", false);
        i18n_gameopt_PL_desc = optPL != null ? optPL.getDesc() : "";
        SOCScenario scWond = SOCScenario.getScenario("SC_WOND");
        i18n_scenario_SC_WOND_desc = scWond != null ? scWond.getDesc() : "";
        GENERATEROBOTCOOKIE_HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        GENERAL_COMMANDS_HELP = new String[]{"--- General Commands ---", "*ADDTIME*  add 30 minutes before game expiration", "*CHECKTIME*  print time remaining before expiration", "*HELP*   info on available commands", "*STATS*   server stats and current-game stats", "*VERSION*  show version and build information", "*WHO*   show players and observers of this game"};
        ADMIN_GAME_COMMANDS_HELP = new String[]{"--- Game Admin Commands ---", "*MUTE*  nickname  Mute a player or observer", "*UNMUTE*  nickname  Unmute a player or observer"};
        ADMIN_USER_COMMANDS_HELP = new String[]{"*WHO* gameName   show players and observers of gameName", "*WHO* *  show all connected clients", "*BCAST*  Broadcast msg to all games/channels", "*DBSETTINGS*  Show current database settings, if any", "*GC*  Trigger the java garbage-collect", "*KILLBOT*  botname  End a bot's connection", "*RESETBOT* botname  End a bot's connection", "*LOADGAME* savename  Load a previously saved game from snapshot file", "*SAVEGAME* [-f] savename  Save this game's current state to snapshot file"};
        DEBUG_COMMANDS_HELP = new String[]{"--- Debug Commands ---", "*KILLGAME*  end the current game", "*STARTBOTGAME* [maxBots]  Start this game (no humans have sat) with bots only", "*STOP*  kill the server"};
        printedUsageAlready = false;
        sysInBuffered = null;
    }

    public static interface AuthSuccessRunnable {
        public void success(Connection var1, int var2);
    }
}

