/*
 * Decompiled with CFR 0.152.
 */
package soc.server;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TimerTask;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import soc.debug.D;
import soc.game.SOCGame;
import soc.game.SOCGameOption;
import soc.game.SOCGameOptionSet;
import soc.game.SOCGameOptionVersionException;
import soc.game.SOCPlayer;
import soc.game.SOCScenario;
import soc.game.SOCVersionedItem;
import soc.message.SOCAdminReset;
import soc.message.SOCAuthRequest;
import soc.message.SOCBCastTextMsg;
import soc.message.SOCChangeFace;
import soc.message.SOCChannelMembers;
import soc.message.SOCChannelTextMsg;
import soc.message.SOCCreateAccount;
import soc.message.SOCDeleteChannel;
import soc.message.SOCGameOptionGetDefaults;
import soc.message.SOCGameOptionGetInfos;
import soc.message.SOCGameOptionInfo;
import soc.message.SOCGameTextMsg;
import soc.message.SOCImARobot;
import soc.message.SOCJoinChannel;
import soc.message.SOCJoinChannelAuth;
import soc.message.SOCJoinGame;
import soc.message.SOCLeaveChannel;
import soc.message.SOCLeaveGame;
import soc.message.SOCLocalizedStrings;
import soc.message.SOCMessage;
import soc.message.SOCNewChannel;
import soc.message.SOCNewGameWithOptionsRequest;
import soc.message.SOCPlayerStats;
import soc.message.SOCRejectConnection;
import soc.message.SOCResetBoardRequest;
import soc.message.SOCResetBoardVote;
import soc.message.SOCResetBoardVoteRequest;
import soc.message.SOCRobotDismiss;
import soc.message.SOCScenarioInfo;
import soc.message.SOCServerPing;
import soc.message.SOCSetSeatLock;
import soc.message.SOCSitDown;
import soc.message.SOCStartGame;
import soc.message.SOCStatusMessage;
import soc.message.SOCUpdateRobotParams;
import soc.message.SOCVersion;
import soc.server.GameHandler;
import soc.server.SOCChannelList;
import soc.server.SOCChatRecentBuffer;
import soc.server.SOCClientData;
import soc.server.SOCGameListAtServer;
import soc.server.SOCReplaceRequest;
import soc.server.SOCServer;
import soc.server.genericServer.Connection;
import soc.server.genericServer.StringConnection;
import soc.server.savegame.GameLoaderJSON;
import soc.server.savegame.GameSaverJSON;
import soc.server.savegame.SavedGameModel;
import soc.util.I18n;
import soc.util.SOCFeatureSet;
import soc.util.SOCGameBoardReset;
import soc.util.SOCStringManager;
import soc.util.Version;

public class SOCServerMessageHandler {
    protected static final Pattern DEBUG_COMMAND_SAVEGAME_FILENAME_REGEX = Pattern.compile("^[\\p{IsLetter}\\p{IsDigit}_-]+$");
    protected final SOCServer srv;
    protected final SOCGameListAtServer gameList;
    protected final SOCChannelList channelList;

    public SOCServerMessageHandler(SOCServer srv, SOCGameListAtServer gameList, SOCChannelList channelList) {
        this.srv = srv;
        this.gameList = gameList;
        this.channelList = channelList;
    }

    final void dispatch(SOCMessage mes, Connection c) throws NullPointerException, Exception {
        switch (mes.getType()) {
            case 9999: {
                this.handleSERVERPING(c, (SOCServerPing)mes);
                break;
            }
            case 9998: {
                this.handleVERSION(c, (SOCVersion)mes);
                break;
            }
            case 999: {
                this.handleAUTHREQUEST(c, (SOCAuthRequest)mes);
                break;
            }
            case 1004: {
                this.handleJOINCHANNEL(c, (SOCJoinChannel)mes);
                break;
            }
            case 1006: {
                this.handleLEAVECHANNEL(c, (SOCLeaveChannel)mes);
                break;
            }
            case 1008: {
                this.srv.removeConnection(c, true);
                break;
            }
            case 1005: {
                this.handleCHANNELTEXTMSG(c, (SOCChannelTextMsg)mes);
                break;
            }
            case 1022: {
                this.handleIMAROBOT(c, (SOCImARobot)mes);
                break;
            }
            case 1010: {
                this.handleGAMETEXTMSG(c, (SOCGameTextMsg)mes);
                break;
            }
            case 1013: {
                this.handleJOINGAME(c, (SOCJoinGame)mes);
                break;
            }
            case 1011: {
                this.handleLEAVEGAME(c, (SOCLeaveGame)mes);
                break;
            }
            case 1012: {
                this.handleSITDOWN(c, (SOCSitDown)mes);
                break;
            }
            case 1018: {
                this.handleSTARTGAME(c, (SOCStartGame)mes, 0);
                break;
            }
            case 1058: {
                this.handleCHANGEFACE(c, (SOCChangeFace)mes);
                break;
            }
            case 1068: {
                this.handleSETSEATLOCK(c, (SOCSetSeatLock)mes);
                break;
            }
            case 1073: {
                this.handleRESETBOARDREQUEST(c, (SOCResetBoardRequest)mes);
                break;
            }
            case 1076: {
                this.handleRESETBOARDVOTE(c, (SOCResetBoardVote)mes);
                break;
            }
            case 1070: {
                SOCCreateAccount m = (SOCCreateAccount)mes;
                this.srv.createAccount(m.getNickname(), m.getPassword(), m.getEmail(), c);
                break;
            }
            case 1100: {
                this.handleLOCALIZEDSTRINGS(c, (SOCLocalizedStrings)mes);
                break;
            }
            case 1080: {
                this.handleGAMEOPTIONGETDEFAULTS(c, (SOCGameOptionGetDefaults)mes);
                break;
            }
            case 1081: {
                this.handleGAMEOPTIONGETINFOS(c, (SOCGameOptionGetInfos)mes);
                break;
            }
            case 1078: {
                this.handleNEWGAMEWITHOPTIONSREQUEST(c, (SOCNewGameWithOptionsRequest)mes);
                break;
            }
            case 1101: {
                this.handleSCENARIOINFO(c, (SOCScenarioInfo)mes);
            }
        }
    }

    void handleVERSION(Connection c, SOCVersion mes) {
        if (c == null) {
            return;
        }
        this.srv.setClientVersSendGamesOrReject(c, mes.getVersionNumber(), mes.feats, mes.cliLocale, true);
    }

    private void handleAUTHREQUEST(Connection c, SOCAuthRequest mes) {
        if (c == null) {
            return;
        }
        final String mesUser = mes.nickname.trim();
        final String mesRole = mes.role;
        final boolean isPlayerRole = mesRole.equals("P");
        final int cliVersion = c.getVersion();
        if (c.getData() != null) {
            this.handleAUTHREQUEST_postAuth(c, mesUser, mesRole, isPlayerRole, cliVersion, 1);
        } else {
            if (cliVersion <= 0) {
                c.put(new SOCStatusMessage(1, "AUTHREQUEST: Send version first"));
                return;
            }
            if (mes.authScheme != 1) {
                c.put(new SOCStatusMessage(1, "AUTHREQUEST: Auth scheme unknown: " + mes.authScheme));
                return;
            }
            this.srv.authOrRejectClientUser(c, mesUser, mes.password, cliVersion, isPlayerRole, false, new SOCServer.AuthSuccessRunnable(){

                @Override
                public void success(Connection conn, int authResult) {
                    SOCServerMessageHandler.this.handleAUTHREQUEST_postAuth(conn, mesUser, mesRole, isPlayerRole, cliVersion, authResult);
                }
            });
        }
    }

    private void handleAUTHREQUEST_postAuth(Connection c, String mesUser, String mesRole, boolean isPlayerRole, int cliVersion, int authResult) {
        if (c.getData() == null && !isPlayerRole) {
            if (mesRole.equals("UA") && !this.srv.isUserDBUserAdmin(mesUser)) {
                c.put(SOCStatusMessage.buildForVersion(17, cliVersion, c.getLocalized("account.create.not_auth")));
                this.srv.printAuditMessage(mesUser, "Requested jsettlers account creation, this requester not on account admins list", null, null, c.host());
                return;
            }
            try {
                c.setData(this.srv.db.getUser(mesUser));
                this.srv.nameConnection(c, false);
            }
            catch (SQLException e) {
                c.put(SOCStatusMessage.buildForVersion(6, c.getVersion(), "Problem connecting to database, please try again later."));
                return;
            }
        }
        String txt = this.srv.getClientWelcomeMessage(c);
        if (0 == (authResult & 4)) {
            c.put(new SOCStatusMessage(0, txt));
        } else {
            c.put(new SOCStatusMessage(20, c.getData() + ',' + txt));
        }
        SOCClientData scd = (SOCClientData)c.getAppData();
        if (scd != null) {
            scd.sentPostAuthWelcome = true;
        }
    }

    private void handleIMAROBOT(Connection c, SOCImARobot mes) {
        if (c == null) {
            return;
        }
        String botName = mes.getNickname();
        String rejectReason = this.srv.authOrRejectClientRobot(c, botName, mes.getCookie(), mes.getRBClass());
        if (rejectReason != null) {
            if (rejectReason.equals("Someone with that nickname is already logged into the system.")) {
                c.put(SOCStatusMessage.buildForVersion(4, c.getVersion(), rejectReason));
            }
            c.put(new SOCRejectConnection(rejectReason));
            c.disconnectSoft();
            final Connection rc = c;
            this.srv.miscTaskTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    SOCServerMessageHandler.this.srv.removeConnection(rc, true);
                }
            }, 300L);
            return;
        }
        c.put(new SOCUpdateRobotParams(this.srv.getRobotParameters(botName)));
    }

    private void handleSERVERPING(Connection c, SOCServerPing mes) {
        SOCClientData cd = (SOCClientData)c.getAppData();
        if (cd == null) {
            return;
        }
        cd.disconnectLastPingMillis = 0L;
    }

    private void handleLOCALIZEDSTRINGS(Connection c, SOCLocalizedStrings mes) {
        List<String> strs = mes.getParams();
        String type = strs.get(0);
        List<String> rets = null;
        int flags = 0;
        if (type.equals("O")) {
            flags = 4;
        } else if (type.equals("S")) {
            SOCClientData scd = (SOCClientData)c.getAppData();
            if (scd.localeHasGameScenarios(c)) {
                boolean wantsAll;
                boolean bl = wantsAll = mes.isFlagSet(2) || strs.size() == 1;
                if (wantsAll) {
                    flags = 4;
                    scd.sentAllScenarioStrings = true;
                }
                rets = SOCServer.localizeGameScenarios(scd.locale, strs, wantsAll, true, scd);
            } else {
                flags = 4;
                scd.sentAllScenarioStrings = true;
            }
        } else {
            flags = 1;
        }
        c.put(new SOCLocalizedStrings(type, flags, rets));
    }

    private void handleGAMEOPTIONGETDEFAULTS(Connection c, SOCGameOptionGetDefaults mes) {
        if (c == null) {
            return;
        }
        boolean hideLongNameOpts = c.getVersion() < 2000;
        c.put(new SOCGameOptionGetDefaults(SOCGameOption.packKnownOptionsToString(this.srv.knownOpts, true, hideLongNameOpts)));
    }

    private void handleGAMEOPTIONGETINFOS(Connection c, SOCGameOptionGetInfos mes) {
        String localDesc;
        SOCGameOptionSet opts3p;
        Map<String, SOCGameOption> trimmedOpts;
        Map<String, SOCGameOption> map;
        SOCFeatureSet limitedCliFeats;
        HashMap<String, SOCGameOption> optsToLocal;
        boolean unknownsWithDescs;
        if (c == null) {
            return;
        }
        int cliVers = c.getVersion();
        SOCClientData scd = (SOCClientData)c.getAppData();
        boolean hasLimitedFeats = scd.hasLimitedFeats;
        boolean alreadyTrimmedEnums = false;
        HashMap<String, SOCGameOption> opts = new HashMap<String, SOCGameOption>();
        if (mes.hasTokenGetI18nDescs && c.getI18NLocale() != null) {
            scd.wantsI18N = true;
        }
        boolean wantsLocalDescs = scd.wantsI18N && !SOCServer.i18n_gameopt_PL_desc.equals(c.getLocalized("gameopt.PL"));
        boolean bl = unknownsWithDescs = cliVers >= 2700;
        if (wantsLocalDescs) {
            optsToLocal = new HashMap<String, SOCGameOption>();
            for (SOCGameOption sOCGameOption : this.srv.knownOpts.optionsForVersion(cliVers)) {
                optsToLocal.put(sOCGameOption.key, sOCGameOption);
            }
        } else {
            optsToLocal = null;
        }
        if (mes.optionKeys != null) {
            for (String string : mes.optionKeys) {
                SOCGameOption opt = this.srv.knownOpts.getKnownOption(string, false);
                if (opt == null || opt.minVersion > cliVers) {
                    String localDesc2 = null;
                    if (unknownsWithDescs && opt != null) {
                        try {
                            localDesc2 = c.getLocalized("gameopt." + string);
                        }
                        catch (MissingResourceException e) {
                            localDesc2 = opt.getDesc();
                        }
                    }
                    opt = new SOCGameOption(string, localDesc2);
                }
                opts.put(string, opt);
            }
        }
        if (mes.hasTokenGetAnyChanges || mes.optionKeys == null && !mes.hasOnlyTokenI18n) {
            List<SOCGameOption> newerOpts = this.srv.knownOpts.optionsNewerThanVersion(cliVers, false, true);
            if (newerOpts != null) {
                for (SOCGameOption opt : newerOpts) {
                    opts.put(opt.key, opt);
                }
            }
            if (mes.optionKeys == null) {
                alreadyTrimmedEnums = true;
            }
            if (cliVers < 2000) {
                Iterator iterator = opts.keySet().iterator();
                while (iterator.hasNext()) {
                    String okey = (String)iterator.next();
                    if (okey.length() <= 3 && !okey.contains("_")) continue;
                    iterator.remove();
                }
            }
        }
        if ((limitedCliFeats = this.srv.checkLimitClientFeaturesForServerDisallows(scd.feats)) == null && hasLimitedFeats) {
            limitedCliFeats = scd.feats;
        }
        Map<String, SOCGameOption> map2 = map = limitedCliFeats != null ? this.srv.knownOpts.optionsNotSupported(limitedCliFeats) : null;
        if (map != null) {
            for (SOCGameOption opt : map.values()) {
                opts.put(opt.key, new SOCGameOption(opt.key, opt.getDesc()));
            }
        }
        Map<String, SOCGameOption> map3 = trimmedOpts = limitedCliFeats != null ? this.srv.knownOpts.optionsTrimmedForSupport(limitedCliFeats) : null;
        if (trimmedOpts != null) {
            opts.putAll(trimmedOpts);
        }
        if ((opts3p = this.srv.knownOpts.optionsWithFlag(16, 0)) != null) {
            SOCFeatureSet cliFeats = scd.feats;
            List<String> requestedKeys = mes.optionKeys;
            for (SOCGameOption opt : opts3p) {
                String ofeat = opt.getClientFeature();
                if (ofeat == null || cliFeats != null && cliFeats.isActive(ofeat)) continue;
                String okey = opt.key;
                if (requestedKeys != null && requestedKeys.contains(okey)) {
                    opts.put(okey, new SOCGameOption(okey, opt.getDesc()));
                    continue;
                }
                opts.remove(okey);
                if (!wantsLocalDescs) continue;
                optsToLocal.remove(okey);
            }
        }
        for (SOCGameOption opt : opts.values()) {
            String okey = opt.key;
            localDesc = null;
            if (opt.optType != 0) {
                boolean sendAsUnknown;
                block37: {
                    boolean bl2 = sendAsUnknown = opt.minVersion > cliVers || hasLimitedFeats && map.containsKey(okey);
                    if (wantsLocalDescs || sendAsUnknown && unknownsWithDescs) {
                        try {
                            localDesc = c.getLocalized("gameopt." + okey);
                        }
                        catch (MissingResourceException e) {
                            if (!sendAsUnknown) break block37;
                            localDesc = opt.getDesc();
                        }
                    }
                }
                if (sendAsUnknown) {
                    opt = new SOCGameOption(okey, localDesc);
                    localDesc = null;
                }
            }
            if (wantsLocalDescs) {
                optsToLocal.remove(okey);
                if (opt.getDesc().equals(localDesc)) {
                    localDesc = null;
                }
            }
            if (!alreadyTrimmedEnums && opt.enumVals != null && opt.optType != 0 && opt.lastModVersion > cliVers) {
                opt = SOCGameOption.trimEnumForVersion(opt, cliVers);
            }
            c.put(new SOCGameOptionInfo(opt, cliVers, localDesc));
        }
        if (optsToLocal != null) {
            ArrayList<String> strs = new ArrayList<String>(2 * optsToLocal.size());
            for (SOCGameOption opt : optsToLocal.values()) {
                if (opt.hasFlag(8)) continue;
                try {
                    localDesc = c.getLocalized("gameopt." + opt.key);
                    if (opt.getDesc().equals(localDesc)) continue;
                    strs.add(opt.key);
                    strs.add(localDesc);
                }
                catch (MissingResourceException missingResourceException) {}
            }
            c.put(new SOCLocalizedStrings("O", 4, strs));
        }
        c.put(SOCGameOptionInfo.OPTINFO_NO_MORE_OPTS);
    }

    private void handleSCENARIOINFO(Connection c, SOCScenarioInfo mes) {
        if (c == null) {
            return;
        }
        List<String> params = mes.getParams();
        int L = params.size();
        if (L == 0) {
            return;
        }
        boolean hasAnyChangedMarker = params.get(L - 1).equals("?");
        if (hasAnyChangedMarker) {
            params.remove(L - 1);
            --L;
        } else if (L == 1) {
            this.srv.sendGameScenarioInfo(params.get(0), null, c, true, false);
            return;
        }
        SOCClientData scd = (SOCClientData)c.getAppData();
        int cliVers = scd.scenVersion;
        Map<String, SOCScenario> knownScens = null;
        List<Object> changes = null;
        if (hasAnyChangedMarker && cliVers < Version.versionNumber()) {
            knownScens = SOCScenario.getAllKnownScenarios();
            changes = SOCVersionedItem.itemsNewerThanVersion(cliVers, false, knownScens);
        }
        if (L > 0) {
            if (changes == null) {
                changes = new ArrayList();
            }
            for (String scKey : params) {
                SOCScenario sc = SOCScenario.getScenario(scKey);
                if (sc == null || sc.minVersion > cliVers) {
                    c.put(new SOCScenarioInfo(scKey, true));
                    continue;
                }
                if (changes.contains(sc)) continue;
                changes.add(sc);
            }
        }
        if (changes != null) {
            for (Object sc : changes) {
                if (((SOCScenario)sc).minVersion <= cliVers) {
                    this.srv.sendGameScenarioInfo(null, (SOCScenario)sc, c, true, false);
                    continue;
                }
                c.put(new SOCScenarioInfo(((SOCScenario)sc).key, true));
            }
        }
        if (hasAnyChangedMarker && scd.wantsI18N && !scd.sentAllScenarioStrings) {
            if (!scd.checkedLocaleScenStrings) {
                scd.localeHasScenStrings = scd.localeHasGameScenarios(c);
                scd.checkedLocaleScenStrings = true;
            }
            if (scd.localeHasScenStrings) {
                if (knownScens == null) {
                    knownScens = SOCScenario.getAllKnownScenarios();
                }
                ArrayList<String> scKeys = new ArrayList<String>();
                for (SOCScenario sc : SOCVersionedItem.itemsForVersion(cliVers, knownScens)) {
                    if (changes != null && changes.contains(sc)) continue;
                    scKeys.add(sc.key);
                }
                List<String> scenStrs = !scKeys.isEmpty() ? SOCServer.localizeGameScenarios(scd.locale, scKeys, false, false, scd) : scKeys;
                c.put(new SOCLocalizedStrings("S", 4, scenStrs));
            }
            scd.sentAllScenarioStrings = true;
        }
        c.put(new SOCScenarioInfo(null, null, null));
        if (hasAnyChangedMarker) {
            scd.sentAllScenarioInfo = true;
            scd.sentAllScenarioStrings = true;
        }
    }

    private void handleCHANGEFACE(Connection c, SOCChangeFace mes) {
        String gaName = mes.getGame();
        SOCGame ga = this.gameList.getGameData(gaName);
        if (ga == null) {
            return;
        }
        SOCPlayer player = ga.getPlayer(c.getData());
        if (player == null) {
            return;
        }
        int id = mes.getFaceId();
        if (id <= 0 && !player.isRobot()) {
            return;
        }
        player.setFaceId(id);
        this.srv.messageToGame(gaName, true, new SOCChangeFace(gaName, player.getPlayerNumber(), id));
        SOCClientData scd = (SOCClientData)c.getAppData();
        if (scd != null && !scd.isRobot) {
            scd.faceId = id;
        }
    }

    private void handleSETSEATLOCK(Connection c, SOCSetSeatLock mes) {
        SOCGame.SeatLockState sl = mes.getLockState();
        String gaName = mes.getGame();
        SOCGame ga = this.gameList.getGameData(gaName);
        if (ga == null) {
            return;
        }
        SOCPlayer player = ga.getPlayer(c.getData());
        if (player == null) {
            return;
        }
        try {
            int pn = mes.getPlayerNumber();
            ga.setSeatLock(pn, sl);
            if (sl != SOCGame.SeatLockState.CLEAR_ON_RESET || ga.clientVersionLowest >= 2000) {
                this.srv.messageToGame(gaName, true, mes);
            } else {
                this.srv.messageToGameForVersions(ga, 2000, Integer.MAX_VALUE, mes, true);
                this.srv.messageToGameForVersions(ga, -1, 1999, new SOCSetSeatLock(gaName, pn, SOCGame.SeatLockState.UNLOCKED), true);
                this.srv.recordGameEvent(gaName, mes);
            }
        }
        catch (IllegalStateException e) {
            this.srv.messageToPlayerKeyed(c, gaName, player.getPlayerNumber(), "reply.lock.cannot");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleCHANNELTEXTMSG(Connection c, SOCChannelTextMsg mes) {
        String chName = mes.getChannel();
        String mName = c.getData();
        String txt = mes.getText().trim();
        if (this.srv.isDebugUserEnabled() && mName.equals("debug") && txt.startsWith("*KILLCHANNEL*")) {
            this.srv.messageToChannel(chName, new SOCChannelTextMsg(chName, "Server", "********** " + mName + " KILLED THE CHANNEL **********"));
            this.channelList.takeMonitor();
            try {
                this.srv.destroyChannel(chName);
            }
            catch (Exception e) {
                D.ebugPrintStackTrace(e, "Exception in KILLCHANNEL");
            }
            finally {
                this.channelList.releaseMonitor();
            }
            this.srv.broadcast(new SOCDeleteChannel(chName));
            return;
        }
        if (this.srv.channelList.isMember(c, chName)) {
            SOCChatRecentBuffer buf;
            this.srv.messageToChannel(chName, new SOCChannelTextMsg(chName, mName, txt));
            SOCChatRecentBuffer sOCChatRecentBuffer = buf = this.srv.channelList.getChatBuffer(chName);
            synchronized (sOCChatRecentBuffer) {
                buf.add(mName, txt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleGAMETEXTMSG(Connection c, SOCGameTextMsg gameTextMsgMes) {
        block44: {
            String cmdTxtUC;
            String cmdText;
            boolean userIsDebug;
            String plName;
            SOCGame ga;
            String gaName;
            block43: {
                String[] GAMETYPE_DEBUG_HELP;
                int i;
                boolean canChat;
                gaName = gameTextMsgMes.getGame();
                ga = this.gameList.getGameData(gaName);
                if (ga == null) {
                    return;
                }
                plName = c.getData();
                userIsDebug = this.srv.isDebugUserEnabled() && plName.equals("debug") || c instanceof StringConnection;
                boolean userIsAdmin = this.srv.isUserDBUserAdmin(plName);
                boolean bl = canChat = userIsDebug || userIsAdmin;
                if (!canChat && this.gameList.isMember(c, gaName)) {
                    int gstate = ga.getGameState();
                    canChat = gstate < 15 || gstate == 990 || gstate == 992 || ga.isMemberChatAllowed(plName);
                }
                cmdText = gameTextMsgMes.getText().trim();
                cmdTxtUC = null;
                if (canChat && cmdText.charAt(0) == '*') {
                    cmdTxtUC = cmdText.toUpperCase(Locale.US);
                    boolean matchedHere = true;
                    if (cmdTxtUC.startsWith("*ADDTIME*") || cmdTxtUC.startsWith("ADDTIME")) {
                        if (ga.isPractice) {
                            this.srv.messageToPlayerKeyed(c, gaName, -256, "reply.addtime.practice.never");
                        } else if (ga.getGameState() >= 1000) {
                            this.srv.messageToPlayerKeyed(c, gaName, -256, "reply.addtime.game_over");
                        } else {
                            int gameMaxMins;
                            long now = System.currentTimeMillis();
                            long exp = ga.getExpiration();
                            int minRemain = (int)((exp - now) / 60000L);
                            if (minRemain > (gameMaxMins = SOCGameListAtServer.GAME_TIME_EXPIRE_MINUTES + 30) - 4) {
                                this.srv.messageToPlayerKeyed(c, gaName, -258, "reply.addtime.not_expire_soon", minRemain);
                            } else {
                                int minAdd = 30;
                                if (minRemain + minAdd > gameMaxMins) {
                                    minAdd = gameMaxMins - minRemain;
                                }
                                exp += (long)(minAdd * 60 * 1000);
                                if ((minRemain += minAdd) < 30) {
                                    minRemain = 30;
                                    exp = now + (long)(minRemain * 60 * 1000);
                                }
                                ga.setExpiration(exp);
                                this.srv.messageToGameKeyed(ga, true, true, "reply.addtime.extended");
                                this.srv.messageToGameKeyed(ga, true, true, "stats.game.willexpire.urgent", minRemain);
                            }
                        }
                    } else if (cmdTxtUC.startsWith("*CHECKTIME*")) {
                        this.processDebugCommand_gameStats(c, ga, true);
                    } else if (cmdTxtUC.startsWith("*VERSION*")) {
                        this.srv.messageToPlayer(c, gaName, -258, "Java Settlers Server " + Version.versionNumber() + " (" + Version.version() + ") build " + Version.buildnum());
                    } else if (cmdTxtUC.startsWith("*STATS*")) {
                        this.processDebugCommand_serverStats(c, ga);
                    } else if (cmdTxtUC.startsWith("*WHO*")) {
                        this.processDebugCommand_who(c, ga, cmdText);
                    } else if (cmdTxtUC.startsWith("*MUTE*")) {
                        this.processGameMemberMuteCommand(c, ga, userIsDebug || userIsAdmin, cmdText, true);
                    } else if (cmdTxtUC.startsWith("*UNMUTE*")) {
                        this.processGameMemberMuteCommand(c, ga, userIsDebug || userIsAdmin, cmdText, false);
                    } else {
                        matchedHere = userIsDebug || userIsAdmin ? this.processAdminCommand(c, ga, cmdText, cmdTxtUC) : false;
                    }
                    if (matchedHere) {
                        return;
                    }
                }
                if (!canChat) {
                    SOCPlayer pl = ga.getPlayer(plName);
                    this.srv.messageToPlayerKeyed(c, gaName, pl != null ? pl.getPlayerNumber() : -257, pl != null ? "member.chat.not_this_time" : "member.chat.not_observers");
                    if (pl == null && !ga.hasHintedObserverWantsChat) {
                        Connection ownerConn;
                        String gameOwnerName = ga.getOwner();
                        Connection connection = ownerConn = gameOwnerName != null ? this.srv.getConnection(gameOwnerName) : null;
                        if (ownerConn != null) {
                            this.srv.messageToPlayerKeyed(ownerConn, gaName, -256, "admin.mute.hint.observer_wants_chat", plName);
                            this.srv.messageToPlayerKeyed(ownerConn, gaName, -256, "admin.mute.hint.observer_line_2");
                        }
                        ga.hasHintedObserverWantsChat = true;
                    }
                    return;
                }
                if (cmdTxtUC == null) {
                    cmdTxtUC = cmdText.toUpperCase(Locale.US);
                }
                if (!cmdTxtUC.startsWith("*HELP")) break block43;
                for (i = 0; i < SOCServer.GENERAL_COMMANDS_HELP.length; ++i) {
                    this.srv.messageToPlayer(c, gaName, -256, SOCServer.GENERAL_COMMANDS_HELP[i]);
                }
                if (this.srv.isUserGameAdmin(plName, ga)) {
                    for (i = 0; i < SOCServer.ADMIN_GAME_COMMANDS_HELP.length; ++i) {
                        this.srv.messageToPlayer(c, gaName, -256, SOCServer.ADMIN_GAME_COMMANDS_HELP[i]);
                    }
                }
                if (userIsDebug || this.srv.isUserDBUserAdmin(plName)) {
                    this.srv.messageToPlayer(c, gaName, -256, "--- Admin Commands ---");
                    for (i = 0; i < SOCServer.ADMIN_USER_COMMANDS_HELP.length; ++i) {
                        this.srv.messageToPlayer(c, gaName, -256, SOCServer.ADMIN_USER_COMMANDS_HELP[i]);
                    }
                }
                if (!userIsDebug) break block44;
                for (i = 0; i < SOCServer.DEBUG_COMMANDS_HELP.length; ++i) {
                    this.srv.messageToPlayer(c, gaName, -256, SOCServer.DEBUG_COMMANDS_HELP[i]);
                }
                GameHandler hand = this.gameList.getGameTypeHandler(gaName);
                if (hand != null && (GAMETYPE_DEBUG_HELP = hand.getDebugCommandsHelp()) != null) {
                    for (int i2 = 0; i2 < GAMETYPE_DEBUG_HELP.length; ++i2) {
                        this.srv.messageToPlayer(c, gaName, -256, GAMETYPE_DEBUG_HELP[i2]);
                    }
                }
                break block44;
            }
            if (!userIsDebug || !this.srv.processDebugCommand(c, ga, cmdText, cmdTxtUC)) {
                this.srv.messageToGame(gaName, true, new SOCGameTextMsg(gaName, plName, cmdText));
                SOCChatRecentBuffer buf = this.gameList.getChatBuffer(gaName);
                if (buf != null) {
                    SOCChatRecentBuffer sOCChatRecentBuffer = buf;
                    synchronized (sOCChatRecentBuffer) {
                        buf.add(plName, cmdText);
                    }
                }
            }
        }
    }

    public boolean processAdminCommand(Connection c, SOCGame ga, String cmdText, String cmdTextUC) {
        String gaName = ga.getName();
        boolean matchedHere = true;
        if (cmdTextUC.startsWith("*GC*")) {
            Runtime rt = Runtime.getRuntime();
            rt.gc();
            this.srv.messageToGame(gaName, true, "> GARBAGE COLLECTING DONE");
            this.srv.messageToGame(gaName, true, "> Free Memory: " + this.getSettingsFormatted_freeMemory(rt.freeMemory(), rt.totalMemory()));
        } else if (cmdTextUC.startsWith("*BCAST* ")) {
            this.srv.broadcast(new SOCBCastTextMsg(c.getData() + ": " + cmdText.substring(8).trim()));
        } else if (cmdTextUC.startsWith("*BOTLIST*")) {
            StringBuilder sb = new StringBuilder("Currently connected bots: ");
            if (!this.srv.getConnectedRobotNames(sb)) {
                sb.append("(None)");
            }
            this.srv.messageToPlayer(c, gaName, -258, sb.toString());
        } else if (cmdTextUC.startsWith("*RESETBOT* ")) {
            String botName = cmdText.substring(11).trim();
            this.srv.messageToGame(gaName, true, "> Admin: RESETBOT " + botName);
            Connection robotConn = this.srv.getRobotConnection(botName);
            if (robotConn != null) {
                this.srv.messageToGame(gaName, true, "> Admin: SENDING RESET COMMAND TO " + botName);
                robotConn.put(new SOCAdminReset());
            } else {
                this.srv.messageToPlayer(c, gaName, -256, "Bot not found to reset: " + botName);
            }
        } else if (cmdTextUC.startsWith("*KILLBOT* ")) {
            String botName = cmdText.substring(10).trim();
            this.srv.messageToGame(gaName, true, "> Admin: KILLBOT " + botName);
            Connection robotConn = this.srv.getRobotConnection(botName);
            if (robotConn != null) {
                this.srv.messageToGame(gaName, true, "> Admin: DISCONNECTING " + botName);
                this.srv.removeConnection(robotConn, true);
            } else {
                this.srv.messageToPlayer(c, gaName, -256, "Bot not found to disconnect: " + botName);
            }
        } else if (cmdTextUC.startsWith("*LOADGAME*")) {
            this.processDebugCommand_loadGame(c, gaName, cmdText.substring(10).trim());
        } else if (cmdTextUC.startsWith("*RESUMEGAME*")) {
            this.processDebugCommand_resumeGame(c, ga, cmdText.substring(12).trim());
        } else if (cmdTextUC.startsWith("*SAVEGAME*")) {
            this.processDebugCommand_saveGame(c, ga, cmdText.substring(10).trim());
        } else if (cmdTextUC.startsWith("*DBSETTINGS*")) {
            this.processDebugCommand_dbSettings(c, ga);
        } else {
            matchedHere = false;
        }
        return matchedHere;
    }

    private void processDebugCommand_dbSettings(Connection c, SOCGame ga) {
        String gaName = ga.getName();
        if (!this.srv.db.isInitialized()) {
            this.srv.messageToPlayer(c, gaName, -256, "Not using a database.");
            return;
        }
        this.srv.messageToPlayer(c, gaName, -256, "Database settings:");
        Iterator<String> it = this.srv.db.getSettingsFormatted(this.srv).iterator();
        while (it.hasNext()) {
            this.srv.messageToPlayer(c, gaName, -256, "> " + it.next() + ": " + it.next());
        }
    }

    final void processDebugCommand_connStats(Connection c, SOCGame ga, boolean skipWinLossBefore2) {
        int losses;
        String gaName = ga.getName();
        long connMinutes = (System.currentTimeMillis() - c.getConnectTime().getTime() + 30000L) / 60000L;
        String connMsgKey = ga.isPractice ? "stats.cli.connected.minutes.prac" : "stats.cli.connected.minutes";
        this.srv.messageToPlayerKeyed(c, gaName, -256, connMsgKey, connMinutes);
        SOCClientData scd = (SOCClientData)c.getAppData();
        if (scd == null) {
            return;
        }
        int wins = scd.getWins();
        if (wins + (losses = scd.getLosses()) < (skipWinLossBefore2 ? 2 : 1)) {
            return;
        }
        if (wins > 0) {
            if (losses == 0) {
                this.srv.messageToPlayerKeyed(c, gaName, -256, "stats.cli.winloss.won", wins);
            } else {
                this.srv.messageToPlayerKeyed(c, gaName, -256, "stats.cli.winloss.wonlost", wins, losses);
            }
        } else {
            this.srv.messageToPlayerKeyed(c, gaName, -256, "stats.cli.winloss.lost", losses);
        }
    }

    void processDebugCommand_gameStats(Connection c, SOCGame gameData, boolean isCheckTime) {
        SOCPlayer cp;
        if (gameData == null) {
            return;
        }
        String gaName = gameData.getName();
        this.srv.messageToPlayerKeyed(c, gaName, -258, "stats.game.title");
        this.srv.messageToPlayerKeyed(c, gaName, -258, "stats.game.rounds", gameData.getRoundCount());
        int cliVers = c.getVersion();
        if (cliVers >= 1109 && (cp = gameData.getPlayer(c.getData())) != null) {
            int pn = cp.getPlayerNumber();
            this.srv.messageToPlayer(c, gaName, pn, new SOCPlayerStats(cp, 1));
            if (cliVers >= 2600) {
                this.srv.messageToPlayer(c, gaName, pn, new SOCPlayerStats(cp, 2));
            }
        }
        int gameSeconds = gameData.getDurationSeconds();
        int gameMinutes = (gameSeconds + 29) / 60;
        gameSeconds %= 60;
        if (gameData.getGameState() < 1000) {
            this.srv.messageToPlayerKeyed(c, gaName, -258, "stats.game.startedago", gameMinutes);
        } else if (gameSeconds == 0) {
            this.srv.messageToPlayerKeyed(c, gaName, -258, "stats.game.was.minutes", gameMinutes);
        } else {
            this.srv.messageToPlayerKeyed(c, gaName, -258, "stats.game.was.minutessec", gameMinutes, gameSeconds);
        }
        if (!gameData.isPractice) {
            this.srv.messageToPlayerKeyed(c, gaName, -258, isCheckTime ? "stats.game.willexpire.urgent" : "stats.game.willexpire", (int)((gameData.getExpiration() - System.currentTimeMillis()) / 60000L));
        }
    }

    void processGameMemberMuteCommand(Connection c, SOCGame gameData, boolean isUserAdmin, String cmdText, boolean wantMute) {
        if (gameData == null) {
            return;
        }
        String gaName = gameData.getName();
        if (!isUserAdmin && !this.srv.isUserGameAdmin(c.getData(), gameData)) {
            this.srv.messageToPlayerKeyed(c, gaName, -258, "admin.mute.resp.only_game_admin");
            return;
        }
        int cmdWordLength = wantMute ? 6 : 8;
        String restOfCmd = cmdText.substring(cmdWordLength).trim();
        if (!restOfCmd.isEmpty() && cmdText.charAt(cmdWordLength) == ' ') {
            if (restOfCmd.equals("-l") || restOfCmd.equals("--list")) {
                Set<String> cal = gameData.getMemberChatAllowList();
                if (cal != null) {
                    this.srv.messageToPlayerKeyed(c, gaName, -258, "admin.mute.resp.currently_unmuted_list", String.join((CharSequence)", ", cal));
                } else {
                    this.srv.messageToPlayerKeyed(c, gaName, -258, "admin.mute.resp.cannot_before_start");
                }
                return;
            }
            if (wantMute && restOfCmd.equals(c.getData())) {
                this.srv.messageToPlayerKeyed(c, gaName, -258, "admin.mute.resp.cannot_mute_yourself");
                return;
            }
            if (this.gameList.isMember(restOfCmd, gaName)) {
                if (wantMute == !gameData.isMemberChatAllowed(restOfCmd)) {
                    this.srv.messageToPlayerKeyed(c, gaName, -258, wantMute ? "admin.mute.resp.is_already_muted" : "admin.mute.resp.is_already_unmuted", restOfCmd);
                } else {
                    try {
                        gameData.setMemberChatAllowed(restOfCmd, !wantMute);
                        this.srv.messageToPlayerKeyed(c, gaName, -258, wantMute ? "admin.mute.ok.muted" : "admin.mute.ok.unmuted", restOfCmd);
                        if (wantMute && gameData.getGameState() < 15) {
                            this.srv.messageToPlayerKeyed(c, gaName, -258, "admin.mute.ok.after_initial_placement");
                        }
                    }
                    catch (IllegalStateException e) {
                        this.srv.messageToPlayerKeyed(c, gaName, -258, "admin.mute.resp.cannot_before_start");
                    }
                }
            } else {
                this.srv.messageToPlayerKeyed(c, gaName, -258, "admin.mute.resp.nickname_not_found");
            }
            return;
        }
        this.srv.messageToPlayerKeyed(c, gaName, -258, "admin.mute.resp.usage", wantMute ? "*MUTE*" : "*UNMUTE*");
    }

    private void listAddStat(List<String> li, String name, String val) {
        li.add(name);
        li.add(val);
    }

    private void listAddStat(List<String> li, String name, int val) {
        li.add(name);
        li.add(Integer.toString(val));
    }

    final List<String> getSettingsFormatted(SOCStringManager strings) {
        if (strings == null) {
            strings = SOCStringManager.getFallbackServerManagerForClient();
        }
        Runtime rt = Runtime.getRuntime();
        ArrayList<String> li = new ArrayList<String>();
        this.listAddStat(li, "Uptime", I18n.durationToDaysHoursMinutesSeconds(System.currentTimeMillis() - this.srv.startTime, strings));
        this.listAddStat(li, "Connections since startup", this.srv.getRunConnectionCount());
        this.listAddStat(li, "Current named connections", this.srv.getNamedConnectionCount());
        this.listAddStat(li, "Current connections including unnamed", this.srv.getCurrentConnectionCount());
        this.listAddStat(li, "Total Users", this.srv.numberOfUsers);
        this.listAddStat(li, "Games started", this.srv.numberOfGamesStarted);
        this.listAddStat(li, "Games finished", this.srv.numberOfGamesFinished);
        this.listAddStat(li, "Games finished which had bots", this.srv.numberOfGamesFinishedWithBots);
        this.listAddStat(li, "Number of bots in finished games", this.srv.numberOfBotsInFinishedGames);
        long totalMem = rt.totalMemory();
        long freeMem = rt.freeMemory();
        this.listAddStat(li, "Total Memory", totalMem + " (" + I18n.bytesToHumanUnits(totalMem) + ')');
        this.listAddStat(li, "Free Memory", this.getSettingsFormatted_freeMemory(freeMem, totalMem));
        this.listAddStat(li, "Version", Version.versionNumber() + " (" + Version.version() + ") build " + Version.buildnum());
        if (!this.srv.clientPastVersionStats.isEmpty()) {
            if (this.srv.clientPastVersionStats.size() == 1) {
                this.listAddStat(li, "Client versions since startup", "all " + Version.version(this.srv.clientPastVersionStats.keySet().iterator().next()));
            } else {
                this.listAddStat(li, "Client versions since startup", "(includes bots)");
                for (Map.Entry<Integer, AtomicInteger> e : this.srv.clientPastVersionStats.entrySet()) {
                    this.listAddStat(li, "  ", Version.version(e.getKey()) + ": " + e.getValue());
                }
            }
        }
        return li;
    }

    private String getSettingsFormatted_freeMemory(long freeMem, long totalMem) {
        return freeMem + " (" + I18n.bytesToHumanUnits(freeMem) + ": " + 100L * freeMem / totalMem + "%)";
    }

    final void processDebugCommand_serverStats(Connection c, SOCGame ga) {
        String gaName = ga.getName();
        Iterator<String> it = this.getSettingsFormatted(c.getI18NStringManager()).iterator();
        while (it.hasNext()) {
            this.srv.messageToPlayer(c, gaName, -258, "> " + it.next() + ": " + it.next());
        }
        if (ga.clientVersionLowest != Version.versionNumber() || ga.clientVersionLowest != ga.clientVersionHighest) {
            this.srv.messageToPlayer(c, gaName, -258, "> This game's client versions: " + Version.version(ga.clientVersionLowest) + " - " + Version.version(ga.clientVersionHighest));
        }
        this.processDebugCommand_gameStats(c, ga, false);
        this.processDebugCommand_connStats(c, ga, false);
    }

    void processDebugCommand_loadGame(Connection c, String connGaName, String argsStr) {
        String errText;
        SavedGameModel sgm;
        block13: {
            if (argsStr.isEmpty() || argsStr.indexOf(32) != -1) {
                this.srv.messageToPlayerKeyed(c, connGaName, -256, "admin.loadgame.resp.usage");
                return;
            }
            if (!DEBUG_COMMAND_SAVEGAME_FILENAME_REGEX.matcher(argsStr).matches()) {
                this.srv.messageToPlayerKeyed(c, connGaName, -256, "admin.loadsavegame.resp.gamename.chars");
                return;
            }
            if (!this.processDebugCommand_loadSaveGame_checkDir("LOADGAME", c, connGaName)) {
                return;
            }
            sgm = null;
            errText = null;
            try {
                sgm = GameLoaderJSON.loadGame(new File(this.srv.savegameDir, argsStr + ".game.json"), this.srv);
            }
            catch (SOCGameOptionVersionException e) {
                errText = c.getLocalized("admin.loadgame.err.too_new.vers", argsStr, e.gameOptsVersion);
            }
            catch (NoSuchElementException e) {
                errText = c.getLocalized("admin.loadgame.err.too_new", argsStr, e.getMessage());
            }
            catch (SavedGameModel.UnsupportedSGMOperationException e) {
                String hasWhat = e.getMessage();
                try {
                    hasWhat = c.getLocalized(hasWhat, e.param1, e.param2);
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
                errText = c.getLocalized("admin.loadgame.err.too_new", argsStr, hasWhat);
            }
            catch (IOException | StringIndexOutOfBoundsException e) {
                errText = c.getLocalized("admin.loadgame.err.problem_loading", argsStr, e.getMessage());
            }
            catch (IllegalArgumentException e) {
                errText = c.getLocalized("admin.loadgame.err.cant_create", argsStr, e.getCause());
            }
            catch (Throwable th) {
                errText = c.getLocalized("admin.loadgame.err.problem_loading", argsStr, th);
                if (!"debug".equals(c.getData())) break block13;
                D.ebugPrintStackTrace(th, errText);
                errText = errText + c.getLocalized("admin.loadgame.err.append__see_console");
            }
        }
        if (errText != null) {
            this.srv.messageToPlayer(c, connGaName, -256, errText);
            return;
        }
        this.srv.createAndJoinReloadedGame(sgm, c, connGaName);
    }

    void processDebugCommand_resumeGame(Connection c, SOCGame ga, String argsStr) {
        String gaName = ga.getName();
        if (!argsStr.isEmpty()) {
            this.srv.messageToPlayerKeyed(c, gaName, -256, "admin.resumegame.resp.usage");
            return;
        }
        SavedGameModel sgm = (SavedGameModel)ga.savedGameModel;
        if (ga.getGameState() != 990 && ga.getGameState() != 992 || sgm == null) {
            this.srv.messageToPlayerKeyed(c, gaName, -256, "admin.resumegame.resp.not_waiting");
            return;
        }
        this.srv.resumeReloadedGame(c, ga);
    }

    void processDebugCommand_saveGame(Connection c, SOCGame ga, String argsStr) {
        int gstate;
        String gaName = ga.getName();
        boolean askedForce = false;
        if (argsStr.startsWith("-f ")) {
            askedForce = true;
            argsStr = argsStr.substring(3).trim();
        } else {
            int i = argsStr.indexOf(32);
            if (i != -1 && argsStr.substring(i + 1).trim().equals("-f")) {
                askedForce = true;
                argsStr = argsStr.substring(0, i);
            }
        }
        if (argsStr.isEmpty() || argsStr.indexOf(32) != -1) {
            this.srv.messageToPlayerKeyed(c, gaName, -256, "admin.savegame.resp.usage");
            return;
        }
        if (!this.processDebugCommand_loadSaveGame_checkDir("SAVEGAME", c, gaName)) {
            return;
        }
        String fname = argsStr + ".game.json";
        if (!askedForce) {
            try {
                File f = new File(this.srv.savegameDir, fname);
                if (f.exists()) {
                    this.srv.messageToPlayerKeyed(c, gaName, -258, "admin.savegame.resp.file_exists");
                    return;
                }
            }
            catch (SecurityException f) {
                // empty catch block
            }
        }
        if ((gstate = ga.getGameState()) < 15) {
            this.srv.messageToPlayerKeyed(c, gaName, -258, "admin.savegame.resp.must_initial_placement");
            return;
        }
        if (gstate == 990 || gstate == 992) {
            this.srv.messageToPlayerKeyed(c, gaName, -258, "admin.savegame.resp.must_resume");
            return;
        }
        if (!DEBUG_COMMAND_SAVEGAME_FILENAME_REGEX.matcher(argsStr).matches()) {
            this.srv.messageToPlayerKeyed(c, gaName, -256, "admin.loadsavegame.resp.gamename.chars");
            return;
        }
        try {
            GameSaverJSON.saveGame(ga, this.srv.savegameDir, fname, this.srv);
            this.srv.messageToPlayerKeyed(c, gaName, -258, "admin.savegame.ok.saved_to", fname);
        }
        catch (SavedGameModel.UnsupportedSGMOperationException e) {
            String hasWhat = e.getMessage();
            try {
                hasWhat = c.getLocalized(hasWhat, e.param1, e.param2);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            this.srv.messageToPlayerKeyed(c, gaName, -258, "admin.savegame.err.cannot_save_has", hasWhat);
        }
        catch (IOException | IllegalArgumentException | IllegalStateException e) {
            this.srv.messageToPlayerKeyed(c, gaName, -258, "admin.savegame.err.problem_saving", e);
        }
    }

    private boolean processDebugCommand_loadSaveGame_checkDir(String cmdName, Connection c, String connGaName) {
        String errMsgObj;
        File dir = this.srv.savegameDir;
        String errMsgKey = null;
        Object errMsgO1 = null;
        if (this.srv.savegameInitFailed) {
            errMsgKey = "admin.loadsavegame.resp.disabled_init";
            errMsgObj = cmdName;
        } else if (dir == null) {
            errMsgKey = "admin.loadsavegame.resp.disabled_prop";
            errMsgObj = cmdName;
            errMsgO1 = "jsettlers.savegame.dir";
        } else {
            errMsgObj = dir.getPath();
            try {
                if (!dir.exists()) {
                    errMsgKey = "admin.loadsavegame.err.dir_not_found";
                } else if (!dir.isDirectory()) {
                    errMsgKey = "admin.loadsavegame.err.dir_not_dir";
                }
            }
            catch (SecurityException e) {
                errMsgKey = "admin.loadsavegame.err.dir_no_access";
                errMsgO1 = e;
            }
        }
        if (errMsgKey != null) {
            this.srv.messageToPlayerKeyed(c, connGaName, -256, errMsgKey, errMsgObj, errMsgO1);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processDebugCommand_who(Connection c, SOCGame ga, String cmdText) {
        String gname;
        String gaName;
        String gaNameWho = gaName = ga.getName();
        boolean sendToCli = false;
        int i = cmdText.indexOf(32);
        if (i != -1 && (gname = cmdText.substring(i + 1).trim()).length() > 0) {
            boolean isAdmin;
            String cliUsername = c.getData();
            boolean bl = isAdmin = c instanceof StringConnection || this.srv.isUserDBUserAdmin(cliUsername) || this.srv.isDebugUserEnabled() && cliUsername.equals("debug");
            if (!isAdmin) {
                this.srv.messageToPlayerKeyed(c, gaName, -256, "reply.must_be_admin.view");
                return;
            }
            sendToCli = true;
            if (gname.equals("*") || gname.toUpperCase(Locale.US).equals("ALL")) {
                ArrayList<StringBuilder> sbs = new ArrayList<StringBuilder>();
                sbs.add(new StringBuilder(c.getLocalized("reply.who.conn_to_srv")));
                Integer nUnnamed = this.srv.getConnectedClientNames(sbs);
                if (nUnnamed != 0) {
                    StringBuilder sb = new StringBuilder("- ");
                    sb.append(c.getLocalized("reply.who.and_unnamed", nUnnamed));
                    sbs.add(sb);
                }
                for (StringBuilder sbb : sbs) {
                    this.srv.messageToPlayer(c, gaName, -256, sbb.toString());
                }
                return;
            }
            if (this.gameList.isGame(gname)) {
                gaNameWho = gname;
            } else {
                this.srv.messageToPlayerKeyed(c, gaName, -256, "reply.game.not.found");
                return;
            }
        }
        Vector<Connection> gameMembers = null;
        this.gameList.takeMonitorForGame(gaNameWho);
        try {
            gameMembers = this.gameList.getMembers(gaNameWho);
            if (!sendToCli) {
                this.srv.messageToGameKeyed(ga, false, false, "reply.game_members.this");
            }
        }
        catch (Exception e) {
            D.ebugPrintStackTrace(e, "Exception in *WHO* (gameMembers)");
        }
        finally {
            this.gameList.releaseMonitorForGame(gaNameWho);
        }
        if (gameMembers == null) {
            return;
        }
        if (sendToCli) {
            this.srv.messageToPlayerKeyed(c, gaName, -256, "reply.game_members.of", gaNameWho);
        }
        Enumeration<Connection> membersEnum = gameMembers.elements();
        while (membersEnum.hasMoreElements()) {
            Connection conn = membersEnum.nextElement();
            String mNameStr = "> " + conn.getData();
            if (sendToCli) {
                this.srv.messageToPlayer(c, gaName, -256, mNameStr);
                continue;
            }
            this.srv.messageToGame(gaName, false, mNameStr);
        }
    }

    private void handleJOINCHANNEL(Connection c, SOCJoinChannel mes) {
        int cliVers;
        if (c == null) {
            return;
        }
        if (D.ebugIsEnabled()) {
            D.ebugPrintlnINFO("handleJOINCHANNEL: " + mes);
        }
        if ((cliVers = c.getVersion()) == -1) {
            if (!this.srv.setClientVersSendGamesOrReject(c, 1000, null, null, false)) {
                return;
            }
            cliVers = c.getVersion();
        }
        final String chName = mes.getChannel().trim();
        if (c.getData() != null) {
            this.handleJOINCHANNEL_postAuth(c, chName, cliVers, 1);
        } else {
            String msgUser = mes.getNickname().trim();
            String msgPass = mes.getPassword();
            final int cv = cliVers;
            this.srv.authOrRejectClientUser(c, msgUser, msgPass, cliVers, true, false, new SOCServer.AuthSuccessRunnable(){

                @Override
                public void success(Connection conn, int authResult) {
                    SOCServerMessageHandler.this.handleJOINCHANNEL_postAuth(conn, chName, cv, authResult);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleJOINCHANNEL_postAuth(Connection c, String ch, int cliVers, int authResult) {
        List<SOCChatRecentBuffer.Entry> recents;
        SOCClientData scd = (SOCClientData)c.getAppData();
        boolean mustSetUsername = 0 != (authResult & 4);
        String msgUsername = c.getData();
        if (!SOCMessage.isSingleLineAndSafe(ch) || "*".equals(ch)) {
            c.put(SOCStatusMessage.buildForVersion(12, cliVers, c.getLocalized("netmsg.status.common.newgame_name_rejected")));
            return;
        }
        if (!this.channelList.isChannel(ch) && SOCServer.CLIENT_MAX_CREATE_CHANNELS >= 0 && SOCServer.CLIENT_MAX_CREATE_CHANNELS <= scd.getcurrentCreatedChannels()) {
            c.put(SOCStatusMessage.buildForVersion(15, cliVers, c.getLocalized("netmsg.status.newchannel_too_many_created", SOCServer.CLIENT_MAX_CREATE_CHANNELS)));
            return;
        }
        String txt = this.srv.getClientWelcomeMessage(c);
        if (!mustSetUsername) {
            if (!scd.sentPostAuthWelcome || c.getVersion() < 2000) {
                c.put(new SOCStatusMessage(0, txt));
                scd.sentPostAuthWelcome = true;
            }
        } else {
            c.put(new SOCStatusMessage(20, msgUsername + ',' + txt));
        }
        c.put(new SOCJoinChannelAuth(msgUsername, ch));
        if (this.channelList.takeMonitorForChannel(ch)) {
            try {
                this.srv.connectToChannel(c, ch);
            }
            catch (Exception e) {
                D.ebugPrintStackTrace(e, "Exception in handleJOIN (connectToChannel)");
            }
            this.channelList.releaseMonitorForChannel(ch);
        } else {
            this.channelList.takeMonitor();
            try {
                this.channelList.createChannel(ch, msgUsername);
                scd.createdChannel();
            }
            catch (Exception e) {
                D.ebugPrintStackTrace(e, "Exception in handleJOIN (createChannel)");
            }
            this.channelList.releaseMonitor();
            this.srv.broadcast(new SOCNewChannel(ch));
            c.put(new SOCChannelMembers(ch, this.channelList.getMembers(ch)));
            D.ebugPrintlnINFO("*** " + msgUsername + " joined new channel " + ch + " at " + DateFormat.getTimeInstance(3).format(new Date()));
            this.channelList.takeMonitorForChannel(ch);
            try {
                this.channelList.addMember(c, ch);
            }
            catch (Exception e) {
                D.ebugPrintStackTrace(e, "Exception in handleJOIN (addMember)");
            }
            this.channelList.releaseMonitorForChannel(ch);
        }
        this.srv.messageToChannel(ch, new SOCJoinChannel(msgUsername, "", "\t", ch));
        SOCChatRecentBuffer buf = this.channelList.getChatBuffer(ch);
        SOCChatRecentBuffer sOCChatRecentBuffer = buf;
        synchronized (sOCChatRecentBuffer) {
            recents = buf.getAll();
        }
        if (!recents.isEmpty()) {
            c.put(new SOCChannelTextMsg(ch, ":", c.getLocalized("member.join.recap_begin")));
            for (SOCChatRecentBuffer.Entry e : recents) {
                c.put(new SOCChannelTextMsg(ch, e.nickname, e.text));
            }
            c.put(new SOCChannelTextMsg(ch, ":", c.getLocalized("member.join.recap_end")));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleLEAVECHANNEL(Connection c, SOCLeaveChannel mes) {
        if (D.ebugIsEnabled()) {
            D.ebugPrintlnINFO("handleLEAVECHANNEL: " + mes);
        }
        if (c == null) {
            return;
        }
        String chName = mes.getChannel();
        boolean destroyedChannel = false;
        this.channelList.takeMonitorForChannel(chName);
        try {
            destroyedChannel = this.srv.leaveChannel(c, chName, true, false);
        }
        catch (Exception e) {
            D.ebugPrintStackTrace(e, "Exception in handleLEAVECHANNEL");
        }
        finally {
            this.channelList.releaseMonitorForChannel(chName);
        }
        if (destroyedChannel) {
            this.srv.broadcast(new SOCDeleteChannel(chName));
        }
    }

    private void handleNEWGAMEWITHOPTIONSREQUEST(Connection c, SOCNewGameWithOptionsRequest mes) {
        if (c == null) {
            return;
        }
        Map<String, SOCGameOption> optsMap = mes.getOptions(this.srv.knownOpts);
        this.srv.createOrJoinGameIfUserOK(c, mes.getNickname(), mes.getPassword(), mes.getGame(), optsMap != null ? new SOCGameOptionSet(optsMap) : null);
    }

    private void handleJOINGAME(Connection c, SOCJoinGame mes) {
        if (c == null) {
            return;
        }
        if (c.getVersion() == -1 && !this.srv.setClientVersSendGamesOrReject(c, 1000, null, null, false)) {
            return;
        }
        this.srv.createOrJoinGameIfUserOK(c, mes.getNickname(), mes.getPassword(), mes.getGame(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleLEAVEGAME(Connection c, SOCLeaveGame mes) {
        if (c == null) {
            return;
        }
        boolean isMember = false;
        String gaName = mes.getGame();
        if (!this.gameList.takeMonitorForGame(gaName)) {
            return;
        }
        try {
            isMember = this.gameList.isMember(c, gaName);
        }
        catch (Exception e) {
            D.ebugPrintStackTrace(e, "Exception in handleLEAVEGAME (isMember)");
        }
        finally {
            this.gameList.releaseMonitorForGame(gaName);
        }
        if (isMember) {
            this.srv.leaveGameMemberAndCleanup(c, null, gaName);
        } else if (((SOCClientData)c.getAppData()).isRobot) {
            this.handleLEAVEGAME_maybeGameReset_oldRobot(gaName);
        }
    }

    private void handleLEAVEGAME_maybeGameReset_oldRobot(String gaName) {
        SOCGame cg = this.gameList.getGameData(gaName);
        if (cg == null || cg.getGameState() != 4) {
            return;
        }
        boolean gameResetRobotsAllDismissed = false;
        SOCGameBoardReset gr = cg.boardResetOngoingInfo;
        if (gr != null) {
            --gr.oldRobotCount;
            if (0 == gr.oldRobotCount) {
                gameResetRobotsAllDismissed = true;
            }
        }
        if (gameResetRobotsAllDismissed) {
            this.srv.resetBoardAndNotify_finish(gr, cg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSITDOWN(Connection c, SOCSitDown mes) {
        if (c == null) {
            return;
        }
        String gaName = mes.getGame();
        SOCGame ga = this.gameList.getGameData(gaName);
        if (ga == null) {
            this.srv.messageToPlayerKeyed(c, gaName, -258, "reply.game.not.found");
            return;
        }
        SOCClientData scd = (SOCClientData)c.getAppData();
        boolean isArrivingRobot = scd != null && scd.isRobot;
        boolean canSit = true;
        boolean gameIsFull = false;
        boolean gameAlreadyStarted = false;
        boolean sentBotDismiss = false;
        boolean isBotJoinRequest = false;
        Hashtable<Connection, Object> joinRequests = this.srv.robotJoinRequests.get(gaName);
        if (joinRequests != null) {
            isBotJoinRequest = null != joinRequests.remove(c);
        }
        int pn = mes.getPlayerNumber();
        int gameState = ga.getGameState();
        ga.takeMonitor();
        try {
            if (ga.isSeatVacant(pn)) {
                boolean bl = gameAlreadyStarted = gameState >= 10;
                if (!gameAlreadyStarted) {
                    boolean bl2 = gameIsFull = 1 > ga.getAvailableSeatCount();
                }
                if (gameIsFull || gameAlreadyStarted && !isBotJoinRequest) {
                    canSit = false;
                }
            } else {
                boolean canTakeOverPlayer;
                canSit = false;
                SOCPlayer seatedPlayer = ga.getPlayer(pn);
                String seatedName = seatedPlayer.getName();
                boolean isLoadingState = gameState == 990 || gameState == 992;
                boolean isloadingBot = isLoadingState && isArrivingRobot;
                boolean bl = canTakeOverPlayer = seatedPlayer.isRobot() || isLoadingState && (isloadingBot || !this.gameList.isMember(seatedName, gaName));
                if (isloadingBot && c.getData().equals(seatedName)) {
                    canSit = true;
                } else if (canTakeOverPlayer && (ga.getSeatLock(pn) != SOCGame.SeatLockState.LOCKED && ga.getCurrentPlayerNumber() != pn || isLoadingState)) {
                    Connection robotCon = this.srv.getConnection(seatedName);
                    if (robotCon != null && this.gameList.isMember(robotCon, gaName)) {
                        Vector<SOCReplaceRequest> disRequests = this.srv.robotDismissRequests.get(gaName);
                        SOCReplaceRequest req = new SOCReplaceRequest(c, robotCon, mes);
                        if (disRequests == null) {
                            disRequests = new Vector();
                            this.srv.robotDismissRequests.put(gaName, disRequests);
                        }
                        disRequests.addElement(req);
                        sentBotDismiss = true;
                        this.srv.messageToPlayer(robotCon, gaName, pn, new SOCRobotDismiss(gaName));
                    } else if (ga.savedGameModel != null && gameState >= 990) {
                        canSit = true;
                        this.srv.messageToGame(gaName, true, new SOCLeaveGame(seatedName, "-", gaName));
                    }
                }
            }
        }
        catch (Exception e) {
            D.ebugPrintStackTrace(e, "Exception caught at handleSITDOWN");
        }
        finally {
            ga.releaseMonitor();
        }
        if (canSit) {
            SOCGame.SeatLockState modelLock;
            SOCGame.SeatLockState gaLock;
            this.srv.sitDown(ga, c, pn, isArrivingRobot, false);
            if (gameState == 990 && isArrivingRobot && ga.savedGameModel != null && ((SavedGameModel)ga.savedGameModel).playerSeatLocks != null && (gaLock = ga.getSeatLock(pn)) != (modelLock = ((SavedGameModel)ga.savedGameModel).playerSeatLocks[pn]) && modelLock != null) {
                ga.setSeatLock(pn, modelLock);
                this.srv.messageToGame(gaName, true, new SOCSetSeatLock(gaName, pn, modelLock));
            }
        } else if (isArrivingRobot) {
            this.srv.messageToPlayer(c, gaName, -257, new SOCRobotDismiss(gaName));
        } else if (gameAlreadyStarted) {
            this.srv.messageToPlayerKeyed(c, gaName, -257, "member.sit.game.started");
        } else if (gameIsFull) {
            this.srv.messageToPlayerKeyed(c, gaName, -257, "member.sit.game.full");
        } else if (!sentBotDismiss) {
            this.srv.messageToPlayer(c, gaName, -256, "This seat is claimed by another game member, choose another.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleSTARTGAME(Connection c, SOCStartGame mes, int botsOnly_maxBots) {
        block29: {
            String gn = mes.getGame();
            SOCGame ga = this.gameList.getGameData(gn);
            if (ga == null) {
                return;
            }
            ga.takeMonitor();
            try {
                GameHandler hand;
                if (ga.getGameState() != 0) break block29;
                boolean allowStart = true;
                boolean seatsFull = true;
                boolean anyLocked = false;
                int numEmpty = 0;
                int numPlayers = 0;
                for (int i = 0; i < ga.maxPlayers; ++i) {
                    if (ga.isSeatVacant(i)) {
                        if (ga.getSeatLock(i) == SOCGame.SeatLockState.UNLOCKED) {
                            seatsFull = false;
                            ++numEmpty;
                            continue;
                        }
                        anyLocked = true;
                        continue;
                    }
                    ++numPlayers;
                }
                int numAvail = ga.getAvailableSeatCount();
                if (numAvail < numEmpty && (numEmpty = numAvail) == 0) {
                    seatsFull = true;
                }
                if (numPlayers == 0) {
                    if (0 == this.srv.getConfigIntProperty("jsettlers.bots.botgames.total", 0)) {
                        allowStart = false;
                        this.srv.messageToGameKeyed(ga, true, true, "start.player.must.sit");
                    } else if (botsOnly_maxBots != 0 && botsOnly_maxBots < numEmpty) {
                        numEmpty = botsOnly_maxBots;
                    }
                }
                if (seatsFull && numPlayers < 2) {
                    allowStart = false;
                    numEmpty = 3;
                    this.srv.messageToGameKeyed(ga, true, true, "start.only.cannot.lock.all");
                } else if (allowStart && !seatsFull) {
                    int numBots = this.srv.getRobotCount();
                    if (numBots == 0) {
                        if (numPlayers < 2) {
                            this.srv.messageToGameKeyed(ga, true, true, "start.no.robots.on.server", 2);
                        } else {
                            seatsFull = true;
                        }
                    } else if (numEmpty > numBots) {
                        String m = anyLocked ? "start.not.enough.robots" : "start.not.enough.robots.lock";
                        this.srv.messageToGameKeyed(ga, true, true, m, numBots);
                    } else {
                        ga.setGameState(1);
                        boolean invitedBots = false;
                        IllegalStateException e = null;
                        try {
                            invitedBots = this.srv.readyGameAskRobotsJoin(ga, null, null, numEmpty);
                        }
                        catch (IllegalStateException ex) {
                            e = ex;
                        }
                        if (!invitedBots) {
                            System.err.println("Robot-join problem in game " + gn + ": " + (e != null ? e : " no matching bots available"));
                            ga.setGameState(0);
                            allowStart = false;
                            this.gameList.takeMonitorForGame(gn);
                            if (e != null) {
                                this.srv.messageToGameKeyed(ga, true, false, "start.robots.cannot.join.problem", e.getMessage());
                            } else {
                                this.srv.messageToGameKeyed(ga, true, false, "start.robots.cannot.join.options");
                            }
                            this.srv.messageToGameKeyed(ga, true, false, "start.to.start.without.robots");
                            this.gameList.releaseMonitorForGame(gn);
                        }
                    }
                }
                if (seatsFull && allowStart && (hand = this.gameList.getGameTypeHandler(gn)) != null) {
                    hand.startGame(ga);
                }
            }
            catch (Throwable e) {
                D.ebugPrintStackTrace(e, "Exception caught");
            }
            finally {
                ga.releaseMonitor();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRESETBOARDREQUEST(Connection c, SOCResetBoardRequest mes) {
        String gaName = mes.getGame();
        SOCGame ga = this.gameList.getGameData(gaName);
        if (ga == null) {
            return;
        }
        SOCPlayer reqPlayer = ga.getPlayer(c.getData());
        if (reqPlayer == null) {
            return;
        }
        if (ga.getResetVoteActive() || reqPlayer.hasAskedBoardReset()) {
            return;
        }
        Connection[] humanConns = new Connection[ga.maxPlayers];
        Connection[] robotConns = new Connection[ga.maxPlayers];
        int numHuman = SOCGameBoardReset.sortPlayerConnections(ga, null, this.gameList.getMembers(gaName), humanConns, robotConns);
        int reqPN = reqPlayer.getPlayerNumber();
        if (numHuman < 2) {
            boolean hadRobot = false;
            boolean hadUnlockedRobot = false;
            for (int i = robotConns.length - 1; i >= 0; --i) {
                if (robotConns[i] == null) continue;
                hadRobot = true;
                if (ga.getSeatLock(i) != SOCGame.SeatLockState.UNLOCKED) continue;
                hadUnlockedRobot = true;
                break;
            }
            if (hadUnlockedRobot) {
                this.srv.resetBoardAndNotify(gaName, reqPN);
            } else if (hadRobot) {
                this.srv.messageToPlayerKeyed(c, gaName, reqPN, "resetboard.request.unlock.bot");
            } else {
                this.srv.messageToGameKeyed(ga, true, true, "resetboard.request.everyone.left");
            }
        } else {
            this.gameList.takeMonitorForGame(gaName);
            int votingPlayers = 0;
            try {
                for (int i = ga.maxPlayers - 1; i >= 0; --i) {
                    Connection pc;
                    if (i == reqPN || ga.isSeatVacant(i) || (pc = this.srv.getConnection(ga.getPlayer(i).getName())) == null || !pc.isConnected() || pc.getVersion() < 1100) continue;
                    ++votingPlayers;
                }
            }
            finally {
                this.gameList.releaseMonitorForGame(gaName);
            }
            if (votingPlayers == 0) {
                this.srv.messageToGameKeyed(ga, true, false, "resetboard.vote.request.alloldcli", c.getData());
                this.srv.resetBoardAndNotify(gaName, reqPN);
            } else {
                this.srv.messageToGameKeyed(ga, true, false, "resetboard.vote.request", c.getData());
                SOCResetBoardVoteRequest vr = new SOCResetBoardVoteRequest(gaName, reqPN);
                ga.resetVoteBegin(reqPN);
                for (int i = 0; i < ga.maxPlayers; ++i) {
                    if (humanConns[i] == null) continue;
                    if (humanConns[i].getVersion() >= 1100) {
                        this.srv.messageToPlayer(humanConns[i], gaName, i, vr);
                        continue;
                    }
                    ga.resetVoteRegister(ga.getPlayer(humanConns[i].getData()).getPlayerNumber(), true);
                }
            }
        }
    }

    private void handleRESETBOARDVOTE(Connection c, SOCResetBoardVote mes) {
        String gaName = mes.getGame();
        SOCGame ga = this.gameList.getGameData(gaName);
        if (ga == null) {
            return;
        }
        String plName = c.getData();
        SOCPlayer reqPlayer = ga.getPlayer(plName);
        if (reqPlayer == null) {
            return;
        }
        this.srv.resetBoardVoteNotifyOne(ga, reqPlayer.getPlayerNumber(), plName, mes.getPlayerVote());
    }
}

