/*
 * Decompiled with CFR 0.152.
 */
package soc.server;

import java.util.ConcurrentModificationException;
import java.util.Vector;
import soc.disableDebug.D;
import soc.message.SOCServerPing;
import soc.server.SOCServer;
import soc.server.genericServer.Connection;

class SOCServerRobotPinger
extends Thread {
    private Vector<Connection> robotConnections;
    private final int sleepTime = 150000;
    private final SOCServerPing ping;
    private volatile boolean alive;
    private final SOCServer srv;

    public SOCServerRobotPinger(SOCServer s, Vector<Connection> robots) {
        this.setDaemon(true);
        this.srv = s;
        this.robotConnections = robots;
        this.ping = new SOCServerPing(150000);
        this.alive = true;
        this.setName("robotPinger-srv");
    }

    @Override
    public void run() {
        while (this.alive) {
            boolean retry = false;
            if (!this.robotConnections.isEmpty()) {
                try {
                    for (Connection robotConnection : this.robotConnections) {
                        if (D.ebugIsEnabled()) {
                            D.ebugPrintlnINFO("(*)(*)(*)(*) PINGING " + robotConnection.getData());
                        }
                        robotConnection.put(this.ping);
                    }
                }
                catch (ConcurrentModificationException e) {
                    retry = true;
                }
            }
            Thread.yield();
            int msec = retry ? 250 : 90000;
            try {
                SOCServerRobotPinger.sleep(msec);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.robotConnections = null;
    }

    public void stopPinger() {
        this.alive = false;
    }
}

