/*
 * Decompiled with CFR 0.152.
 */
package soc.server;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.file.Files;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import soc.server.SOCServerMessageHandler;

class StatsFileWriterTask {
    public static final int INITIAL_RUN_DELAY_MINUTES = 60;
    private static final SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd HH:mm z");
    private final SOCServerMessageHandler ssmh;
    private final Timer timer;
    private final File statsFile;
    private final String statsFilename;

    public StatsFileWriterTask(SOCServerMessageHandler ssmh, File statsFile, String filename, Timer timer) {
        this.ssmh = ssmh;
        this.statsFile = statsFile;
        this.statsFilename = filename;
        this.timer = timer;
        this.checkIfWritable();
        timer.schedule((TimerTask)new FirstRun(), 3600000L);
    }

    public boolean checkIfWritable() {
        boolean allOK;
        block12: {
            allOK = false;
            try {
                File statsDir = this.statsFile.getParentFile();
                String statsDirName = statsDir.getPath();
                if (!statsDir.exists()) {
                    System.err.println("Warning: Directory not found for stats.file: " + this.statsFilename);
                    break block12;
                }
                if (!statsDir.isDirectory()) {
                    System.err.println("Warning: stats.file parent exists but isn't a directory: " + statsDirName);
                    break block12;
                }
                if (this.statsFile.exists()) {
                    if (this.statsFile.isDirectory()) {
                        System.err.println("Warning: stats.file exists but is a directory: " + this.statsFilename);
                        return false;
                    }
                    if (this.statsFile.canWrite()) {
                        allOK = true;
                    } else {
                        System.err.println("Warning: stats.file exists but is read-only: " + this.statsFilename);
                    }
                }
                boolean canWriteDir = false;
                try {
                    canWriteDir = Files.isWritable(statsDir.toPath());
                    if (!canWriteDir) {
                        System.err.println("Warning: Directory for stats.file is read-only: " + statsDirName);
                    }
                }
                catch (SecurityException e) {
                    System.err.println("Warning: Can't access stats.file's directory " + statsDirName + ": " + e);
                }
                if (!allOK) {
                    allOK = canWriteDir;
                }
            }
            catch (IllegalArgumentException | SecurityException e) {
                System.err.println("Warning: Can't access stats.file " + this.statsFilename + ": " + e);
            }
        }
        return allOK;
    }

    private Calendar runReportIfWritable() {
        Calendar localCal = Calendar.getInstance();
        if (this.checkIfWritable()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Server stats at ");
            sb.append(SDF.format(localCal.getTime()));
            sb.append("\n\n");
            Iterator<String> it = this.ssmh.getSettingsFormatted(null).iterator();
            while (it.hasNext()) {
                sb.append(it.next() + ": " + it.next() + "\n");
            }
            sb.append("\n\n");
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(this.statsFile, true), "UTF-8");){
                writer.append(sb);
                writer.flush();
                System.err.println("\nStats file: Updated " + this.statsFile.getPath() + "\n");
            }
            catch (IOException | SecurityException e) {
                System.err.println("\n* Can't write to stats.file " + this.statsFilename + ": " + e + "\n");
            }
        }
        return localCal;
    }

    private class DailyRun
    extends TimerTask {
        private DailyRun() {
        }

        @Override
        public void run() {
            StatsFileWriterTask.this.runReportIfWritable();
        }
    }

    private class FirstRun
    extends TimerTask {
        private FirstRun() {
        }

        @Override
        public void run() {
            Calendar localCal = StatsFileWriterTask.this.runReportIfWritable();
            long nowUTC = localCal.getTimeInMillis();
            localCal.add(5, 1);
            localCal.set(11, 0);
            localCal.set(12, 1);
            localCal.set(13, 30);
            StatsFileWriterTask.this.timer.scheduleAtFixedRate((TimerTask)new DailyRun(), localCal.getTimeInMillis() - nowUTC, 86400000L);
        }
    }
}

