/*
 * Decompiled with CFR 0.152.
 */
package soc.server.database;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.SecureRandom;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import soc.debug.D;
import soc.game.SOCGame;
import soc.game.SOCGameOption;
import soc.game.SOCGameOptionSet;
import soc.game.SOCPlayer;
import soc.server.SOCServer;
import soc.server.database.BCrypt;
import soc.server.database.DBSettingMismatchException;
import soc.util.IntPair;
import soc.util.SOCRobotParameters;

public class SOCDBHelper {
    public static final String PROP_JSETTLERS_DB_USER = "jsettlers.db.user";
    public static final String PROP_JSETTLERS_DB_PASS = "jsettlers.db.pass";
    public static final String PROP_JSETTLERS_DB_JAR = "jsettlers.db.jar";
    public static final String PROP_JSETTLERS_DB_DRIVER = "jsettlers.db.driver";
    public static final String PROP_JSETTLERS_DB_URL = "jsettlers.db.url";
    public static final String PROP_JSETTLERS_DB_SETTINGS = "jsettlers.db.settings";
    public static final String PROP_JSETTLERS_DB_BCRYPT_WORK__FACTOR = "jsettlers.db.bcrypt.work_factor";
    public static final String PROP_JSETTLERS_DB_SCRIPT_SETUP = "jsettlers.db.script.setup";
    public static final String PROP_JSETTLERS_DB_UPGRADE__SCHEMA = "jsettlers.db.upgrade_schema";
    public static final String PROP_JSETTLERS_DB_SAVE_GAMES = "jsettlers.db.save.games";
    public static final String PROP_IMPL_JSETTLERS_PW_RESET = "_jsettlers.user.pw_reset";
    public static final String PROP_SQLITE_TMPDIR = "org.sqlite.tmpdir";
    public static final int SCHEMA_VERSION_ORIGINAL = 1000;
    public static final int SCHEMA_VERSION_1200 = 1200;
    public static final int SCHEMA_VERSION_2000 = 2000;
    public static final int SCHEMA_VERSION_LATEST = 2000;
    public static final int PW_SCHEME_NONE = 0;
    public static final int PW_SCHEME_BCRYPT = 1;
    public static final int BCRYPT_MIN_WORK_FACTOR = 9;
    public static final int BCRYPT_DEFAULT_WORK_FACTOR = 12;
    public static final int PW_MAX_LEN_SCHEME_NONE = 20;
    public static final int PW_MAX_LEN_SCHEME_BCRYPT = 50;
    public static final String SETTING_BCRYPT_WORK__FACTOR = "BCRYPT.WORK_FACTOR";
    private static final char DBTYPE_MARIADB = 'A';
    private static final char DBTYPE_MYSQL = 'M';
    private static final char DBTYPE_ORA = 'O';
    private static final char DBTYPE_POSTGRESQL = 'P';
    private static final char DBTYPE_SQLITE = 'S';
    private static final char DBTYPE_UNKNOWN = '?';
    private static String INT_AUTO_PK;
    private static String TIMESTAMP_NULL;
    private static String TIMESTAMP;
    private static final int UPG_BATCH_MAX = 100;
    private char dbType;
    private String driverclass = null;
    private Driver driverinstance = null;
    private Connection connection = null;
    private String dbURL = null;
    private boolean errorCondition = false;
    private boolean initialized = false;
    private int schemaVersion;
    private int bcryptWorkFactor = 12;
    private volatile int schemaUpgBGTasks_fromVersion;
    private volatile UpgradeBGTasksThread schemaUpgBGTasksThread;
    private static final ExecutorService bcryptQueueThreader;
    private String dbcUserName;
    private String dbcPassword;
    private Properties props;
    private static final String CREATE_ACCOUNT_COMMAND_1000 = "INSERT INTO users(nickname,host,password,email,lastlogin) VALUES (?,?,?,?,?);";
    private static final String CREATE_ACCOUNT_COMMAND_1200 = "INSERT INTO users(nickname,host,password,email,lastlogin,nickname_lc,pw_scheme,pw_store) VALUES (?,?,'!',?,?,?,?,?);";
    private static final String CREATE_ACCOUNT_COMMAND_2000 = "INSERT INTO users(nickname,host,password,email,lastlogin,nickname_lc,pw_scheme,pw_store,games_won,games_lost) VALUES (?,?,'!',?,?,?,?,?,0,0);";
    private static final String RECORD_LOGIN_COMMAND = "INSERT INTO logins VALUES (?,?,?);";
    private static final String USER_PASSWORD_QUERY_1000 = "SELECT nickname,password FROM users WHERE nickname = ? ;";
    private static final String USER_PASSWORD_QUERY_1200 = "SELECT nickname,password,pw_scheme,pw_store FROM users WHERE nickname_lc = ? ;";
    private static final String HOST_QUERY = "SELECT nickname FROM users WHERE ( users.host = ? );";
    private static final String LASTLOGIN_UPDATE = "UPDATE users SET lastlogin = ?  WHERE nickname = ? ;";
    private static final String PASSWORD_UPDATE_COMMAND_1000 = "UPDATE users SET password = ? WHERE nickname = ? ;";
    private static final String PASSWORD_UPDATE_COMMAND_1200 = "UPDATE users SET password = '!', pw_scheme = ?, pw_store = ? WHERE nickname_lc = ? ;";
    private static final String SAVE_GAME_COMMAND_1000 = "INSERT INTO games(gamename,player1,player2,player3,player4,score1,score2,score3,score4,starttime) VALUES (?,?,?,?,?,?,?,?,?,?);";
    private static final String SAVE_GAME_COMMAND_1200 = "INSERT INTO games(gamename,player1,player2,player3,player4,player5,player6,score1,score2,score3,score4,score5,score6,starttime,duration_sec,winner,gameopts) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?);";
    private static final String SAVE_GAME_COMMAND_2000 = "INSERT INTO games2(gamename,starttime,duration_sec,winner,gameopts,scenario) VALUES (?,?,?,?,?,?);";
    private static final String[] SAVE_GAME_COMMAND_2000_GEN_KEY;
    private static final String SAVE_GAME_PLAYER_COMMAND = "INSERT INTO games2_players(gameid,player,score) VALUES (?,?,?);";
    private static final String ROBOT_PARAMS_QUERY = "SELECT * FROM robotparams WHERE robotname = ?;";
    private static final String USER_COUNT_QUERY = "SELECT count(*) FROM users;";
    private static final String USER_EXISTS_QUERY_1000 = "SELECT nickname FROM users WHERE nickname = ?;";
    private static final String USER_EXISTS_QUERY_1200 = "SELECT nickname FROM users WHERE nickname_lc = ?;";
    private static final String USER_INCREMENT_WON_COMMAND = "UPDATE users SET games_won = 1 + coalesce(games_won, 0) WHERE nickname = ?;";
    private static final String USER_INCREMENT_LOST_COMMAND = "UPDATE users SET games_lost = 1 + coalesce(games_lost, 0) WHERE nickname = ?;";
    private PreparedStatement createAccountCommand = null;
    private PreparedStatement recordLoginCommand = null;
    private PreparedStatement userExistsQuery = null;
    private PreparedStatement userIncrWonCommand = null;
    private PreparedStatement userIncrLostCommand = null;
    private PreparedStatement userPasswordQuery = null;
    private PreparedStatement hostQuery = null;
    private PreparedStatement lastloginUpdate = null;
    private PreparedStatement passwordUpdateCommand = null;
    private PreparedStatement saveGameCommand = null;
    private PreparedStatement saveGamePlayerCommand = null;
    private PreparedStatement robotParamsQuery = null;
    private PreparedStatement userCountQuery = null;

    public void initialize(String user, String pswd, Properties dbProps) throws IllegalArgumentException, DBSettingMismatchException, SQLException, IOException {
        SQLException sx;
        this.initialized = false;
        this.driverclass = "com.mysql.jdbc.Driver";
        this.dbType = (char)77;
        this.dbURL = "jdbc:mysql://localhost/socdata";
        this.props = dbProps;
        if (user == null) {
            return;
        }
        if (dbProps != null) {
            String pval;
            String prop_dbURL = dbProps.getProperty(PROP_JSETTLERS_DB_URL);
            String prop_driverclass = dbProps.getProperty(PROP_JSETTLERS_DB_DRIVER);
            if (prop_dbURL != null) {
                this.dbURL = prop_dbURL;
                if (prop_driverclass != null) {
                    this.driverclass = prop_driverclass;
                    if (this.driverclass.contains("postgresql")) {
                        this.dbType = (char)80;
                    } else if (this.driverclass.contains("sqlite")) {
                        this.dbType = (char)83;
                    } else if (this.driverclass.contains("mariadb")) {
                        this.dbType = (char)65;
                    } else if (!this.driverclass.contains("mysql")) {
                        this.dbType = (char)63;
                    }
                } else if (prop_dbURL.startsWith("jdbc:postgresql")) {
                    this.driverclass = "org.postgresql.Driver";
                    this.dbType = (char)80;
                } else if (prop_dbURL.startsWith("jdbc:sqlite:")) {
                    this.driverclass = "org.sqlite.JDBC";
                    this.dbType = (char)83;
                } else if (prop_dbURL.startsWith("jdbc:mariadb")) {
                    this.driverclass = "org.mariadb.jdbc.Driver";
                    this.dbType = (char)65;
                } else if (!prop_dbURL.startsWith("jdbc:mysql")) {
                    throw new IllegalArgumentException("JDBC: URL property is set, but driver property is not (jsettlers.db.url, jsettlers.db.driver)");
                }
            } else {
                if (prop_driverclass != null) {
                    this.driverclass = prop_driverclass;
                }
                if (this.driverclass.contains("postgresql")) {
                    this.dbURL = "jdbc:postgresql://localhost/socdata";
                    this.dbType = (char)80;
                } else if (this.driverclass.contains("sqlite")) {
                    this.dbURL = "jdbc:sqlite:socdata.sqlite";
                    this.dbType = (char)83;
                } else if (this.driverclass.contains("mariadb")) {
                    this.dbURL = "jdbc:mariadb://localhost/socdata";
                    this.dbType = (char)65;
                } else if (!this.driverclass.contains("mysql")) {
                    throw new IllegalArgumentException("JDBC: Driver property is set, but URL property is not (jsettlers.db.driver, jsettlers.db.url)");
                }
            }
            String prop_bcryptWF = dbProps.getProperty(PROP_JSETTLERS_DB_BCRYPT_WORK__FACTOR);
            if (prop_bcryptWF != null) {
                String errMsg = null;
                try {
                    int wf = Integer.parseInt(prop_bcryptWF);
                    if (wf >= 9 && wf <= 30) {
                        this.bcryptWorkFactor = wf;
                    } else {
                        errMsg = "Out of range (9-30)";
                    }
                }
                catch (NumberFormatException e) {
                    errMsg = "Bad format, integer is required";
                }
                if (errMsg != null) {
                    throw new IllegalArgumentException("DB: BCrypt work factor param: " + errMsg + " (" + PROP_JSETTLERS_DB_BCRYPT_WORK__FACTOR + ")");
                }
            }
            if ((pval = dbProps.getProperty(PROP_JSETTLERS_DB_SETTINGS)) != null && !pval.equals("write")) {
                throw new IllegalArgumentException("DB: Utility property jsettlers.db.settings's value must be \"write\"");
            }
        }
        if (this.dbType == '?' && this.driverclass.toLowerCase().contains("oracle")) {
            this.dbType = (char)79;
        }
        switch (this.dbType) {
            case 'A': 
            case 'M': {
                INT_AUTO_PK = "INT NOT NULL AUTO_INCREMENT PRIMARY KEY";
                TIMESTAMP = "TIMESTAMP";
                TIMESTAMP_NULL = "TIMESTAMP NULL DEFAULT null";
                break;
            }
            case 'P': {
                INT_AUTO_PK = "SERIAL PRIMARY KEY";
                TIMESTAMP = "TIMESTAMP WITHOUT TIME ZONE";
                TIMESTAMP_NULL = "TIMESTAMP WITHOUT TIME ZONE";
                break;
            }
            case 'S': {
                INT_AUTO_PK = "INTEGER PRIMARY KEY";
                TIMESTAMP = "TIMESTAMP";
                TIMESTAMP_NULL = "TIMESTAMP";
                break;
            }
            default: {
                INT_AUTO_PK = "INTEGER GENERATED BY DEFAULT AS IDENTITY PRIMARY KEY";
                TIMESTAMP = "TIMESTAMP";
                TIMESTAMP_NULL = "TIMESTAMP";
            }
        }
        this.driverinstance = null;
        boolean driverNewInstanceFailed = false;
        try {
            String prop_dbSetupScript;
            try {
                String prop_jarname;
                String string = prop_jarname = dbProps != null ? dbProps.getProperty(PROP_JSETTLERS_DB_JAR) : null;
                if (prop_jarname != null && prop_jarname.length() == 0) {
                    prop_jarname = null;
                }
                if (prop_jarname != null) {
                    File jf = new File(prop_jarname);
                    if (!jf.exists()) {
                        System.err.println("Could not find " + prop_jarname + " for JDBC driver class " + this.driverclass);
                        throw new FileNotFoundException(prop_jarname);
                    }
                    URL[] urls = new URL[]{jf.toURI().toURL()};
                    URLClassLoader child = new URLClassLoader(urls, ClassLoader.getSystemClassLoader());
                    Class<?> dclass = Class.forName(this.driverclass, true, child);
                    this.driverinstance = (Driver)dclass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                } else {
                    this.driverinstance = (Driver)Class.forName(this.driverclass).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
            }
            catch (Throwable x) {
                driverNewInstanceFailed = true;
                sx = new SQLException("JDBC driver is unavailable: " + this.driverclass + ": " + x);
                sx.initCause(x);
                throw sx;
            }
            String string = prop_dbSetupScript = dbProps != null ? dbProps.getProperty(PROP_JSETTLERS_DB_SCRIPT_SETUP) : null;
            if (prop_dbSetupScript != null && prop_dbSetupScript.length() == 0) {
                prop_dbSetupScript = null;
            }
            this.connect(user, pswd, prop_dbSetupScript);
            this.checkSettings(false, prop_dbSetupScript != null);
        }
        catch (DBSettingMismatchException dx) {
            throw dx;
        }
        catch (IOException iox) {
            throw iox;
        }
        catch (Throwable x) {
            if (driverNewInstanceFailed && x instanceof SQLException) {
                throw (SQLException)x;
            }
            sx = new SQLException("Unable to initialize user database");
            sx.initCause(x);
            throw sx;
        }
        this.initialized = true;
    }

    public boolean isInitialized() {
        return this.initialized && this.connection != null;
    }

    public int getSchemaVersion() {
        return this.schemaVersion;
    }

    public boolean isSchemaLatestVersion() throws IllegalStateException {
        if (!this.isInitialized()) {
            throw new IllegalStateException();
        }
        return this.schemaVersion == 2000;
    }

    public boolean doesSchemaUpgradeNeedBGTasks() throws IllegalStateException {
        if (!this.isInitialized()) {
            throw new IllegalStateException();
        }
        return 0 != this.schemaUpgBGTasks_fromVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startSchemaUpgradeBGTasks() {
        if (!this.isInitialized()) {
            return false;
        }
        Connection connection = this.connection;
        synchronized (connection) {
            UpgradeBGTasksThread t = this.schemaUpgBGTasksThread;
            if (t != null && t.isAlive()) {
                return false;
            }
            this.schemaUpgBGTasksThread = t = new UpgradeBGTasksThread();
            t.start();
            return true;
        }
    }

    private boolean checkConnection() throws SQLException {
        if (this.connection != null) {
            try {
                return !this.errorCondition || this.connect(this.dbcUserName, this.dbcPassword, null);
            }
            catch (IOException ioe) {
                return false;
            }
        }
        return false;
    }

    private boolean connect(String user, String pswd, String setupScriptPath) throws SQLException, IllegalStateException, IOException {
        if (this.driverinstance == null) {
            this.connection = DriverManager.getConnection(this.dbURL, user, pswd);
        } else {
            Properties dbProps = new Properties();
            dbProps.put("user", user);
            dbProps.put("password", pswd);
            this.connection = this.driverinstance.connect(this.dbURL, dbProps);
        }
        this.errorCondition = false;
        this.dbcUserName = user;
        this.dbcPassword = pswd;
        if (setupScriptPath != null) {
            this.runSetupScript(setupScriptPath);
        }
        this.detectSchemaVersion();
        this.prepareStatements();
        return true;
    }

    private void detectSchemaVersion() throws SQLException, IllegalStateException {
        this.schemaVersion = -1;
        if (this.doesTableExist("db_version")) {
            ResultSet rs = this.connection.createStatement().executeQuery("SELECT max(to_vers) FROM db_version;");
            if (rs.next()) {
                this.schemaVersion = rs.getInt(1);
                if (rs.wasNull()) {
                    this.schemaVersion = -1;
                }
            }
            rs.close();
        }
        if (this.schemaVersion > 0) {
            int from_vers = 0;
            boolean upg_ddl_unfinished = false;
            boolean upg_bg_unfinished = false;
            ResultSet rs = this.connection.createStatement().executeQuery("SELECT from_vers, ddl_done, bg_tasks_done FROM db_version WHERE to_vers=" + this.schemaVersion + ";");
            if (rs.next()) {
                from_vers = rs.getInt(1);
                rs.getTimestamp(2);
                if (rs.wasNull()) {
                    upg_ddl_unfinished = true;
                } else {
                    rs.getTimestamp(3);
                    if (rs.wasNull()) {
                        upg_bg_unfinished = true;
                    }
                }
            }
            rs.close();
            if (upg_ddl_unfinished) {
                throw new IllegalStateException("Incomplete DB schema upgrade from version " + from_vers + " to " + this.schemaVersion + ": db_version.ddl_done field is null");
            }
            if (upg_bg_unfinished) {
                this.schemaUpgBGTasks_fromVersion = from_vers;
                System.err.println("* Warning: DB schema upgrade BG tasks are incomplete per db_version table");
            }
        } else {
            this.schemaVersion = this.doesTableColumnExist("users", "nickname_lc") ? 1200 : 1000;
            if (this.schemaVersion > 1000) {
                System.err.println("* Warning: DB schema version appears to be " + this.schemaVersion + ", but missing from db_version table");
            }
        }
    }

    private void prepareStatements() throws SQLFeatureNotSupportedException, SQLException {
        this.createAccountCommand = this.connection.prepareStatement(this.schemaVersion >= 2000 ? CREATE_ACCOUNT_COMMAND_2000 : (this.schemaVersion == 1200 ? CREATE_ACCOUNT_COMMAND_1200 : CREATE_ACCOUNT_COMMAND_1000));
        this.recordLoginCommand = this.connection.prepareStatement(RECORD_LOGIN_COMMAND);
        this.userExistsQuery = this.connection.prepareStatement(this.schemaVersion >= 1200 ? USER_EXISTS_QUERY_1200 : USER_EXISTS_QUERY_1000);
        if (this.schemaVersion >= 2000) {
            this.userIncrWonCommand = this.connection.prepareStatement(USER_INCREMENT_WON_COMMAND);
            this.userIncrLostCommand = this.connection.prepareStatement(USER_INCREMENT_LOST_COMMAND);
        }
        this.userPasswordQuery = this.connection.prepareStatement(this.schemaVersion >= 1200 ? USER_PASSWORD_QUERY_1200 : USER_PASSWORD_QUERY_1000);
        this.hostQuery = this.connection.prepareStatement(HOST_QUERY);
        this.lastloginUpdate = this.connection.prepareStatement(LASTLOGIN_UPDATE);
        this.passwordUpdateCommand = this.connection.prepareStatement(this.schemaVersion >= 1200 ? PASSWORD_UPDATE_COMMAND_1200 : PASSWORD_UPDATE_COMMAND_1000);
        if (this.schemaVersion < 2000) {
            this.saveGameCommand = this.connection.prepareStatement(this.schemaVersion == 1200 ? SAVE_GAME_COMMAND_1200 : SAVE_GAME_COMMAND_1000);
        } else {
            this.saveGameCommand = this.connection.prepareStatement(SAVE_GAME_COMMAND_2000, SAVE_GAME_COMMAND_2000_GEN_KEY);
            this.saveGamePlayerCommand = this.connection.prepareStatement(SAVE_GAME_PLAYER_COMMAND);
        }
        this.robotParamsQuery = this.connection.prepareStatement(ROBOT_PARAMS_QUERY);
        this.userCountQuery = this.connection.prepareStatement(USER_COUNT_QUERY);
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void checkSettings(boolean checkAll, boolean writeIfNeeded) throws SQLException, DBSettingMismatchException {
        int L;
        boolean anyMissing;
        ArrayList<String> mm;
        boolean withWrite;
        block12: {
            block13: {
                block14: {
                    boolean bl = withWrite = writeIfNeeded || !checkAll && this.props != null && this.props.containsKey(PROP_JSETTLERS_DB_SETTINGS);
                    if (writeIfNeeded) {
                        checkAll = true;
                    }
                    mm = new ArrayList<String>();
                    anyMissing = false;
                    if (this.schemaVersion < 1200) break block12;
                    int bc = this.getIntSetting(SETTING_BCRYPT_WORK__FACTOR, 0);
                    if (bc == 0) break block13;
                    if (bc < 9 || bc > 30) break block14;
                    if (checkAll || this.props != null && this.props.containsKey(PROP_JSETTLERS_DB_BCRYPT_WORK__FACTOR)) {
                        if (bc != this.bcryptWorkFactor) {
                            if (withWrite) {
                                this.updateSetting(SETTING_BCRYPT_WORK__FACTOR, this.bcryptWorkFactor, false);
                            }
                            mm.add(SETTING_BCRYPT_WORK__FACTOR);
                            mm.add(Integer.toString(bc));
                            mm.add(Integer.toString(this.bcryptWorkFactor));
                        }
                        break block12;
                    } else {
                        this.bcryptWorkFactor = bc;
                    }
                    break block12;
                }
                System.err.println("* Warning: Ignoring DB setting for BCRYPT.WORK_FACTOR: Out of range");
                break block12;
            }
            if (withWrite) {
                this.updateSetting(SETTING_BCRYPT_WORK__FACTOR, this.bcryptWorkFactor, true);
                mm.add(SETTING_BCRYPT_WORK__FACTOR);
                mm.add("-");
                mm.add(Integer.toString(this.bcryptWorkFactor));
            } else {
                anyMissing = true;
                System.err.println("* Warning: Missing DB setting for BCRYPT.WORK_FACTOR, using " + this.bcryptWorkFactor);
            }
        }
        if (!mm.isEmpty()) {
            System.err.println(writeIfNeeded ? "\n* These DB settings were added or updated:\nSettings key\t\tDB\tCurrent value" : (checkAll ? "\n* These DB settings have changed from their current values set during startup:\nSettings key\t\tDB\tCurrent value" : "\n* These DB settings differ from values specified in properties:\nSettings key\t\tDB\tProperty"));
            L = mm.size();
        } else {
            if (withWrite && !writeIfNeeded) {
                System.err.println("Warning: Found no settings table updates from properties values.");
                return;
            }
            if (!anyMissing) return;
            System.err.println("To save to the settings table, run once with utility property -Djsettlers.db.settings=write");
            return;
        }
        for (int i = 0; i < L; ++i) {
            System.err.print((String)mm.get(i));
            System.err.print(i % 3 == 2 ? (char)'\n' : '\t');
        }
        System.err.println();
        if (withWrite) {
            System.err.println("Saving to settings table from properties values.\n");
            return;
        }
        System.err.println(checkAll ? "The next startup will use the changed DB values instead of current values." : "To save to the settings table, run once with utility property -Djsettlers.db.settings=write");
        throw new DBSettingMismatchException((String)mm.get(0));
    }

    public String getUser(String userName) throws IllegalArgumentException, SQLException {
        if (userName == null) {
            throw new IllegalArgumentException();
        }
        if (!this.checkConnection()) {
            return null;
        }
        if (this.schemaVersion >= 1200) {
            userName = userName.toLowerCase(Locale.US);
        }
        this.userExistsQuery.setString(1, userName);
        ResultSet rs = this.userExistsQuery.executeQuery();
        userName = rs.next() ? rs.getString(1) : null;
        rs.close();
        return userName;
    }

    public String authenticateUserPassword(String sUserName, String sPassword, final AuthPasswordRunnable authCallback) throws SQLException {
        String ret;
        boolean ok;
        int L = sPassword.length();
        if (L > 256) {
            return null;
        }
        String dbUserName = sUserName;
        String dbPassword = null;
        int pwScheme = 0;
        boolean dbUserFound = false;
        boolean ranBCryptTask = false;
        if (this.checkConnection()) {
            try {
                dbUserName = this.schemaVersion < 1200 ? sUserName : sUserName.toLowerCase(Locale.US);
                this.userPasswordQuery.setString(1, dbUserName);
                ResultSet resultSet = this.userPasswordQuery.executeQuery();
                if (resultSet.next()) {
                    dbUserFound = true;
                    dbUserName = resultSet.getString(1);
                    dbPassword = resultSet.getString(2);
                    if (this.schemaVersion >= 1200 && (pwScheme = resultSet.getInt(3)) != 0) {
                        dbPassword = resultSet.getString(4);
                    }
                } else {
                    dbUserName = sUserName;
                }
                resultSet.close();
            }
            catch (SQLException sqlE) {
                this.errorCondition = true;
                sqlE.printStackTrace();
                throw sqlE;
            }
        }
        if (dbUserFound && dbPassword != null) {
            ok = false;
            try {
                switch (pwScheme) {
                    case 0: {
                        if (L > 20) {
                            sPassword = sPassword.substring(0, 20);
                        }
                        ok = dbPassword.equals(sPassword);
                        break;
                    }
                    case 1: {
                        try {
                            if (L <= 50 && sPassword.getBytes("utf-8").length <= 50) {
                                if (authCallback == null) {
                                    ok = BCrypt.checkpw(sPassword, dbPassword);
                                    break;
                                }
                                ranBCryptTask = true;
                                final String sPass = sPassword;
                                final String dbUser = dbUserName;
                                final String dbPass = dbPassword;
                                bcryptQueueThreader.execute(new Runnable(){

                                    @Override
                                    public void run() {
                                        try {
                                            boolean pwOK = BCrypt.checkpw(sPass, dbPass);
                                            authCallback.authResult(pwOK ? dbUser : null, true);
                                        }
                                        catch (RuntimeException runtimeException) {
                                            // empty catch block
                                        }
                                    }
                                });
                            }
                        }
                        catch (UnsupportedEncodingException sPass) {}
                        break;
                    }
                }
            }
            catch (RuntimeException sPass) {}
        } else {
            ok = "".equals(sPassword);
        }
        String string = ret = ok ? dbUserName : null;
        if (authCallback != null && !ranBCryptTask) {
            authCallback.authResult(ret, false);
        }
        return ret;
    }

    public String getUserFromHost(String host) throws SQLException {
        String nickname = null;
        if (this.checkConnection()) {
            try {
                this.hostQuery.setString(1, host);
                ResultSet resultSet = this.hostQuery.executeQuery();
                if (resultSet.next()) {
                    nickname = resultSet.getString(1);
                }
                resultSet.close();
            }
            catch (SQLException sqlE) {
                this.errorCondition = true;
                sqlE.printStackTrace();
                throw sqlE;
            }
        }
        return nickname;
    }

    public boolean createAccount(String userName, String host, String password, String email, long time) throws IllegalArgumentException, SQLException {
        if (!this.isPasswordLengthOK(password)) {
            throw new IllegalArgumentException("password");
        }
        if (this.checkConnection()) {
            try {
                Date sqlDate = new Date(time);
                Calendar cal = Calendar.getInstance();
                this.createAccountCommand.setString(1, userName);
                this.createAccountCommand.setString(2, host);
                if (this.schemaVersion < 1200) {
                    this.createAccountCommand.setString(3, password);
                    this.createAccountCommand.setString(4, email);
                    this.createAccountCommand.setDate(5, sqlDate, cal);
                } else {
                    this.createAccountCommand.setString(3, email);
                    this.createAccountCommand.setDate(4, sqlDate, cal);
                    this.createAccountCommand.setString(5, userName.toLowerCase(Locale.US));
                    this.createAccountCommand.setInt(6, 1);
                    try {
                        String pw_store = BCrypt.hashpw(password, BCrypt.gensalt(this.bcryptWorkFactor));
                        this.createAccountCommand.setString(7, pw_store);
                    }
                    catch (RuntimeException e) {
                        SQLException sqlE = new SQLException("BCrypt exception");
                        sqlE.initCause(e);
                        throw sqlE;
                    }
                }
                this.createAccountCommand.executeUpdate();
                return true;
            }
            catch (SQLException sqlE) {
                this.errorCondition = true;
                sqlE.printStackTrace();
                throw sqlE;
            }
        }
        return false;
    }

    public boolean recordLogin(String userName, String host, long time) throws SQLException {
        if (this.checkConnection()) {
            try {
                Date sqlDate = new Date(time);
                Calendar cal = Calendar.getInstance();
                this.recordLoginCommand.setString(1, userName);
                this.recordLoginCommand.setString(2, host);
                this.recordLoginCommand.setDate(3, sqlDate, cal);
                this.recordLoginCommand.executeUpdate();
                return true;
            }
            catch (SQLException sqlE) {
                this.errorCondition = true;
                sqlE.printStackTrace();
                throw sqlE;
            }
        }
        return false;
    }

    public boolean updateLastlogin(String userName, long time) throws SQLException {
        if (this.checkConnection()) {
            try {
                Date sqlDate = new Date(time);
                Calendar cal = Calendar.getInstance();
                this.lastloginUpdate.setDate(1, sqlDate, cal);
                this.lastloginUpdate.setString(2, userName);
                this.lastloginUpdate.executeUpdate();
                return true;
            }
            catch (SQLException sqlE) {
                this.errorCondition = true;
                sqlE.printStackTrace();
                throw sqlE;
            }
        }
        return false;
    }

    public boolean updateUserPassword(String userName, String newPassword) throws IllegalArgumentException, SQLException {
        if (userName == null) {
            throw new IllegalArgumentException("userName");
        }
        if (!this.isPasswordLengthOK(newPassword)) {
            throw new IllegalArgumentException("newPassword");
        }
        if (!this.checkConnection()) {
            return false;
        }
        if (this.schemaVersion >= 1200) {
            userName = userName.toLowerCase(Locale.US);
        }
        try {
            if (this.schemaVersion < 1200) {
                this.passwordUpdateCommand.setString(1, newPassword);
                this.passwordUpdateCommand.setString(2, userName);
            } else {
                this.passwordUpdateCommand.setInt(1, 1);
                try {
                    String pw_store = BCrypt.hashpw(newPassword, BCrypt.gensalt(this.bcryptWorkFactor));
                    this.passwordUpdateCommand.setString(2, pw_store);
                }
                catch (RuntimeException e) {
                    SQLException sqlE = new SQLException("BCrypt exception");
                    sqlE.initCause(e);
                    throw sqlE;
                }
                this.passwordUpdateCommand.setString(3, userName);
            }
            this.passwordUpdateCommand.executeUpdate();
            return true;
        }
        catch (SQLException sqlE) {
            this.errorCondition = true;
            sqlE.printStackTrace();
            throw sqlE;
        }
    }

    public final int getMaxPasswordLength() {
        return this.schemaVersion >= 1200 ? 50 : 20;
    }

    public final boolean isPasswordLengthOK(String password) {
        if (password == null) {
            return false;
        }
        int L = password.length();
        if (L == 0) {
            return false;
        }
        if (this.schemaVersion < 1200) {
            return L <= 20;
        }
        try {
            if (L <= 50 && password.getBytes("utf-8").length <= 50) {
                return true;
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return false;
    }

    public boolean saveGameScores(SOCGame ga, int gameLengthSeconds, boolean winLossOnly) throws IllegalArgumentException, SQLException {
        block26: {
            SOCPlayer winner = ga.getPlayerWithWin();
            if (winner == null) {
                throw new IllegalArgumentException("no winner");
            }
            if (winLossOnly && this.userIncrWonCommand == null || !this.checkConnection()) {
                return false;
            }
            String[] names = new String[6];
            short[] scores = new short[6];
            for (int pn = 0; pn < ga.maxPlayers; ++pn) {
                SOCPlayer pl = ga.getPlayer(pn);
                names[pn] = pl.getName();
                scores[pn] = (short)pl.getTotalVP();
            }
            try {
                int newGameID = -1;
                if (!winLossOnly) {
                    String optsStr;
                    int db_max_players;
                    int n = db_max_players = this.schemaVersion < 1200 ? 4 : 6;
                    if (!(ga.maxPlayers <= db_max_players || ga.isSeatVacant(4) && ga.isSeatVacant(5))) {
                        SOCDBHelper.saveGameScores_fit6pInto4(ga, names, scores);
                    }
                    String gaName = ga.getName();
                    long startTimeMillis = ga.getStartTime().getTime();
                    SOCGameOptionSet opts = ga.getGameOptions();
                    String string = optsStr = opts == null ? null : SOCGameOption.packOptionsToString(opts.getAll(), false, true);
                    if (this.schemaVersion >= 2000) {
                        SOCGameOption scOpt = opts.get("SC");
                        String scen = scOpt != null ? scOpt.getStringValue() : null;
                        newGameID = this.insertGames2Row(gaName, winner.getName(), startTimeMillis, gameLengthSeconds, optsStr, scen);
                    } else {
                        int pn;
                        this.saveGameCommand.setString(1, gaName);
                        int i = 2;
                        for (pn = 0; pn < db_max_players; ++pn) {
                            this.saveGameCommand.setString(i, names[pn]);
                            ++i;
                        }
                        for (pn = 0; pn < db_max_players; ++pn) {
                            if (scores[pn] != 0 || names[pn] != null) {
                                this.saveGameCommand.setShort(i, scores[pn]);
                            } else {
                                this.saveGameCommand.setNull(i, 5);
                            }
                            ++i;
                        }
                        this.saveGameCommand.setTimestamp(i, new Timestamp(startTimeMillis));
                        ++i;
                        if (this.schemaVersion >= 1200) {
                            this.saveGameCommand.setInt(i, gameLengthSeconds);
                            this.saveGameCommand.setString(++i, winner.getName());
                            this.saveGameCommand.setString(++i, optsStr);
                            ++i;
                        }
                        newGameID = 0;
                        this.saveGameCommand.executeUpdate();
                    }
                }
                if (this.userIncrWonCommand == null) break block26;
                String winnerName = winner.getName();
                if (winnerName == null || winnerName.isEmpty()) {
                    winnerName = "?";
                }
                boolean wasConnAutocommit = this.enterTransactionMode();
                try {
                    if (!winLossOnly) {
                        boolean hadAnyPlayers = false;
                        this.saveGamePlayerCommand.clearBatch();
                        for (int pn = 0; pn < ga.maxPlayers; ++pn) {
                            if (ga.isSeatVacant(pn)) continue;
                            String plName = names[pn];
                            short plScore = scores[pn];
                            if (plScore == 0 || plName == null || plName.isEmpty()) continue;
                            hadAnyPlayers = true;
                            this.saveGamePlayerCommand.setInt(1, newGameID);
                            this.saveGamePlayerCommand.setString(2, plName);
                            this.saveGamePlayerCommand.setInt(3, plScore);
                            this.saveGamePlayerCommand.addBatch();
                        }
                        if (hadAnyPlayers) {
                            this.saveGamePlayerCommand.executeBatch();
                        }
                    }
                    if (winnerName != null && winnerName.length() > 0) {
                        this.userIncrWonCommand.setString(1, winnerName);
                        this.userIncrWonCommand.executeUpdate();
                    }
                    int nLost = 0;
                    int winnerPN = winner.getPlayerNumber();
                    for (int pn = 0; pn < ga.maxPlayers; ++pn) {
                        String pname;
                        if (pn == winnerPN || ga.isSeatVacant(pn) || (pname = names[pn]) == null || pname.isEmpty()) continue;
                        this.userIncrLostCommand.setString(1, pname);
                        this.userIncrLostCommand.addBatch();
                        ++nLost;
                    }
                    if (nLost > 0) {
                        this.userIncrLostCommand.executeBatch();
                    }
                    this.connection.commit();
                }
                catch (SQLException e) {
                    this.connection.rollback();
                    throw e;
                }
                finally {
                    this.exitTransactionMode(wasConnAutocommit);
                }
            }
            catch (SQLException sqlE) {
                this.errorCondition = true;
                sqlE.printStackTrace();
                throw sqlE;
            }
        }
        return true;
    }

    private static void saveGameScores_fit6pInto4(SOCGame ga, String[] names, short[] scores) {
        int pnH;
        SOCPlayer pl = ga.getPlayerWithWin();
        int winnerPN = pl != null ? pl.getPlayerNumber() : -1;
        int nVacantLow = 0;
        int nBotLow = 0;
        boolean[] isBot = new boolean[4];
        boolean[] isVacant = new boolean[4];
        for (int pn = 0; pn < 4; ++pn) {
            if (ga.isSeatVacant(pn)) {
                isVacant[pn] = true;
                ++nVacantLow;
                continue;
            }
            if (!ga.getPlayer(pn).isRobot()) continue;
            isBot[pn] = true;
            if (pn == winnerPN) continue;
            ++nBotLow;
        }
        int[] pnHigh = new int[]{-1, -1};
        if (!ga.isSeatVacant(4)) {
            pnHigh[0] = 4;
        }
        if (!ga.isSeatVacant(5)) {
            if (pnHigh[0] == -1) {
                pnHigh[0] = 5;
            } else if (!ga.getPlayer(5).isRobot() && (winnerPN == 5 || ga.getPlayer(4).isRobot() && winnerPN != 4)) {
                pnHigh[0] = 5;
                pnHigh[1] = 4;
            } else {
                pnHigh[1] = 5;
            }
        }
        if (winnerPN >= 4 && !ga.getPlayer(winnerPN).isRobot() && nVacantLow == 0 && nBotLow == 0) {
            int pnLow = 0;
            short scoreLow = scores[0];
            for (int pn = 1; pn < 4; ++pn) {
                if (scores[pn] >= scoreLow) continue;
                pnLow = pn;
                scoreLow = scores[pn];
            }
            names[pnLow] = names[winnerPN];
            scores[pnLow] = scores[winnerPN];
            return;
        }
        block2: for (int i = 0; i < 2 && (pnH = pnHigh[i]) != -1; ++i) {
            if (nVacantLow > 0) {
                for (int pn = 0; pn < 4; ++pn) {
                    if (!isVacant[pn]) continue;
                    names[pn] = names[pnH];
                    scores[pn] = scores[pnH];
                    isBot[pn] = ga.getPlayer(pnH).isRobot();
                    isVacant[pn] = false;
                    if (winnerPN == pnH) {
                        winnerPN = pn;
                    }
                    --nVacantLow;
                    continue block2;
                }
                continue;
            }
            if (nBotLow <= 0) continue;
            int pnLowBot = -1;
            short s = Integer.MAX_VALUE;
            for (int pn = 0; pn < 4; ++pn) {
                if (pn == winnerPN || !isBot[pn] || pnLowBot != -1 && scores[pn] >= s) continue;
                pnLowBot = pn;
                s = scores[pn];
            }
            boolean pnHIsRobot = ga.getPlayer(pnH).isRobot();
            if (pnLowBot == -1 || pnHIsRobot && winnerPN != pnH && scores[pnH] <= scores[pnLowBot]) continue;
            names[pnLowBot] = names[pnH];
            scores[pnLowBot] = scores[pnH];
            isBot[pnLowBot] = pnHIsRobot;
            if (winnerPN == pnH) {
                winnerPN = pnLowBot;
            }
            --nBotLow;
        }
    }

    public final SOCRobotParameters retrieveRobotParams(String robotName) throws SQLException {
        SOCRobotParameters robotParams = null;
        if (this.checkConnection()) {
            if (this.robotParamsQuery == null) {
                return null;
            }
            try {
                this.robotParamsQuery.setString(1, robotName);
                ResultSet resultSet = this.robotParamsQuery.executeQuery();
                if (resultSet.next()) {
                    int mgl = resultSet.getInt(2);
                    int me = resultSet.getInt(3);
                    float ebf = resultSet.getFloat(4);
                    float af = resultSet.getFloat(5);
                    float laf = resultSet.getFloat(6);
                    float dcm = resultSet.getFloat(7);
                    float tm = resultSet.getFloat(8);
                    int st = resultSet.getInt(9);
                    int tf = resultSet.getInt(14);
                    robotParams = new SOCRobotParameters(mgl, me, ebf, af, laf, dcm, tm, st, tf);
                }
                resultSet.close();
            }
            catch (SQLException sqlE) {
                this.errorCondition = true;
                sqlE.printStackTrace();
                throw sqlE;
            }
        }
        return robotParams;
    }

    public int countUsers() throws SQLException {
        if (!this.checkConnection()) {
            return -1;
        }
        if (this.userCountQuery == null) {
            return -1;
        }
        try {
            ResultSet resultSet = this.userCountQuery.executeQuery();
            int count = -1;
            if (resultSet.next()) {
                count = resultSet.getInt(1);
            }
            resultSet.close();
            return count;
        }
        catch (SQLException sqlE) {
            this.errorCondition = true;
            sqlE.printStackTrace();
            throw sqlE;
        }
    }

    public List<String> getSettingsFormatted(SOCServer srv) {
        if (!this.isInitialized()) {
            throw new IllegalStateException();
        }
        ArrayList<String> li = new ArrayList<String>();
        li.add("Schema version");
        li.add(Integer.toString(this.schemaVersion) + (this.schemaVersion == 2000 ? " (is latest version)" : " (upgrade recommended)"));
        li.add("Password encoding scheme");
        if (this.schemaVersion < 1200) {
            li.add("None (plain text)");
        } else {
            li.add("BCrypt");
            String dbStat = "";
            try {
                int dbWF = this.getIntSetting(SETTING_BCRYPT_WORK__FACTOR, 0);
                if (dbWF == 0) {
                    dbStat = " (Missing from DB settings table)";
                } else if (dbWF != this.bcryptWorkFactor) {
                    dbStat = " (Mismatch: DB settings table has " + dbWF + ")";
                }
            }
            catch (SQLException e) {
                dbStat = " (Error retrieving from DB: " + e.getMessage() + ")";
            }
            li.add("BCrypt work factor");
            li.add(this.bcryptWorkFactor + dbStat);
        }
        try {
            DatabaseMetaData meta = this.connection.getMetaData();
            li.add("DB server version");
            li.add(meta.getDatabaseProductVersion());
            li.add("JDBC driver");
            li.add(this.driverclass + " v" + this.driverinstance.getMajorVersion() + '.' + this.driverinstance.getMinorVersion() + " (jdbc v" + meta.getJDBCMajorVersion() + '.' + meta.getJDBCMinorVersion() + ")");
            li.add("Driver supports insert getGeneratedKeys?");
            li.add(Boolean.toString(meta.supportsGetGeneratedKeys()));
        }
        catch (SQLException e) {
            li.add("Error retrieving DB version info");
            li.add(e.getMessage());
        }
        li.add("Game results saved in DB?");
        li.add(Boolean.toString(srv.getConfigBoolProperty(PROP_JSETTLERS_DB_SAVE_GAMES, false)));
        return li;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<String>> queryUsersDuplicateLCase(Set<String> out_allNames) throws IllegalStateException, SQLException {
        try {
            if (!this.checkConnection()) {
                throw new IllegalStateException();
            }
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
        HashMap<String, String> namesFromLC = new HashMap<String, String>();
        HashMap<String, List<String>> dupeMap = new HashMap<String, List<String>>();
        Statement s = this.connection.createStatement();
        ResultSet rs = null;
        try {
            rs = s.executeQuery("SELECT nickname FROM users");
            while (rs.next()) {
                String nm = rs.getString(1);
                String nmLC = nm.toLowerCase(Locale.US);
                if (namesFromLC.containsKey(nmLC)) {
                    ArrayList<String> li = (ArrayList<String>)dupeMap.get(nmLC);
                    if (li == null) {
                        li = new ArrayList<String>();
                        li.add((String)namesFromLC.get(nmLC));
                        dupeMap.put(nmLC, li);
                    }
                    li.add(nm);
                } else {
                    namesFromLC.put(nmLC, nm);
                }
                if (out_allNames == null) continue;
                out_allNames.add(nm);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException sQLException) {}
            try {
                s.close();
            }
            catch (SQLException sQLException) {}
        }
        namesFromLC.clear();
        return dupeMap.isEmpty() ? null : dupeMap;
    }

    public int testBCryptSpeed() {
        System.err.println((this.props != null && this.props.containsKey(PROP_JSETTLERS_DB_UPGRADE__SCHEMA) ? "" : "* Utility Mode: ") + "Testing BCrypt speeds for work factors:");
        int max = 15;
        float[] wfSpeedMSec = new float[max + 1];
        float[][] wfSpeedsRef = new float[][]{wfSpeedMSec};
        int recc_wf = this.testBCryptSpeed_range(wfSpeedsRef, max, 9);
        while (recc_wf == -2) {
            if (max >= 30) {
                System.err.println("\n\n*** Maximum BCrypt work factor is still too fast");
                break;
            }
            int mNew = max + 3;
            if (mNew > 30) {
                mNew = 30;
            }
            recc_wf = this.testBCryptSpeed_range(wfSpeedsRef, max + 1, mNew);
            wfSpeedMSec = wfSpeedsRef[0];
            max = wfSpeedMSec.length - 1;
        }
        System.err.println();
        System.err.println("WF:  BCrypt time (ms) per password:");
        for (int wf = 9; wf <= max; ++wf) {
            if (wf < 10) {
                System.err.print(' ');
            }
            System.err.print(wf);
            System.err.print("   ");
            if (wf == recc_wf) {
                System.err.println(wfSpeedMSec[wf] + "  <--- Recommended Work Factor ---");
                continue;
            }
            if (wfSpeedMSec[wf] > 0.0f) {
                System.err.println(wfSpeedMSec[wf]);
                continue;
            }
            System.err.println("> 1200.0");
        }
        System.err.println();
        return recc_wf;
    }

    private int testBCryptSpeed_range(float[][] wfSpeedsRef, int wfFrom, int wfTo) {
        int max;
        int inc;
        if (wfFrom > 30) {
            wfFrom = 30;
        }
        if (wfTo > 30) {
            wfTo = 30;
        }
        float[] wfSpeedMSec = wfSpeedsRef[0];
        if (wfFrom < wfTo) {
            inc = 1;
            max = wfTo;
        } else {
            inc = -1;
            max = wfFrom;
        }
        if (wfSpeedMSec.length <= max) {
            float[] wfs = new float[max + 1];
            System.arraycopy(wfSpeedMSec, 0, wfs, 0, wfSpeedMSec.length);
            wfSpeedMSec = wfs;
            wfSpeedsRef[0] = wfs;
        }
        int TOO_SLOW_MSEC = 1200;
        SecureRandom sr = new SecureRandom();
        boolean all_too_fast = true;
        int fastest_wf = -1;
        float fastest_msec = 9999.0f;
        int wf = wfFrom;
        while (true) {
            System.err.print(wf);
            System.err.print(' ');
            System.err.flush();
            String salt = BCrypt.gensalt(wf, sr);
            long start_ms = System.currentTimeMillis();
            boolean tooSlow = false;
            for (int i = 0; i < 7; ++i) {
                BCrypt.hashpw("testDBHelper", salt);
                if (i != 1 || (System.currentTimeMillis() - start_ms) / 2L <= 1200L) continue;
                tooSlow = true;
                break;
            }
            long end_ms = System.currentTimeMillis();
            if (tooSlow) {
                wfSpeedMSec[wf] = -1.0f;
                all_too_fast = false;
            } else {
                float speed;
                wfSpeedMSec[wf] = speed = (float)(end_ms - start_ms) / 7.0f;
                if (speed >= 270.0f) {
                    all_too_fast = false;
                    if (speed <= 620.0f && (fastest_wf == -1 || speed < fastest_msec)) {
                        fastest_wf = wf;
                        fastest_msec = speed;
                    }
                }
            }
            if (wf == wfTo) break;
            wf += inc;
        }
        return all_too_fast ? -2 : fastest_wf;
    }

    public ResultSet selectWithLimit(String selectStmt, int limit) throws SQLException {
        StringBuilder sql = new StringBuilder(selectStmt);
        int L = sql.length();
        if (sql.charAt(L - 1) == ';') {
            sql.setLength(L - 1);
        }
        switch (this.dbType) {
            case 'A': 
            case 'M': 
            case 'P': 
            case 'S': {
                sql.append(" LIMIT ");
                sql.append(limit);
                break;
            }
            case 'O': {
                sql.insert(0, "SELECT * FROM (");
                sql.append(") t WHERE ROWNUM <= ");
                sql.append(limit);
                break;
            }
        }
        sql.append(';');
        return this.connection.createStatement().executeQuery(sql.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int insertGames2Row(String gaName, String winnerName, long startTimeMillis, int gameLengthSeconds, String optsStr, String scen) throws IllegalStateException, UnsupportedOperationException, SQLException {
        try {
            if (!this.checkConnection()) {
                throw new IllegalStateException();
            }
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
        if (this.schemaVersion < 2000) {
            throw new UnsupportedOperationException();
        }
        int i = 1;
        this.saveGameCommand.setString(1, gaName);
        this.saveGameCommand.setTimestamp(++i, new Timestamp(startTimeMillis));
        this.saveGameCommand.setInt(++i, gameLengthSeconds);
        this.saveGameCommand.setString(++i, winnerName);
        this.saveGameCommand.setString(++i, optsStr);
        this.saveGameCommand.setString(++i, scen);
        ++i;
        this.saveGameCommand.executeUpdate();
        int id = 0;
        ResultSet rs = null;
        try {
            rs = this.saveGameCommand.getGeneratedKeys();
            if (rs.next()) {
                id = rs.getInt(1);
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return id;
    }

    public boolean doesTableExist(String tabname) throws IllegalStateException {
        boolean found;
        block8: {
            try {
                if (!this.checkConnection()) {
                    throw new IllegalStateException();
                }
            }
            catch (SQLException e) {
                throw new IllegalStateException(e);
            }
            ResultSet rs = null;
            found = false;
            try {
                rs = this.connection.getMetaData().getTables(null, null, tabname, null);
                while (rs.next()) {
                    String na = rs.getString("TABLE_NAME");
                    if (na == null || !na.equalsIgnoreCase(tabname)) continue;
                    found = true;
                    break;
                }
                rs.close();
            }
            catch (Exception e) {
                if (rs == null) break block8;
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }
        return found;
    }

    public boolean doesTableColumnExist(String tabname, String colname) throws IllegalStateException {
        try {
            if (!this.checkConnection()) {
                throw new IllegalStateException();
            }
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
        ResultSet rs = null;
        try {
            boolean checkResultNum;
            PreparedStatement ps;
            if (this.dbType != 'O') {
                ps = this.connection.prepareStatement("select " + colname + " from " + tabname + " LIMIT 1;");
                checkResultNum = false;
            } else {
                ps = this.connection.prepareStatement("select count(*) FROM user_tab_columns WHERE table_name='" + tabname + "' AND column_name='" + colname + "';");
                checkResultNum = true;
            }
            rs = ps.executeQuery();
            if (checkResultNum) {
                if (!rs.next()) {
                    rs.close();
                    return false;
                }
                int count = rs.getInt(1);
                if (count == 0) {
                    rs.close();
                    return false;
                }
            }
            rs.close();
        }
        catch (Throwable th) {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            return false;
        }
        return true;
    }

    private boolean enterTransactionMode() throws SQLException {
        boolean wasConnAutocommit = this.connection.getAutoCommit();
        if (wasConnAutocommit) {
            this.connection.setAutoCommit(false);
        } else {
            try {
                this.connection.commit();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return wasConnAutocommit;
    }

    private void exitTransactionMode(boolean wasConnAutocommit) throws SQLException {
        if (wasConnAutocommit) {
            this.connection.setAutoCommit(true);
        }
    }

    private void runSetupScript(String setupScriptPath) throws FileNotFoundException, IOException, SQLException {
        if (!this.checkConnection()) {
            return;
        }
        FileReader fr = new FileReader(setupScriptPath);
        BufferedReader br = new BufferedReader(fr);
        ArrayList<String> sqls = new ArrayList<String>();
        try {
            StringBuilder sb = new StringBuilder();
            String nextLine22 = br.readLine();
            while (nextLine22 != null) {
                if (!(nextLine22.length() == 0 || nextLine22.trim().length() == 0 || nextLine22.startsWith("--") || this.dbType == 'S' && nextLine22.toLowerCase().startsWith("use "))) {
                    if (Character.isWhitespace(nextLine22.codePointAt(0))) {
                        if (sb.length() > 0) {
                            sb.append("\n");
                        }
                    } else {
                        sqls.add(sb.toString());
                        sb.delete(0, sb.length());
                    }
                    sb.append(nextLine22);
                }
                nextLine22 = br.readLine();
            }
            sqls.add(sb.toString());
            try {
                br.close();
            }
            catch (IOException nextLine22) {
                // empty catch block
            }
            try {
                fr.close();
            }
            catch (IOException nextLine22) {}
        }
        catch (IOException e) {
            try {
                br.close();
            }
            catch (IOException nextLine22) {
                // empty catch block
            }
            try {
                fr.close();
            }
            catch (IOException nextLine22) {
                // empty catch block
            }
            throw e;
        }
        for (String sql : sqls) {
            if (sql.trim().length() == 0) continue;
            Statement cmd = this.connection.createStatement();
            cmd.executeUpdate(sql);
            cmd.close();
        }
    }

    public void upgradeSchema(Set<String> userAdmins) throws IllegalStateException, SQLException, MissingResourceException {
        if (this.isSchemaLatestVersion()) {
            throw new IllegalStateException("already at latest schema");
        }
        if (this.dbType == 'P') {
            String otherOwner = this.upg_postgres_checkIsTableOwner();
            if (otherOwner != null) {
                throw new MissingResourceException("Must change table owner to " + this.dbcUserName + " from " + otherOwner, "unused", "unused");
            }
        } else if (this.dbType == 'O') {
            throw new MissingResourceException("Upgrade on oracle to schema 2.0.00 not yet implemented", "unused", "unused");
        }
        HashSet<String> upg_1200_allUsers = new HashSet<String>();
        if (this.schemaVersion < 1200) {
            Map<String, List<String>> dupes = this.queryUsersDuplicateLCase(upg_1200_allUsers);
            if (dupes != null) {
                StringBuilder sb = new StringBuilder("These groups of users' nicknames collide with each other when lowercase:\n");
                for (String k : dupes.keySet()) {
                    sb.append(dupes.get(k));
                    sb.append('\n');
                }
                sb.append("\nTo upgrade, the nicknames must be changed to be unique when lowercase.\nContact each user and determine new nicknames, then for each user run this SQL:\n  BEGIN;\n  UPDATE users SET nickname='newnick' WHERE nickname='oldnick';\n  UPDATE logins SET nickname='newnick' WHERE nickname='oldnick';\n  UPDATE games SET player1='newnick' WHERE player1='oldnick';\n  UPDATE games SET player2='newnick' WHERE player2='oldnick';\n  UPDATE games SET player3='newnick' WHERE player3='oldnick';\n  UPDATE games SET player4='newnick' WHERE player4='oldnick';\n  COMMIT;\nThen, retry the DB schema upgrade.\n");
                throw new MissingResourceException(sb.toString(), "unused", "unused");
            }
            if (this.props != null && !this.props.containsKey(PROP_JSETTLERS_DB_BCRYPT_WORK__FACTOR)) {
                int wf = this.testBCryptSpeed();
                if (wf < 9) {
                    throw new MissingResourceException("Must re-run with jsettlers.db.bcrypt.work_factor property", "unused", "unused");
                }
                this.bcryptWorkFactor = wf;
            }
        }
        int from_vers = this.schemaVersion;
        if (this.schemaVersion < 1200) {
            String sql = "CREATE TABLE db_version (from_vers INT not null, to_vers INT not null, ddl_done " + TIMESTAMP_NULL + ", bg_tasks_done " + TIMESTAMP_NULL + ", PRIMARY KEY (to_vers) );";
            this.runDDL(sql);
        }
        try {
            PreparedStatement ps = this.connection.prepareStatement("INSERT into db_version(from_vers, to_vers, ddl_done, bg_tasks_done) VALUES(?,?,null,null);");
            ps.setInt(1, from_vers);
            ps.setInt(2, 2000);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            if (this.schemaVersion < 1200) {
                try {
                    this.runDDL("DROP TABLE db_version;");
                }
                catch (SQLException se) {
                    if (se.getCause() == null) {
                        se.initCause(e);
                    }
                    throw se;
                }
            }
            throw e;
        }
        if (this.schemaVersion < 1200) {
            boolean added_tab_settings = false;
            boolean added_game_fields = false;
            boolean added_user_fields = false;
            try {
                this.runDDL("CREATE TABLE settings ( s_name varchar(32) not null, s_value varchar(500), i_value int, s_changed " + TIMESTAMP + " not null, PRIMARY KEY (s_name) );");
                added_tab_settings = true;
                this.runDDL("ALTER TABLE games ADD COLUMN player5 VARCHAR(20);");
                added_game_fields = true;
                this.runDDL("ALTER TABLE games ADD COLUMN player6 VARCHAR(20);");
                this.runDDL("ALTER TABLE games ADD COLUMN score5 SMALLINT;");
                this.runDDL("ALTER TABLE games ADD COLUMN score6 SMALLINT;");
                this.runDDL("ALTER TABLE games ADD COLUMN duration_sec INT;");
                this.runDDL("ALTER TABLE games ADD COLUMN winner VARCHAR(20);");
                this.runDDL("ALTER TABLE games ADD COLUMN gameopts VARCHAR(500);");
                this.runDDL("ALTER TABLE users ADD COLUMN nickname_lc VARCHAR(20);");
                added_user_fields = true;
                this.runDDL("ALTER TABLE users ADD COLUMN pw_scheme INT;");
                this.runDDL("ALTER TABLE users ADD COLUMN pw_store VARCHAR(255);");
                this.runDDL("ALTER TABLE users ADD COLUMN pw_change " + TIMESTAMP_NULL + ";");
                if (!upg_1200_allUsers.isEmpty()) {
                    PreparedStatement ps = this.connection.prepareStatement("UPDATE users SET nickname_lc=? WHERE nickname=?");
                    boolean wasConnAutocommit = this.enterTransactionMode();
                    try {
                        int n = 0;
                        for (String nm : upg_1200_allUsers) {
                            ps.setString(1, nm.toLowerCase(Locale.US));
                            ps.setString(2, nm);
                            ps.addBatch();
                            if (++n < 100) continue;
                            ps.executeBatch();
                            ps.clearBatch();
                            n = 0;
                        }
                        ps.executeBatch();
                        this.connection.commit();
                    }
                    catch (SQLException e) {
                        this.connection.rollback();
                        throw e;
                    }
                    finally {
                        this.exitTransactionMode(wasConnAutocommit);
                    }
                }
                this.runDDL("CREATE UNIQUE INDEX users__l ON users(nickname_lc);");
                try {
                    this.updateSetting(SETTING_BCRYPT_WORK__FACTOR, this.bcryptWorkFactor, true);
                }
                catch (SQLException e) {
                    System.err.println("* Could not set BCRYPT.WORK_FACTOR in settings table: " + e);
                }
                if (userAdmins != null) {
                    this.upgradeSchema_1200_encodeUserPasswords(userAdmins, null, "Encoding passwords for user account admins...", "* Warning: No user account admins found to encode", "User admin password encoding completed");
                }
            }
            catch (SQLException e) {
                String[] cols;
                System.err.println("*** Problem occurred during schema upgrade to v1200:\n" + e + "\n\n* Will attempt to roll back to schema v1000.");
                boolean couldRollback = true;
                if (added_tab_settings && !this.runDDL_rollback("DROP TABLE settings;")) {
                    couldRollback = false;
                }
                if (couldRollback && added_user_fields) {
                    cols = new String[]{"pw_scheme", "pw_store", "pw_change"};
                    if (this.dbType == 'S' || !this.runDDL_rollback("ALTER TABLE users DROP nickname_lc;") || !this.runDDL_dropCols("users", cols)) {
                        couldRollback = false;
                    }
                }
                if (couldRollback && added_game_fields) {
                    cols = new String[]{"player6", "score5", "score6", "duration_sec", "winner", "gameopts"};
                    if (this.dbType == 'S' || !this.runDDL_rollback("ALTER TABLE games DROP player5;") || !this.runDDL_dropCols("games", cols)) {
                        couldRollback = false;
                    }
                }
                this.upgradeSchema_setDBVersionTable(false, from_vers, 0, false);
                if (!couldRollback) {
                    System.err.println("*** Could not completely roll back failed upgrade: Must restore DB from backup!");
                } else {
                    System.err.println("\n* All rollbacks were successful.\n");
                }
                throw e;
            }
        }
        if (this.schemaVersion < 2000) {
            boolean added_tab_games2 = false;
            boolean added_tab_games2_pl = false;
            boolean added_tab_upg_tmp = false;
            boolean added_user_fields = false;
            try {
                String sql = "CREATE TABLE games2 (gameid " + INT_AUTO_PK + ", gamename VARCHAR(20) not null,starttime " + TIMESTAMP + " not null,duration_sec INT,winner VARCHAR(20) not null,gameopts VARCHAR(500), scenario VARCHAR(16) ); ";
                this.runDDL(sql);
                added_tab_games2 = true;
                this.runDDL("CREATE INDEX games2__s ON games2(starttime);");
                sql = "CREATE TABLE games2_players (gameid INT not null, player VARCHAR(20) not null, score SMALLINT not null,PRIMARY KEY(gameid, player) ); ";
                this.runDDL(sql);
                added_tab_games2_pl = true;
                sql = "CREATE TABLE upg_tmp_games (gameid " + INT_AUTO_PK + ", gamename VARCHAR(20) not null,player1 VARCHAR(20), player2 VARCHAR(20), player3 VARCHAR(20), player4 VARCHAR(20), player5 VARCHAR(20), player6 VARCHAR(20),score1 SMALLINT, score2 SMALLINT, score3 SMALLINT, score4 SMALLINT, score5 SMALLINT, score6 SMALLINT,starttime " + TIMESTAMP + " not null, duration_sec INT, winner VARCHAR(20) not null, gameopts VARCHAR(500), mig_done SMALLINT );";
                this.runDDL(sql);
                added_tab_upg_tmp = true;
                this.runDDL("CREATE INDEX upg_tmp_games__m ON upg_tmp_games(mig_done);");
                boolean wasConnAutocommit = this.enterTransactionMode();
                Statement st = null;
                try {
                    st = this.connection.createStatement();
                    st.executeUpdate("INSERT INTO upg_tmp_games(gamename,player1,player2,player3,player4,player5,player6,score1,score2,score3,score4,score5,score6,starttime,duration_sec,winner,gameopts) SELECT gamename,player1,player2,player3,player4,player5,player6,score1,score2,score3,score4,score5,score6,starttime,duration_sec,coalesce(winner,'?'),gameopts FROM games ORDER BY starttime;");
                    this.connection.commit();
                    st.close();
                    st = null;
                    st = this.connection.createStatement();
                    st.executeUpdate("INSERT INTO games2(gameid,gamename,starttime,duration_sec,winner,gameopts) SELECT gameid,gamename,starttime,duration_sec,winner,gameopts FROM upg_tmp_games ORDER BY gameid;");
                    this.connection.commit();
                    st.close();
                    st = null;
                    if (this.dbType == 'P') {
                        String seqname = this.dbtypePostgresGetSerialSequence("games2", "gameid");
                        if (seqname != null) {
                            PreparedStatement ps = this.connection.prepareStatement("SELECT setval(?, (SELECT coalesce(max(gameid),1) FROM games2), true);");
                            ps.setString(1, seqname);
                            ps.executeQuery();
                            ps.close();
                        } else {
                            System.err.println("* DB upgrade warning: Can't find sequence for primary key field games2.gameid\n  The upgrade will continue, but you can't save new games to the database until you correct the warning:\n  - Connect to the DB with psql\n  - Run the command \\ds and note the sequence name for games2\n  - Run this command, replacing name_of_seq with the name from \\ds:\n  - SELECT setval('name_of_seq', (SELECT coalesce(max(gameid),1) FROM games2), true);\n");
                        }
                    }
                }
                catch (SQLException e) {
                    this.connection.rollback();
                    throw e;
                }
                finally {
                    try {
                        if (st != null) {
                            st.close();
                        }
                    }
                    catch (SQLException sQLException) {}
                    this.exitTransactionMode(wasConnAutocommit);
                }
                this.runDDL("ALTER TABLE users ADD COLUMN games_won INT;");
                added_user_fields = true;
                this.runDDL("ALTER TABLE users ADD COLUMN games_lost INT;");
            }
            catch (SQLException e) {
                System.err.println("*** Problem occurred during schema upgrade to v2000:\n" + e + "\n\n* Will attempt to roll back to schema v1200.\n");
                boolean couldRollback = true;
                if (couldRollback && added_user_fields) {
                    String[] cols = new String[]{"games_won", "games_lost"};
                    if (this.dbType == 'S' || !this.runDDL_dropCols("users", cols)) {
                        couldRollback = false;
                    }
                }
                if (couldRollback && added_tab_upg_tmp && !this.runDDL_rollback("DROP TABLE upg_tmp_games;")) {
                    couldRollback = false;
                }
                if (couldRollback && added_tab_games2_pl && !this.runDDL_rollback("DROP TABLE games2_players;")) {
                    couldRollback = false;
                }
                if (couldRollback && added_tab_games2 && !this.runDDL_rollback("DROP TABLE games2;")) {
                    couldRollback = false;
                }
                if (!couldRollback) {
                    System.err.println("*** Could not completely roll back failed upgrade: Must restore DB from backup!");
                } else {
                    System.err.println("\n* All rollbacks were successful.\n");
                }
                if (from_vers < 1200) {
                    this.upgradeSchema_setDBVersionTable(false, from_vers, 1200, true);
                } else {
                    this.upgradeSchema_setDBVersionTable(false, from_vers, 0, false);
                }
                throw e;
            }
        }
        boolean has_bg_tasks = this.schemaVersion < 2000;
        try {
            this.upgradeSchema_setDBVersionTable(true, from_vers, 2000, has_bg_tasks);
        }
        catch (SQLException e) {
            System.err.println("* Upgrade was successful except for final db_version table update; please manually update db_version as described above.");
        }
        if (has_bg_tasks) {
            this.schemaUpgBGTasks_fromVersion = this.schemaVersion;
        }
        this.prepareStatements();
        System.err.println("* DB schema upgrade completed.\n\n");
    }

    private void upgradeSchema_setDBVersionTable(boolean throwExcepIfError, int fromVers, int successfulToVers, boolean hasBGTasks) throws SQLException {
        block8: {
            try {
                PreparedStatement ps;
                if (successfulToVers == 0) {
                    ps = this.connection.prepareStatement("DELETE FROM db_version WHERE from_vers=?;");
                    ps.setInt(1, fromVers);
                } else {
                    ps = this.connection.prepareStatement("UPDATE db_version SET to_vers=?, ddl_done=?, bg_tasks_done=? WHERE from_vers=?;");
                    Timestamp now = new Timestamp(System.currentTimeMillis());
                    ps.setInt(1, successfulToVers);
                    ps.setTimestamp(2, now);
                    if (hasBGTasks) {
                        ps.setNull(3, 93);
                    } else {
                        ps.setTimestamp(3, now);
                    }
                    ps.setInt(4, fromVers);
                }
                ps.executeUpdate();
                ps.close();
            }
            catch (SQLException e) {
                System.err.println("*** SQLException while updating db_version table: " + e);
                if (successfulToVers == 0) {
                    System.err.println("    Cleanup needed: DELETE FROM db_version WHERE from_vers=" + fromVers + ';');
                } else {
                    System.err.println("    Cleanup needed: Restore from backup, or UPDATE db_version SET to_vers=" + successfulToVers + ", ddl_done=(timestamp), bg_tasks_done=" + (hasBGTasks ? "null" : "(timestamp)") + " WHERE from_vers=" + fromVers + ';');
                }
                if (!throwExcepIfError) break block8;
                throw e;
            }
        }
    }

    public void cleanup(boolean isForShutdown) {
        try {
            if (!this.checkConnection()) {
                return;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            this.createAccountCommand.close();
            this.userPasswordQuery.close();
            this.hostQuery.close();
            this.lastloginUpdate.close();
            this.saveGameCommand.close();
            if (this.saveGamePlayerCommand != null) {
                this.saveGamePlayerCommand.close();
            }
            this.robotParamsQuery.close();
            this.userCountQuery.close();
            this.userExistsQuery.close();
            if (this.userIncrWonCommand != null) {
                this.userIncrWonCommand.close();
            }
            if (this.userIncrLostCommand != null) {
                this.userIncrLostCommand.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (isForShutdown && this.schemaUpgBGTasksThread != null && this.schemaUpgBGTasksThread.isAlive()) {
            this.schemaUpgBGTasksThread.doShutdown = true;
        }
        this.initialized = false;
        try {
            this.connection.close();
            if (isForShutdown) {
                this.connection = null;
            }
        }
        catch (SQLException sqlE) {
            this.errorCondition = true;
            if (isForShutdown) {
                this.connection = null;
            }
            sqlE.printStackTrace();
        }
    }

    private boolean upgradeSchema_1200_encodeUserPasswords(Set<String> users, SecureRandom sr, String beginText, String warnEmptyText, String doneText) throws SQLException {
        if (sr == null) {
            sr = new SecureRandom();
        }
        if (beginText != null) {
            System.err.println(beginText);
        }
        HashMap<String, String> userConvPW = new HashMap<String, String>();
        for (String uname : users) {
            this.userPasswordQuery.setString(1, uname);
            String dbUserName = null;
            String dbPassword = null;
            ResultSet resultSet = this.userPasswordQuery.executeQuery();
            if (resultSet.next()) {
                dbUserName = resultSet.getString(1);
                dbPassword = resultSet.getString(2);
            }
            resultSet.close();
            if (dbPassword == null) continue;
            try {
                String pwStore = BCrypt.hashpw(dbPassword, BCrypt.gensalt(this.bcryptWorkFactor));
                userConvPW.put(dbUserName, pwStore);
            }
            catch (RuntimeException e) {
                SQLException sqlE = new SQLException("BCrypt exception");
                sqlE.initCause(e);
                throw sqlE;
            }
        }
        if (userConvPW.isEmpty()) {
            if (warnEmptyText != null) {
                System.err.println(warnEmptyText);
            }
            return false;
        }
        PreparedStatement ps = this.connection.prepareStatement("UPDATE users SET password='!', pw_scheme=1, pw_store=? WHERE nickname=?");
        boolean wasConnAutocommit = this.enterTransactionMode();
        try {
            int n = 0;
            for (Map.Entry e : userConvPW.entrySet()) {
                ps.setString(1, (String)e.getValue());
                ps.setString(2, (String)e.getKey());
                ps.addBatch();
                if (++n < 100) continue;
                ps.executeBatch();
                ps.clearBatch();
                n = 0;
            }
            ps.executeBatch();
            this.connection.commit();
        }
        catch (SQLException e) {
            this.connection.rollback();
            throw e;
        }
        finally {
            this.exitTransactionMode(wasConnAutocommit);
        }
        if (doneText != null) {
            System.err.println(doneText);
        }
        return true;
    }

    private String upg_postgres_checkIsTableOwner() throws SQLException {
        String curr = null;
        String owner = null;
        String error = null;
        String sql = "select current_user;";
        ResultSet rs = this.connection.createStatement().executeQuery(sql);
        if (rs.next()) {
            curr = rs.getString(1);
        } else {
            error = "Empty result: " + sql;
        }
        rs.close();
        if (error == null) {
            sql = "select tableowner from pg_tables where tablename='users';";
            rs = this.connection.createStatement().executeQuery(sql);
            if (rs.next()) {
                owner = rs.getString(1);
                if (owner == null) {
                    error = "Null owner for users table from: " + sql;
                }
            } else {
                error = "Empty result: " + sql;
            }
            rs.close();
        }
        if (error != null) {
            throw new SQLException(error);
        }
        return owner.equals(curr) ? null : owner;
    }

    private String dbtypePostgresGetSerialSequence(String tabName, String fieldName) throws IllegalStateException, SQLException {
        if (this.dbType != 'P') {
            throw new IllegalStateException("dbType: " + this.dbType);
        }
        String seqname = null;
        Statement st = this.connection.createStatement();
        ResultSet rs = st.executeQuery("SELECT pg_get_serial_sequence('" + tabName + "', '" + fieldName + "');");
        if (rs.next()) {
            seqname = rs.getString(1);
        }
        st.close();
        return seqname;
    }

    private boolean runDDL_dropCols(String tabName, String[] colNames) throws IllegalStateException {
        if (this.dbType == 'S') {
            throw new IllegalStateException("sqlite cannot drop columns");
        }
        try {
            if (this.dbType == 'A' || this.dbType == 'M' || this.dbType == 'P' || this.dbType == 'O') {
                StringBuilder sb = new StringBuilder("ALTER TABLE ");
                sb.append(tabName);
                for (int i = 0; i < colNames.length; ++i) {
                    if (i > 0) {
                        sb.append(',');
                    }
                    if (this.dbType != 'O') {
                        sb.append(" DROP ");
                    } else if (i == 0) {
                        sb.append(" DROP (");
                    }
                    sb.append(colNames[i]);
                }
                if (this.dbType == 'O') {
                    sb.append(')');
                }
                sb.append(';');
                this.runDDL(sb.toString());
            } else {
                for (int i = 0; i < colNames.length; ++i) {
                    this.runDDL("ALTER TABLE " + tabName + " DROP " + colNames[i] + ';');
                }
            }
            return true;
        }
        catch (Exception e) {
            System.err.println("* Problem during drop columns for " + tabName + ": " + e);
            return false;
        }
    }

    private boolean runDDL_rollback(String sql) {
        try {
            this.runDDL(sql);
            return true;
        }
        catch (Exception rollE) {
            System.err.println("* Problem during rollback: " + rollE);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runDDL(String sql) throws IllegalStateException, SQLException {
        try {
            if (!this.checkConnection()) {
                throw new IllegalStateException();
            }
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
        Statement s = this.connection.createStatement();
        try {
            s.execute(sql);
        }
        finally {
            try {
                s.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    private int getIntSetting(String settingKey, int defaultVal) throws SQLException {
        int v = defaultVal;
        Statement s = this.connection.createStatement();
        ResultSet rs = s.executeQuery("SELECT i_value FROM settings WHERE s_name='" + settingKey + "';");
        if (rs.next()) {
            v = rs.getInt(1);
        }
        s.close();
        return v;
    }

    private void updateSetting(String settingKey, int val, boolean isAdd) throws SQLException {
        PreparedStatement ps = this.connection.prepareStatement(isAdd ? "INSERT INTO settings(s_name, i_value, s_changed) values(?, ?, ?);" : "UPDATE settings SET i_value=?, s_changed=? WHERE s_name=?;");
        Timestamp tsNow = new Timestamp(System.currentTimeMillis());
        if (isAdd) {
            ps.setString(1, settingKey);
            ps.setInt(2, val);
            ps.setTimestamp(3, tsNow);
        } else {
            ps.setInt(1, val);
            ps.setTimestamp(2, tsNow);
            ps.setString(3, settingKey);
        }
        ps.executeUpdate();
        ps.close();
    }

    static void dispResultSet(ResultSet rs) throws SQLException {
        int i;
        System.out.println("dispResultSet()");
        ResultSetMetaData rsmd = rs.getMetaData();
        int numCols = rsmd.getColumnCount();
        for (i = 1; i <= numCols; ++i) {
            if (i > 1) {
                System.out.print(",");
            }
            System.out.print(rsmd.getColumnLabel(i));
        }
        System.out.println("");
        boolean more = rs.next();
        while (more) {
            for (i = 1; i <= numCols; ++i) {
                if (i > 1) {
                    System.out.print(",");
                }
                System.out.print(rs.getString(i));
            }
            System.out.println("");
            more = rs.next();
        }
    }

    private boolean testOne_doesTableExist(String tabname, boolean wantSuccess, boolean isRequired) throws IllegalStateException {
        boolean exists = this.doesTableExist(tabname);
        boolean pass = exists == wantSuccess;
        System.err.println((pass ? "test ok" : (isRequired ? "test FAIL" : "test failed but optional: ok")) + ": doesTableExist(" + tabname + "): " + exists);
        return pass;
    }

    private boolean testOne_doesTableColumnExist(String tabname, String colname, boolean wantSuccess, boolean isRequired) throws IllegalStateException {
        boolean exists = this.doesTableColumnExist(tabname, colname);
        boolean pass = exists == wantSuccess;
        System.err.println((pass ? "test ok" : (isRequired ? "test FAIL" : "test failed but optional: ok")) + ": doesTableColumnExist(" + tabname + ", " + colname + "): " + exists);
        return pass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean testOne_insertGameRow(boolean prepareWithArrayParam, boolean isRequired) {
        String testFailed;
        String testDesc = "testOne_insertGameRow(" + prepareWithArrayParam + ')';
        String string = testFailed = isRequired ? "test FAIL" : "test failed but optional: ok";
        if (this.schemaVersion < 2000) {
            System.err.println("test skipped (db has old schema): " + testDesc);
            return true;
        }
        PreparedStatement prevPS = this.saveGameCommand;
        try {
            PreparedStatement ps;
            this.saveGameCommand = ps = prepareWithArrayParam ? this.connection.prepareStatement(SAVE_GAME_COMMAND_2000, new String[]{"gameid"}) : this.connection.prepareStatement(SAVE_GAME_COMMAND_2000, 1);
        }
        catch (SQLFeatureNotSupportedException sfe) {
            System.err.println(testFailed + " (SQLFeatureNotSupportedException): " + testDesc + ": " + sfe);
            return false;
        }
        catch (SQLException e) {
            System.err.println(testFailed + " (SQLException): " + testDesc + ": " + e);
            return false;
        }
        long startTimeMillis = System.currentTimeMillis();
        boolean allOK = true;
        int[] newIDs = new int[5];
        try {
            int i;
            PreparedStatement psSel = this.connection.prepareStatement("SELECT gamename,duration_sec FROM games2 WHERE gameid=?");
            for (i = 0; i < newIDs.length; ++i) {
                newIDs[i] = this.insertGames2Row("db_testOne_ins" + i, "winner", startTimeMillis, i + 1, null, null);
            }
            for (i = 0; i < newIDs.length; ++i) {
                int id = newIDs[i];
                if (id <= 0 || id > 9999999) {
                    System.err.println("Unreasonable gameid=" + id + " for inserted games2 row");
                    allOK = false;
                    continue;
                }
                psSel.setInt(1, id);
                ResultSet rs = psSel.executeQuery();
                if (!rs.next()) {
                    System.err.println("Can't select from games2 where gameid=" + id);
                    allOK = false;
                } else {
                    String gaName = rs.getString(1);
                    int gaSec = rs.getInt(2);
                    if (gaSec != i + 1 || !("db_testOne_ins" + i).equals(gaName)) {
                        System.err.println("Wrong test data: gameid=" + id);
                        allOK = false;
                    }
                }
                rs.close();
            }
            psSel.close();
        }
        catch (SQLException e) {
            System.err.println(testFailed + " (SQLException): " + testDesc + ": " + e);
            boolean bl = false;
            return bl;
        }
        finally {
            for (int id : newIDs) {
                if (id == 0) continue;
                try {
                    this.connection.createStatement().executeUpdate("DELETE FROM games2 WHERE gameid=" + id);
                }
                catch (SQLException e) {
                    System.err.println("* Cleanup failed: couldn't delete temporary games2 where gameid=" + id + ": " + e);
                }
            }
            this.saveGameCommand = prevPS;
        }
        for (Object id : (PreparedStatement)newIDs) {
            if (id == false) continue;
            try {
                this.connection.createStatement().executeUpdate("DELETE FROM games2 WHERE gameid=" + (int)id);
            }
            catch (SQLException e) {
                System.err.println("* Cleanup failed: couldn't delete temporary games2 where gameid=" + (int)id + ": " + e);
            }
        }
        this.saveGameCommand = prevPS;
        System.err.println((allOK ? "test ok: " : testFailed + ": ") + testDesc + ": gameIDs " + Arrays.toString(newIDs));
        return allOK;
    }

    private void testDBHelper_runDDL(String desc, String sql) throws IllegalStateException, SQLException {
        System.err.println("For testing: " + desc);
        this.runDDL(sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void testDBHelper() throws IllegalStateException, SQLException {
        boolean anyFailed;
        block77: {
            if (!this.initialized) {
                throw new IllegalStateException();
            }
            boolean wasConnAutocommit = this.connection.getAutoCommit();
            anyFailed = false;
            System.err.println();
            DatabaseMetaData meta = this.connection.getMetaData();
            System.err.println("DB testing note: dbType " + this.dbType + ", driver class: " + this.driverclass + " v" + this.driverinstance.getMajorVersion() + '.' + this.driverinstance.getMinorVersion() + " (jdbc v" + meta.getJDBCMajorVersion() + '.' + meta.getJDBCMinorVersion() + "), db version: " + meta.getDatabaseProductVersion() + ", autoCommit: " + wasConnAutocommit + ", supportsGetGeneratedKeys: " + meta.supportsGetGeneratedKeys());
            try {
                System.err.println();
                anyFailed |= !this.testOne_doesTableExist("games", true, true);
                anyFailed |= !this.testOne_doesTableExist("gamesxyz", false, true);
                anyFailed |= !this.testOne_doesTableExist("gam_es", false, true);
                this.testOne_doesTableExist("GAMES", true, false);
                this.testOne_doesTableExist("Games", true, false);
                System.err.println();
                anyFailed |= !this.testOne_doesTableColumnExist("games", "gamename", true, true);
                anyFailed |= !this.testOne_doesTableColumnExist("games", "gamenamexyz", false, true);
                anyFailed |= !this.testOne_doesTableColumnExist("gamesxyz", "xyz", false, true);
                this.testOne_doesTableColumnExist("GAMES", "GAMENAME", true, false);
                this.testOne_doesTableColumnExist("Games", "gameName", true, false);
                System.err.println();
                this.testOne_insertGameRow(false, false);
                anyFailed |= !this.testOne_insertGameRow(true, true);
                System.err.println();
                if (this.dbType == 'P') {
                    try {
                        this.upg_postgres_checkIsTableOwner();
                        System.err.println("Test ok: upg_postgres_checkIsTableOwner()");
                    }
                    catch (SQLException e) {
                        System.err.println("Test failed: upg_postgres_checkIsTableOwner(): " + e);
                        anyFailed = true;
                    }
                    System.err.println();
                }
                if (!anyFailed) {
                    boolean hasFixtureFieldD3;
                    boolean hasFixtureFieldXYZW;
                    boolean hasFixtureTabXYZ;
                    block76: {
                        boolean didBulkIns;
                        block73: {
                            hasFixtureTabXYZ = false;
                            hasFixtureFieldXYZW = false;
                            hasFixtureFieldD3 = false;
                            didBulkIns = false;
                            boolean switchedAutoCommitOff = false;
                            try {
                                String c;
                                String[] cols;
                                this.testDBHelper_runDDL("fixture: create table gamesxyz2", "CREATE TABLE gamesxyz2 ( name VARCHAR(20) not null );");
                                hasFixtureTabXYZ = true;
                                anyFailed |= !this.testOne_doesTableExist("gamesxyz2", true, true);
                                anyFailed |= !this.testOne_doesTableColumnExist("gamesxyz2", "name", true, true);
                                anyFailed |= !this.testOne_doesTableColumnExist("gamesxyz2", "xyz", false, true);
                                this.testDBHelper_runDDL("fixture: table gamesxyz2 add field xyz", "ALTER TABLE gamesxyz2 ADD COLUMN xyz VARCHAR(20);");
                                this.testDBHelper_runDDL("fixture: table gamesxyz2 add field xyzw", "ALTER TABLE gamesxyz2 ADD COLUMN xyzw int;");
                                hasFixtureFieldXYZW = true;
                                String[] stringArray = cols = new String[]{"d1", "d2", "d3"};
                                int n = stringArray.length;
                                for (int i = 0; i < n; anyFailed |= !this.testOne_doesTableColumnExist("gamesxyz2", c, true, true), ++i) {
                                    c = stringArray[i];
                                    this.testDBHelper_runDDL("fixture: table gamesxyz2 add field " + c, "ALTER TABLE gamesxyz2 ADD COLUMN " + c + " int;");
                                }
                                hasFixtureFieldD3 = true;
                                anyFailed |= !this.testOne_doesTableColumnExist("gamesxyz2", "xyz", true, true);
                                anyFailed |= !this.testOne_doesTableColumnExist("gamesxyz2", "xyzw", true, true);
                                System.err.println();
                                try {
                                    this.runDDL("CREATE UNIQUE INDEX gamesxyz2__w ON gamesxyz2(xyzw);");
                                    System.err.println("Test ok: Create unique index gamesxyz2__w");
                                }
                                catch (SQLException e) {
                                    System.err.println("Test failed: Create unique index gamesxyz2__w: " + e);
                                    anyFailed = true;
                                }
                                if (this.dbType == 'P') {
                                    boolean hasFixtureTabPg = false;
                                    try {
                                        this.testDBHelper_runDDL("fixture: create table gamestest_pg", "CREATE TABLE gamestest_pg ( testid " + INT_AUTO_PK + ", ifield int not null );");
                                        hasFixtureTabPg = true;
                                        PreparedStatement ps = this.connection.prepareStatement("INSERT INTO gamestest_pg(ifield) VALUES(?)");
                                        for (int n2 = 0; n2 < 3; ++n2) {
                                            ps.setInt(1, n2);
                                            ps.executeUpdate();
                                        }
                                        ps.close();
                                        String seqname = this.dbtypePostgresGetSerialSequence("gamestest_pg", "ifield");
                                        if (seqname != null) {
                                            System.err.println("Test failed: PostgreSQL: pg_get_serial_sequence(.., 'ifield') should be null");
                                            anyFailed = true;
                                        }
                                        if ((seqname = this.dbtypePostgresGetSerialSequence("gamestest_pg", "testid")) != null) {
                                            if (!seqname.toLowerCase(Locale.US).contains("testid")) {
                                                System.err.println("Test failed: PostgreSQL: pg_get_serial_sequence(.., 'testid') returned \"" + seqname + "\", doesn't contain \"testid\" as expected");
                                                anyFailed = true;
                                            }
                                        } else {
                                            System.err.println("Test failed: PostgreSQL: pg_get_serial_sequence returned null");
                                            anyFailed = true;
                                        }
                                        if (!anyFailed) {
                                            System.err.println("Test ok: PostgreSQL: pg_get_serial_sequence(\"gamestest_pg\", ...)");
                                        }
                                    }
                                    catch (SQLException e) {
                                        System.err.println("Test failed: PostgreSQL: pg_get_serial_sequence: " + e);
                                        anyFailed = true;
                                    }
                                    if (hasFixtureTabPg) {
                                        try {
                                            this.testDBHelper_runDDL("fixture cleanup: drop table gamestest_pg", "DROP TABLE gamestest_pg;");
                                        }
                                        catch (SQLException e) {
                                            System.err.println("Cleanup failed: Drop table gamestest_pg: " + e);
                                            anyFailed = true;
                                        }
                                    }
                                }
                                try {
                                    int i;
                                    PreparedStatement ps = this.connection.prepareStatement("INSERT INTO gamesxyz2(name,xyzw) VALUES(?,?)");
                                    if (wasConnAutocommit) {
                                        this.connection.setAutoCommit(false);
                                        switchedAutoCommitOff = true;
                                    } else {
                                        try {
                                            this.connection.commit();
                                        }
                                        catch (SQLException e) {
                                            System.err.println("Unexpected error at pre-transaction commit: " + e);
                                            e.printStackTrace();
                                            throw e;
                                        }
                                    }
                                    for (i = 0; i < 100; ++i) {
                                        ps.setString(1, "test" + i);
                                        ps.setInt(2, i);
                                        ps.addBatch();
                                    }
                                    ps.executeBatch();
                                    ps.clearBatch();
                                    for (i = 1; i <= 100; ++i) {
                                        ps.setString(1, "test2_" + i);
                                        ps.setInt(2, -i);
                                        ps.addBatch();
                                    }
                                    ps.executeBatch();
                                    this.connection.commit();
                                    didBulkIns = true;
                                    ResultSet rs = this.connection.createStatement().executeQuery("SELECT count(*) FROM gamesxyz2");
                                    rs.next();
                                    int n3 = rs.getInt(1);
                                    rs.close();
                                    if (n3 == 200) {
                                        System.err.println("Test ok: executeBatch");
                                    } else {
                                        System.err.println("Test failed: executeBatch: count(*) " + n3 + " expected " + 200);
                                    }
                                }
                                catch (SQLException e) {
                                    System.err.println("Test failed: executeBatch: " + e);
                                    anyFailed = true;
                                }
                                try {
                                    this.connection.commit();
                                    this.connection.commit();
                                    System.err.println("Test ok: empty commits");
                                }
                                catch (SQLException e) {
                                    System.err.println("Test failed: empty commits: " + e);
                                    anyFailed = true;
                                }
                                System.err.println();
                                if (!switchedAutoCommitOff) break block73;
                            }
                            catch (Throwable throwable) {
                                block74: {
                                    System.err.println();
                                    if (switchedAutoCommitOff) {
                                        try {
                                            this.connection.setAutoCommit(true);
                                            System.err.println("Cleanup ok: Restore autoCommit mode");
                                        }
                                        catch (SQLException e) {
                                            System.err.println("Cleanup failed: Restore autoCommit mode: " + e);
                                            anyFailed = true;
                                        }
                                    }
                                    if (didBulkIns) {
                                        try {
                                            ResultSet rs = this.selectWithLimit("SELECT * FROM gamesxyz2 WHERE xyzw <= 9", 5);
                                            int i = 0;
                                            while (rs.next()) {
                                                ++i;
                                            }
                                            rs.close();
                                            if (i == 5) {
                                                System.err.println("Test ok: selectWithLimit");
                                                break block74;
                                            }
                                            System.err.println("Test failed: selectWithLimit: Expected 5 rows, got " + i);
                                            if (this.dbType != '?') {
                                                anyFailed = true;
                                            } else {
                                                System.err.println("  (failure OK here: dbType is unknown)");
                                            }
                                        }
                                        catch (SQLException e) {
                                            System.err.println("Test failed: selectWithLimit: " + e);
                                            anyFailed = true;
                                        }
                                    }
                                }
                                if (hasFixtureTabXYZ) {
                                    try {
                                        String sql = this.dbType != 'M' && this.dbType != 'A' ? "DROP INDEX gamesxyz2__w;" : "DROP INDEX gamesxyz2__w ON gamesxyz2;";
                                        this.testDBHelper_runDDL("fixture cleanup: drop index gamesxyz2__w", sql);
                                    }
                                    catch (SQLException e) {
                                        System.err.println("Cleanup failed: Drop index gamesxyz2__w: " + e);
                                        anyFailed = true;
                                    }
                                    if (hasFixtureFieldXYZW && this.dbType != 'S') {
                                        this.testDBHelper_runDDL("drop table column gamesxyz2.xyzw", "ALTER TABLE gamesxyz2 DROP xyzw;");
                                        anyFailed |= !this.testOne_doesTableColumnExist("gamesxyz2", "xyzw", false, true);
                                        if (hasFixtureFieldD3) {
                                            String[] cols = new String[]{"d1", "d2", "d3"};
                                            if (this.runDDL_dropCols("gamesxyz2", cols)) {
                                                System.err.println("Test ok: runDDL_dropCols gamesxyz2");
                                                anyFailed |= !this.testOne_doesTableColumnExist("gamesxyz2", "d1", false, true);
                                                anyFailed |= !this.testOne_doesTableColumnExist("gamesxyz2", "d2", false, true);
                                                anyFailed |= !this.testOne_doesTableColumnExist("gamesxyz2", "d3", false, true);
                                            } else {
                                                anyFailed = true;
                                                System.err.println("4 Tests failed: runDDL_dropCols gamesxyz2");
                                            }
                                        }
                                    } else {
                                        System.err.println("5 tests skipped for sqlite: drop table column gamesxyz2.xyzw, runDDL_dropCols");
                                    }
                                    this.testDBHelper_runDDL("fixture cleanup: drop table gamesxyz2", "DROP TABLE gamesxyz2;");
                                    anyFailed |= !this.testOne_doesTableExist("gamesxyz2", false, true);
                                }
                                throw throwable;
                            }
                            try {
                                this.connection.setAutoCommit(true);
                                System.err.println("Cleanup ok: Restore autoCommit mode");
                            }
                            catch (SQLException e) {
                                System.err.println("Cleanup failed: Restore autoCommit mode: " + e);
                                anyFailed = true;
                            }
                        }
                        if (didBulkIns) {
                            try {
                                ResultSet rs = this.selectWithLimit("SELECT * FROM gamesxyz2 WHERE xyzw <= 9", 5);
                                int i = 0;
                                while (rs.next()) {
                                    ++i;
                                }
                                rs.close();
                                if (i == 5) {
                                    System.err.println("Test ok: selectWithLimit");
                                    break block76;
                                }
                                System.err.println("Test failed: selectWithLimit: Expected 5 rows, got " + i);
                                if (this.dbType != '?') {
                                    anyFailed = true;
                                } else {
                                    System.err.println("  (failure OK here: dbType is unknown)");
                                }
                            }
                            catch (SQLException e) {
                                System.err.println("Test failed: selectWithLimit: " + e);
                                anyFailed = true;
                            }
                        }
                    }
                    if (!hasFixtureTabXYZ) break block77;
                    try {
                        String sql = this.dbType != 'M' && this.dbType != 'A' ? "DROP INDEX gamesxyz2__w;" : "DROP INDEX gamesxyz2__w ON gamesxyz2;";
                        this.testDBHelper_runDDL("fixture cleanup: drop index gamesxyz2__w", sql);
                    }
                    catch (SQLException e) {
                        System.err.println("Cleanup failed: Drop index gamesxyz2__w: " + e);
                        anyFailed = true;
                    }
                    if (hasFixtureFieldXYZW && this.dbType != 'S') {
                        this.testDBHelper_runDDL("drop table column gamesxyz2.xyzw", "ALTER TABLE gamesxyz2 DROP xyzw;");
                        anyFailed |= !this.testOne_doesTableColumnExist("gamesxyz2", "xyzw", false, true);
                        if (hasFixtureFieldD3) {
                            String[] cols = new String[]{"d1", "d2", "d3"};
                            if (this.runDDL_dropCols("gamesxyz2", cols)) {
                                System.err.println("Test ok: runDDL_dropCols gamesxyz2");
                                anyFailed |= !this.testOne_doesTableColumnExist("gamesxyz2", "d1", false, true);
                                anyFailed |= !this.testOne_doesTableColumnExist("gamesxyz2", "d2", false, true);
                                anyFailed |= !this.testOne_doesTableColumnExist("gamesxyz2", "d3", false, true);
                            } else {
                                anyFailed = true;
                                System.err.println("4 Tests failed: runDDL_dropCols gamesxyz2");
                            }
                        }
                    } else {
                        System.err.println("5 tests skipped for sqlite: drop table column gamesxyz2.xyzw, runDDL_dropCols");
                    }
                    this.testDBHelper_runDDL("fixture cleanup: drop table gamesxyz2", "DROP TABLE gamesxyz2;");
                    anyFailed |= !this.testOne_doesTableExist("gamesxyz2", false, true);
                    break block77;
                }
                System.err.println("16 tests skipped because not creating fixture after previous failures.");
            }
            catch (Exception e) {
                D.ebugPrintStackTrace(e, "test caught exception: testDBHelper");
                if (e instanceof SQLException) {
                    throw (SQLException)e;
                }
                SQLException sx = new SQLException("Error during testDBHelper()");
                sx.initCause(e);
                throw sx;
            }
        }
        System.err.println();
        if (anyFailed) {
            System.err.println("*** Some required DB tests failed.");
            throw new SQLException("Required test(s) failed");
        }
        System.err.println("* All required DB tests passed.");
    }

    static {
        bcryptQueueThreader = Executors.newSingleThreadExecutor();
        SAVE_GAME_COMMAND_2000_GEN_KEY = new String[]{"gameid"};
    }

    private class UpgradeBGTasksThread
    extends Thread {
        public volatile boolean doShutdown = false;

        private UpgradeBGTasksThread() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                this.setName("UpgradeBGTasksThread");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            System.err.println("\n* Schema upgrade: Beginning background tasks\n");
            try {
                int fromVers;
                block12: while (SOCDBHelper.this.schemaUpgBGTasks_fromVersion < SOCDBHelper.this.schemaVersion && !this.doShutdown && (fromVers = SOCDBHelper.this.schemaUpgBGTasks_fromVersion) != 0) {
                    switch (fromVers) {
                        case 1000: {
                            this.upgradeBGTasks_1000_1200();
                            continue block12;
                        }
                        case 1200: {
                            this.upgradeBGTasks_1200_2000();
                            continue block12;
                        }
                    }
                    System.err.println("*** UpgradeBGTasksThread: Unknown fromVersion: " + fromVers);
                    return;
                }
            }
            catch (SQLException e) {
                if (!this.doShutdown) {
                    System.err.println("*** Schema upgrade: SQL error during background tasks: " + e);
                    e.printStackTrace();
                    return;
                }
                System.err.println("*** Schema upgrade: SQL error during shutdown: " + e);
                return;
            }
            SOCDBHelper.this.schemaUpgBGTasks_fromVersion = 0;
            try {
                Timestamp sqlNow = new Timestamp(System.currentTimeMillis());
                PreparedStatement ps = SOCDBHelper.this.connection.prepareStatement("UPDATE db_version SET bg_tasks_done = ? WHERE bg_tasks_done IS NULL AND to_vers = ?;");
                ps.setTimestamp(1, sqlNow);
                ps.setInt(2, SOCDBHelper.this.schemaVersion);
                ps.executeUpdate();
            }
            catch (SQLException e) {
                System.err.println("*** Schema upgrade BG tasks completed, but SQL error setting db_version.bg_tasks_done: " + e);
            }
            if (!this.doShutdown) {
                System.err.println("\n* Schema upgrade: Completed background tasks\n");
                return;
            }
            System.err.println("\n* Schema upgrade: Shutting shutdown background tasks, will complete later\n");
        }

        private void upgradeBGTasks_1000_1200() throws SQLException {
            int UPG_BATCH = 10;
            if (UPG_BATCH > 100) {
                UPG_BATCH = 100;
            }
            System.err.println("Schema upgrade: Encoding passwords for users");
            SecureRandom sr = new SecureRandom();
            HashSet<String> users = new HashSet<String>();
            do {
                users.clear();
                ResultSet rs = SOCDBHelper.this.selectWithLimit("SELECT nickname_lc FROM users WHERE pw_store IS NULL", UPG_BATCH);
                for (int i = 0; i < UPG_BATCH && rs.next(); ++i) {
                    users.add(rs.getString(1));
                }
                rs.close();
                if (users.isEmpty() || SOCDBHelper.this.upgradeSchema_1200_encodeUserPasswords(users, sr, null, null, null)) continue;
                throw new SQLException("L3087 Internal error: Could not select any users.nickname to encode");
            } while (!this.doShutdown && !users.isEmpty());
            if (!this.doShutdown) {
                System.err.println("Schema upgrade: User password encoding: Completed");
            }
            SOCDBHelper.this.schemaUpgBGTasks_fromVersion = 1200;
        }

        private void upgradeBGTasks_1200_2000() throws SQLException {
            int UPG_BATCH = 34;
            System.err.println("Schema upgrade: Normalizing games into games2");
            HashMap<String, String> allDBUsers = new HashMap<String, String>();
            Statement st = SOCDBHelper.this.connection.createStatement();
            ResultSet rs = st.executeQuery("SELECT nickname_lc, nickname FROM users");
            while (rs.next()) {
                allDBUsers.put(rs.getString(1), rs.getString(2));
            }
            st.close();
            PreparedStatement psInsPlayer = SOCDBHelper.this.connection.prepareStatement("INSERT INTO games2_players(gameid,player,score) VALUES(?,?,?);");
            PreparedStatement psSetWinner = SOCDBHelper.this.connection.prepareStatement("UPDATE games2 SET winner=? WHERE gameid=?;");
            PreparedStatement psAddUserWins = SOCDBHelper.this.connection.prepareStatement("UPDATE users SET games_won = coalesce(games_won,0) + ? WHERE nickname=?;");
            PreparedStatement psAddUserLosses = SOCDBHelper.this.connection.prepareStatement("UPDATE users SET games_lost = coalesce(games_lost,0) + ? WHERE nickname=?;");
            PreparedStatement psAddUserWinsLosses = SOCDBHelper.this.connection.prepareStatement("UPDATE users SET games_won = coalesce(games_won,0) + ?, games_lost = coalesce(games_lost,0) + ? WHERE nickname=?;");
            HashMap<String, IntPair> winLossDBUsers = new HashMap<String, IntPair>();
            boolean wasConnAutocommit = SOCDBHelper.this.enterTransactionMode();
            try {
                boolean hasGames;
                do {
                    hasGames = false;
                    boolean hasSetWinners = false;
                    StringBuilder sbMarkUpg = new StringBuilder("UPDATE upg_tmp_games SET mig_done=1 WHERE gameid IN (");
                    rs = SOCDBHelper.this.selectWithLimit("SELECT gameid,winner,player1,player2,player3,player4,player5,player6,score1,score2,score3,score4,score5,score6 FROM upg_tmp_games WHERE mig_done IS NULL", 34);
                    for (int i = 0; i < 34 && rs.next(); ++i) {
                        boolean winnerWasNull;
                        int pn;
                        int gameid = rs.getInt(1);
                        String winner = rs.getString(2);
                        if (winner != null && winner.equals("?")) {
                            winner = null;
                        }
                        String[] plNames = new String[6];
                        int[] plScores = new int[6];
                        for (pn = 0; pn < 6; ++pn) {
                            plNames[pn] = rs.getString(pn + 3);
                        }
                        for (pn = 0; pn < 6; ++pn) {
                            plScores[pn] = rs.getInt(pn + 3 + 6);
                        }
                        boolean setWinnerInGames2 = false;
                        String winner_LC = null;
                        boolean bl = winnerWasNull = winner == null;
                        if (winnerWasNull) {
                            int highscore = 0;
                            int winPN = -1;
                            boolean hadTie = false;
                            for (int pn2 = 0; pn2 < 6; ++pn2) {
                                if (plNames[pn2] == null) continue;
                                int score = plScores[pn2];
                                if (score > highscore) {
                                    highscore = score;
                                    hadTie = false;
                                    winPN = pn2;
                                    continue;
                                }
                                if (score != highscore) continue;
                                hadTie = true;
                            }
                            if (winPN != -1 && !hadTie) {
                                winner = plNames[winPN];
                                winner_LC = winner.toLowerCase(Locale.US);
                                setWinnerInGames2 = true;
                                String dbName = (String)allDBUsers.get(winner_LC);
                                if (dbName != null) {
                                    winner = dbName;
                                }
                            }
                        } else {
                            winner_LC = winner.toLowerCase(Locale.US);
                        }
                        for (int pn3 = 0; pn3 < 6; ++pn3) {
                            String name = plNames[pn3];
                            if (name == null) continue;
                            String name_LC = name.toLowerCase(Locale.US);
                            boolean playerWon = name_LC.equals(winner_LC);
                            String dbName = (String)allDBUsers.get(name_LC);
                            if (dbName != null) {
                                name = dbName;
                                IntPair userWinLoss = (IntPair)winLossDBUsers.get(dbName);
                                if (userWinLoss == null) {
                                    userWinLoss = new IntPair(0, 0);
                                    winLossDBUsers.put(dbName, userWinLoss);
                                }
                                if (playerWon) {
                                    ++userWinLoss.a;
                                    if (!winnerWasNull && !winner.equals(dbName)) {
                                        winner = dbName;
                                        setWinnerInGames2 = true;
                                    }
                                } else {
                                    ++userWinLoss.b;
                                }
                            }
                            psInsPlayer.setInt(1, gameid);
                            psInsPlayer.setString(2, name);
                            psInsPlayer.setInt(3, plScores[pn3]);
                            psInsPlayer.addBatch();
                        }
                        if (i > 0) {
                            sbMarkUpg.append(',');
                        } else {
                            hasGames = true;
                        }
                        sbMarkUpg.append(gameid);
                        if (!setWinnerInGames2) continue;
                        psSetWinner.setString(1, winner);
                        psSetWinner.setInt(2, gameid);
                        psSetWinner.addBatch();
                        hasSetWinners = true;
                    }
                    rs.close();
                    if (!hasGames) continue;
                    psInsPlayer.executeBatch();
                    if (!winLossDBUsers.isEmpty()) {
                        for (String dbUser : winLossDBUsers.keySet()) {
                            IntPair WL = (IntPair)winLossDBUsers.get(dbUser);
                            int wins = WL.a;
                            int losses = WL.b;
                            if (wins != 0) {
                                if (losses != 0) {
                                    psAddUserWinsLosses.setInt(1, wins);
                                    psAddUserWinsLosses.setInt(2, losses);
                                    psAddUserWinsLosses.setString(3, dbUser);
                                    psAddUserWinsLosses.executeUpdate();
                                    continue;
                                }
                                psAddUserWins.setInt(1, wins);
                                psAddUserWins.setString(2, dbUser);
                                psAddUserWins.executeUpdate();
                                continue;
                            }
                            psAddUserLosses.setInt(1, losses);
                            psAddUserLosses.setString(2, dbUser);
                            psAddUserLosses.executeUpdate();
                        }
                        winLossDBUsers.clear();
                    }
                    if (hasSetWinners) {
                        psSetWinner.executeBatch();
                    }
                    sbMarkUpg.append(");");
                    st = SOCDBHelper.this.connection.createStatement();
                    st.executeUpdate(sbMarkUpg.toString());
                    st.close();
                    SOCDBHelper.this.connection.commit();
                } while (hasGames && !this.doShutdown);
                if (!this.doShutdown) {
                    SOCDBHelper.this.runDDL("DROP TABLE upg_tmp_games;");
                    System.err.println("Schema upgrade: Normalizing games into games2: Completed");
                }
                SOCDBHelper.this.schemaUpgBGTasks_fromVersion = 2000;
            }
            catch (SQLException e) {
                SOCDBHelper.this.connection.rollback();
                throw e;
            }
            finally {
                SOCDBHelper.this.exitTransactionMode(wasConnAutocommit);
            }
        }
    }

    public static interface AuthPasswordRunnable {
        public void authResult(String var1, boolean var2);
    }
}

