/*
 * Decompiled with CFR 0.152.
 */
package soc.server.genericServer;

import java.util.Date;
import java.util.MissingResourceException;
import soc.game.SOCGame;
import soc.message.SOCMessage;
import soc.server.genericServer.Server;
import soc.util.SOCStringManager;

public abstract class Connection {
    public static final int MAX_MESSAGE_SIZE_UTF8 = 65535;
    protected String data;
    protected Object appData;
    protected String localeStr;
    protected SOCStringManager stringMgr;
    protected int remoteVersion;
    protected boolean remoteVersionKnown;
    protected boolean remoteVersionTrack;
    protected boolean hideTimeoutMessage;
    protected Server ourServer;
    protected Exception error;
    protected Date connectTime = new Date();

    public abstract String host();

    public abstract void put(String var1) throws IllegalStateException;

    public void put(SOCMessage msg) throws IllegalArgumentException, IllegalStateException {
        if (msg == null) {
            throw new IllegalArgumentException("null");
        }
        this.put(msg.toCmd());
    }

    public abstract void run();

    public abstract boolean isConnected();

    public abstract boolean connect();

    public abstract void disconnect();

    public abstract void disconnectSoft();

    public String getData() {
        return this.data;
    }

    public Object getAppData() {
        return this.appData;
    }

    public void setData(String data) {
        this.data = data;
    }

    public void setAppData(Object data) {
        this.appData = data;
    }

    public String getI18NLocale() {
        return this.localeStr;
    }

    public SOCStringManager getI18NStringManager() {
        return this.stringMgr;
    }

    public void setI18NStringManager(SOCStringManager mgr, String loc) {
        this.stringMgr = mgr;
        this.localeStr = loc;
    }

    public String getLocalized(String key) throws MissingResourceException {
        SOCStringManager sm = this.stringMgr;
        if (sm == null) {
            sm = SOCStringManager.getFallbackServerManagerForClient();
        }
        return sm.get(key);
    }

    public String getLocalized(String key, Object ... arguments) throws MissingResourceException {
        SOCStringManager sm = this.stringMgr;
        if (sm == null) {
            sm = SOCStringManager.getFallbackServerManagerForClient();
        }
        return sm.get(key, arguments);
    }

    public String getLocalizedSpecial(SOCGame game, String key, Object ... arguments) throws MissingResourceException, IllegalArgumentException {
        SOCStringManager sm = this.stringMgr;
        if (sm == null) {
            sm = SOCStringManager.getFallbackServerManagerForClient();
        }
        return sm.getSpecial(game, key, arguments);
    }

    public Exception getError() {
        return this.error;
    }

    public Date getConnectTime() {
        return this.connectTime;
    }

    public int getVersion() {
        return this.remoteVersion;
    }

    public void setVersion(int version) {
        this.setVersion(version, version > 0);
    }

    public void setVersion(int version, boolean isKnown) {
        int prevVers = this.remoteVersion;
        this.remoteVersion = version;
        this.remoteVersionKnown = isKnown;
        if (this.remoteVersionTrack && this.ourServer != null && prevVers != version) {
            this.ourServer.clientVersionRem(prevVers);
            this.ourServer.clientVersionAdd(version);
        }
    }

    public boolean isVersionKnown() {
        return this.remoteVersionKnown;
    }

    public void setVersionTracking(boolean doTracking) {
        this.remoteVersionTrack = doTracking;
    }

    public abstract boolean isInputAvailable();

    public boolean wantsHideTimeoutMessage() {
        return this.hideTimeoutMessage;
    }

    public void setHideTimeoutMessage(boolean wantsHide) {
        this.hideTimeoutMessage = wantsHide;
    }
}

