/*
 * Decompiled with CFR 0.152.
 */
package soc.server.genericServer;

import java.util.Vector;
import soc.message.SOCMessage;
import soc.server.genericServer.Connection;
import soc.server.genericServer.Server;

public class InboundMessageQueue {
    private Vector<MessageData> inQueue = new Vector();
    private Treater treater;
    private final Server.InboundMessageDispatcher dispatcher;

    public InboundMessageQueue(Server.InboundMessageDispatcher imd) {
        this.dispatcher = imd;
    }

    public void startMessageProcessing() {
        this.treater = new Treater();
        this.treater.start();
    }

    public void stopMessageProcessing() {
        if (this.treater != null) {
            this.treater.stopTreater();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void push(SOCMessage receivedMessage, Connection clientConnection) {
        MessageData md = new MessageData(receivedMessage, clientConnection);
        Vector<MessageData> vector = this.inQueue;
        synchronized (vector) {
            this.inQueue.addElement(md);
            this.inQueue.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void post(Runnable run) {
        MessageData md = new MessageData(run);
        Vector<MessageData> vector = this.inQueue;
        synchronized (vector) {
            this.inQueue.addElement(md);
            this.inQueue.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final MessageData poll() {
        Vector<MessageData> vector = this.inQueue;
        synchronized (vector) {
            if (this.inQueue.size() > 0) {
                return this.inQueue.remove(0);
            }
        }
        return null;
    }

    public final boolean isCurrentThreadTreater() {
        return Thread.currentThread() == this.treater;
    }

    private static class MessageData {
        public final SOCMessage message;
        public final Connection clientSender;
        public final Runnable run;

        public MessageData(SOCMessage message, Connection clientSender) {
            this.message = message;
            this.clientSender = clientSender;
            this.run = null;
        }

        public MessageData(Runnable run) {
            this.run = run;
            this.message = null;
            this.clientSender = null;
        }
    }

    final class Treater
    extends Thread {
        private volatile boolean processMessage;

        public Treater() {
            this.setName("treater");
            this.processMessage = true;
        }

        public void stopTreater() {
            this.processMessage = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.processMessage) {
                MessageData messageData = InboundMessageQueue.this.poll();
                try {
                    if (messageData != null) {
                        if (messageData.run != null) {
                            messageData.run.run();
                        } else {
                            InboundMessageQueue.this.dispatcher.dispatch(messageData.message, messageData.clientSender);
                        }
                    }
                }
                catch (Exception e) {
                    System.out.println("Exception in treater (dispatch) - " + e.getMessage());
                    e.printStackTrace();
                }
                Thread.yield();
                Vector vector = InboundMessageQueue.this.inQueue;
                synchronized (vector) {
                    if (InboundMessageQueue.this.inQueue.size() == 0) {
                        try {
                            InboundMessageQueue.this.inQueue.wait(1000L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
        }
    }
}

