/*
 * Decompiled with CFR 0.152.
 */
package soc.server.genericServer;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.Socket;
import java.util.Date;
import java.util.Vector;
import soc.disableDebug.D;
import soc.message.SOCMessage;
import soc.server.genericServer.Connection;
import soc.server.genericServer.InboundMessageQueue;
import soc.server.genericServer.Server;

final class NetConnection
extends Connection
implements Runnable,
Serializable,
Cloneable {
    protected static final int TIMEOUT_VALUE = 3600000;
    DataInputStream in = null;
    DataOutputStream out = null;
    Socket s = null;
    protected String hst;
    protected boolean connected = false;
    protected boolean inputConnected = false;
    private Vector<String> outQueue = new Vector();

    NetConnection(Socket so, Server sve) {
        this.hst = so.getInetAddress().getHostName();
        this.ourServer = sve;
        this.s = so;
    }

    public String getName() {
        if (this.hst != null && this.s != null) {
            return "connection-" + this.hst + "-" + Integer.toString(this.s.getPort());
        }
        return "connection-(null)-" + Integer.toString(this.hashCode());
    }

    @Override
    public String host() {
        return this.hst;
    }

    @Override
    public boolean connect() {
        if (this.getData() != null) {
            D.ebugPrintlnINFO("conn.connect() requires null getData()");
            return false;
        }
        try {
            this.s.setSoTimeout(3600000);
            this.in = new DataInputStream(this.s.getInputStream());
            this.out = new DataOutputStream(this.s.getOutputStream());
            this.connected = true;
            this.inputConnected = true;
            this.connectTime = new Date();
            Putter putter = new Putter();
            putter.start();
        }
        catch (Exception e) {
            D.ebugPrintlnINFO("IOException in Connection.connect (" + this.hst + ") - " + e);
            this.error = e;
            this.disconnect();
            return false;
        }
        return true;
    }

    @Override
    public boolean isInputAvailable() {
        try {
            return this.inputConnected && 0 < this.in.available();
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public void run() {
        Thread.currentThread().setName(this.getName());
        this.ourServer.addConnection(this);
        try {
            String firstMsg;
            SOCMessage msgObj;
            InboundMessageQueue inQueue = this.ourServer.inQueue;
            if (this.inputConnected && !this.ourServer.processFirstCommand(msgObj = SOCMessage.toMsg(firstMsg = this.in.readUTF()), this) && msgObj != null) {
                inQueue.push(msgObj, this);
            }
            while (this.inputConnected) {
                String msgStr = this.in.readUTF();
                msgObj = SOCMessage.toMsg(msgStr);
                if (msgObj == null) continue;
                inQueue.push(msgObj, this);
            }
        }
        catch (Exception e) {
            D.ebugPrintlnINFO("Exception in NetConnection.run (" + this.hst + ") - " + e);
            if (!this.connected) {
                return;
            }
            this.error = e;
            this.ourServer.removeConnection(this, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void put(String str) {
        Vector<String> vector = this.outQueue;
        synchronized (vector) {
            this.outQueue.addElement(str);
            this.outQueue.notify();
        }
    }

    private boolean putForReal(String str) {
        boolean rv = this.putAux(str);
        if (!rv) {
            if (!this.connected) {
                return false;
            }
            this.ourServer.removeConnection(this, false);
            return false;
        }
        return true;
    }

    private final boolean putAux(String str) {
        if (this.error != null || !this.connected) {
            return false;
        }
        try {
            this.out.writeUTF(str);
        }
        catch (IOException e) {
            D.ebugPrintlnINFO("IOException in NetConnection.putAux (" + this.hst + ") - " + e);
            this.error = e;
            return false;
        }
        catch (Exception ex) {
            D.ebugPrintlnINFO("generic exception in NetConnection.putAux");
            return false;
        }
        return true;
    }

    @Override
    public void disconnect() {
        if (!this.connected) {
            return;
        }
        D.ebugPrintlnINFO("DISCONNECTING " + this.data);
        this.connected = false;
        this.inputConnected = false;
        try {
            if (this.out != null) {
                try {
                    this.out.flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.s != null) {
                this.s.close();
            }
        }
        catch (IOException e) {
            D.ebugPrintlnINFO("IOException in Connection.disconnect (" + this.hst + ") - " + e);
            this.error = e;
        }
        this.s = null;
        this.in = null;
        this.out = null;
    }

    @Override
    public void disconnectSoft() {
        if (!this.inputConnected) {
            return;
        }
        D.ebugPrintlnINFO("DISCONNECTING(SOFT) " + this.data);
        this.inputConnected = false;
        if (this.out != null) {
            try {
                this.out.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean isConnected() {
        return this.connected && this.inputConnected;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Connection[");
        if (this.data != null) {
            sb.append(this.data);
        } else {
            sb.append(super.hashCode());
        }
        sb.append('-');
        sb.append(this.getName());
        sb.append(']');
        return sb.toString();
    }

    class Putter
    extends Thread {
        public Putter() {
            D.ebugPrintlnINFO("NEW PUTTER CREATED FOR " + NetConnection.this.data);
            String cn = NetConnection.this.host();
            if (cn != null) {
                this.setName("putter-" + cn + "-" + Integer.toString(NetConnection.this.s.getPort()));
            } else {
                this.setName("putter-(null)-" + Integer.toString(this.hashCode()));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (NetConnection.this.connected) {
                String c = null;
                if (D.ebugIsEnabled()) {
                    D.ebugPrintlnINFO("** " + NetConnection.this.data + " is at the top of the putter loop");
                }
                Vector vector = NetConnection.this.outQueue;
                synchronized (vector) {
                    if (NetConnection.this.outQueue.size() > 0) {
                        c = (String)NetConnection.this.outQueue.elementAt(0);
                        NetConnection.this.outQueue.removeElementAt(0);
                    }
                }
                if (c != null) {
                    NetConnection.this.putForReal(c);
                }
                vector = NetConnection.this.outQueue;
                synchronized (vector) {
                    if (NetConnection.this.outQueue.size() == 0) {
                        try {
                            NetConnection.this.outQueue.wait(1000L);
                        }
                        catch (Exception ex) {
                            D.ebugPrintlnINFO("Exception while waiting for outQueue in " + NetConnection.this.data + ". - " + ex);
                        }
                    }
                }
            }
            D.ebugPrintlnINFO("putter not putting connected==false : " + NetConnection.this.data);
        }
    }
}

