/*
 * Decompiled with CFR 0.152.
 */
package soc.server.genericServer;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import soc.server.genericServer.Connection;
import soc.server.genericServer.NetConnection;
import soc.server.genericServer.SOCServerSocket;
import soc.server.genericServer.Server;

class NetServerSocket
implements SOCServerSocket {
    private final ServerSocket implServSocket;
    private final Server server;

    public NetServerSocket(int port, Server server) throws IOException {
        this.server = server;
        this.implServSocket = new ServerSocket();
        this.implServSocket.setReuseAddress(true);
        this.implServSocket.bind(new InetSocketAddress(port));
    }

    @Override
    public Connection accept() throws SocketException, IOException {
        Socket s = this.implServSocket.accept();
        return new NetConnection(s, this.server);
    }

    @Override
    public void close() throws IOException {
        this.implServSocket.close();
    }
}

