/*
 * Decompiled with CFR 0.152.
 */
package soc.server.genericServer;

import java.io.IOException;
import java.io.Serializable;
import java.net.SocketTimeoutException;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.Vector;
import soc.debug.D;
import soc.message.SOCMessage;
import soc.server.genericServer.Connection;
import soc.server.genericServer.InboundMessageQueue;
import soc.server.genericServer.NetConnection;
import soc.server.genericServer.NetServerSocket;
import soc.server.genericServer.SOCServerSocket;
import soc.server.genericServer.StringConnection;
import soc.server.genericServer.StringServerSocket;

public abstract class Server
extends Thread
implements Serializable,
Cloneable {
    SOCServerSocket ss;
    protected final Properties props;
    protected final InboundMessageDispatcher inboundMsgDispatcher;
    boolean up = false;
    protected Exception error = null;
    protected int port;
    protected String strSocketName;
    public static final int CLI_VERSION_SET_CONSIS_CHECK_MINUTES = 33;
    public static final int CLI_VERSION_SET_CONSIS_CHECK_QUICK_COUNT = 5;
    protected int numberOfConnections = 0;
    protected int numberCurrentConnections = 0;
    protected Hashtable<Object, Connection> conns = new Hashtable();
    protected Vector<Connection> unnamedConns = new Vector();
    private HashMap<String, String> connNames = new HashMap();
    public final InboundMessageQueue inQueue;
    private TreeMap<Integer, ConnVersionCounter> cliVersionsConnected = new TreeMap();
    private int cliVersionMin;
    private int cliVersionMax;
    private int cliVersionsConnectedQuickCheckCount = 0;
    public Timer utilTimer = new Timer(true);
    public HashMap<Object, ConnExcepDelayedPrintTask> cliConnDisconPrintsPending = new HashMap();
    public static int CLI_DISCON_PRINT_TIMER_FIRE_MS = 1300;
    public static int CLI_CONN_PRINT_TIMER_FIRE_MS = 1000;

    public Server(int port, InboundMessageDispatcher imd, Properties props) throws IllegalArgumentException {
        if (imd == null) {
            throw new IllegalArgumentException("imd null");
        }
        if (props == null) {
            props = new Properties();
        }
        this.props = props;
        this.port = port;
        this.strSocketName = null;
        this.inboundMsgDispatcher = imd;
        this.inQueue = new InboundMessageQueue(imd);
        try {
            this.ss = new NetServerSocket(port, this);
        }
        catch (IOException e) {
            System.err.println("Could not listen on port " + port + ": " + e);
            this.error = e;
        }
        this.setName("server-" + port);
        this.initMisc();
    }

    public Server(String stringSocketName, InboundMessageDispatcher imd, Properties props) throws IllegalArgumentException {
        if (stringSocketName == null) {
            throw new IllegalArgumentException("stringSocketName null");
        }
        if (imd == null) {
            throw new IllegalArgumentException("imd null");
        }
        if (props == null) {
            props = new Properties();
        }
        this.props = props;
        this.port = -1;
        this.strSocketName = stringSocketName;
        this.inboundMsgDispatcher = imd;
        this.inQueue = new InboundMessageQueue(imd);
        this.ss = new StringServerSocket(stringSocketName);
        this.setName("server-localstring-" + stringSocketName);
        this.initMisc();
    }

    private void initMisc() {
        if (this.error != null) {
            return;
        }
        ConnVersionSetCheckerTask cvChkTask = new ConnVersionSetCheckerTask(this);
        this.utilTimer.schedule((TimerTask)cvChkTask, 0L, 1980000L);
    }

    public Connection getConnection(String connName) {
        if (connName != null) {
            return this.conns.get(connName);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection(String connName, boolean isCaseSensitive) {
        if (!isCaseSensitive && connName != null) {
            Vector<Connection> vector = this.unnamedConns;
            synchronized (vector) {
                connName = this.connNames.get(connName.toLowerCase(Locale.US));
            }
        }
        if (connName != null) {
            return this.getConnection(connName);
        }
        return null;
    }

    protected Enumeration<Connection> getConnections() {
        return this.conns.elements();
    }

    public int getPort() {
        return this.port;
    }

    public String getLocalSocketName() {
        return this.strSocketName;
    }

    public final int getConfigIntProperty(String pName, int pDefault) {
        try {
            String mcs = this.props.getProperty(pName);
            if (mcs != null) {
                return Integer.parseInt(mcs);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return pDefault;
    }

    public final boolean getConfigBoolProperty(String pName, boolean pDefault) {
        try {
            String mcs = this.props.getProperty(pName);
            if (mcs == null) {
                return pDefault;
            }
            if (mcs.equalsIgnoreCase("Y") || mcs.equalsIgnoreCase("T")) {
                return true;
            }
            if (mcs.equalsIgnoreCase("N") || mcs.equalsIgnoreCase("F")) {
                return false;
            }
            int iv = Integer.parseInt(mcs);
            if (iv == 0) {
                return false;
            }
            if (iv == 1) {
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return pDefault;
    }

    public final int getRunConnectionCount() {
        return this.numberOfConnections;
    }

    public final int getNamedConnectionCount() {
        return this.conns.size();
    }

    public final int getCurrentConnectionCount() {
        return this.numberCurrentConnections;
    }

    public synchronized boolean isUp() {
        return this.up;
    }

    @Override
    public void run() {
        if (this.error != null) {
            return;
        }
        this.up = true;
        this.serverUp();
        this.inQueue.startMessageProcessing();
        while (this.isUp()) {
            block10: {
                try {
                    while (this.isUp()) {
                        Connection connection = this.ss.accept();
                        if (this.port != -1) {
                            new Thread((NetConnection)connection).start();
                            continue;
                        }
                        StringConnection localConnection = (StringConnection)connection;
                        localConnection.setServer(this);
                        new Thread(localConnection).start();
                    }
                }
                catch (IOException e) {
                    this.error = e;
                    if (!this.up) break block10;
                    D.ebugPrintlnINFO("Exception " + e + " during accept");
                }
            }
            try {
                this.ss.close();
                if (!this.up) continue;
                if (this.strSocketName == null) {
                    this.ss = new NetServerSocket(this.port, this);
                    continue;
                }
                this.ss = new StringServerSocket(this.strSocketName);
            }
            catch (IOException e) {
                if (this.up) {
                    System.err.println("Could not listen on port " + this.port + ": " + e);
                    this.up = false;
                }
                this.inQueue.stopMessageProcessing();
                this.error = e;
            }
        }
    }

    public boolean processFirstCommand(SOCMessage mes, Connection con) {
        return false;
    }

    protected void serverUp() {
    }

    protected void serverDown() {
    }

    protected boolean newConnection1(Connection c) {
        return true;
    }

    protected void newConnection2(Connection c) {
    }

    protected void leaveConnection(Connection c) {
    }

    public synchronized void stopServer() {
        this.up = false;
        this.inQueue.stopMessageProcessing();
        this.serverDown();
        Enumeration<Connection> e = this.conns.elements();
        while (e.hasMoreElements()) {
            e.nextElement().disconnect();
        }
        if (this.ss != null) {
            try {
                this.ss.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.conns.clear();
        this.connNames.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnection(Connection c, boolean doCleanup) {
        Exception cerr;
        String connName = c.getData();
        Vector<Connection> vector = this.unnamedConns;
        synchronized (vector) {
            if (connName != null) {
                Connection connNameConn = this.conns.get(connName);
                if (null == connNameConn) {
                    return;
                }
                if (c == connNameConn) {
                    this.conns.remove(connName);
                    this.connNames.remove(connName.toLowerCase(Locale.US));
                }
            } else {
                this.unnamedConns.removeElement(c);
            }
            --this.numberCurrentConnections;
            this.clientVersionRem(c.getVersion());
            c.setVersionTracking(false);
        }
        c.disconnect();
        this.leaveConnection(c);
        if (!(!D.ebugIsEnabled() || (cerr = c.getError()) != null && cerr instanceof SocketTimeoutException && c.wantsHideTimeoutMessage())) {
            if (connName != null) {
                ConnExcepDelayedPrintTask leftMsgTask = new ConnExcepDelayedPrintTask(false, cerr, c);
                this.cliConnDisconPrintsPending.put(connName, leftMsgTask);
                this.utilTimer.schedule((TimerTask)leftMsgTask, CLI_DISCON_PRINT_TIMER_FIRE_MS);
            } else {
                D.ebugPrintlnINFO(c.host() + " left (" + this.getNamedConnectionCount() + "," + this.numberCurrentConnections + ")  " + new Date().toString() + (cerr != null ? ": " + cerr.toString() : ""));
            }
        }
        if (doCleanup) {
            this.removeConnectionCleanup(c);
        }
    }

    protected void removeConnectionCleanup(Connection c) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnection(Connection c) throws IllegalArgumentException {
        boolean connAccepted;
        Vector<Connection> vector = this.unnamedConns;
        synchronized (vector) {
            if (c.connect()) {
                connAccepted = this.newConnection1(c);
                if (connAccepted) {
                    String connName = c.getData();
                    if (connName != null) {
                        String connNameLower = connName.toLowerCase(Locale.US);
                        if (this.connNames.containsKey(connNameLower)) {
                            throw new IllegalArgumentException("already in connNames: " + connNameLower);
                        }
                        this.conns.put(connName, c);
                        this.connNames.put(connNameLower, connName);
                    } else {
                        this.unnamedConns.add(c);
                    }
                    this.clientVersionAdd(c.getVersion());
                    ++this.numberCurrentConnections;
                    c.setVersionTracking(true);
                } else {
                    c.disconnectSoft();
                }
            } else {
                return;
            }
        }
        if (connAccepted) {
            ++this.numberOfConnections;
            if (D.ebugIsEnabled()) {
                ConnExcepDelayedPrintTask cameMsgTask = new ConnExcepDelayedPrintTask(true, null, c);
                this.cliConnDisconPrintsPending.put(c, cameMsgTask);
                this.utilTimer.schedule((TimerTask)cameMsgTask, CLI_CONN_PRINT_TIMER_FIRE_MS);
            }
            this.newConnection2(c);
        } else {
            D.ebugPrintlnINFO(c.host() + " came but rejected (" + this.getNamedConnectionCount() + "," + this.numberCurrentConnections + ")  " + new Date().toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nameConnection(Connection c, boolean isReplacing) throws IllegalArgumentException {
        String connName = c.getData();
        if (connName == null) {
            throw new IllegalArgumentException("null c.getData");
        }
        Vector<Connection> vector = this.unnamedConns;
        synchronized (vector) {
            String connNameLower = connName.toLowerCase(Locale.US);
            if (!isReplacing && this.connNames.containsKey(connNameLower)) {
                throw new IllegalArgumentException("already in connNames: " + connNameLower);
            }
            if (!this.unnamedConns.removeElement(c)) {
                throw new IllegalArgumentException("was not both connected and unnamed");
            }
            this.conns.put(connName, c);
            this.connNames.put(connNameLower, connName);
        }
    }

    public void clientVersionAdd(int cvers) {
        Integer cvkey = cvers;
        ConnVersionCounter cv = this.cliVersionsConnected.get(cvkey);
        if (cv != null) {
            ++cv.cliCount;
            return;
        }
        cv = new ConnVersionCounter(cvers);
        this.cliVersionsConnected.put(cvkey, cv);
        if (1 == this.cliVersionsConnected.size()) {
            this.cliVersionMin = cvers;
            this.cliVersionMax = cvers;
        } else if (cvers < this.cliVersionMin) {
            this.cliVersionMin = cvers;
        } else if (cvers > this.cliVersionMax) {
            this.cliVersionMax = cvers;
        }
    }

    public void clientVersionRem(int cvers) {
        Integer cvkey = cvers;
        ConnVersionCounter cv = this.cliVersionsConnected.get(cvkey);
        if (cv == null) {
            this.clientVersionRebuildMap(null);
            return;
        }
        --cv.cliCount;
        if (cv.cliCount > 0) {
            return;
        }
        this.cliVersionsConnected.remove(cvkey);
        if (this.cliVersionsConnected.size() == 0) {
            return;
        }
        if (cv.cliCount < 0) {
            this.clientVersionRebuildMap(null);
            return;
        }
        if (cvers == this.cliVersionMin) {
            this.cliVersionMin = this.cliVersionsConnected.firstKey();
        } else if (cvers == this.cliVersionMax) {
            this.cliVersionMax = this.cliVersionsConnected.lastKey();
        }
    }

    public int getMinConnectedCliVersion() {
        return this.cliVersionMin;
    }

    public int getMaxConnectedCliVersion() {
        return this.cliVersionMax;
    }

    public boolean isCliVersionConnected(int cvers) {
        ConnVersionCounter cv = this.cliVersionsConnected.get(cvers);
        return cv != null && cv.cliCount > 0;
    }

    private TreeMap<Integer, ConnVersionCounter> clientVersionBuildMap() {
        int cvers;
        int lastVers = 0;
        Integer cvkey = null;
        ConnVersionCounter cvc = null;
        TreeMap<Integer, ConnVersionCounter> cvmap = new TreeMap<Integer, ConnVersionCounter>();
        Enumeration<Connection> e = this.getConnections();
        while (e.hasMoreElements()) {
            cvers = e.nextElement().getVersion();
            if ((cvkey == null || cvers != lastVers) && (cvc = cvmap.get(cvkey = Integer.valueOf(cvers))) == null) {
                cvc = new ConnVersionCounter(cvers);
                cvmap.put(cvkey, cvc);
                --cvc.cliCount;
            }
            ++cvc.cliCount;
            lastVers = cvers;
        }
        e = this.unnamedConns.elements();
        while (e.hasMoreElements()) {
            cvers = e.nextElement().getVersion();
            if ((cvkey == null || cvers != lastVers) && (cvc = cvmap.get(cvkey = Integer.valueOf(cvers))) == null) {
                cvc = new ConnVersionCounter(cvers);
                cvmap.put(cvkey, cvc);
                --cvc.cliCount;
            }
            ++cvc.cliCount;
            lastVers = cvers;
        }
        return cvmap;
    }

    private boolean clientVersionCheckMap(TreeMap<Integer, ConnVersionCounter> tree2, boolean fullCheck) {
        block9: {
            if (fullCheck) {
                if (tree2 == null) {
                    tree2 = this.clientVersionBuildMap();
                }
                if (tree2.size() != this.cliVersionsConnected.size()) {
                    return false;
                }
            }
            try {
                Iterator<ConnVersionCounter> cve2;
                int cliCount = 0;
                Iterator<ConnVersionCounter> cve1 = this.cliVersionsConnected.values().iterator();
                Iterator<ConnVersionCounter> iterator = cve2 = fullCheck ? tree2.values().iterator() : null;
                while (cve1.hasNext()) {
                    ConnVersionCounter cvc1 = cve1.next();
                    if (fullCheck) {
                        ConnVersionCounter cvc2 = cve2.next();
                        if (cvc1.vers == cvc2.vers && cvc1.cliCount == cvc2.cliCount) continue;
                        return false;
                    }
                    cliCount += cvc1.cliCount;
                }
                if (fullCheck) {
                    if (cve2.hasNext()) {
                        return false;
                    }
                    break block9;
                }
                return cliCount == this.numberCurrentConnections;
            }
            catch (Throwable t) {
                return false;
            }
        }
        return true;
    }

    private void clientVersionRebuildMap(TreeMap<Integer, ConnVersionCounter> newTree) {
        int cvers;
        if (newTree == null) {
            newTree = this.clientVersionBuildMap();
        }
        this.cliVersionsConnected = newTree;
        this.cliVersionsConnectedQuickCheckCount = 0;
        int treeSize = this.cliVersionsConnected.size();
        if (treeSize == 0) {
            return;
        }
        this.cliVersionMin = cvers = this.cliVersionsConnected.firstKey().intValue();
        this.cliVersionMax = 1 == treeSize ? cvers : this.cliVersionsConnected.lastKey();
    }

    private synchronized void broadcast(String m) throws IllegalArgumentException {
        if (m == null) {
            throw new IllegalArgumentException("m null");
        }
        Enumeration<Connection> e = this.getConnections();
        while (e.hasMoreElements()) {
            e.nextElement().put(m);
        }
        e = this.unnamedConns.elements();
        while (e.hasMoreElements()) {
            e.nextElement().put(m);
        }
    }

    public synchronized void broadcast(SOCMessage m) throws IllegalArgumentException {
        if (m == null) {
            throw new IllegalArgumentException("m null");
        }
        this.broadcast(m.toCmd());
    }

    private synchronized void broadcastToVers(String m, int vmin, int vmax) throws IllegalArgumentException {
        int cvers;
        Connection c;
        if (m == null) {
            throw new IllegalArgumentException("m null");
        }
        if (vmin > vmax) {
            return;
        }
        Enumeration<Connection> e = this.getConnections();
        while (e.hasMoreElements()) {
            c = e.nextElement();
            cvers = c.getVersion();
            if (cvers < vmin || cvers > vmax) continue;
            c.put(m);
        }
        e = this.unnamedConns.elements();
        while (e.hasMoreElements()) {
            c = e.nextElement();
            cvers = c.getVersion();
            if (cvers < vmin || cvers > vmax) continue;
            c.put(m);
        }
    }

    public synchronized void broadcastToVers(SOCMessage m, int vmin, int vmax) throws IllegalArgumentException {
        if (m == null) {
            throw new IllegalArgumentException("m null");
        }
        this.broadcastToVers(m.toCmd(), vmin, vmax);
    }

    protected class ConnExcepDelayedPrintTask
    extends TimerTask {
        public Throwable excep;
        public String connName;
        public String connHost;
        public boolean isArriveNotDepart;
        public Connection arrivingConn;
        public long thrownAt;

        public ConnExcepDelayedPrintTask(boolean isArrival, Throwable ex, Connection c) throws IllegalArgumentException {
            if (!D.ebugIsEnabled()) {
                return;
            }
            if (c == null) {
                throw new IllegalArgumentException("null conn");
            }
            this.excep = ex;
            this.thrownAt = System.currentTimeMillis();
            this.isArriveNotDepart = isArrival;
            this.connHost = c.host();
            this.connName = c.getData();
            if (isArrival) {
                this.arrivingConn = c;
            } else if (this.connName == null) {
                throw new IllegalArgumentException("null c.getData");
            }
        }

        @Override
        public void run() {
            if (this.isArriveNotDepart) {
                D.ebugPrintlnINFO(this.connHost + " came (" + Server.this.getNamedConnectionCount() + "," + Server.this.numberCurrentConnections + ")  " + new Date(this.thrownAt).toString());
                Server.this.cliConnDisconPrintsPending.remove(this.arrivingConn);
            } else {
                D.ebugPrintlnINFO(this.connHost + " left (" + Server.this.getNamedConnectionCount() + "," + Server.this.numberCurrentConnections + ")  " + new Date(this.thrownAt).toString() + (this.excep != null ? ": " + this.excep.toString() : ""));
                Server.this.cliConnDisconPrintsPending.remove(this.connName);
            }
        }
    }

    private static class ConnVersionSetCheckerTask
    extends TimerTask {
        private Server srv;

        public ConnVersionSetCheckerTask(Server s) {
            this.srv = s;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean wantsFull = this.srv.cliVersionsConnectedQuickCheckCount >= 5;
            Vector<Connection> vector = this.srv.unnamedConns;
            synchronized (vector) {
                TreeMap tree2 = wantsFull ? this.srv.clientVersionBuildMap() : null;
                boolean checkPassed = this.srv.clientVersionCheckMap(tree2, wantsFull);
                if (!checkPassed) {
                    this.srv.clientVersionRebuildMap(tree2);
                } else if (wantsFull) {
                    this.srv.cliVersionsConnectedQuickCheckCount = 0;
                } else {
                    this.srv.cliVersionsConnectedQuickCheckCount++;
                }
            }
        }
    }

    private static class ConnVersionCounter
    implements Comparable<ConnVersionCounter> {
        public final int vers;
        public int cliCount;

        public ConnVersionCounter(int version) {
            this.vers = version;
            this.cliCount = 1;
        }

        public boolean equals(Object o) {
            return o instanceof ConnVersionCounter && this.vers == ((ConnVersionCounter)o).vers;
        }

        @Override
        public int compareTo(ConnVersionCounter cvc) {
            return this.vers - cvc.vers;
        }
    }

    public static interface InboundMessageDispatcher {
        public void dispatch(SOCMessage var1, Connection var2) throws IllegalStateException;
    }
}

