/*
 * Decompiled with CFR 0.152.
 */
package soc.server.genericServer;

import java.io.EOFException;
import java.net.ConnectException;
import java.util.Date;
import java.util.Vector;
import soc.disableDebug.D;
import soc.message.SOCMessage;
import soc.server.genericServer.Connection;
import soc.server.genericServer.InboundMessageQueue;
import soc.server.genericServer.Server;
import soc.server.genericServer.StringServerSocket;

public class StringConnection
extends Connection
implements Runnable {
    protected static String EOF_MARKER = "__EOF_MARKER__\u0004";
    protected Vector<String> in;
    protected Vector<String> out;
    protected boolean in_reachedEOF;
    protected boolean out_setEOF;
    protected boolean accepted;
    private StringConnection ourPeer;

    public StringConnection() {
        this.in = new Vector();
        this.out = new Vector();
        this.init();
    }

    public StringConnection(StringConnection peer) throws EOFException {
        if (peer == null) {
            throw new IllegalArgumentException("peer null");
        }
        if (peer.ourPeer != null) {
            throw new IllegalArgumentException("peer already has a peer");
        }
        if (peer.isOutEOF() || peer.isInEOF()) {
            throw new EOFException("peer EOF at constructor");
        }
        this.in = peer.out;
        this.out = peer.in;
        peer.ourPeer = this;
        this.ourPeer = peer;
        this.init();
    }

    private void init() {
        this.in_reachedEOF = false;
        this.out_setEOF = false;
        this.accepted = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readNext() throws EOFException, IllegalStateException {
        String obj;
        if (!this.accepted) {
            this.error = new IllegalStateException("Not accepted by server yet");
            throw (IllegalStateException)this.error;
        }
        if (this.in_reachedEOF) {
            this.error = new EOFException();
            throw (EOFException)this.error;
        }
        Vector<String> vector = this.in;
        synchronized (vector) {
            while (this.in.isEmpty()) {
                if (this.in_reachedEOF) {
                    this.error = new EOFException();
                    throw (EOFException)this.error;
                }
                try {
                    this.in.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            obj = this.in.elementAt(0);
            this.in.removeElementAt(0);
            if (obj == EOF_MARKER) {
                this.in_reachedEOF = true;
                if (this.ourServer != null) {
                    this.ourServer.removeConnection(this, false);
                }
                this.error = new EOFException();
                throw (EOFException)this.error;
            }
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(String dat) throws IllegalArgumentException, IllegalStateException {
        if (dat == null) {
            throw new IllegalArgumentException("null");
        }
        if (!this.accepted && this.data == null) {
            this.error = new IllegalStateException("Not accepted by server yet");
            throw (IllegalStateException)this.error;
        }
        if (this.out_setEOF) {
            return;
        }
        Vector<String> vector = this.out;
        synchronized (vector) {
            this.out.addElement(dat);
            this.out.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() {
        if (!this.accepted) {
            return;
        }
        D.ebugPrintlnINFO("DISCONNECTING " + this.data);
        this.accepted = false;
        Vector<String> vector = this.out;
        synchronized (vector) {
            this.out.clear();
            this.out.addElement(EOF_MARKER);
            this.out_setEOF = true;
            this.out.notifyAll();
        }
        this.disconnectSoft();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnectSoft() {
        if (this.in_reachedEOF) {
            return;
        }
        D.ebugPrintlnINFO("DISCONNECTING(SOFT) " + this.data);
        Vector<String> vector = this.in;
        synchronized (vector) {
            this.in.clear();
            this.in.addElement(EOF_MARKER);
            this.in_reachedEOF = true;
            this.in.notifyAll();
        }
    }

    public void connect(String serverSocketName) throws ConnectException, IllegalStateException {
        if (this.accepted) {
            throw new IllegalStateException("Already accepted by a server");
        }
        StringServerSocket.connectTo(serverSocketName, this);
        this.connectTime = new Date();
        this.accepted = true;
    }

    public StringConnection getPeer() {
        return this.ourPeer;
    }

    public boolean isAccepted() {
        return this.accepted;
    }

    public void setAccepted() throws IllegalStateException {
        if (this.ourPeer == null) {
            throw new IllegalStateException("No peer, can't be accepted");
        }
        if (this.accepted) {
            throw new IllegalStateException("Already accepted");
        }
        if (!this.out_setEOF && !this.in_reachedEOF) {
            this.accepted = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEOF() {
        Vector<String> vector = this.out;
        synchronized (vector) {
            this.out.addElement(EOF_MARKER);
            this.out_setEOF = true;
            this.out.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInEOF() {
        Vector<String> vector = this.in;
        synchronized (vector) {
            return this.in_reachedEOF;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOutEOF() {
        Vector<String> vector = this.out;
        synchronized (vector) {
            return this.out_setEOF;
        }
    }

    public Server getServer() {
        return this.ourServer;
    }

    public void setServer(Server srv) {
        this.ourServer = srv;
    }

    @Override
    public String host() {
        return "localhost";
    }

    @Override
    public boolean connect() {
        return this.accepted;
    }

    @Override
    public boolean isConnected() {
        return this.accepted && !this.out_setEOF && !this.in_reachedEOF;
    }

    @Override
    public boolean isInputAvailable() {
        return !this.in_reachedEOF && 0 < this.in.size();
    }

    @Override
    public void run() {
        Thread.currentThread().setName("connection-srv-localstring");
        if (this.ourServer == null) {
            return;
        }
        this.ourServer.addConnection(this);
        try {
            String firstMsg;
            SOCMessage msgObj;
            InboundMessageQueue inQueue = this.ourServer.inQueue;
            if (!this.in_reachedEOF && !this.ourServer.processFirstCommand(msgObj = SOCMessage.toMsg(firstMsg = this.readNext()), this) && msgObj != null) {
                inQueue.push(msgObj, this);
            }
            while (!this.in_reachedEOF) {
                String msgStr = this.readNext();
                msgObj = SOCMessage.toMsg(msgStr);
                if (msgObj == null) continue;
                inQueue.push(msgObj, this);
            }
        }
        catch (Exception e) {
            D.ebugPrintlnINFO("Exception in StringConnection.run - " + e);
            if (this.in_reachedEOF) {
                return;
            }
            this.error = e;
            this.ourServer.removeConnection(this, false);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("StringConnection[");
        if (this.data != null) {
            sb.append(this.data);
        } else {
            sb.append(super.hashCode());
        }
        sb.append(']');
        return sb.toString();
    }
}

