/*
 * Decompiled with CFR 0.152.
 */
package soc.server.genericServer;

import java.io.EOFException;
import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import soc.server.genericServer.Connection;
import soc.server.genericServer.SOCServerSocket;
import soc.server.genericServer.StringConnection;

public class StringServerSocket
implements SOCServerSocket {
    protected static Hashtable<String, StringServerSocket> allSockets = new Hashtable();
    public static int ACCEPT_QUEUELENGTH = 100;
    protected Vector<StringConnection> allConnected;
    protected Vector<StringConnection> acceptQueue;
    private String socketName;
    boolean out_setEOF;
    private Object sync_out_setEOF;

    public StringServerSocket(String name) {
        this.socketName = name;
        this.allConnected = new Vector();
        this.acceptQueue = new Vector();
        this.out_setEOF = false;
        this.sync_out_setEOF = new Object();
        allSockets.put(name, this);
    }

    public static StringConnection connectTo(String name) throws ConnectException, IllegalArgumentException {
        return StringServerSocket.connectTo(name, new StringConnection());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StringConnection connectTo(String name, StringConnection client) throws ConnectException, IllegalArgumentException {
        StringConnection servSidePeer;
        if (name == null) {
            throw new IllegalArgumentException("name null");
        }
        if (client == null) {
            throw new IllegalArgumentException("client null");
        }
        if (client.getPeer() != null) {
            throw new IllegalArgumentException("client already peered");
        }
        if (!allSockets.containsKey(name)) {
            throw new ConnectException("StringServerSocket name not found: " + name);
        }
        StringServerSocket ss = allSockets.get(name);
        if (ss.isOutEOF()) {
            throw new ConnectException("StringServerSocket already EOF: " + name);
        }
        try {
            servSidePeer = ss.queueAcceptClient(client);
        }
        catch (ConnectException ce) {
            throw ce;
        }
        catch (Throwable t) {
            ConnectException ce = new ConnectException("Error queueing to accept for " + name);
            ce.initCause(t);
            throw ce;
        }
        StringConnection stringConnection = servSidePeer;
        synchronized (stringConnection) {
            if (!servSidePeer.isAccepted()) {
                try {
                    servSidePeer.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        if (client != servSidePeer.getPeer()) {
            throw new IllegalStateException("Internal error: Peer is wrong");
        }
        if (client.isOutEOF()) {
            throw new ConnectException("Server at EOF, closed waiting to be accepted");
        }
        return client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StringConnection queueAcceptClient(StringConnection client) throws IllegalStateException, IllegalArgumentException, ConnectException, EOFException {
        if (this.isOutEOF()) {
            throw new IllegalStateException("Internal error, already at EOF");
        }
        if (client.isAccepted()) {
            throw new IllegalArgumentException("Client is already accepted somewhere");
        }
        if (client.isOutEOF() || client.isInEOF()) {
            throw new EOFException("client is already at EOF");
        }
        StringConnection serverPeer = new StringConnection(client);
        Vector<StringConnection> vector = this.acceptQueue;
        synchronized (vector) {
            if (this.acceptQueue.size() > ACCEPT_QUEUELENGTH) {
                throw new ConnectException("Server accept queue is full");
            }
            this.acceptQueue.add(client);
            this.acceptQueue.notifyAll();
        }
        return serverPeer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection accept() throws SocketException, IOException {
        StringConnection cliPeer;
        if (this.out_setEOF) {
            throw new SocketException("Server socket already at EOF");
        }
        Vector<StringConnection> vector = this.acceptQueue;
        synchronized (vector) {
            while (this.acceptQueue.isEmpty()) {
                if (this.out_setEOF) {
                    throw new SocketException("Server socket already at EOF");
                }
                try {
                    this.acceptQueue.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            cliPeer = this.acceptQueue.elementAt(0);
            this.acceptQueue.removeElementAt(0);
        }
        StringConnection servPeer = cliPeer.getPeer();
        cliPeer.setAccepted();
        if (this.out_setEOF) {
            servPeer.disconnect();
            cliPeer.disconnect();
        }
        StringConnection stringConnection = servPeer;
        synchronized (stringConnection) {
            if (!this.out_setEOF) {
                servPeer.setAccepted();
            }
            servPeer.notifyAll();
        }
        if (this.out_setEOF) {
            throw new SocketException("Server socket already at EOF");
        }
        this.allConnected.addElement(servPeer);
        return servPeer;
    }

    public Enumeration<StringConnection> allClients() {
        return this.allConnected.elements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnectEOFClients() {
        Vector<StringConnection> vector = this.allConnected;
        synchronized (vector) {
            for (int i = this.allConnected.size() - 1; i >= 0; --i) {
                StringConnection servPeer = this.allConnected.elementAt(i);
                if (!servPeer.isInEOF()) continue;
                this.allConnected.removeElementAt(i);
                servPeer.setEOF();
            }
        }
    }

    public String getSocketName() {
        return this.socketName;
    }

    public void setEOF() {
        this.setEOF(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setEOF(boolean forceDisconnect) {
        Object object = this.sync_out_setEOF;
        synchronized (object) {
            this.out_setEOF = true;
        }
        Enumeration<StringConnection> connected = this.allConnected.elements();
        while (connected.hasMoreElements()) {
            if (forceDisconnect) {
                connected.nextElement().disconnect();
                continue;
            }
            connected.nextElement().setEOF();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOutEOF() {
        Object object = this.sync_out_setEOF;
        synchronized (object) {
            return this.out_setEOF;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        this.setEOF(true);
        for (StringConnection cliPeer : this.acceptQueue) {
            cliPeer.disconnect();
            StringConnection stringConnection = cliPeer;
            synchronized (stringConnection) {
                cliPeer.notifyAll();
            }
        }
    }
}

