/*
 * Decompiled with CFR 0.152.
 */
package soc.server.savegame;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import soc.game.SOCGame;
import soc.game.SOCGameOptionVersionException;
import soc.game.SOCPlayer;
import soc.message.SOCGameElements;
import soc.message.SOCPlayerElement;
import soc.server.SOCServer;
import soc.server.savegame.SavedGameModel;

public class GameLoaderJSON {
    public static final SOCGame dummyGame = new SOCGame("dummy", false);
    public static final SOCPlayer dummyPlayer = new SOCPlayer(-2, dummyGame);
    private static GsonBuilder gsonb;

    public static SavedGameModel loadGame(File loadFrom, SOCServer srv) throws NoSuchElementException, SOCGameOptionVersionException, SavedGameModel.UnsupportedSGMOperationException, StringIndexOutOfBoundsException, IOException, IllegalArgumentException {
        SavedGameModel sgm;
        if (srv == null) {
            throw new IllegalArgumentException("srv");
        }
        GameLoaderJSON.initGson();
        try (FileInputStream fis = new FileInputStream(loadFrom);
             InputStreamReader reader = new InputStreamReader((InputStream)fis, "UTF-8");){
            sgm = (SavedGameModel)gsonb.create().fromJson((Reader)reader, SavedGameModel.class);
        }
        catch (JsonIOException e) {
            throw new IOException("JSON: " + e.getMessage(), e);
        }
        catch (JsonSyntaxException e) {
            StringIndexOutOfBoundsException wrap = new StringIndexOutOfBoundsException("JSON: " + e.getMessage());
            wrap.initCause(e);
            throw wrap;
        }
        sgm.createLoadedGame(srv);
        return sgm;
    }

    private static void initGson() {
        GsonBuilder gb = gsonb;
        if (gb != null) {
            return;
        }
        gb = new GsonBuilder();
        SavedGameModel.initGsonRegisterAdapters(gb);
        gb.registerTypeAdapter(new TypeToken<HashMap<SOCGameElements.GEType, Integer>>(){}.getType(), new EnumKeyedMapDeserializer<SOCGameElements.GEType>(SOCGameElements.GEType.class));
        gb.registerTypeAdapter(new TypeToken<HashMap<SOCPlayerElement.PEType, Integer>>(){}.getType(), new EnumKeyedMapDeserializer<SOCPlayerElement.PEType>(SOCPlayerElement.PEType.class));
        gsonb = gb;
    }

    public static class EnumKeyedMapDeserializer<E extends Enum<E>>
    implements JsonDeserializer<HashMap<E, Integer>> {
        private final Class<E> enumClassType;

        EnumKeyedMapDeserializer(Class<E> enumClass) {
            this.enumClassType = enumClass;
        }

        public HashMap<E, Integer> deserialize(JsonElement elem, Type t, JsonDeserializationContext ctx) throws JsonParseException {
            HashMap<E, Integer> ret = new HashMap<E, Integer>();
            for (Map.Entry ent : elem.getAsJsonObject().entrySet()) {
                E ev;
                String key = (String)ent.getKey();
                if (key == null) continue;
                try {
                    ev = Enum.valueOf(this.enumClassType, key);
                    if (ev == null) {
                    }
                }
                catch (IllegalArgumentException e) {}
                continue;
                JsonElement val = (JsonElement)ent.getValue();
                try {
                    ret.put(ev, val.getAsInt());
                }
                catch (ClassCastException | IllegalStateException e) {
                    throw new JsonParseException("Expected int values in map", (Throwable)e);
                }
            }
            return ret;
        }
    }
}

