/*
 * Decompiled with CFR 0.152.
 */
package soc.server.savegame;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import soc.game.SOCGame;
import soc.server.SOCServer;
import soc.server.savegame.SavedGameModel;

public class GameSaverJSON {
    public static final String FILENAME_EXTENSION = ".game.json";

    public static void saveGame(SOCGame ga, File saveDir, String saveFilename, SOCServer srv) throws IllegalArgumentException, SavedGameModel.UnsupportedSGMOperationException, IllegalStateException, IOException {
        Gson gson;
        if (!saveDir.isDirectory()) {
            throw new IllegalArgumentException("Not found as directory: " + saveDir.getPath());
        }
        SavedGameModel sgm = new SavedGameModel(ga, srv);
        try {
            GsonBuilder gb = new GsonBuilder();
            SavedGameModel.initGsonRegisterAdapters(gb);
            gson = gb.setPrettyPrinting().create();
        }
        catch (Throwable th) {
            throw new IOException("failed to load Gson class: " + th, th);
        }
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(new File(saveDir, saveFilename)), "UTF-8");){
            gson.toJson((Object)sgm, (Appendable)writer);
        }
    }
}

