/*
 * Decompiled with CFR 0.152.
 */
package soc.server.savegame;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import soc.baseclient.SOCDisplaylessPlayerClient;
import soc.game.GameAction;
import soc.game.ResourceSet;
import soc.game.SOCBoard;
import soc.game.SOCBoardLarge;
import soc.game.SOCCity;
import soc.game.SOCDevCard;
import soc.game.SOCGame;
import soc.game.SOCGameOption;
import soc.game.SOCGameOptionSet;
import soc.game.SOCGameOptionVersionException;
import soc.game.SOCInventory;
import soc.game.SOCInventoryItem;
import soc.game.SOCPlayer;
import soc.game.SOCPlayingPiece;
import soc.game.SOCResourceSet;
import soc.game.SOCRoad;
import soc.game.SOCSettlement;
import soc.game.SOCShip;
import soc.game.SOCTradeOffer;
import soc.message.SOCBoardLayout;
import soc.message.SOCBoardLayout2;
import soc.message.SOCGameElements;
import soc.message.SOCMessage;
import soc.message.SOCPlayerElement;
import soc.message.SOCPotentialSettlements;
import soc.server.SOCClientData;
import soc.server.SOCGameHandler;
import soc.server.SOCGameListAtServer;
import soc.server.SOCServer;
import soc.server.genericServer.Server;
import soc.server.savegame.GameLoaderJSON;
import soc.util.SOCRobotParameters;
import soc.util.Version;

public class SavedGameModel {
    public static final int MODEL_VERSION = 2400;
    public transient SOCGameListAtServer glas;
    public static Random rand = new Random();
    private transient SOCGame game = null;
    public transient boolean warnHasHumanPlayerWithBotName;
    public transient int warnDevCardDeckUnknownTypeAtIndex = -1;
    public int modelVersion;
    public int savedByVersion;
    public int gameMinVersion;
    public String gameName;
    public String comments;
    public String author;
    public String gameOptions;
    public int gameDurationSeconds;
    public int gameState;
    public int oldGameState;
    public int currentDice;
    public HashMap<SOCGameElements.GEType, Integer> elements = new HashMap();
    @JsonAdapter(value=DevCardEnumListAdapter.class)
    public ArrayList<Integer> devCardDeck;
    public boolean placingRobberForKnightCard;
    public boolean robberyWithPirateNotRobber;
    public boolean askedSpecialBuildPhase;
    public boolean movedShipThisTurn;
    public boolean playingRoadBuildingCardForLastRoad;
    public List<Integer> shipsPlacedThisTurn;
    public GameAction lastAction;
    public BoardInfo boardInfo;
    public SOCGame.SeatLockState[] playerSeatLocks;
    public PlayerInfo[] playerSeats;
    private static Pattern REGEX_NAME_ENDS_WITH_DIGITS = Pattern.compile("^(.+?)(\\d+)$");

    public static void checkCanSave(SOCGame ga) throws UnsupportedSGMOperationException {
        String sc = ga.getGameOptionStringValue("SC");
        if (null == sc) {
            return;
        }
        String unsuppOpt = SavedGameModel.checkUnsupportedScenOpts(ga.getGameOptions());
        if (unsuppOpt != null) {
            throw new UnsupportedSGMOperationException("admin.savegame.cannot_save.scen", sc, unsuppOpt);
        }
    }

    private static String checkUnsupportedScenOpts(SOCGameOptionSet opts) {
        if (opts == null) {
            return null;
        }
        for (String okey : opts.keySet()) {
            if (!okey.startsWith("_SC_") || okey.equals("_SC_SEAC") || okey.equals("_SC_SANY") || okey.equals("_SC_FOG")) continue;
            return okey;
        }
        return null;
    }

    static void initGsonRegisterAdapters(GsonBuilder gb) {
        PlayerInfo.initGsonRegisterAdapters(gb);
    }

    public SavedGameModel() {
    }

    public SavedGameModel(SOCGame ga, SOCServer srv) throws UnsupportedSGMOperationException, IllegalStateException, IllegalArgumentException {
        this();
        this.glas = srv.getGameList();
        SavedGameModel.checkCanSave(ga);
        if (ga.getGameState() < 15) {
            throw new IllegalStateException("gameState");
        }
        this.modelVersion = 2400;
        this.savedByVersion = Version.versionNumber();
        this.game = ga;
        this.gameName = ga.getName();
        SOCGameOptionSet opts = ga.getGameOptions();
        if (opts != null) {
            this.gameOptions = SOCGameOption.packOptionsToString(opts.getAll(), false, true);
        }
        this.gameDurationSeconds = ga.getDurationSeconds();
        this.gameState = ga.getGameState();
        this.oldGameState = ga.getOldGameState();
        this.currentDice = ga.getCurrentDice();
        this.gameMinVersion = ga.getClientVersionMinRequired();
        this.devCardDeck = new ArrayList();
        for (int card : ga.getDevCardDeck()) {
            this.devCardDeck.add(card);
        }
        boolean[] flags = ga.getFlagFieldsForSave();
        this.placingRobberForKnightCard = flags[0];
        this.robberyWithPirateNotRobber = flags[1];
        this.askedSpecialBuildPhase = flags[2];
        this.movedShipThisTurn = flags[3];
        this.playingRoadBuildingCardForLastRoad = flags[4];
        this.shipsPlacedThisTurn = ga.getShipsPlacedThisTurn();
        this.lastAction = ga.getLastAction();
        SOCPlayer lrPlayer = ga.getPlayerWithLongestRoad();
        SOCPlayer laPlayer = ga.getPlayerWithLargestArmy();
        this.elements.put(SOCGameElements.GEType.ROUND_COUNT, ga.getRoundCount());
        this.elements.put(SOCGameElements.GEType.FIRST_PLAYER, ga.getFirstPlayer());
        this.elements.put(SOCGameElements.GEType.CURRENT_PLAYER, this.game.getCurrentPlayerNumber());
        this.elements.put(SOCGameElements.GEType.LONGEST_ROAD_PLAYER, lrPlayer != null ? lrPlayer.getPlayerNumber() : -1);
        this.elements.put(SOCGameElements.GEType.LARGEST_ARMY_PLAYER, laPlayer != null ? laPlayer.getPlayerNumber() : -1);
        if (this.gameState == 100) {
            this.elements.put(SOCGameElements.GEType.SPECIAL_BUILDING_AFTER_PLAYER, ga.getSpecialBuildingPlayerNumberAfter());
        }
        this.boardInfo = new BoardInfo(ga);
        this.playerSeatLocks = ga.getSeatLocks();
        this.playerSeats = new PlayerInfo[ga.maxPlayers];
        for (int pn = 0; pn < ga.maxPlayers; ++pn) {
            this.playerSeats[pn] = new PlayerInfo(ga.getPlayer(pn), ga.isSeatVacant(pn), srv);
        }
    }

    public SOCGame getGame() {
        return this.game;
    }

    public boolean[] findSeatsNeedingBots() {
        boolean[] ret = null;
        String gaName = this.game.getName();
        for (int pn = 0; pn < this.game.maxPlayers; ++pn) {
            String plName;
            if (this.playerSeats[pn].isSeatVacant || (plName = this.game.getPlayer(pn).getName()) != null && !plName.isEmpty() && this.glas.isMember(plName, gaName)) continue;
            if (ret == null) {
                ret = new boolean[this.game.maxPlayers];
            }
            ret[pn] = true;
        }
        return ret;
    }

    public SOCGame resumePlay(boolean ignoreConstraints) throws UnsupportedOperationException, MissingResourceException, IllegalStateException {
        int gstate = this.game.getGameState();
        if (gstate != 990 && gstate != 992) {
            throw new UnsupportedOperationException("gameState: " + gstate);
        }
        if (this.gameState != 1000 && null != this.findSeatsNeedingBots()) {
            throw new MissingResourceException("Still need players to fill non-vacant seats", "unused", "unused");
        }
        this.game.lastActionTime = System.currentTimeMillis();
        this.game.setGameState(this.gameState);
        this.game.savedGameModel = null;
        return this.game;
    }

    public void checkCanLoad(SOCGameOptionSet knownOpts) throws NoSuchElementException, SOCGameOptionVersionException, UnsupportedSGMOperationException {
        String unsuppOpt;
        SOCGameOptionSet opts;
        if (this.modelVersion > 2400) {
            throw new NoSuchElementException("model version " + this.modelVersion + " newer than our version " + 2400);
        }
        int serverVersion = Version.versionNumber();
        if (this.gameMinVersion > serverVersion) {
            throw new SOCGameOptionVersionException(this.gameMinVersion, serverVersion, null);
        }
        if (this.gameOptions == null || this.gameOptions.isEmpty()) {
            return;
        }
        try {
            opts = SOCGameOption.parseOptionsToSet(this.gameOptions, knownOpts);
        }
        catch (IllegalArgumentException e) {
            throw new UnsupportedSGMOperationException("Problem opt in gameOptions: " + e.getMessage(), e);
        }
        if (opts == null) {
            if (this.gameOptions != null && !this.gameOptions.isEmpty()) {
                throw new UnsupportedSGMOperationException("Can't parse gameOptions");
            }
            return;
        }
        SOCGameOption oSC = opts.get("SC");
        if (oSC != null && null != oSC.getStringValue() && (unsuppOpt = SavedGameModel.checkUnsupportedScenOpts(opts)) != null) {
            throw new UnsupportedSGMOperationException("admin.savegame.cannot_save.scen", oSC.getStringValue(), unsuppOpt);
        }
    }

    void createLoadedGame(SOCServer srv) throws IllegalStateException, NoSuchElementException, SOCGameOptionVersionException, UnsupportedSGMOperationException, IllegalArgumentException {
        if (this.game != null) {
            throw new IllegalStateException("already called createLoadedGame");
        }
        this.glas = srv.getGameList();
        this.checkCanLoad(srv.knownOpts);
        try {
            int pn;
            SOCGame ga = new SOCGame(this.gameName, SOCGameOption.parseOptionsToSet(this.gameOptions, srv.knownOpts), srv.knownOpts);
            ga.initAtServer();
            ga.setGameState(990);
            if (ga.maxPlayers != this.playerSeats.length) {
                throw new IllegalArgumentException("maxPlayers " + ga.maxPlayers + " != playerSeats.length " + this.playerSeats.length);
            }
            this.game = ga;
            ga.savedGameModel = this;
            if (this.gameState >= 1000) {
                ga.hasDoneGameOverTasks = true;
            }
            ga.setTimeSinceCreated(this.gameDurationSeconds);
            ga.setCurrentDice(this.currentDice);
            if (this.devCardDeck == null) {
                this.devCardDeck = new ArrayList();
            } else {
                int n = this.devCardDeck.size();
                for (int i = 0; i < n; ++i) {
                    int ctype = this.devCardDeck.get(i);
                    if (ctype > 0 && ctype < 10) continue;
                    this.warnDevCardDeckUnknownTypeAtIndex = i;
                    break;
                }
            }
            ga.setFieldsForLoad(this.devCardDeck, this.oldGameState, this.shipsPlacedThisTurn, this.placingRobberForKnightCard, this.robberyWithPirateNotRobber, this.askedSpecialBuildPhase, this.movedShipThisTurn, this.playingRoadBuildingCardForLastRoad);
            if (this.elements != null) {
                for (SOCGameElements.GEType elem : this.elements.keySet()) {
                    SOCDisplaylessPlayerClient.handleGAMEELEMENT(ga, elem, this.elements.get((Object)elem));
                }
            }
            this.boardInfo.loadInto(ga);
            for (pn = 0; pn < ga.maxPlayers; ++pn) {
                String nLower;
                SOCPlayer pl = ga.getPlayer(pn);
                PlayerInfo pinfo = this.playerSeats[pn];
                String pname = pinfo.name;
                if (!pinfo.isSeatVacant) {
                    if (pinfo.isRobot) {
                        pinfo.name = pname = SavedGameModel.checkBotRename(pname, ga, srv);
                    }
                    ga.addPlayer(pname, pn);
                }
                pinfo.loadInto(pl);
                if (pname == null || pinfo.isRobot || !(nLower = pname.toLowerCase(Locale.US)).startsWith("droid ") && !nLower.startsWith("robot ") && !nLower.startsWith("extrabot ")) continue;
                this.warnHasHumanPlayerWithBotName = true;
            }
            if (this.playerSeatLocks != null) {
                for (pn = 0; pn < ga.maxPlayers; ++pn) {
                    SOCGame.SeatLockState lock = this.playerSeatLocks[pn];
                    if (lock == null) continue;
                    ga.setSeatLock(pn, lock);
                }
            }
            for (pn = 0; pn < ga.maxPlayers; ++pn) {
                ga.getPlayer(pn).calcLongestRoad2();
            }
            ga.setLastAction(this.lastAction);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Problem initializing game: " + e, e);
        }
    }

    private static String checkBotRename(String botName, SOCGame ga, Server srv) {
        Matcher m;
        if (!(botName == null || botName.isEmpty() || srv != null && null != srv.getConnection(botName, false))) {
            return botName;
        }
        if (botName != null && (m = REGEX_NAME_ENDS_WITH_DIGITS.matcher(botName)).matches()) {
            String stem = m.group(1);
            String newName = stem + '-' + m.group(2);
            if (null == srv.getConnection(newName, false) && null == ga.getPlayer(newName)) {
                return newName;
            }
            for (int attempt = 0; attempt < 50; ++attempt) {
                newName = stem + '-' + (10000 + rand.nextInt(989999));
                if (null != srv.getConnection(newName, false) || null != ga.getPlayer(newName)) continue;
                return newName;
            }
        }
        for (int attempt = 0; attempt < 250; ++attempt) {
            String newName = "botNameConflict-" + (10000 + rand.nextInt(99989999));
            if (null != srv.getConnection(newName, false) || null != ga.getPlayer(newName)) continue;
            return newName;
        }
        return "botNameConflict-" + botName;
    }

    public static class UnsupportedSGMOperationException
    extends UnsupportedOperationException {
        private static final long serialVersionUID = 2400L;
        public final String param1;
        public final String param2;

        public UnsupportedSGMOperationException(String msg) {
            this(msg, null, null);
        }

        public UnsupportedSGMOperationException(String msg, String param1) {
            this(msg, param1, null);
        }

        public UnsupportedSGMOperationException(String msg, Throwable cause) {
            super(msg, cause);
            this.param1 = null;
            this.param2 = null;
        }

        public UnsupportedSGMOperationException(String msg, String param1, String param2) {
            super(msg);
            this.param1 = param1;
            this.param2 = param2;
        }
    }

    public static abstract class CallbackClassTypeAdapterFactory<C>
    implements TypeAdapterFactory {
        private final Class<C> forClass;

        public CallbackClassTypeAdapterFactory(Class<C> forClass) {
            this.forClass = forClass;
        }

        public final <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            return type.getRawType() == this.forClass ? this.customizeMyClassAdapter(gson, type) : null;
        }

        private TypeAdapter<C> customizeMyClassAdapter(Gson gson, TypeToken<C> type) {
            final TypeAdapter delegate = gson.getDelegateAdapter((TypeAdapterFactory)this, type);
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            return new TypeAdapter<C>(){

                public void write(JsonWriter out, C value) throws IOException {
                    JsonElement tree = delegate.toJsonTree(value);
                    this.beforeWrite(value, tree);
                    elementAdapter.write(out, (Object)tree);
                }

                public C read(JsonReader in) throws IOException {
                    JsonElement tree = (JsonElement)elementAdapter.read(in);
                    Object maybeObj = this.afterRead(tree);
                    return maybeObj != null ? maybeObj : delegate.fromJsonTree(tree);
                }
            };
        }

        protected void beforeWrite(C source, JsonElement serializedTree) throws IOException {
        }

        protected C afterRead(JsonElement deserializedTree) throws IOException {
            return null;
        }
    }

    public static class Constraint {
    }

    static class BoardInfo {
        public SOCBoardLayout layout1;
        public SOCBoardLayout2 layout2;
        public SOCPotentialSettlements[] playerPotentials;
        public HashMap<Integer, Integer> fogHiddenHexes;

        BoardInfo(SOCGame ga) throws IllegalArgumentException {
            HashMap<Integer, Integer> fogHexes;
            SOCMessage m = SOCGameHandler.getBoardLayoutMessage(ga);
            if (m instanceof SOCBoardLayout) {
                this.layout1 = (SOCBoardLayout)m;
            } else if (m instanceof SOCBoardLayout2) {
                this.layout2 = (SOCBoardLayout2)m;
            } else {
                throw new IllegalArgumentException("unexpected boardlayout msg type " + m.getType() + " " + m.getClass().getSimpleName());
            }
            this.playerPotentials = SOCGameHandler.gatherBoardPotentials(ga, Integer.MAX_VALUE);
            SOCBoard board = ga.getBoard();
            if (board instanceof SOCBoardLarge && (fogHexes = ((SOCBoardLarge)board).getFogHiddenHexes()) != null && !fogHexes.isEmpty()) {
                this.fogHiddenHexes = fogHexes;
            }
        }

        void loadInto(SOCGame ga) {
            if (this.layout2 != null) {
                SOCDisplaylessPlayerClient.handleBOARDLAYOUT2(this.layout2, ga);
            } else if (this.layout1 != null) {
                SOCDisplaylessPlayerClient.handleBOARDLAYOUT(this.layout1, ga);
            }
            for (SOCPotentialSettlements potenMsg : this.playerPotentials) {
                SOCDisplaylessPlayerClient.handlePOTENTIALSETTLEMENTS(potenMsg, ga);
            }
            if (this.fogHiddenHexes != null) {
                ((SOCBoardLarge)ga.getBoard()).setFogHiddenHexes(this.fogHiddenHexes);
            }
        }
    }

    public static class TradeTypeStat {
        public static final String[] TYPE_DESCRIPTIONS = new String[]{"3:1 Port", "2:1 Clay port", "2:1 Ore port", "2:1 Sheep port", "2:1 Wheat port", "2:1 Wood port", "4:1 Bank", "All trades with players"};
        public String tradeType;
        public KnownResourceSet gave;
        public KnownResourceSet received;

        public TradeTypeStat(SOCResourceSet gave, SOCResourceSet received, String tradeType) {
            this.tradeType = tradeType;
            if (gave != null && !gave.isEmpty()) {
                this.gave = new KnownResourceSet(gave);
            }
            if (received != null && !received.isEmpty()) {
                this.received = new KnownResourceSet(received);
            }
        }
    }

    static class TradeOffer {
        public KnownResourceSet give;
        public KnownResourceSet receive;
        public boolean[] offeredTo;
        public long offeredAtDurationMillis;

        public TradeOffer(SOCTradeOffer offer, long offeredAtDurationMillis) throws NullPointerException {
            this.give = new KnownResourceSet(offer.getGiveSet());
            this.receive = new KnownResourceSet(offer.getGetSet());
            this.offeredTo = offer.getTo();
            this.offeredAtDurationMillis = offeredAtDurationMillis;
        }

        public SOCTradeOffer toOffer(SOCPlayer fromPlayer) {
            return new SOCTradeOffer(fromPlayer.getGame().getName(), fromPlayer.getPlayerNumber(), this.offeredTo, this.give.toResourceSet(), this.receive.toResourceSet());
        }
    }

    public static class KnownResourceSet
    implements ResourceSet {
        public int clay;
        public int ore;
        public int sheep;
        public int wheat;
        public int wood;

        public KnownResourceSet(SOCResourceSet rs) {
            this.clay = rs.getAmount(1);
            this.ore = rs.getAmount(2);
            this.sheep = rs.getAmount(3);
            this.wheat = rs.getAmount(4);
            this.wood = rs.getAmount(5);
        }

        public void loadInto(SOCResourceSet rs) {
            rs.setAmounts(this.toResourceSet());
        }

        public SOCResourceSet toResourceSet() {
            return new SOCResourceSet(this.clay, this.ore, this.sheep, this.wheat, this.wood, 0);
        }

        @Override
        public boolean isEmpty() {
            return this.clay == 0 && this.ore == 0 && this.sheep == 0 && this.wheat == 0 && this.wood == 0;
        }

        @Override
        public int getAmount(int resourceType) {
            switch (resourceType) {
                case 1: {
                    return this.clay;
                }
                case 2: {
                    return this.ore;
                }
                case 3: {
                    return this.sheep;
                }
                case 4: {
                    return this.wheat;
                }
                case 5: {
                    return this.wood;
                }
            }
            return 0;
        }

        @Override
        public boolean contains(int resourceType) {
            return this.getAmount(resourceType) > 0;
        }

        @Override
        public boolean contains(ResourceSet rs) {
            for (int rtype = 1; rtype <= 5; ++rtype) {
                if (this.getAmount(rtype) >= rs.getAmount(rtype)) continue;
                return false;
            }
            return true;
        }

        @Override
        public int getResourceTypeCount() {
            return (this.clay > 0 ? 1 : 0) + (this.ore > 0 ? 1 : 0) + (this.sheep > 0 ? 1 : 0) + (this.wheat > 0 ? 1 : 0) + (this.wood > 0 ? 1 : 0);
        }

        @Override
        public int getTotal() {
            return this.clay + this.ore + this.sheep + this.wheat + this.wood;
        }
    }

    private static class DevCardEnumListAdapter
    extends TypeAdapter<ArrayList<Integer>> {
        private DevCardEnumListAdapter() {
        }

        public void write(JsonWriter jw, ArrayList<Integer> devcardTypes) throws IOException {
            if (devcardTypes == null) {
                jw.nullValue();
                return;
            }
            jw.beginArray();
            for (Integer ctype : devcardTypes) {
                jw.value(SOCDevCard.getCardTypeName(ctype));
            }
            jw.endArray();
        }

        public ArrayList<Integer> read(JsonReader jr) throws IOException {
            JsonToken jtype = jr.peek();
            if (jtype == JsonToken.NULL) {
                return null;
            }
            if (jtype != JsonToken.BEGIN_ARRAY) {
                throw new IOException("devcards expected [, not " + jtype);
            }
            ArrayList<Integer> ret = new ArrayList<Integer>();
            jr.beginArray();
            block7: while (jr.hasNext()) {
                jtype = jr.peek();
                switch (jtype) {
                    case NUMBER: {
                        ret.add(jr.nextInt());
                        continue block7;
                    }
                    case NULL: {
                        jr.nextNull();
                        ret.add(0);
                        continue block7;
                    }
                    case STRING: {
                        String v = jr.nextString();
                        try {
                            ret.add(SOCDevCard.getCardType(v));
                            continue block7;
                        }
                        catch (IllegalArgumentException e) {
                            throw new IOException("bad cardtype format: " + v, e);
                        }
                    }
                }
                throw new IOException("devcards expected int or string or ], not " + jtype);
            }
            jr.endArray();
            return ret;
        }
    }

    public static class PlayerInfo {
        public String name;
        public boolean isSeatVacant;
        public int totalVP;
        public boolean isRobot;
        public boolean isBuiltInRobot;
        public boolean isRobotWithSmartStrategy;
        public String robot3rdPartyBrainClass;
        public int faceID;
        public KnownResourceSet resources;
        public HashMap<SOCPlayerElement.PEType, Integer> earlyElements;
        public TradeOffer currentTradeOffer;
        public HashMap<SOCPlayerElement.PEType, Integer> elements = new HashMap();
        public int[] resRollStats;
        public TradeTypeStat[] resTradeStats;
        @JsonAdapter(value=DevCardEnumListAdapter.class)
        public ArrayList<Integer> oldDevCards = new ArrayList();
        @JsonAdapter(value=DevCardEnumListAdapter.class)
        public ArrayList<Integer> newDevCards = new ArrayList();
        @JsonAdapter(value=DevCardEnumListAdapter.class)
        public ArrayList<Integer> playedDevCards;
        public ArrayList<SOCPlayingPiece> pieces = new ArrayList();
        public ArrayList<SOCPlayer.SpecialVPInfo> specialVPInfo;

        private static void initGsonRegisterAdapters(GsonBuilder gb) {
            gb.registerTypeAdapterFactory((TypeAdapterFactory)new PPieceAdapter());
        }

        PlayerInfo(SOCPlayer pl, boolean isVacant, SOCServer srv) {
            int n;
            SOCGame ga = pl.getGame();
            this.name = pl.getName();
            this.isSeatVacant = isVacant;
            this.totalVP = pl.getTotalVP();
            this.isRobot = pl.isRobot();
            this.isBuiltInRobot = pl.isBuiltInRobot();
            if (this.isRobot) {
                SOCClientData scd;
                SOCRobotParameters params = srv.getRobotParameters(this.name);
                if (params != null && params.getStrategyType() == 0) {
                    this.isRobotWithSmartStrategy = true;
                }
                if (!this.isBuiltInRobot && (scd = srv.getClientData(this.name)) != null) {
                    this.robot3rdPartyBrainClass = scd.robot3rdPartyBrainClass;
                }
            }
            this.faceID = pl.getFaceId();
            this.resources = new KnownResourceSet(pl.getResources());
            this.elements.put(SOCPlayerElement.PEType.NUMKNIGHTS, pl.getNumKnights());
            this.elements.put(SOCPlayerElement.PEType.ROADS, pl.getNumPieces(0));
            this.elements.put(SOCPlayerElement.PEType.SETTLEMENTS, pl.getNumPieces(1));
            this.elements.put(SOCPlayerElement.PEType.CITIES, pl.getNumPieces(2));
            if (!isVacant) {
                SOCTradeOffer curr;
                if (pl.getNeedToDiscard()) {
                    this.elements.put(SOCPlayerElement.PEType.DISCARD_FLAG, 1);
                } else {
                    int n2 = pl.getNeedToPickGoldHexResources();
                    if (n2 != 0) {
                        this.elements.put(SOCPlayerElement.PEType.NUM_PICK_GOLD_HEX_RESOURCES, n2);
                    }
                }
                if (pl.hasPlayedDevCard()) {
                    this.elements.put(SOCPlayerElement.PEType.PLAYED_DEV_CARD_FLAG, 1);
                }
                if (ga.maxPlayers > 4) {
                    if (pl.hasAskedSpecialBuild()) {
                        this.elements.put(SOCPlayerElement.PEType.ASK_SPECIAL_BUILD, 1);
                    }
                    if (ga.getGameState() == 100) {
                        this.elements.put(SOCPlayerElement.PEType.HAS_SPECIAL_BUILT, pl.hasSpecialBuilt() ? 1 : 0);
                    }
                }
                if ((curr = pl.getCurrentOffer()) != null) {
                    this.currentTradeOffer = new TradeOffer(curr, pl.getCurrentOfferTime() - ga.getStartTime().getTime());
                }
            }
            if ((n = pl.numDISCCards) > 0) {
                this.elements.put(SOCPlayerElement.PEType.NUM_PLAYED_DEV_CARD_DISC, n);
            }
            if ((n = pl.numMONOCards) > 0) {
                this.elements.put(SOCPlayerElement.PEType.NUM_PLAYED_DEV_CARD_MONO, n);
            }
            if ((n = pl.numRBCards) > 0) {
                this.elements.put(SOCPlayerElement.PEType.NUM_PLAYED_DEV_CARD_ROADS, n);
            }
            if ((n = pl.getUndosRemaining()) > 0) {
                this.elements.put(SOCPlayerElement.PEType.NUM_UNDOS_REMAINING, n);
            }
            if (ga.hasSeaBoard) {
                HashMap<SOCPlayerElement.PEType, Integer> early = new HashMap<SOCPlayerElement.PEType, Integer>();
                this.elements.put(SOCPlayerElement.PEType.SHIPS, pl.getNumPieces(3));
                n = pl.getNumWarships();
                if (n != 0) {
                    this.elements.put(SOCPlayerElement.PEType.SCENARIO_WARSHIP_COUNT, n);
                }
                if ((n = pl.getSpecialVP()) != 0) {
                    this.elements.put(SOCPlayerElement.PEType.SCENARIO_SVP, n);
                }
                if ((n = pl.getStartingLandAreasEncoded()) != 0) {
                    early.put(SOCPlayerElement.PEType.STARTING_LANDAREAS, n);
                }
                if ((n = pl.getPlayerEvents()) != 0) {
                    early.put(SOCPlayerElement.PEType.PLAYEREVENTS_BITMASK, n);
                }
                if ((n = pl.getScenarioSVPLandAreas()) != 0) {
                    early.put(SOCPlayerElement.PEType.SCENARIO_SVP_LANDAREAS_BITMASK, n);
                }
                if (!early.isEmpty()) {
                    this.earlyElements = early;
                }
            }
            if (this.totalVP > 0) {
                this.resRollStats = pl.getResourceRollStats();
                SOCResourceSet[][] tradeStats = pl.getResourceTradeStats();
                int nTypes = tradeStats[0].length;
                boolean anyTrades = false;
                this.resTradeStats = new TradeTypeStat[nTypes];
                for (int i = 0; i <= 1; ++i) {
                    for (int ttype = 0; ttype < nTypes; ++ttype) {
                        TradeTypeStat tts;
                        this.resTradeStats[ttype] = tts = new TradeTypeStat(tradeStats[0][ttype], tradeStats[1][ttype], TradeTypeStat.TYPE_DESCRIPTIONS[ttype]);
                        if (anyTrades) continue;
                        anyTrades = tts.gave != null || tts.received != null;
                    }
                }
                if (!anyTrades) {
                    this.resTradeStats = null;
                }
            }
            SOCInventory cardsInv = pl.getInventory();
            for (SOCInventoryItem item : cardsInv.getByState(1)) {
                if (!(item instanceof SOCDevCard)) continue;
                this.newDevCards.add(item.itype);
            }
            for (int dcState = 2; dcState <= 3; ++dcState) {
                for (SOCInventoryItem item : cardsInv.getByState(dcState)) {
                    if (!(item instanceof SOCDevCard)) continue;
                    this.oldDevCards.add(item.itype);
                }
            }
            List<Integer> cards = pl.getDevCardsPlayed();
            if (cards != null) {
                this.playedDevCards = new ArrayList<Integer>(cards);
            }
            this.pieces.addAll(pl.getPieces());
            this.specialVPInfo = pl.getSpecialVPInfo();
        }

        void loadInto(SOCPlayer pl) {
            int ctype;
            ResourceSet[][] tradeStats;
            int pn;
            SOCGame ga = pl.getGame();
            if (ga.isSeatVacant(pn = pl.getPlayerNumber())) {
                pl.setName(this.name);
            }
            pl.setRobotFlag(this.isRobot, this.isBuiltInRobot);
            pl.setFaceId(this.faceID);
            this.resources.loadInto(pl.getResources());
            if (this.resRollStats != null && this.resRollStats.length > 0) {
                pl.setResourceRollStats(this.resRollStats);
            }
            if (this.resTradeStats != null && this.resTradeStats.length > 0) {
                int n = this.resTradeStats.length;
                if (n > 8) {
                    n = 8;
                }
                tradeStats = new SOCResourceSet[2][n];
                for (int ttype = 0; ttype < n; ++ttype) {
                    KnownResourceSet gave = this.resTradeStats[ttype].gave;
                    KnownResourceSet received = this.resTradeStats[ttype].received;
                    tradeStats[0][ttype] = gave != null ? gave.toResourceSet() : SOCResourceSet.EMPTY_SET;
                    tradeStats[1][ttype] = received != null ? received.toResourceSet() : SOCResourceSet.EMPTY_SET;
                }
                pl.setResourceTradeStats(tradeStats);
            }
            Iterator<SOCPlayerElement.PEType> inv = pl.getInventory();
            tradeStats = this.oldDevCards.iterator();
            while (tradeStats.hasNext()) {
                ctype = tradeStats.next();
                ((SOCInventory)((Object)inv)).addDevCard(1, 0, ctype);
            }
            tradeStats = this.newDevCards.iterator();
            while (tradeStats.hasNext()) {
                ctype = (Integer)tradeStats.next();
                ((SOCInventory)((Object)inv)).addDevCard(1, 1, ctype);
            }
            if (this.playedDevCards != null) {
                inv = this.playedDevCards.iterator();
                while (inv.hasNext()) {
                    int ctype2 = (Integer)((Object)inv.next());
                    pl.updateDevCardsPlayed(ctype2, false);
                }
            }
            if (this.earlyElements != null) {
                for (SOCPlayerElement.PEType et : this.earlyElements.keySet()) {
                    SOCDisplaylessPlayerClient.handlePLAYERELEMENT(ga, pl, pn, 100, et, this.earlyElements.get((Object)et), null);
                }
            }
            SOCBoard b = ga.getBoard();
            HashSet<Integer> psList = new HashSet<Integer>(pl.getPotentialSettlements());
            for (SOCPlayingPiece pp : this.pieces) {
                pp.setGameInfo(pl, b);
                ga.putPiece(pp);
            }
            pl.setPotentialAndLegalSettlements(psList, false, null);
            pl.setCurrentOffer(this.currentTradeOffer != null ? this.currentTradeOffer.toOffer(pl) : null);
            for (SOCPlayerElement.PEType et : this.elements.keySet()) {
                SOCDisplaylessPlayerClient.handlePLAYERELEMENT(ga, pl, pn, 100, et, this.elements.get((Object)et), null);
            }
            pl.setSpecialVPInfo(this.specialVPInfo);
        }

        private static class PPieceAdapter
        extends CallbackClassTypeAdapterFactory<SOCPlayingPiece> {
            private PPieceAdapter() {
                super(SOCPlayingPiece.class);
            }

            @Override
            protected void beforeWrite(SOCPlayingPiece source, JsonElement serializedTree) throws IOException {
                JsonObject obj = serializedTree.getAsJsonObject();
                obj.addProperty("pieceType", SOCPlayingPiece.getTypeName(source.getType()));
                JsonElement svpField = obj.get("specialVP");
                if (svpField != null && svpField.getAsInt() == 0) {
                    obj.remove("specialVP");
                }
                if (source instanceof SOCShip && ((SOCShip)source).isClosed()) {
                    obj.addProperty("isClosed", Boolean.valueOf(true));
                }
            }

            @Override
            protected SOCPlayingPiece afterRead(JsonElement deserializedTree) throws IOException {
                SOCPlayingPiece pp;
                int coord;
                int ptype;
                JsonObject obj = deserializedTree.getAsJsonObject();
                try {
                    String ptStr = obj.get("pieceType").getAsString();
                    ptype = SOCPlayingPiece.getType(ptStr);
                    if (ptype == -1) {
                        throw new IOException("unknown pieceType: " + ptStr);
                    }
                }
                catch (RuntimeException e) {
                    throw new IOException("can't parse pieceType", e);
                }
                try {
                    coord = obj.get("coord").getAsInt();
                }
                catch (RuntimeException e) {
                    throw new IOException("can't parse coord", e);
                }
                switch (ptype) {
                    case 0: {
                        pp = new SOCRoad(GameLoaderJSON.dummyPlayer, coord, null);
                        break;
                    }
                    case 1: {
                        pp = new SOCSettlement(GameLoaderJSON.dummyPlayer, coord, null);
                        break;
                    }
                    case 2: {
                        pp = new SOCCity(GameLoaderJSON.dummyPlayer, coord, null);
                        break;
                    }
                    case 3: {
                        pp = new SOCShip(GameLoaderJSON.dummyPlayer, coord, null);
                        if (!obj.has("isClosed") || !obj.get("isClosed").getAsBoolean()) break;
                        ((SOCShip)pp).setClosed();
                        break;
                    }
                    default: {
                        throw new IOException("unknown pieceType: " + ptype);
                    }
                }
                if (obj.has("specialVP")) {
                    try {
                        int n = obj.get("specialVP").getAsInt();
                        if (n != 0) {
                            pp.specialVP = n;
                        }
                    }
                    catch (RuntimeException e) {
                        throw new IOException("can't parse specialVP", e);
                    }
                }
                return pp;
            }
        }
    }
}

