/*
 * Decompiled with CFR 0.152.
 */
package soc.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;

public abstract class DataUtils {
    public static final void arrayIntoStringBuilder(int[] ia, StringBuilder sb, boolean useHex) throws NullPointerException {
        if (ia == null) {
            throw new NullPointerException("ia");
        }
        sb.append("{");
        for (int i = 0; i < ia.length; ++i) {
            sb.append(' ');
            if (!useHex) {
                sb.append(ia[i]);
                continue;
            }
            int iai = ia[i];
            if (iai >= 0) {
                sb.append(Integer.toHexString(iai));
                continue;
            }
            sb.append('-');
            sb.append(Integer.toHexString(-iai));
        }
        sb.append(" }");
    }

    public static final void listIntoStringBuilder(Collection<?> sc, StringBuilder sb) throws NullPointerException {
        if (sc.isEmpty()) {
            return;
        }
        boolean any = false;
        for (Object s : sc) {
            if (any) {
                sb.append(',');
            } else {
                any = true;
            }
            sb.append(s);
        }
    }

    public static final void mapIntoStringBuilder(Map<?, ?> map, StringBuilder sb, String kvSeparator, String entrySeparator) throws NullPointerException {
        if (map == null) {
            sb.append("(null)");
            return;
        }
        if (map.isEmpty()) {
            sb.append("(empty)");
            return;
        }
        if (kvSeparator == null) {
            kvSeparator = ": ";
        }
        if (entrySeparator == null) {
            entrySeparator = ", ";
        }
        TreeSet sortedKeys = map instanceof TreeMap ? map.keySet() : new TreeSet(map.keySet());
        boolean any = false;
        for (Object k : sortedKeys) {
            if (any) {
                sb.append(entrySeparator);
            } else {
                any = true;
            }
            sb.append(k).append(kvSeparator).append(map.get(k));
        }
    }

    public static final int[] intListToPrimitiveArray(List<Integer> li) {
        if (li == null) {
            return null;
        }
        int[] arr = new int[li.size()];
        Iterator<Integer> iterator = li.iterator();
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = iterator.next();
        }
        return arr;
    }
}

