/*
 * Decompiled with CFR 0.152.
 */
package soc.util;

import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;

public class DebugRecorder {
    public static final int NOT_RECORDING = 0;
    public static final int RECORDING = 1;
    private Map<Object, Vector<String>> records;
    private Object currentKey;
    private Vector<String> currentRecord;
    private int state = 0;
    private boolean on = false;

    public void turnOn() {
        if (this.records == null) {
            this.records = Collections.synchronizedMap(new Hashtable());
        }
        this.on = true;
    }

    public void turnOff() {
        this.on = false;
        this.currentRecord = null;
        this.currentKey = null;
        this.records.clear();
        this.state = 0;
    }

    public boolean isOn() {
        return this.on;
    }

    public void startRecording(Object key) {
        this.state = 1;
        this.currentKey = key;
        this.currentRecord = new Vector();
    }

    public void stopRecording() {
        this.state = 0;
        if (this.currentKey != null && this.currentRecord != null) {
            this.records.put(this.currentKey, this.currentRecord);
        }
    }

    public void suspend() {
        this.state = 0;
    }

    public void resume() {
        this.state = 1;
    }

    public void record(String s) {
        if (this.state == 1) {
            this.currentRecord.addElement(s);
        }
    }

    public Vector<String> getRecord(Object key) {
        return this.records.get(key);
    }

    public void putRecord(Object key, Vector<String> rec) {
        if (key != null && rec != null) {
            this.records.put(key, rec);
        }
    }

    public void eraseAllRecords() {
        this.records.clear();
    }
}

