/*
 * Decompiled with CFR 0.152.
 */
package soc.util;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.List;
import soc.util.SOCStringManager;

public abstract class I18n {
    public static final String PROP_JSETTLERS_LOCALE = "jsettlers.locale";
    private static final MathContext PRECISION_3_SIG_FIGS = new MathContext(3, RoundingMode.HALF_UP);
    private static final int BYTES_1_MB = 0x100000;
    private static final long BYTES_1_GB = 0x40000000L;

    public static final String listItems(List<? extends Object> items, SOCStringManager strings) throws IllegalArgumentException {
        if (items == null || strings == null) {
            throw new IllegalArgumentException("null");
        }
        int L = items.size();
        switch (L) {
            case 0: {
                return strings.get("i18n.listitems.nothing");
            }
            case 1: {
                return items.get(0).toString();
            }
            case 2: {
                return strings.get("i18n.listitems.2", items.get(0), items.get(1));
            }
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < L - 1; ++i) {
            sb.append(strings.get("i18n.listitems.item", items.get(i)));
        }
        sb.append(strings.get("i18n.listitems.finalitem", items.get(L - 1)));
        return sb.toString();
    }

    private static String numTo3SigFigs(BigDecimal amount, String unit) {
        long wholeAmount = amount.setScale(0, 4).longValue();
        StringBuilder sb = new StringBuilder();
        if (wholeAmount >= 100L) {
            sb.append(wholeAmount);
        } else {
            sb.append(amount.round(PRECISION_3_SIG_FIGS).toPlainString());
            if (wholeAmount < 10L && sb.lastIndexOf(".") == sb.length() - 2) {
                sb.append('0');
            }
        }
        sb.append(' ');
        sb.append(unit);
        return sb.toString();
    }

    public static String bytesToHumanUnits(long bytes) throws IllegalArgumentException {
        if (bytes < 0L) {
            throw new IllegalArgumentException("bytes < 0");
        }
        return bytes >= 0x40000000L ? I18n.numTo3SigFigs(BigDecimal.valueOf((double)bytes / 1.073741824E9), "GB") : I18n.numTo3SigFigs(BigDecimal.valueOf((double)bytes / 1048576.0), "MB");
    }

    public static String durationToDaysHoursMinutesSeconds(long millis, SOCStringManager strings) throws IllegalArgumentException, NullPointerException {
        if (millis < 0L) {
            throw new IllegalArgumentException("negative");
        }
        long hours = millis / 3600000L;
        long hoursAsMillis = hours * 60L * 60L * 1000L;
        long minutes = (millis - hoursAsMillis) / 60000L;
        long seconds = (millis - hoursAsMillis - minutes * 60L * 1000L) / 1000L;
        if (hours < 24L) {
            return strings.get("i18n.duration.hours_min_sec", hours, minutes, seconds);
        }
        int days = (int)(hours / 24L);
        int hr = (int)(hours - (long)days * 24L);
        return strings.get("i18n.duration.days_hours_min_sec", days, hr, minutes, seconds);
    }
}

