/*
 * Decompiled with CFR 0.152.
 */
package soc.util;

public class SOCFeatureSet {
    public static final int VERSION_FOR_SERVERFEATURES = 1119;
    public static final int VERSION_FOR_CLIENTFEATURES = 2000;
    public static final String SERVER_ACCOUNTS = "accts";
    public static final String SERVER_CHANNELS = "ch";
    public static final String SERVER_OPEN_REG = "oreg";
    public static final String CLIENT_6_PLAYERS = "6pl";
    public static final String CLIENT_SEA_BOARD = "sb";
    public static final String CLIENT_SCENARIO_VERSION = "sc";
    public static final char SEP_CHAR = ';';
    private String featureList = null;

    public SOCFeatureSet(boolean withOldDefaults, boolean withOldDefaultsForServer) {
        if (withOldDefaults) {
            this.featureList = withOldDefaultsForServer ? ";accts;ch;oreg;" : ";6pl;";
        }
    }

    public SOCFeatureSet(String encodedList) throws IllegalArgumentException {
        if (encodedList != null) {
            int L = encodedList.length();
            if (L == 0) {
                encodedList = null;
            } else if (encodedList.charAt(0) != ';' || encodedList.charAt(L - 1) != ';') {
                throw new IllegalArgumentException("Bad encoding: " + encodedList);
            }
        }
        this.featureList = encodedList;
    }

    public SOCFeatureSet(SOCFeatureSet feats) throws NullPointerException {
        this.featureList = feats.featureList;
    }

    public boolean isActive(String featureName) throws IllegalArgumentException {
        if (featureName == null || featureName.length() == 0) {
            throw new IllegalArgumentException("featureName: " + featureName);
        }
        if (this.featureList == null) {
            return false;
        }
        return this.featureList.contains(';' + featureName + ';') || this.featureList.contains(';' + featureName + '=');
    }

    public int getValue(String featureName, int dflt) {
        if (featureName == null || featureName.length() == 0) {
            throw new IllegalArgumentException("featureName: " + featureName);
        }
        if (this.featureList == null) {
            return dflt;
        }
        int iStart = this.featureList.indexOf(';' + featureName + '=');
        if (iStart == -1) {
            return dflt;
        }
        int iEnd = this.featureList.indexOf(59, iStart += featureName.length() + 2);
        if (iEnd == -1) {
            iEnd = this.featureList.length();
        }
        try {
            return Integer.parseInt(this.featureList.substring(iStart, iEnd));
        }
        catch (RuntimeException e) {
            return dflt;
        }
    }

    public void add(String featureName) throws IllegalArgumentException {
        if (featureName == null || featureName.length() == 0 || -1 != featureName.indexOf(59) || -1 != featureName.indexOf(61)) {
            throw new IllegalArgumentException("featureName: " + featureName);
        }
        this.featureList = this.featureList == null ? ';' + featureName + ';' : this.featureList.concat(featureName + ';');
    }

    public void add(String featureName, int val) throws IllegalArgumentException {
        if (featureName == null || featureName.length() == 0 || -1 != featureName.indexOf(59) || -1 != featureName.indexOf(61)) {
            throw new IllegalArgumentException("featureName: " + featureName);
        }
        this.featureList = this.featureList == null ? ';' + featureName + "=" + val + ';' : this.featureList.concat(featureName + "=" + val + ';');
    }

    public void remove(String featureName) throws IllegalArgumentException {
        if (featureName == null || featureName.length() == 0) {
            throw new IllegalArgumentException("featureName: " + featureName);
        }
        if (this.featureList == null) {
            return;
        }
        int L = featureName.length();
        int LTotal = this.featureList.length();
        int i = 0;
        while (i > -1 && i < LTotal) {
            i = this.featureList.indexOf(';' + featureName, i);
            if (i == -1) {
                return;
            }
            int iNext = i + L + 1;
            if (iNext < LTotal) {
                char ch = this.featureList.charAt(iNext);
                if (ch == '=') {
                    iNext = this.featureList.indexOf(59, iNext + 1);
                } else if (ch != ';') {
                    i = iNext;
                    continue;
                }
                this.featureList = i == 0 && ++iNext == LTotal ? null : this.featureList.substring(0, i + 1) + (iNext > 0 && iNext < LTotal ? this.featureList.substring(iNext) : "");
                return;
            }
            this.featureList = this.featureList.substring(0, i);
            return;
        }
    }

    public String findMissingAgainst(SOCFeatureSet otherSet, boolean stopAtFirstFound) {
        if (otherSet == null || otherSet.featureList == null) {
            return null;
        }
        String fList = otherSet.featureList;
        int L = fList.length();
        if (L < 2) {
            return null;
        }
        StringBuilder missingList = null;
        int i = fList.indexOf(59, 1);
        int iprev = 0;
        while (true) {
            if (i == -1) {
                i = L;
            }
            if (i - iprev > 1) {
                String missingItem = null;
                String f = fList.substring(iprev + 1, i);
                int ieq = f.indexOf(61);
                if (ieq == -1) {
                    if (!this.isActive(f)) {
                        missingItem = f;
                    }
                } else if (ieq == 0) {
                    missingItem = "?";
                } else {
                    String name = f.substring(0, ieq);
                    String val = f.substring(ieq + 1);
                    int ival = 0;
                    if (val.length() > 0) {
                        try {
                            ival = Integer.parseInt(val);
                            int ourval = this.getValue(name, ival - 1);
                            if (ourval < ival) {
                                missingItem = f;
                            }
                        }
                        catch (NumberFormatException e) {
                            missingItem = name;
                        }
                    }
                }
                if (missingItem != null) {
                    if (stopAtFirstFound) {
                        return missingItem;
                    }
                    if (missingList == null) {
                        missingList = new StringBuilder();
                    } else {
                        missingList.append(';');
                    }
                    missingList.append(missingItem);
                }
            }
            if (i >= L - 1) break;
            iprev = i;
            i = fList.indexOf(59, i + 1);
        }
        return missingList != null ? missingList.toString() : null;
    }

    public String getEncodedList() {
        return this.featureList;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append('{');
        sb.append(this.featureList != null ? this.featureList : "(empty)");
        sb.append('}');
        return sb.toString();
    }
}

