/*
 * Decompiled with CFR 0.152.
 */
package soc.util;

import java.util.Enumeration;
import java.util.Vector;
import soc.debug.D;
import soc.game.SOCGame;
import soc.game.SOCPlayer;
import soc.server.genericServer.Connection;

public class SOCGameBoardReset {
    public final SOCGame newGame;
    public final int oldGameState;
    public final boolean hadRobots;
    public final boolean hasRobots;
    public int oldRobotCount;
    public Connection[] humanConns;
    public Connection[] robotConns;
    public boolean[] wasRobot;

    public SOCGameBoardReset(SOCGame oldGame, Vector<Connection> memberConns) {
        this.oldGameState = oldGame.getGameState();
        this.oldRobotCount = 0;
        this.wasRobot = new boolean[oldGame.maxPlayers];
        boolean hadBots = false;
        boolean hasBots = false;
        for (int i = 0; i < oldGame.maxPlayers; ++i) {
            boolean isRobot;
            SOCPlayer pl = oldGame.getPlayer(i);
            this.wasRobot[i] = isRobot = pl.isRobot() && !oldGame.isSeatVacant(i);
            if (!isRobot) continue;
            hadBots = true;
            ++this.oldRobotCount;
            if (oldGame.getSeatLock(i) != SOCGame.SeatLockState.UNLOCKED) continue;
            hasBots = true;
        }
        this.hadRobots = hadBots;
        this.hasRobots = hasBots;
        this.newGame = oldGame.resetAsCopy();
        this.humanConns = new Connection[oldGame.maxPlayers];
        this.robotConns = new Connection[oldGame.maxPlayers];
        if (memberConns != null) {
            SOCGameBoardReset.sortPlayerConnections(this.newGame, oldGame, memberConns, this.humanConns, this.robotConns);
            for (int pn = 0; pn < oldGame.maxPlayers; ++pn) {
                if (!this.wasRobot[pn]) continue;
                memberConns.remove(this.robotConns[pn]);
            }
        }
        if (this.hadRobots) {
            this.newGame.boardResetOngoingInfo = this;
            this.newGame.setGameState(4);
        }
    }

    public static int sortPlayerConnections(SOCGame newGame, SOCGame oldGame, Vector<Connection> memberConns, Connection[] humanConns, Connection[] robotConns) {
        int numHuman = 0;
        Enumeration<Connection> playersEnum = memberConns.elements();
        while (playersEnum.hasMoreElements()) {
            int pn;
            Connection pCon = playersEnum.nextElement();
            String plName = pCon.getData();
            SOCPlayer p = newGame.getPlayer(plName);
            if (p != null) {
                pn = p.getPlayerNumber();
                if (p.isRobot()) {
                    robotConns[pn] = pCon;
                    continue;
                }
                humanConns[pn] = pCon;
                ++numHuman;
                continue;
            }
            if (oldGame == null || (p = oldGame.getPlayer(plName)) == null) continue;
            pn = p.getPlayerNumber();
            if (p.isRobot()) {
                robotConns[pn] = pCon;
                continue;
            }
            D.ebugPrintlnINFO("findPlayerConnections assert failed: human player not copied: " + pn);
        }
        for (int pn = 0; pn < newGame.maxPlayers; ++pn) {
            if (!newGame.isSeatVacant(pn)) {
                if (humanConns[pn] != null || robotConns[pn] != null) continue;
                D.ebugPrintlnINFO("findPlayerConnections assert failed: did not find player " + pn);
                continue;
            }
            if (humanConns[pn] == null && (robotConns[pn] == null || oldGame != null && !oldGame.isSeatVacant(pn))) continue;
            D.ebugPrintlnINFO("findPlayerConnections assert failed: memberlist had vacant player " + pn);
        }
        return numHuman;
    }
}

