/*
 * Decompiled with CFR 0.152.
 */
package soc.util;

import java.util.Hashtable;
import java.util.Set;
import java.util.regex.Pattern;
import soc.debug.D;
import soc.game.SOCGame;
import soc.game.SOCGameOption;
import soc.game.SOCGameOptionSet;
import soc.util.MutexFlag;

public class SOCGameList {
    public static final int GAME_NAME_MAX_LENGTH = 30;
    public static final Pattern REGEX_ALL_DIGITS_OR_PUNCT = Pattern.compile("^[\\p{Nd}\\p{Punct}\\p{P}]+$");
    protected Hashtable<String, GameInfo> gameInfo = new Hashtable();
    protected final SOCGameOptionSet knownOpts;
    protected boolean inUse;

    public SOCGameList(SOCGameOptionSet knownOpts) {
        this.knownOpts = knownOpts;
        this.inUse = false;
    }

    public synchronized void takeMonitor() {
        while (this.inUse) {
            try {
                this.wait(1000L);
            }
            catch (InterruptedException e) {
                System.out.println("EXCEPTION IN takeMonitor() -- " + e);
            }
        }
        this.inUse = true;
    }

    public synchronized void releaseMonitor() {
        this.inUse = false;
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean takeMonitorForGame(String game) {
        GameInfo info = this.gameInfo.get(game);
        if (info == null || info.gameDestroyed) {
            return false;
        }
        MutexFlag mutex = info.mutex;
        if (mutex == null) {
            return false;
        }
        boolean done = false;
        while (!done) {
            if (mutex == null) {
                return false;
            }
            if (info.gameDestroyed) {
                D.ebugPrintStackTrace(null, "Game " + game + " was destroyed while waiting");
                return false;
            }
            MutexFlag mutexFlag = mutex;
            synchronized (mutexFlag) {
                if (mutex.getState()) {
                    try {
                        mutex.wait(1000L);
                    }
                    catch (InterruptedException e) {
                        System.out.println("EXCEPTION IN takeMonitor() -- " + e);
                    }
                } else {
                    done = true;
                }
            }
        }
        mutex.setState(true);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean releaseMonitorForGame(String game) {
        GameInfo info = this.gameInfo.get(game);
        if (info == null) {
            return false;
        }
        MutexFlag mutex = info.mutex;
        if (mutex == null) {
            return false;
        }
        MutexFlag mutexFlag = mutex;
        synchronized (mutexFlag) {
            mutex.setState(false);
            mutex.notify();
        }
        return true;
    }

    public Set<String> getGameNames() {
        return this.gameInfo.keySet();
    }

    public int size() {
        return this.gameInfo.size();
    }

    public SOCGameOptionSet getGameOptions(String gaName) {
        GameInfo info = this.gameInfo.get(gaName);
        if (info == null) {
            return null;
        }
        return info.opts;
    }

    public String getGameOptionsString(String gaName) {
        GameInfo info = this.gameInfo.get(gaName);
        if (info == null) {
            return null;
        }
        return info.optsStr;
    }

    public SOCGameOptionSet parseGameOptions(String gaName) {
        GameInfo info = this.gameInfo.get(gaName);
        if (info == null) {
            return null;
        }
        return info.parseOptsStr();
    }

    public boolean isGame(String gaName) {
        return this.gameInfo.containsKey(gaName);
    }

    public boolean isUnjoinableGame(String gaName) {
        if (gaName.charAt(0) == '?') {
            return true;
        }
        GameInfo gi = this.gameInfo.get(gaName);
        if (gi == null) {
            return false;
        }
        return !gi.canJoin;
    }

    public synchronized void addGame(String gaName, String gaOptsStr, boolean cannotJoin) {
        this.addGame(gaName, null, gaOptsStr, cannotJoin);
    }

    protected synchronized void addGame(String gaName, SOCGameOptionSet gaOpts, String gaOptsStr, boolean cannotJoin) {
        if (gaName.charAt(0) == '?') {
            cannotJoin = true;
            gaName = gaName.substring(1);
        }
        if (this.isGame(gaName)) {
            if (cannotJoin) {
                GameInfo gi = this.gameInfo.get(gaName);
                if (gi.canJoin) {
                    gi.canJoin = false;
                }
            }
            return;
        }
        if (gaOpts != null) {
            this.gameInfo.put(gaName, new GameInfo(!cannotJoin, gaOpts));
        } else {
            this.gameInfo.put(gaName, new GameInfo(!cannotJoin, gaOptsStr));
        }
    }

    public synchronized void addGames(SOCGameList gl, int ourVersion) {
        if (gl == null || gl.gameInfo == null) {
            return;
        }
        if (gl.gameInfo != null) {
            for (String gaName : gl.gameInfo.keySet()) {
                GameInfo gi = gl.gameInfo.get(gaName);
                if (gi.opts != null) {
                    this.addGame(gaName, gi.opts, null, !gi.canJoin);
                    continue;
                }
                this.addGame(gaName, null, gi.optsStr, !gi.canJoin);
            }
        }
    }

    public synchronized void addGames(Iterable<?> gameList, int ourVersion) {
        if (gameList == null) {
            return;
        }
        for (Object ob : gameList) {
            boolean cannotJoin;
            SOCGameOptionSet gaOpts;
            String gaName;
            boolean isGameObj = ob instanceof SOCGame;
            if (isGameObj) {
                gaName = ((SOCGame)ob).getName();
                gaOpts = ((SOCGame)ob).getGameOptions();
                cannotJoin = ourVersion < ((SOCGame)ob).getClientVersionMinRequired();
            } else {
                gaName = (String)ob;
                gaOpts = null;
                cannotJoin = false;
            }
            this.addGame(gaName, gaOpts, null, cannotJoin);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void deleteGame(String gaName) {
        soc.disableDebug.D.ebugPrintlnINFO("SOCGameList : deleteGame(" + gaName + ")");
        GameInfo info = this.gameInfo.get(gaName);
        if (info == null) {
            return;
        }
        info.gameDestroyed = true;
        this.gameInfo.remove(gaName);
        MutexFlag mutexFlag = info.mutex;
        synchronized (mutexFlag) {
            info.mutex.notifyAll();
        }
        info.dispose();
    }

    protected class GameInfo {
        public MutexFlag mutex = new MutexFlag();
        public SOCGameOptionSet opts;
        public String optsStr;
        public boolean canJoin;
        public boolean gameDestroyed;

        public GameInfo(boolean canJoinGame, SOCGameOptionSet gameOpts) {
            this.opts = gameOpts;
            this.canJoin = canJoinGame;
        }

        public GameInfo(boolean canJoinGame, String gameOptsStr) {
            this.optsStr = gameOptsStr;
            this.canJoin = canJoinGame;
        }

        public SOCGameOptionSet parseOptsStr() {
            if (this.opts != null) {
                return this.opts;
            }
            if (this.optsStr == null || SOCGameList.this.knownOpts == null) {
                return null;
            }
            this.opts = SOCGameOption.parseOptionsToSet(this.optsStr, SOCGameList.this.knownOpts);
            return this.opts;
        }

        public void dispose() {
            if (this.opts != null) {
                this.opts.clear();
                this.opts = null;
            }
        }
    }
}

