/*
 * Decompiled with CFR 0.152.
 */
package soc.util;

import java.io.Serializable;
import soc.game.SOCGameOptionSet;

public class SOCRobotParameters
implements Serializable {
    private static final long serialVersionUID = 1000L;
    protected int maxGameLength;
    protected int maxETA;
    protected float etaBonusFactor;
    protected float adversarialFactor;
    protected float leaderAdversarialFactor;
    protected float devCardMultiplier;
    protected float threatMultiplier;
    protected int strategyType;
    protected int tradeFlag;

    public SOCRobotParameters(int mgl, int me, float ebf, float af, float laf, float dcm, float tm, int st, int tf) {
        this.maxGameLength = mgl;
        this.maxETA = me;
        this.etaBonusFactor = ebf;
        this.adversarialFactor = af;
        this.leaderAdversarialFactor = laf;
        this.devCardMultiplier = dcm;
        this.threatMultiplier = tm;
        this.strategyType = st;
        this.tradeFlag = tf;
    }

    public SOCRobotParameters(SOCRobotParameters params) {
        this.maxGameLength = params.getMaxGameLength();
        this.maxETA = params.getMaxETA();
        this.etaBonusFactor = params.getETABonusFactor();
        this.adversarialFactor = params.getAdversarialFactor();
        this.leaderAdversarialFactor = params.getLeaderAdversarialFactor();
        this.devCardMultiplier = params.getDevCardMultiplier();
        this.threatMultiplier = params.getThreatMultiplier();
        this.strategyType = params.getStrategyType();
        this.tradeFlag = params.getTradeFlag();
    }

    public SOCRobotParameters copyIfOptionChanged(SOCGameOptionSet gameOpts) {
        if (gameOpts == null) {
            return this;
        }
        boolean copied = false;
        SOCRobotParameters params = this;
        if (gameOpts != null && gameOpts.isOptionSet("NT") && 1 == params.tradeFlag) {
            if (!copied) {
                copied = true;
                params = new SOCRobotParameters(params);
            }
            params.tradeFlag = 0;
        }
        return params;
    }

    public int getMaxGameLength() {
        return this.maxGameLength;
    }

    public int getMaxETA() {
        return this.maxETA;
    }

    public float getETABonusFactor() {
        return this.etaBonusFactor;
    }

    public float getAdversarialFactor() {
        return this.adversarialFactor;
    }

    public float getLeaderAdversarialFactor() {
        return this.leaderAdversarialFactor;
    }

    public float getDevCardMultiplier() {
        return this.devCardMultiplier;
    }

    public float getThreatMultiplier() {
        return this.threatMultiplier;
    }

    public int getStrategyType() {
        return this.strategyType;
    }

    public int getTradeFlag() {
        return this.tradeFlag;
    }

    public boolean equals(Object o) {
        if (!(o instanceof SOCRobotParameters)) {
            return false;
        }
        SOCRobotParameters params = (SOCRobotParameters)o;
        return this.maxGameLength == params.maxGameLength && this.maxETA == params.maxETA && this.etaBonusFactor == params.etaBonusFactor && this.adversarialFactor == params.adversarialFactor && this.leaderAdversarialFactor == params.leaderAdversarialFactor && this.devCardMultiplier == params.devCardMultiplier && this.threatMultiplier == params.threatMultiplier && this.strategyType == params.strategyType && this.tradeFlag == params.tradeFlag;
    }

    public String toString() {
        String s = "mgl=" + this.maxGameLength + "|me=" + this.maxETA + "|ebf=" + this.etaBonusFactor + "|af=" + this.adversarialFactor + "|laf=" + this.leaderAdversarialFactor + "|dcm=" + this.devCardMultiplier + "|tm=" + this.threatMultiplier + "|st=" + this.strategyType + "|tf=" + this.tradeFlag;
        return s;
    }
}

