/*
 * Decompiled with CFR 0.152.
 */
package soc.util;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import net.nand.util.i18n.mgr.StringManager;
import soc.game.ResourceSet;
import soc.game.SOCDevCard;
import soc.game.SOCGame;
import soc.game.SOCInventoryItem;
import soc.util.I18n;

public class SOCStringManager
extends StringManager {
    public static final int VERSION_FOR_I18N = 2000;
    public static final String PROPS_PATH_SERVER_FOR_CLIENT = "resources/strings/server/toClient";
    private static SOCStringManager clientManager = null;
    private static Hashtable<String, SOCStringManager> serverManagerForClientLocale = new Hashtable();
    private static SOCStringManager serverManagerForClientLocale_fallback;
    private static final String[][] GETSPECIAL_RSRC_KEYS;

    public SOCStringManager(String bundlePath) {
        super(bundlePath);
    }

    public SOCStringManager(String bundlePath, Locale loc) {
        super(bundlePath, loc);
    }

    public final String getSOCResourceCount(int rtype, Integer rcountObj) throws MissingResourceException {
        int idx;
        int rcount = rcountObj;
        switch (rcount) {
            case 1: {
                idx = 0;
                break;
            }
            case -1: {
                idx = 2;
                break;
            }
            case -2: {
                idx = 3;
                break;
            }
            default: {
                idx = 1;
            }
        }
        String[] rkeyArray = GETSPECIAL_RSRC_KEYS[idx];
        String resText = rtype >= 1 && rtype <= 5 ? (rcount == 1 || rcount == -1 ? this.bundle.getString(rkeyArray[rtype]) : MessageFormat.format(this.bundle.getString(rkeyArray[rtype]), rcountObj)) : (rcount == 1 || rcount < 0 ? MessageFormat.format(this.bundle.getString(rkeyArray[0]), rtype) : MessageFormat.format(this.bundle.getString(rkeyArray[0]), rcountObj, rtype));
        return resText;
    }

    public String getSpecial(SOCGame game, String key, Object ... arguments) throws MissingResourceException, IllegalArgumentException {
        return this.formatSpecial(game, this.bundle.getString(key), arguments);
    }

    public String formatSpecial(SOCGame game, String txtfmt, Object ... arguments) throws MissingResourceException, IllegalArgumentException {
        ArrayList<String> resList;
        int pnum;
        Object arg;
        int i0;
        Object[] argsLocal = null;
        int ir = txtfmt.indexOf(",rsrcs}");
        while (ir != -1) {
            i0 = txtfmt.lastIndexOf(123, ir - 1);
            if (i0 == -1) {
                throw new IllegalArgumentException("Missing '{' before ',rsrcs}' in pattern: " + txtfmt);
            }
            if (argsLocal == null) {
                argsLocal = (Object[])arguments.clone();
            }
            if ((arg = argsLocal[pnum = Integer.parseInt(txtfmt.substring(i0 + 1, ir))]) instanceof Integer) {
                argsLocal[pnum] = this.getSOCResourceCount((Integer)arguments[pnum + 1], (Integer)arg);
            } else if (arg instanceof ResourceSet) {
                ResourceSet rset = (ResourceSet)arg;
                resList = new ArrayList<String>();
                for (int rtype = 1; rtype <= 5; ++rtype) {
                    int n = rset.getAmount(rtype);
                    if (n <= 0) continue;
                    resList.add(this.getSOCResourceCount(rtype, n));
                }
                argsLocal[pnum] = resList.isEmpty() ? this.bundle.getString("spec.rsrcs.none") : I18n.listItems(resList, this);
            }
            txtfmt = txtfmt.substring(0, ir) + txtfmt.substring(ir + 6);
            ir = txtfmt.indexOf(",rsrcs}");
        }
        ir = txtfmt.indexOf(",list}");
        while (ir != -1) {
            i0 = txtfmt.lastIndexOf(123, ir - 1);
            if (i0 == -1) {
                throw new IllegalArgumentException("Missing '{' before ',list}' in pattern: " + txtfmt);
            }
            if (argsLocal == null) {
                argsLocal = (Object[])arguments.clone();
            }
            if ((arg = argsLocal[pnum = Integer.parseInt(txtfmt.substring(i0 + 1, ir))]) instanceof List) {
                argsLocal[pnum] = I18n.listItems((List)arg, this);
            }
            txtfmt = txtfmt.substring(0, ir) + txtfmt.substring(ir + 5);
            ir = txtfmt.indexOf(",list}");
        }
        ir = txtfmt.indexOf(",dcards}");
        while (ir != -1) {
            i0 = txtfmt.lastIndexOf(123, ir - 1);
            if (i0 == -1) {
                throw new IllegalArgumentException("Missing '{' before ',dcards}' in pattern: " + txtfmt);
            }
            if (argsLocal == null) {
                argsLocal = (Object[])arguments.clone();
            }
            if ((arg = argsLocal[pnum = Integer.parseInt(txtfmt.substring(i0 + 1, ir))]) instanceof Integer) {
                argsLocal[pnum] = SOCDevCard.getCardTypeName((Integer)arg, game, true, this);
            } else if (arg instanceof SOCInventoryItem) {
                argsLocal[pnum] = ((SOCInventoryItem)arg).getItemName(game, true, this);
            } else if (arg instanceof List) {
                int L = ((List)arg).size();
                if (L == 0) {
                    argsLocal[pnum] = this.bundle.getString("base.emptylist.nothing");
                } else {
                    resList = new ArrayList(L);
                    for (Object itm : (List)arg) {
                        if (itm instanceof Integer) {
                            resList.add(SOCDevCard.getCardTypeName((Integer)itm, game, true, this));
                            continue;
                        }
                        if (itm instanceof SOCInventoryItem) {
                            resList.add(((SOCInventoryItem)itm).getItemName(game, true, this));
                            continue;
                        }
                        resList.add(itm.toString());
                    }
                    argsLocal[pnum] = I18n.listItems(resList, this);
                }
            }
            txtfmt = txtfmt.substring(0, ir) + txtfmt.substring(ir + 7);
            ir = txtfmt.indexOf(",dcards}");
        }
        if (argsLocal == null) {
            argsLocal = arguments;
        }
        return MessageFormat.format(txtfmt, argsLocal);
    }

    public static SOCStringManager getClientManager() {
        if (clientManager == null) {
            clientManager = new SOCStringManager("resources/strings/client/data");
        }
        return clientManager;
    }

    public static SOCStringManager getClientManager(Locale loc) {
        if (clientManager == null) {
            clientManager = new SOCStringManager("resources/strings/client/data", loc);
        }
        return clientManager;
    }

    public static SOCStringManager getServerManagerForClient(Locale loc) {
        String lstr;
        SOCStringManager smc;
        if (loc == null) {
            loc = Locale.US;
        }
        if ((smc = serverManagerForClientLocale.get(lstr = loc.toString())) == null) {
            smc = new SOCStringManager(PROPS_PATH_SERVER_FOR_CLIENT, loc);
            serverManagerForClientLocale.put(lstr, smc);
        }
        return smc;
    }

    public static SOCStringManager getFallbackServerManagerForClient() {
        SOCStringManager sm = serverManagerForClientLocale_fallback;
        if (sm == null) {
            serverManagerForClientLocale_fallback = sm = SOCStringManager.getServerManagerForClient(null);
        }
        return sm;
    }

    static {
        GETSPECIAL_RSRC_KEYS = new String[][]{{"spec.rsrcs.1unknown", "spec.rsrcs.1clay", "spec.rsrcs.1ore", "spec.rsrcs.1sheep", "spec.rsrcs.1wheat", "spec.rsrcs.1wood"}, {"spec.rsrcs.nunknown", "spec.rsrcs.nclay", "spec.rsrcs.nore", "spec.rsrcs.nsheep", "spec.rsrcs.nwheat", "spec.rsrcs.nwood"}, {"spec.rsrcs.aunknown", "spec.rsrcs.aclay", "spec.rsrcs.aore", "spec.rsrcs.asheep", "spec.rsrcs.awheat", "spec.rsrcs.awood"}, {"spec.rsrcs.unknown", "spec.rsrcs.clay", "spec.rsrcs.ore", "spec.rsrcs.sheep", "spec.rsrcs.wheat", "spec.rsrcs.wood"}};
    }
}

