/*
 * Decompiled with CFR 0.152.
 */
package soc.util;

import java.io.InputStream;
import java.io.PrintStream;
import java.util.Properties;

public class Version {
    public static String VERSION = "project.version";
    public static String VERSNUM = "project.versionnum";
    public static final String VERSNUM_NOWARN_MAXIMUM = "project.versionnumMaxNoWarn";
    public static String COPYRIGHT = "project.copyright";
    public static String BUILDNUM = "project.buildnum";
    public static String JRE_MIN_VERSION = "project.jre.min.version";
    public static String JRE_MIN_MAJOR = "project.jre.min.major";
    public static String JRE_MIN_MINOR = "project.jre.min.minor";
    public static String JRE_MIN_EDIT = "project.jre.min.edit";
    private static Properties versionInfo = null;
    private static int jreMinMajor = 1;
    private static int jreMinMinor = 8;
    private static int jreMinEdit = 0;

    public static String version(int versionNumber) {
        if (versionNumber < 1000) {
            return Integer.toString(versionNumber);
        }
        if (versionNumber < 1100) {
            return "1.0." + (versionNumber - 1000);
        }
        StringBuffer sb = new StringBuffer(Integer.toString(versionNumber));
        int L = sb.length();
        sb.insert(L - 2, '.');
        sb.insert(L - 3, '.');
        return sb.toString();
    }

    public static String version() {
        return versionInfo.getProperty(VERSION);
    }

    public static int versionNumber() {
        int vnum;
        try {
            vnum = Integer.parseInt(versionInfo.getProperty(VERSNUM));
        }
        catch (Throwable e) {
            vnum = 0;
        }
        return vnum;
    }

    public static int versionNumberMaximumNoWarn() {
        int vnum;
        try {
            vnum = Integer.parseInt(versionInfo.getProperty(VERSNUM_NOWARN_MAXIMUM));
        }
        catch (Throwable e) {
            vnum = -1;
        }
        return vnum;
    }

    public static String copyright() {
        return versionInfo.getProperty(COPYRIGHT);
    }

    public static String buildnum() {
        return versionInfo.getProperty(BUILDNUM);
    }

    public static String minJREVersion() {
        String jreMinVersion = versionInfo.getProperty(JRE_MIN_VERSION);
        if (jreMinVersion == null) {
            try {
                String major = versionInfo.getProperty(JRE_MIN_MAJOR, "" + jreMinMajor);
                String minor = versionInfo.getProperty(JRE_MIN_MINOR, "" + jreMinMinor);
                String edit = versionInfo.getProperty(JRE_MIN_EDIT, "" + jreMinEdit);
                jreMinMajor = Integer.parseInt(major);
                jreMinMinor = Integer.parseInt(minor);
                jreMinEdit = Integer.parseInt(edit);
            }
            catch (Exception x) {
                System.err.println("Error retrieving Version info: ");
                x.printStackTrace();
            }
            jreMinVersion = jreMinMajor + "." + jreMinMinor + "." + jreMinEdit;
            versionInfo.put(JRE_MIN_VERSION, jreMinVersion);
        }
        return jreMinVersion;
    }

    static boolean isJREValid() {
        String v = System.getProperty("java.vm.version");
        int major = Integer.parseInt(v.substring(0, 1));
        int minor = Integer.parseInt(v.substring(2, 3));
        int edit = Integer.parseInt(v.substring(4, 5));
        if (versionInfo.getProperty(JRE_MIN_VERSION) == null) {
            Version.minJREVersion();
        }
        return major >= jreMinMajor || minor >= jreMinMinor || edit >= jreMinEdit;
    }

    public static void printVersionText(PrintStream out, String progname) {
        out.println(progname + Version.version() + ", build " + Version.buildnum() + ", (C) " + Version.copyright());
        out.println("Network layer based on code by Cristian Bogdan; Practice Net by Jeremy Monin.");
    }

    static {
        versionInfo = new Properties();
        versionInfo.put(VERSION, "-error-");
        versionInfo.put(VERSNUM, "-error-");
        versionInfo.put(VERSNUM_NOWARN_MAXIMUM, "-1");
        versionInfo.put(COPYRIGHT, "-error-");
        versionInfo.put(BUILDNUM, "-unknown-");
        try {
            InputStream in = Version.class.getResourceAsStream("/resources/version.info");
            versionInfo.load(in);
            in.close();
        }
        catch (Exception io) {
            System.err.println("Unable to load version information.");
            io.printStackTrace();
        }
        Version.minJREVersion();
    }
}

